/*
 * Decompiled with CFR 0.152.
 */
package artofillusion;

import artofillusion.ModellingApp;
import artofillusion.Renderer;
import artofillusion.Scene;
import artofillusion.math.Vec3;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import java.util.Properties;

public class ApplicationPreferences {
    private Properties properties;
    private int defaultDisplayMode;
    private int undoLevels;
    private double interactiveTol;
    private Renderer objectPreviewRenderer;
    private Renderer texturePreviewRenderer;
    private Renderer defaultRenderer;
    private Renderer liveRenderer;
    private boolean objectSceneAutosync;

    public ApplicationPreferences() {
        this.loadPreferences();
    }

    public void loadPreferences() {
        this.properties = new Properties();
        this.initDefaultPreferences();
        File f = new File(System.getProperty("user.home"), ".aoiprefs");
        if (!f.exists()) {
            Translate.setLocale(Locale.getDefault());
            return;
        }
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(f));
            this.properties.load(in);
            ((InputStream)in).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.parsePreferences();
    }

    public void savePreferences() {
        File f = new File(System.getProperty("user.home"), ".aoiprefs");
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f));
            this.properties.save(out, "Art of Illusion Preferences File");
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void initDefaultPreferences() {
        Renderer[] renderers = ModellingApp.getRenderers();
        if (renderers.length > 0) {
            this.defaultRenderer = this.liveRenderer = renderers[renderers.length - 1];
            this.texturePreviewRenderer = this.liveRenderer;
            this.objectPreviewRenderer = this.liveRenderer;
        }
        this.defaultDisplayMode = 2;
        this.interactiveTol = 0.05;
        this.undoLevels = 4;
        this.objectSceneAutosync = true;
    }

    private void parsePreferences() {
        this.objectPreviewRenderer = this.getNamedRenderer(this.properties.getProperty("objectPreviewRenderer"));
        this.texturePreviewRenderer = this.getNamedRenderer(this.properties.getProperty("texturePreviewRenderer"));
        this.defaultRenderer = this.getNamedRenderer(this.properties.getProperty("defaultRenderer"));
        this.liveRenderer = this.getNamedRenderer(this.properties.getProperty("liveRenderer"));
        this.defaultDisplayMode = this.parseIntProperty("defaultDisplayMode", this.defaultDisplayMode);
        this.interactiveTol = this.parseDoubleProperty("interactiveSurfaceError", this.interactiveTol);
        this.undoLevels = this.parseIntProperty("undoLevels", this.undoLevels);
        Translate.setLocale(this.parseLocaleProperty("language"));
        this.objectSceneAutosync = this.parseBooleanProperty("objectSceneAutosync", this.objectSceneAutosync);
    }

    private int parseIntProperty(String name, int defaultVal) {
        try {
            return Integer.parseInt(this.properties.getProperty(name));
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }

    private double parseDoubleProperty(String name, double defaultVal) {
        try {
            return new Double(this.properties.getProperty(name));
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }

    private Locale parseLocaleProperty(String name) {
        try {
            String desc = this.properties.getProperty(name);
            String language = desc.substring(0, 2);
            String country = desc.substring(3);
            return new Locale(language, country);
        }
        catch (Exception ex) {
            return Locale.getDefault();
        }
    }

    private boolean parseBooleanProperty(String name, boolean defaultVal) {
        try {
            int i = Integer.parseInt(this.properties.getProperty(name));
            return i != 0;
        }
        catch (Exception ex) {
            return defaultVal;
        }
    }

    private Renderer getNamedRenderer(String name) {
        Renderer[] renderers = ModellingApp.getRenderers();
        if (renderers.length == 0) {
            return null;
        }
        for (int i = 0; i < renderers.length; ++i) {
            if (!renderers[i].getName().equals(name)) continue;
            return renderers[i];
        }
        return renderers[renderers.length - 1];
    }

    public final Renderer getDefaultRenderer() {
        return this.defaultRenderer;
    }

    public final void setDefaultRenderer(Renderer rend) {
        this.defaultRenderer = rend;
        this.properties.put("defaultRenderer", rend.getName());
    }

    public final Renderer getObjectPreviewRenderer() {
        return this.objectPreviewRenderer;
    }

    public final void setObjectPreviewRenderer(Renderer rend) {
        this.objectPreviewRenderer = rend;
        this.properties.put("objectPreviewRenderer", rend.getName());
    }

    public final Renderer getTexturePreviewRenderer() {
        return this.texturePreviewRenderer;
    }

    public final void setTexturePreviewRenderer(Renderer rend) {
        this.texturePreviewRenderer = rend;
        this.properties.put("texturePreviewRenderer", rend.getName());
    }

    public final Renderer getLiveRenderer() {
        return this.liveRenderer;
    }

    public final void setLiveRenderer(Renderer rend) {
        this.liveRenderer = rend;
        this.properties.put("liveRenderer", rend.getName());
    }

    public final int getDefaultDisplayMode() {
        return this.defaultDisplayMode;
    }

    public final void setDefaultDisplayMode(int mode) {
        this.defaultDisplayMode = mode;
        this.properties.put("defaultDisplayMode", Integer.toString(mode));
    }

    public final double getInteractiveSurfaceError() {
        return this.interactiveTol;
    }

    public final void setInteractiveSurfaceError(double tol) {
        boolean changed = this.interactiveTol != tol;
        this.interactiveTol = tol;
        this.properties.put("interactiveSurfaceError", Double.toString(tol));
        if (changed) {
            EditingWindow[] windows = ModellingApp.getWindows();
            for (int i = 0; i < windows.length; ++i) {
                Scene sc = windows[i].getScene();
                if (sc == null) continue;
                for (int j = 0; j < sc.getNumObjects(); ++j) {
                    ObjectInfo info = sc.getObject(j);
                    Vec3 size = info.getBounds().getSize();
                    info.object.setSize(size.x, size.y, size.z);
                    info.clearCachedMeshes();
                }
                windows[i].updateImage();
            }
        }
    }

    public final Locale getLocale() {
        return Translate.getLocale();
    }

    public final void setLocale(Locale locale) {
        Translate.setLocale(locale);
        this.properties.put("language", locale.getLanguage() + '_' + locale.getCountry());
    }

    public final int getUndoLevels() {
        return this.undoLevels;
    }

    public final void setUndoLevels(int levels) {
        this.undoLevels = levels;
        this.properties.put("undoLevels", Integer.toString(levels));
    }

    public final boolean getObjectSceneAutosync() {
        return this.objectSceneAutosync;
    }

    public final void setObjectSceneAutosync(boolean value) {
        this.objectSceneAutosync = value;
        this.properties.put("objectSceneAutosync", value ? "1" : "0");
    }
}

