/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.translators;

import artofillusion.ModellingApp;
import artofillusion.Scene;
import artofillusion.math.Mat4;
import artofillusion.math.Vec2;
import artofillusion.math.Vec3;
import artofillusion.object.Mesh;
import artofillusion.object.MeshVertex;
import artofillusion.object.ObjectInfo;
import artofillusion.object.TriangleMesh;
import artofillusion.texture.Mapping2D;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UVMapping;
import artofillusion.translators.TextureImageExporter;
import artofillusion.translators.TextureImageInfo;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.ValueChangedEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BFileChooser;
import buoy.widget.BFrame;
import buoy.widget.BStandardDialog;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;

public class OBJExporter {
    static /* synthetic */ Class class$buoy$event$ValueChangedEvent;

    public static void exportFile(BFrame parent, Scene theScene) {
        ValueField errorField = new ValueField(0.05, 3);
        final ValueField widthField = new ValueField(200.0, 7);
        final ValueField heightField = new ValueField(200.0, 7);
        final ValueSlider qualitySlider = new ValueSlider(0.0, 1.0, 100, 0.5);
        final BCheckBox mtlBox = new BCheckBox(Translate.text((String)"writeTexToMTL"), false);
        BComboBox exportChoice = new BComboBox((Object[])new String[]{Translate.text((String)"exportWholeScene"), Translate.text((String)"selectedObjectsOnly")});
        mtlBox.addEventLink(class$buoy$event$ValueChangedEvent == null ? (class$buoy$event$ValueChangedEvent = OBJExporter.class$("buoy.event.ValueChangedEvent")) : class$buoy$event$ValueChangedEvent, new Object(){

            void processEvent() {
                widthField.setEnabled(mtlBox.getState());
                heightField.setEnabled(mtlBox.getState());
                qualitySlider.setEnabled(mtlBox.getState());
            }
        });
        mtlBox.dispatchEvent((Object)new ValueChangedEvent((Widget)mtlBox));
        ComponentsDialog dlg = theScene.getSelection().length > 0 ? new ComponentsDialog((WindowWidget)parent, Translate.text((String)"exportToOBJ"), new Widget[]{exportChoice, errorField, mtlBox, Translate.label((String)"imageSizeForTextures"), widthField, heightField, qualitySlider}, new String[]{null, Translate.text((String)"maxSurfaceError"), null, null, Translate.text((String)"Width"), Translate.text((String)"Height"), Translate.text((String)"imageQuality")}) : new ComponentsDialog((WindowWidget)parent, Translate.text((String)"exportToOBJ"), new Widget[]{errorField, mtlBox, Translate.label((String)"imageSizeForTextures"), widthField, heightField, qualitySlider}, new String[]{Translate.text((String)"maxSurfaceError"), null, null, Translate.text((String)"Width"), Translate.text((String)"Height"), Translate.text((String)"imageQuality")});
        if (!dlg.clickedOk()) {
            return;
        }
        BFileChooser fc = new BFileChooser(BFileChooser.SAVE_FILE, Translate.text((String)"exportToOBJ"));
        fc.setSelectedFile(new File("Untitled.obj"));
        if (ModellingApp.currentDirectory != null) {
            fc.setDirectory(new File(ModellingApp.currentDirectory));
        }
        if (!fc.showDialog((Widget)parent)) {
            return;
        }
        File dir = fc.getDirectory();
        File f = fc.getSelectedFile();
        String name = f.getName();
        String baseName = name.endsWith(".obj") ? name.substring(0, name.length() - 4) : name;
        ModellingApp.currentDirectory = dir.getAbsolutePath();
        try {
            PrintWriter out;
            TextureImageExporter textureExporter = null;
            String mtlFilename = null;
            if (mtlBox.getState()) {
                textureExporter = new TextureImageExporter(dir, baseName, (int)(100.0 * qualitySlider.getValue()), 21, (int)widthField.getValue(), (int)heightField.getValue());
                mtlFilename = baseName + ".mtl";
                out = new PrintWriter(new BufferedWriter(new FileWriter(new File(dir, mtlFilename))));
                OBJExporter.writeTextures(theScene, out, exportChoice.getSelectedIndex() == 0, textureExporter);
                out.close();
                textureExporter.saveImages();
            }
            out = new PrintWriter(new BufferedWriter(new FileWriter(f)));
            OBJExporter.writeScene(theScene, out, exportChoice.getSelectedIndex() == 0, errorField.getValue(), textureExporter, mtlFilename);
            out.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            new BStandardDialog("", (Object)new String[]{Translate.text((String)"errorExportingScene"), ex.getMessage()}, BStandardDialog.ERROR).showMessageDialog((Widget)parent);
        }
    }

    public static void writeScene(Scene theScene, PrintWriter out, boolean wholeScene, double tol, TextureImageExporter textureExporter, String mtlFilename) {
        out.println("#Produced by Art of Illusion 1.9_ED200411XX, " + new Date().toString());
        if (mtlFilename != null) {
            out.println("mtllib " + mtlFilename);
        }
        int numVert = 0;
        int numNorm = 0;
        int numTexVert = 0;
        Hashtable<String, String> groupNames = new Hashtable<String, String>();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(5);
        nf.setGroupingUsed(false);
        int i = 0;
        while (i < theScene.getNumObjects()) {
            TriangleMesh mesh;
            ObjectInfo info = theScene.getObject(i);
            if ((wholeScene || info.selected) && (mesh = info.object.convertToTriangleMesh(tol)) != null) {
                int j;
                double vscale;
                double uscale;
                String baseName;
                String name = baseName = info.name.replace(' ', '_');
                int append = 1;
                while (groupNames.get(name) != null) {
                    name = baseName + "_" + append++;
                }
                groupNames.put(name, "");
                out.println("g " + name);
                TextureImageInfo ti = null;
                if (textureExporter != null && (ti = textureExporter.getTextureInfo(info.object.getTexture())) != null) {
                    out.println("usemtl " + ti.name);
                }
                Mat4 trans = info.coords.fromLocal();
                MeshVertex[] vert = mesh.getVertices();
                int j2 = 0;
                while (j2 < vert.length) {
                    Vec3 v = trans.times(vert[j2].r);
                    out.println("v " + nf.format(v.x) + " " + nf.format(v.y) + " " + nf.format(v.z));
                    ++j2;
                }
                Vec3[] norm = mesh.getNormals();
                int j3 = 0;
                while (j3 < norm.length) {
                    if (norm[j3] == null) {
                        out.println("vn 1 0 0");
                    } else {
                        Vec3 v = trans.timesDirection(norm[j3]);
                        out.println("vn " + nf.format(v.x) + " " + nf.format(v.y) + " " + nf.format(v.z));
                    }
                    ++j3;
                }
                TriangleMesh.Face[] face = mesh.getFaces();
                if (ti != null && mesh.getTextureMapping() instanceof UVMapping && ((UVMapping)mesh.getTextureMapping()).isPerFaceVertex(mesh)) {
                    Vec2[][] coords = ((UVMapping)mesh.getTextureMapping()).findFaceTextureCoordinates(mesh);
                    uscale = ti.maxu == ti.minu ? 1.0 : 1.0 / (ti.maxu - ti.minu);
                    vscale = ti.maxv == ti.minv ? 1.0 : 1.0 / (ti.maxv - ti.minv);
                    j = 0;
                    while (j < face.length) {
                        int k = 0;
                        while (k < 3) {
                            double u = (coords[k][j].x - ti.minu) * uscale;
                            double v = (coords[k][j].y - ti.minv) * vscale;
                            out.println("vt " + nf.format(u) + " " + nf.format(v));
                            ++k;
                        }
                        ++j;
                    }
                    int j4 = 0;
                    while (j4 < face.length) {
                        out.println("f " + (face[j4].v1 + numVert + 1) + "/" + (j4 * 3 + numTexVert + 1) + "/" + (face[j4].v1 + numNorm + 1) + " " + (face[j4].v2 + numVert + 1) + "/" + (j4 * 3 + numVert + 2) + "/" + (face[j4].v2 + numNorm + 1) + " " + (face[j4].v3 + numVert + 1) + "/" + (j4 * 3 + numVert + 3) + "/" + (face[j4].v3 + numNorm + 1));
                        ++j4;
                    }
                    numTexVert += face.length * 3;
                } else if (ti != null && mesh.getTextureMapping() instanceof Mapping2D) {
                    Vec2[] coords = ((Mapping2D)mesh.getTextureMapping()).findTextureCoordinates((Mesh)mesh);
                    uscale = ti.maxu == ti.minu ? 1.0 : 1.0 / (ti.maxu - ti.minu);
                    vscale = ti.maxv == ti.minv ? 1.0 : 1.0 / (ti.maxv - ti.minv);
                    j = 0;
                    while (j < coords.length) {
                        double u = (coords[j].x - ti.minu) * uscale;
                        double v = (coords[j].y - ti.minv) * vscale;
                        out.println("vt " + nf.format(u) + " " + nf.format(v));
                        ++j;
                    }
                    int j5 = 0;
                    while (j5 < face.length) {
                        out.println("f " + (face[j5].v1 + numVert + 1) + "/" + (face[j5].v1 + numVert + 1) + "/" + (face[j5].v1 + numNorm + 1) + " " + (face[j5].v2 + numVert + 1) + "/" + (face[j5].v2 + numVert + 1) + "/" + (face[j5].v2 + numNorm + 1) + " " + (face[j5].v3 + numVert + 1) + "/" + (face[j5].v3 + numVert + 1) + "/" + (face[j5].v3 + numNorm + 1));
                        ++j5;
                    }
                    numTexVert += coords.length;
                } else {
                    int j6 = 0;
                    while (j6 < face.length) {
                        out.println("f " + (face[j6].v1 + numVert + 1) + "//" + (face[j6].v1 + numNorm + 1) + " " + (face[j6].v2 + numVert + 1) + "//" + (face[j6].v2 + numNorm + 1) + " " + (face[j6].v3 + numVert + 1) + "//" + (face[j6].v3 + numNorm + 1));
                        ++j6;
                    }
                }
                numVert += vert.length;
                numNorm += norm.length;
            }
            ++i;
        }
    }

    private static void writeTextures(Scene theScene, PrintWriter out, boolean wholeScene, TextureImageExporter textureExporter) {
        int i = 0;
        while (i < theScene.getNumObjects()) {
            ObjectInfo info = theScene.getObject(i);
            if (wholeScene || info.selected) {
                textureExporter.addObject(info);
            }
            ++i;
        }
        out.println("#Produced by Art of Illusion 1.9_ED200411XX, " + new Date().toString());
        Enumeration enumeration = textureExporter.getTextures();
        Hashtable<String, TextureImageInfo> names = new Hashtable<String, TextureImageInfo>();
        TextureSpec spec = new TextureSpec();
        NumberFormat nf = NumberFormat.getNumberInstance(Locale.US);
        nf.setMaximumFractionDigits(5);
        while (enumeration.hasMoreElements()) {
            TextureImageInfo info = (TextureImageInfo)enumeration.nextElement();
            String baseName = info.texture.getName().replace(' ', '_');
            if (names.get(baseName) == null) {
                info.name = baseName;
            } else {
                int i2 = 1;
                while (names.get(baseName + i2) != null) {
                    ++i2;
                }
                info.name = baseName + i2;
            }
            names.put(info.name, info);
            out.println("newmtl " + info.name);
            info.texture.getAverageSpec(spec, 0.0, info.paramValue);
            if (info.diffuseFilename == null) {
                out.println("Kd " + nf.format(spec.diffuse.getRed()) + " " + nf.format(spec.diffuse.getGreen()) + " " + nf.format(spec.diffuse.getBlue()));
            } else {
                out.println("Kd 1 1 1");
                out.println("map_Kd " + info.diffuseFilename);
            }
            if (info.hilightFilename == null) {
                out.println("Ks " + nf.format(spec.hilight.getRed()) + " " + nf.format(spec.hilight.getGreen()) + " " + nf.format(spec.hilight.getBlue()));
            } else {
                out.println("Ks 1 1 1");
                out.println("map_Ks " + info.hilightFilename);
            }
            if (info.emissiveFilename == null) {
                out.println("Ka " + nf.format(spec.emissive.getRed()) + " " + nf.format(spec.emissive.getGreen()) + " " + nf.format(spec.emissive.getBlue()));
            } else {
                out.println("Ka 1 1 1");
                out.println("map_Ka " + info.emissiveFilename);
            }
            if (info.hilightFilename == null && spec.hilight.getRed() == 0.0f && spec.hilight.getGreen() == 0.0f && spec.hilight.getBlue() == 0.0f) {
                out.println("illum 1");
                continue;
            }
            out.println("illum 2");
            out.println("Ns " + (int)((1.0 - spec.roughness) * 128.0 + 1.0));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

