/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.SpotLight;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.Ray;

public class SpotlightPhotonSource
implements PhotonSource {
    private SpotLight light;
    private CoordinateSystem coords;
    private RGBColor color;
    private float lightIntensity;
    private double minu;

    public SpotlightPhotonSource(SpotLight light, CoordinateSystem coords, BoundingBox sceneBounds) {
        this.light = light;
        this.coords = coords;
        double exp = light.getExponent() + 1.0;
        this.minu = Math.pow(light.getAngleCosine(), exp) / exp;
        Vec3[] corner = sceneBounds.getCorners();
        Vec3 pos = coords.getOrigin();
        double maxDist2 = 0.0;
        for (int i = 0; i < corner.length; ++i) {
            double dist2 = pos.distance2(corner[i]);
            if (!(dist2 > maxDist2)) continue;
            maxDist2 = dist2;
        }
        this.color = new RGBColor();
        double radius = Math.sqrt(maxDist2) * 0.5;
        light.getLight(this.color, (float)radius);
        this.lightIntensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if (this.lightIntensity == 0.0f) {
            return;
        }
        this.color.scale(1.0f / this.lightIntensity);
        this.lightIntensity *= (float)((1.0 / exp - this.minu) * 2.0 * Math.PI * radius * radius);
    }

    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    public void generatePhotons(PhotonMap map, double intensity) {
        int n;
        Vec3 pos = this.coords.getOrigin();
        Vec3 xdir = this.coords.fromLocal().timesDirection(Vec3.vx());
        Vec3 ydir = this.coords.fromLocal().timesDirection(Vec3.vy());
        Vec3 zdir = this.coords.getZDirection();
        double exp = this.light.getExponent() + 1.0;
        double expInv = 1.0 / exp;
        double maxu = 1.0 / exp;
        double usize = maxu - this.minu;
        boolean randomizeOrigin = map.getRaytracer().penumbra;
        Ray r = new Ray();
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        for (int num = (int)intensity; num > 0; num -= n * n) {
            n = (int)Math.sqrt(num);
            if (n == 0) {
                n = 1;
            }
            double du = usize / (double)n;
            double dv = Math.PI * 2 / (double)n;
            double baseu = this.minu;
            for (int i = 0; i < n; ++i) {
                double basev = 0.0;
                for (int j = 0; j < n; ++j) {
                    double u = baseu + map.random.nextDouble() * du;
                    double v = basev + map.random.nextDouble() * dv;
                    double ctheta = Math.pow(u * exp, expInv);
                    double stheta = Math.sqrt(1.0 - ctheta * ctheta);
                    double cphi = Math.cos(v);
                    double sphi = Math.sin(v);
                    double x = stheta * sphi;
                    double y = stheta * cphi;
                    double z = ctheta;
                    dir.set(x * xdir.x + y * ydir.x + z * zdir.x, x * xdir.y + y * ydir.y + z * zdir.y, x * xdir.z + y * ydir.z + z * zdir.z);
                    orig.set(pos);
                    if (randomizeOrigin) {
                        map.randomizePoint(orig, this.light.getRadius());
                    }
                    r.newID();
                    map.spawnPhoton(r, this.color, false);
                    basev += dv;
                }
                baseu += du;
            }
        }
    }
}

