/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.Camera;
import artofillusion.RenderListener;
import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.SceneRenderInfoProvider;
import artofillusion.image.ComplexImage;
import artofillusion.material.MaterialMapping;
import artofillusion.material.MaterialSpec;
import artofillusion.material.UniformMaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.object.Cylinder;
import artofillusion.object.DirectionalLight;
import artofillusion.object.Light;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectCollection;
import artofillusion.object.ObjectInfo;
import artofillusion.object.PointLight;
import artofillusion.object.SceneCamera;
import artofillusion.object.Sphere;
import artofillusion.object.SpotLight;
import artofillusion.object.TriangleMesh;
import artofillusion.raytracer.CylinderPhotonSource;
import artofillusion.raytracer.DirectionalPhotonSource;
import artofillusion.raytracer.DisplacedTrianglePhotonSource;
import artofillusion.raytracer.EllipsoidPhotonSource;
import artofillusion.raytracer.EnvironmentPhotonSource;
import artofillusion.raytracer.OctreeNode;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.PixelInfo;
import artofillusion.raytracer.PointPhotonSource;
import artofillusion.raytracer.RTCube;
import artofillusion.raytracer.RTCylinder;
import artofillusion.raytracer.RTDisplacedTriangle;
import artofillusion.raytracer.RTEllipsoid;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.RTSphere;
import artofillusion.raytracer.RTTriangle;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.SpotlightPhotonSource;
import artofillusion.raytracer.TrianglePhotonSource;
import artofillusion.texture.ParameterValue;
import artofillusion.texture.Texture;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.ui.ComponentsDialog;
import artofillusion.ui.PanelDialog;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import buoy.event.ValueChangedEvent;
import buoy.event.WidgetEvent;
import buoy.widget.BCheckBox;
import buoy.widget.BComboBox;
import buoy.widget.BDialog;
import buoy.widget.BFrame;
import buoy.widget.BLabel;
import buoy.widget.ColumnContainer;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Vector;

public class Raytracer
implements Runnable {
    RTObject[] sceneObject;
    ObjectInfo[] light;
    OctreeNode rootNode;
    OctreeNode cameraNode;
    OctreeNode[] lightNode;
    ColumnContainer configPanel;
    BCheckBox depthBox;
    BCheckBox glossBox;
    BCheckBox shadowBox;
    BCheckBox causticsBox;
    BCheckBox transparentBox;
    BCheckBox hdrBox;
    BCheckBox adaptiveBox;
    BCheckBox rouletteBox;
    BComboBox aliasChoice;
    BComboBox maxRaysChoice;
    BComboBox minRaysChoice;
    BComboBox giModeChoice;
    ValueField errorField;
    ValueField rayDepthField;
    ValueField rayCutoffField;
    ValueField smoothField;
    ValueField stepSizeField;
    ValueField extraGIField;
    ValueField extraGIEnvField;
    ValueField globalPhotonsField;
    ValueField globalNeighborPhotonsField;
    ValueField causticsPhotonsField;
    ValueField causticsNeighborPhotonsField;
    int[] pixel;
    int width;
    int height;
    int rtWidth;
    int rtHeight;
    int maxRayDepth;
    int minRays;
    int maxRays;
    int antialiasLevel;
    MemoryImageSource imageSource;
    SceneRenderInfoProvider theScene;
    Camera theCamera;
    RenderListener listener;
    Image img;
    Thread renderThread;
    Ray[] ray;
    RGBColor[] color;
    RGBColor[] rayIntensity;
    RGBColor tempColor;
    RGBColor tempColor2;
    RGBColor ambColor;
    RGBColor envColor;
    RGBColor fogColor;
    double[] transparency;
    double[] envParamValue;
    TextureMapping envMapping;
    int envMode;
    Intersection intersect;
    MaterialIntersection[] matChange;
    TextureSpec[] surfSpec;
    MaterialSpec matSpec;
    Vec3[] pos;
    Vec3[] normal;
    Vec3[] trueNormal;
    Vec3 hvec;
    Vec3 vvec;
    Vec3 center;
    Vec3 viewpoint;
    Vec3 cameraDir;
    double time;
    double dofScale;
    double depthOfField;
    double focalDist;
    double fogDist;
    double surfaceError;
    double stepSize;
    double smoothing;
    double smoothScale;
    double extraGISmoothing;
    double extraGIEnvSmoothing;
    int giMode;
    int globalPhotons;
    int globalNeighborPhotons;
    int causticsPhotons;
    int causticsNeighborPhotons;
    float minRayIntensity = 0.01f;
    float[][] floatImage;
    float[] depthImage;
    boolean fog;
    boolean depth;
    boolean gloss;
    boolean penumbra;
    boolean caustics;
    boolean transparentBackground;
    boolean generateHDR;
    boolean adaptive;
    boolean roulette;
    Random random;
    PhotonMap globalMap;
    PhotonMap causticsMap;
    int startDelay = 100;
    public static final double TOL = 1.0E-12;
    public static final int GI_NONE = 0;
    public static final int GI_MONTE_CARLO = 1;
    public static final int GI_PHOTON = 2;
    public static final int GI_HYBRID = 3;
    public static final float COLOR_THRESH_ABS = 0.0078125f;
    public static final float COLOR_THRESH_REL = 0.03125f;
    public static final int[] distrib1 = new int[]{0, 3, 1, 2, 1, 2, 0, 3, 2, 0, 3, 1, 3, 1, 2, 0};
    public static final int[] distrib2 = new int[]{0, 1, 2, 3, 3, 0, 1, 2, 1, 2, 3, 0, 0, 1, 2, 3};

    public synchronized void renderScene(SceneRenderInfoProvider theScene, Camera theCamera, RenderListener rl, SceneCamera sceneCamera) {
        int i;
        int requiredComponents;
        Dimension dim = theCamera.getSize();
        this.listener = rl;
        this.theScene = theScene;
        this.theCamera = theCamera;
        if (sceneCamera == null) {
            this.depthOfField = 0.0;
            this.focalDist = theCamera.getDistToScreen();
        } else {
            this.depthOfField = sceneCamera.getDepthOfField();
            this.focalDist = sceneCamera.getFocalDistance();
        }
        this.time = theScene.getTime();
        if (this.pixel == null || this.width != dim.width || this.height != dim.height) {
            this.width = dim.width;
            this.height = dim.height;
            this.pixel = new int[this.width * this.height];
            this.imageSource = new MemoryImageSource(this.width, this.height, this.pixel, 0, this.width);
            this.imageSource.setAnimated(true);
            this.img = Toolkit.getDefaultToolkit().createImage(this.imageSource);
        }
        int n = requiredComponents = sceneCamera == null ? 0 : sceneCamera.getComponentsForFilters();
        if (this.generateHDR || (requiredComponents & 3) != 0) {
            if (this.floatImage == null || this.floatImage.length != this.width * this.height) {
                this.floatImage = new float[4][this.width * this.height];
            }
        } else {
            this.floatImage = null;
        }
        this.depthImage = (float[])((requiredComponents & 4) != 0 ? new float[this.width * this.height] : null);
        this.ray = new Ray[this.maxRayDepth + 1];
        this.color = new RGBColor[this.maxRayDepth + 1];
        this.transparency = new double[this.maxRayDepth + 1];
        this.rayIntensity = new RGBColor[this.maxRayDepth + 1];
        this.surfSpec = new TextureSpec[this.maxRayDepth + 1];
        this.pos = new Vec3[this.maxRayDepth + 1];
        this.normal = new Vec3[this.maxRayDepth + 1];
        this.trueNormal = new Vec3[this.maxRayDepth + 1];
        for (i = 0; i < this.maxRayDepth + 1; ++i) {
            this.ray[i] = new Ray();
            this.color[i] = new RGBColor(0.0f, 0.0f, 0.0f);
            this.rayIntensity[i] = new RGBColor(0.0f, 0.0f, 0.0f);
            this.surfSpec[i] = new TextureSpec();
            this.pos[i] = new Vec3();
            this.normal[i] = new Vec3();
            this.trueNormal[i] = new Vec3();
        }
        this.matSpec = new MaterialSpec();
        this.intersect = new Intersection();
        this.tempColor = new RGBColor(0.0f, 0.0f, 0.0f);
        this.tempColor2 = new RGBColor(0.0f, 0.0f, 0.0f);
        this.matChange = new MaterialIntersection[64];
        for (i = 0; i < this.matChange.length; ++i) {
            this.matChange[i] = new MaterialIntersection();
        }
        this.random = new Random(0L);
        this.renderThread = new Thread(this);
        this.renderThread.start();
    }

    public synchronized void cancelRendering(SceneRenderInfoProvider sc) {
        Thread t = null;
        RenderListener rl = null;
        if (this.theScene != sc) {
            return;
        }
        t = this.renderThread;
        rl = this.listener;
        this.cancelRenderingAsync(sc);
        if (t == null) {
            return;
        }
        t.interrupt();
        try {
            t.join();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (rl != null) {
            rl.renderingCanceled();
        }
        this.finish();
    }

    public synchronized void cancelRenderingAsync(SceneRenderInfoProvider sc) {
        if (this.theScene != sc) {
            return;
        }
        this.setAllNull();
    }

    public Widget getConfigPanel() {
        if (this.configPanel == null) {
            this.configPanel = new ColumnContainer();
            FormContainer choicesPanel = new FormContainer(2, 4);
            this.configPanel.add((Widget)choicesPanel);
            LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
            LayoutInfo rightLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null);
            choicesPanel.add((Widget)Translate.label((String)"surfaceAccuracy"), 0, 0, leftLayout);
            choicesPanel.add((Widget)new BLabel(Translate.text((String)"Antialiasing") + ":"), 0, 1, leftLayout);
            choicesPanel.add((Widget)Translate.label((String)"minRaysPixel"), 0, 2, leftLayout);
            choicesPanel.add((Widget)Translate.label((String)"maxRaysPixel"), 0, 3, leftLayout);
            this.errorField = new ValueField(0.02, 3, 6);
            choicesPanel.add((Widget)this.errorField, 1, 0, rightLayout);
            this.aliasChoice = new BComboBox((Object[])new String[]{Translate.text((String)"none"), Translate.text((String)"Medium"), Translate.text((String)"Maximum")});
            choicesPanel.add((Widget)this.aliasChoice, 1, 1, rightLayout);
            this.minRaysChoice = new BComboBox();
            choicesPanel.add((Widget)this.minRaysChoice, 1, 2, rightLayout);
            this.maxRaysChoice = new BComboBox();
            choicesPanel.add((Widget)this.maxRaysChoice, 1, 3, rightLayout);
            for (int i = 4; i <= 1024; i *= 2) {
                this.minRaysChoice.add((Object)Integer.toString(i));
                this.maxRaysChoice.add((Object)Integer.toString(i));
            }
            this.minRaysChoice.setSelectedIndex(0);
            this.maxRaysChoice.setSelectedIndex(2);
            ColumnContainer boxes = new ColumnContainer();
            this.configPanel.add((Widget)boxes);
            boxes.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null));
            this.depthBox = new BCheckBox(Translate.text((String)"depthOfField"), false);
            boxes.add((Widget)this.depthBox);
            this.glossBox = new BCheckBox(Translate.text((String)"glossTranslucency"), false);
            boxes.add((Widget)this.glossBox);
            this.shadowBox = new BCheckBox(Translate.text((String)"softShadows"), false);
            boxes.add((Widget)this.shadowBox);
            RowContainer buttons = new RowContainer();
            this.configPanel.add((Widget)buttons);
            buttons.add((Widget)Translate.button((String)"illumination", (Object)this, (String)"showIlluminationWindow"));
            this.giModeChoice = new BComboBox((Object[])new String[]{Translate.text((String)"none"), Translate.text((String)"monteCarlo"), Translate.text((String)"photonMapping"), Translate.text((String)"hybrid")});
            this.globalPhotonsField = new ValueField(10000.0, 7, 7);
            this.globalNeighborPhotonsField = new ValueField(200.0, 7, 4);
            this.causticsPhotonsField = new ValueField(10000.0, 7, 7);
            this.causticsNeighborPhotonsField = new ValueField(100.0, 7, 4);
            this.causticsBox = new BCheckBox(Translate.text((String)"useCausticsMap"), false);
            Object illumListener = new Object(){

                void processEvent() {
                    int mode = Raytracer.this.giModeChoice.getSelectedIndex();
                    Raytracer.this.globalPhotonsField.setEnabled(mode == 2 || mode == 3);
                    Raytracer.this.globalNeighborPhotonsField.setEnabled(mode == 2 || mode == 3);
                    Raytracer.this.causticsPhotonsField.setEnabled(Raytracer.this.causticsBox.getState());
                    Raytracer.this.causticsNeighborPhotonsField.setEnabled(Raytracer.this.causticsBox.getState());
                }
            };
            this.giModeChoice.addEventLink(ValueChangedEvent.class, illumListener);
            this.causticsBox.addEventLink(ValueChangedEvent.class, illumListener);
            this.causticsBox.dispatchEvent((Object)new ValueChangedEvent((Widget)this.causticsBox));
            buttons.add((Widget)Translate.button((String)"output", (Object)this, (String)"showOutputOptionsWindow"));
            this.transparentBox = new BCheckBox(Translate.text((String)"transparentBackground"), false);
            this.hdrBox = new BCheckBox(Translate.text((String)"generateHDR"), true);
            buttons.add((Widget)Translate.button((String)"advanced", (Object)this, (String)"showAdvancedOptionsWindow"));
            this.rayDepthField = new ValueField(8.0, 7);
            this.rayCutoffField = new ValueField(0.01, 1);
            this.smoothField = new ValueField(1.0, 1);
            this.extraGIField = new ValueField(10.0, 3);
            this.extraGIEnvField = new ValueField(100.0, 3);
            this.stepSizeField = new ValueField(1.0, 3);
            this.adaptiveBox = new BCheckBox(Translate.text((String)"reduceAccuracyForDistant"), true);
            this.rouletteBox = new BCheckBox(Translate.text((String)"russianRoulette"), false);
            Object raysListener = new Object(){

                void processEvent(WidgetEvent ev) {
                    boolean multi = Raytracer.this.aliasChoice.getSelectedIndex() > 0;
                    Raytracer.this.depthBox.setEnabled(multi);
                    Raytracer.this.glossBox.setEnabled(multi);
                    Raytracer.this.shadowBox.setEnabled(multi);
                    Raytracer.this.minRaysChoice.setEnabled(multi);
                    Raytracer.this.maxRaysChoice.setEnabled(multi);
                    if (Raytracer.this.minRaysChoice.getSelectedIndex() > Raytracer.this.maxRaysChoice.getSelectedIndex()) {
                        if (ev.getWidget() == Raytracer.this.maxRaysChoice) {
                            Raytracer.this.minRaysChoice.setSelectedIndex(Raytracer.this.maxRaysChoice.getSelectedIndex());
                        } else {
                            Raytracer.this.maxRaysChoice.setSelectedIndex(Raytracer.this.minRaysChoice.getSelectedIndex());
                        }
                    }
                }
            };
            this.aliasChoice.addEventLink(ValueChangedEvent.class, raysListener);
            this.minRaysChoice.addEventLink(ValueChangedEvent.class, raysListener);
            this.maxRaysChoice.addEventLink(ValueChangedEvent.class, raysListener);
            this.aliasChoice.dispatchEvent((Object)new ValueChangedEvent((Widget)this.aliasChoice));
        }
        return this.configPanel;
    }

    private void showAdvancedOptionsWindow(WidgetEvent ev) {
        FormContainer content = new FormContainer(2, 9);
        content.setColumnWeight(0, 0.0);
        LayoutInfo leftLayout = new LayoutInfo(LayoutInfo.EAST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null);
        LayoutInfo rightLayout = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.HORIZONTAL, null, null);
        content.add((Widget)Translate.label((String)"maxRayTreeDepth"), 0, 0, leftLayout);
        content.add((Widget)Translate.label((String)"minRayIntensity"), 0, 1, leftLayout);
        content.add((Widget)Translate.label((String)"matStepSize"), 0, 3, leftLayout);
        content.add((Widget)Translate.label((String)"texSmoothing"), 0, 4, leftLayout);
        content.add((Widget)this.rayDepthField, 1, 0, rightLayout);
        content.add((Widget)this.rayCutoffField, 1, 1, rightLayout);
        content.add((Widget)this.stepSizeField, 1, 3, rightLayout);
        content.add((Widget)this.smoothField, 1, 4, rightLayout);
        content.add((Widget)Translate.label((String)"extraGISmoothing"), 0, 5, 2, 1, rightLayout);
        RowContainer row = new RowContainer();
        content.add((Widget)row, 0, 6, 2, 1);
        row.add((Widget)new BLabel(Translate.text((String)"Textures") + ":"));
        row.add((Widget)this.extraGIField);
        row.add((Widget)new BLabel(Translate.text((String)"environment") + ":"));
        row.add((Widget)this.extraGIEnvField);
        content.add((Widget)this.adaptiveBox, 0, 7, 2, 1, rightLayout);
        content.add((Widget)this.rouletteBox, 0, 8, 2, 1, rightLayout);
        this.maxRayDepth = (int)this.rayDepthField.getValue();
        this.minRayIntensity = (float)this.rayCutoffField.getValue();
        this.stepSize = this.stepSizeField.getValue();
        this.smoothing = this.smoothField.getValue();
        this.extraGISmoothing = this.extraGIField.getValue();
        this.extraGIEnvSmoothing = this.extraGIEnvField.getValue();
        this.adaptive = this.adaptiveBox.getState();
        this.roulette = this.rouletteBox.getState();
        WindowWidget parent = UIUtilities.findWindow((Widget)ev.getWidget());
        PanelDialog dlg = parent instanceof BDialog ? new PanelDialog((WindowWidget)((BDialog)parent), Translate.text((String)"advancedOptions"), (Widget)content) : new PanelDialog((WindowWidget)((BFrame)parent), Translate.text((String)"advancedOptions"), (Widget)content);
        if (!dlg.clickedOk()) {
            this.rayDepthField.setValue((double)this.maxRayDepth);
            this.rayCutoffField.setValue((double)this.minRayIntensity);
            this.stepSizeField.setValue(this.stepSize);
            this.smoothField.setValue(this.smoothing);
            this.extraGIField.setValue(this.extraGISmoothing);
            this.extraGIEnvField.setValue(this.extraGIEnvSmoothing);
            this.adaptiveBox.setState(this.adaptive);
            this.rouletteBox.setState(this.roulette);
        }
    }

    private void showIlluminationWindow(WidgetEvent ev) {
        ColumnContainer content = new ColumnContainer();
        LayoutInfo indent0 = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, null, null);
        LayoutInfo indent1 = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 5, 0, 0), null);
        LayoutInfo indent2 = new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 10, 0, 0), null);
        RowContainer row = new RowContainer();
        content.add((Widget)row, indent0);
        row.add((Widget)Translate.label((String)"globalIllumination"));
        row.add((Widget)this.giModeChoice);
        content.add((Widget)Translate.label((String)"giPhotonMap"), indent1);
        row = new RowContainer();
        content.add((Widget)row, indent2);
        row.add((Widget)Translate.label((String)"totalPhotons"));
        row.add((Widget)this.globalPhotonsField);
        row.add((Widget)Translate.label((String)"numToEstimateLight"));
        row.add((Widget)this.globalNeighborPhotonsField);
        content.add((Widget)this.causticsBox, indent0);
        row = new RowContainer();
        content.add((Widget)row, indent2);
        row.add((Widget)Translate.label((String)"totalPhotons"));
        row.add((Widget)this.causticsPhotonsField);
        row.add((Widget)Translate.label((String)"numToEstimateLight"));
        row.add((Widget)this.causticsNeighborPhotonsField);
        this.giMode = this.giModeChoice.getSelectedIndex();
        this.globalPhotons = (int)this.globalPhotonsField.getValue();
        this.globalNeighborPhotons = (int)this.globalNeighborPhotonsField.getValue();
        this.caustics = this.causticsBox.getState();
        this.causticsPhotons = (int)this.causticsPhotonsField.getValue();
        this.causticsNeighborPhotons = (int)this.causticsNeighborPhotonsField.getValue();
        WindowWidget parent = UIUtilities.findWindow((Widget)ev.getWidget());
        PanelDialog dlg = parent instanceof BDialog ? new PanelDialog((WindowWidget)((BDialog)parent), Translate.text((String)"illuminationOptions"), (Widget)content) : new PanelDialog((WindowWidget)((BFrame)parent), Translate.text((String)"illuminationOptions"), (Widget)content);
        if (!dlg.clickedOk()) {
            this.giModeChoice.setSelectedIndex(this.giMode);
            this.globalPhotonsField.setValue((double)this.globalPhotons);
            this.globalNeighborPhotonsField.setValue((double)this.globalNeighborPhotons);
            this.causticsBox.setState(this.caustics);
            this.causticsPhotonsField.setValue((double)this.causticsPhotons);
            this.causticsNeighborPhotonsField.setValue((double)this.causticsNeighborPhotons);
        }
    }

    private void showOutputOptionsWindow(WidgetEvent ev) {
        this.transparentBackground = this.transparentBox.getState();
        this.generateHDR = this.hdrBox.getState();
        WindowWidget parent = UIUtilities.findWindow((Widget)ev.getWidget());
        ComponentsDialog dlg = parent instanceof BDialog ? new ComponentsDialog((WindowWidget)((BDialog)parent), Translate.text((String)"outputOptions"), new Widget[]{this.transparentBox, this.hdrBox}, new String[]{"", ""}) : new ComponentsDialog((WindowWidget)((BFrame)parent), Translate.text((String)"outputOptions"), new Widget[]{this.transparentBox, this.hdrBox}, new String[]{"", ""});
        if (!dlg.clickedOk()) {
            this.transparentBox.setState(this.transparentBackground);
            this.hdrBox.setState(this.generateHDR);
        }
    }

    public boolean recordConfiguration() {
        this.maxRayDepth = (int)this.rayDepthField.getValue();
        this.minRayIntensity = (float)this.rayCutoffField.getValue();
        this.stepSize = this.stepSizeField.getValue();
        this.smoothing = this.smoothField.getValue();
        this.extraGISmoothing = this.extraGIField.getValue();
        this.extraGIEnvSmoothing = this.extraGIEnvField.getValue();
        this.adaptive = this.adaptiveBox.getState();
        this.roulette = this.rouletteBox.getState();
        this.surfaceError = this.errorField.getValue();
        this.antialiasLevel = this.aliasChoice.getSelectedIndex();
        this.depth = this.depthBox.getState();
        this.gloss = this.glossBox.getState();
        this.penumbra = this.shadowBox.getState();
        this.minRays = Integer.parseInt((String)this.minRaysChoice.getSelectedValue());
        this.maxRays = Integer.parseInt((String)this.maxRaysChoice.getSelectedValue());
        if (this.antialiasLevel == 0) {
            this.maxRays = 1;
            this.minRays = 1;
        }
        this.transparentBackground = this.transparentBox.getState();
        this.generateHDR = this.hdrBox.getState();
        this.giMode = this.giModeChoice.getSelectedIndex();
        this.globalPhotons = (int)this.globalPhotonsField.getValue();
        this.globalNeighborPhotons = (int)this.globalNeighborPhotonsField.getValue();
        this.caustics = this.causticsBox.getState();
        this.causticsPhotons = (int)this.causticsPhotonsField.getValue();
        this.causticsNeighborPhotons = (int)this.causticsNeighborPhotonsField.getValue();
        return true;
    }

    public synchronized void makeEqualConfig(Raytracer r) {
        this.maxRayDepth = r.maxRayDepth;
        this.minRayIntensity = r.minRayIntensity;
        this.stepSize = r.stepSize;
        this.smoothing = r.smoothing;
        this.extraGISmoothing = r.extraGISmoothing;
        this.extraGIEnvSmoothing = r.extraGIEnvSmoothing;
        this.adaptive = r.adaptive;
        this.roulette = r.roulette;
        this.surfaceError = r.surfaceError;
        this.antialiasLevel = r.antialiasLevel;
        this.depth = r.depth;
        this.gloss = r.gloss;
        this.penumbra = r.penumbra;
        this.minRays = r.minRays;
        this.maxRays = r.maxRays;
        if (this.antialiasLevel == 0) {
            this.maxRays = 1;
            this.minRays = 1;
        }
        this.transparentBackground = r.transparentBackground;
        this.generateHDR = r.generateHDR;
        this.giMode = r.giMode;
        this.globalPhotons = r.globalPhotons;
        this.globalNeighborPhotons = r.globalNeighborPhotons;
        this.caustics = r.caustics;
        this.causticsPhotons = r.causticsPhotons;
        this.causticsNeighborPhotons = r.causticsNeighborPhotons;
    }

    public Map getConfiguration() {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("maxRayDepth", new Integer(this.maxRayDepth));
        map.put("minRayIntensity", new Float(this.minRayIntensity));
        map.put("materialStepSize", new Double(this.stepSize));
        map.put("textureSmoothing", new Double(this.smoothing));
        map.put("extraGISmoothing", new Double(this.extraGISmoothing));
        map.put("extraGIEnvSmoothing", new Double(this.extraGIEnvSmoothing));
        map.put("reduceAccuracyForDistant", new Boolean(this.adaptive));
        map.put("russianRouletteSampling", new Boolean(this.roulette));
        map.put("maxSurfaceError", new Double(this.surfaceError));
        map.put("antialiasing", new Integer(this.antialiasLevel));
        map.put("depthOfField", new Boolean(this.depth));
        map.put("gloss", new Boolean(this.gloss));
        map.put("softShadows", new Boolean(this.penumbra));
        map.put("minRaysPerPixel", new Integer(this.minRays));
        map.put("maxRaysPerPixel", new Integer(this.maxRays));
        map.put("transparentBackground", new Boolean(this.transparentBackground));
        map.put("highDynamicRange", new Boolean(this.generateHDR));
        map.put("globalIlluminationMode", new Integer(this.giMode));
        map.put("globalIlluminationPhotons", new Integer(this.globalPhotons));
        map.put("globalIlluminationPhotonsInEstimate", new Integer(this.globalNeighborPhotons));
        map.put("caustics", new Boolean(this.caustics));
        map.put("causticsPhotons", new Integer(this.causticsPhotons));
        map.put("causticsPhotonsInEstimate", new Integer(this.causticsNeighborPhotons));
        return map;
    }

    public void setConfiguration(String property, Object value) {
        if ("maxRayDepth".equals(property)) {
            this.maxRayDepth = (Integer)value;
        } else if ("minRayIntensity".equals(property)) {
            this.minRayIntensity = ((Number)value).floatValue();
        } else if ("materialStepSize".equals(property)) {
            this.stepSize = ((Number)value).doubleValue();
        } else if ("textureSmoothing".equals(property)) {
            this.smoothing = ((Number)value).doubleValue();
        } else if ("extraGISmoothing".equals(property)) {
            this.extraGISmoothing = ((Number)value).doubleValue();
        } else if ("extraGIEnvSmoothing".equals(property)) {
            this.extraGIEnvSmoothing = ((Number)value).doubleValue();
        } else if ("reduceAccuracyForDistant".equals(property)) {
            this.adaptive = (Boolean)value;
        } else if ("russianRouletteSampling".equals(property)) {
            this.roulette = (Boolean)value;
        } else if ("maxSurfaceError".equals(property)) {
            this.surfaceError = ((Number)value).doubleValue();
        } else if ("antialiasing".equals(property)) {
            this.antialiasLevel = (Integer)value;
        } else if ("depthOfField".equals(property)) {
            this.depth = (Boolean)value;
        } else if ("gloss".equals(property)) {
            this.depth = (Boolean)value;
        } else if ("softShadows".equals(property)) {
            this.penumbra = (Boolean)value;
        } else if ("minRaysPerPixel".equals(property)) {
            this.minRays = (Integer)value;
        } else if ("maxRaysPerPixel".equals(property)) {
            this.maxRays = (Integer)value;
        } else if ("transparentBackground".equals(property)) {
            this.transparentBackground = (Boolean)value;
        } else if ("highDynamicRange".equals(property)) {
            this.generateHDR = (Boolean)value;
        } else if ("globalIlluminationMode".equals(property)) {
            this.giMode = (Integer)value;
        } else if ("globalIlluminationPhotons".equals(property)) {
            this.globalPhotons = (Integer)value;
        } else if ("globalIlluminationPhotonsInEstimate".equals(property)) {
            this.globalNeighborPhotons = (Integer)value;
        } else if ("caustics".equals(property)) {
            this.caustics = (Boolean)value;
        } else if ("causticsPhotons".equals(property)) {
            this.causticsPhotons = (Integer)value;
        } else if ("causticsPhotonsInEstimate".equals(property)) {
            this.causticsNeighborPhotons = (Integer)value;
        }
    }

    public void configurePreview() {
        this.maxRayDepth = 6;
        this.minRayIntensity = 0.02f;
        this.antialiasLevel = 0;
        this.generateHDR = false;
        this.transparentBackground = false;
        this.penumbra = false;
        this.gloss = false;
        this.depth = false;
        this.maxRays = 1;
        this.minRays = 1;
        this.stepSize = 1.0;
        this.smoothing = 1.0;
        this.extraGISmoothing = 10.0;
        this.extraGIEnvSmoothing = 100.0;
        this.adaptive = true;
        this.roulette = false;
        this.surfaceError = 0.02;
        this.giMode = 0;
        this.caustics = false;
    }

    void buildScene(SceneRenderInfoProvider theScene, Camera theCamera) {
        int i;
        Vector obj = new Vector();
        Vector lt = new Vector();
        Vec3 orig = theCamera.getCameraCoordinates().getOrigin();
        double distToScreen = theCamera.getDistToScreen();
        Thread thisThread = Thread.currentThread();
        for (i = 0; i < theScene.getNumObjects(); ++i) {
            ObjectInfo info = theScene.getObject(i);
            if (info.visible) {
                this.addObject(obj, lt, info, orig, distToScreen, info.coords.toLocal(), info.coords.fromLocal());
            }
            if (this.renderThread == thisThread) continue;
            return;
        }
        this.sceneObject = new RTObject[obj.size()];
        for (i = 0; i < this.sceneObject.length; ++i) {
            this.sceneObject[i] = (RTObject)obj.elementAt(i);
        }
        this.light = new ObjectInfo[lt.size()];
        for (i = 0; i < this.light.length; ++i) {
            this.light[i] = (ObjectInfo)lt.elementAt(i);
        }
        this.ambColor = theScene.getAmbientColor();
        this.envColor = theScene.getEnvironmentColor();
        this.envMapping = theScene.getEnvironmentMapping();
        this.envMode = theScene.getEnvironmentMode();
        this.fogColor = theScene.getFogColor();
        this.fog = theScene.getFogState();
        this.fogDist = theScene.getFogDistance();
        ParameterValue[] envParam = theScene.getEnvironmentParameterValues();
        this.envParamValue = new double[envParam.length];
        for (i = 0; i < this.envParamValue.length; ++i) {
            this.envParamValue[i] = envParam[i].getAverageValue();
        }
    }

    void addObject(Vector obj, Vector lt, ObjectInfo info, Vec3 orig, double distToScreen, Mat4 toLocal, Mat4 fromLocal) {
        RenderingMesh mesh;
        double dist;
        Thread thisThread = Thread.currentThread();
        Object3D theObject = info.object;
        boolean displaced = false;
        if (this.renderThread != thisThread) {
            return;
        }
        if (theObject instanceof Light) {
            lt.addElement(info);
            return;
        }
        if (theObject instanceof ObjectCollection) {
            Enumeration objenum = ((ObjectCollection)theObject).getObjects(info, false, this.theScene);
            while (objenum.hasMoreElements()) {
                ObjectInfo elem = (ObjectInfo)objenum.nextElement();
                if (!elem.visible) continue;
                CoordinateSystem coords = elem.coords.duplicate();
                coords.transformCoordinates(fromLocal);
                this.addObject(obj, lt, elem, orig, distToScreen, coords.toLocal(), coords.fromLocal());
            }
            return;
        }
        double tol = this.adaptive ? ((dist = info.getBounds().distanceToPoint(toLocal.times(orig))) < distToScreen ? this.surfaceError : this.surfaceError * dist / distToScreen) : this.surfaceError;
        Texture tex = theObject.getTexture();
        if (tex != null && tex.hasComponent(6)) {
            displaced = true;
            if (theObject.canConvertToTriangleMesh() != 0) {
                TriangleMesh tm = theObject.convertToTriangleMesh(tol);
                tm.setTexture(tex, theObject.getTextureMapping().duplicate());
                if (theObject.getMaterialMapping() != null) {
                    tm.setMaterial(theObject.getMaterial(), theObject.getMaterialMapping().duplicate());
                }
                theObject = tm;
            }
        }
        if (!info.isDistorted()) {
            if (theObject instanceof Sphere) {
                Vec3 rad = ((Sphere)theObject).getRadii();
                if (rad.x == rad.y && rad.x == rad.z) {
                    obj.addElement(new RTSphere((Sphere)theObject, fromLocal, toLocal, this.time, info.object.getAverageParameterValues()));
                    return;
                }
                obj.addElement(new RTEllipsoid((Sphere)theObject, fromLocal, toLocal, this.time, info.object.getAverageParameterValues()));
                return;
            }
            if (theObject instanceof Cylinder) {
                obj.addElement(new RTCylinder((Cylinder)theObject, fromLocal, toLocal, this.time, info.object.getAverageParameterValues()));
                return;
            }
            if (theObject instanceof Cube) {
                obj.addElement(new RTCube((Cube)theObject, fromLocal, toLocal, this.time, info.object.getAverageParameterValues()));
                return;
            }
        }
        if ((mesh = info.getRenderingMesh(tol)) == null) {
            return;
        }
        mesh.transformMesh(fromLocal);
        Vec3[] vert = mesh.vert;
        Vec3[] norm = mesh.norm;
        RenderingTriangle[] t = mesh.triangle;
        if (displaced) {
            int i;
            double[] vertTol = new double[vert.length];
            if (this.adaptive) {
                for (i = 0; i < vert.length; ++i) {
                    double vertDist = orig.distance(vert[i]);
                    vertTol[i] = vertDist < distToScreen ? this.surfaceError : this.surfaceError * vertDist / distToScreen;
                }
            }
            for (i = 0; i < t.length; ++i) {
                double localTol;
                RenderingTriangle tri = mesh.triangle[i];
                if (vert[tri.v1].distance(vert[tri.v2]) < 1.0E-12 || vert[tri.v1].distance(vert[tri.v3]) < 1.0E-12 || vert[tri.v2].distance(vert[tri.v3]) < 1.0E-12) continue;
                if (this.adaptive) {
                    localTol = vertTol[tri.v1];
                    if (vertTol[tri.v2] < localTol) {
                        localTol = vertTol[tri.v2];
                    }
                    if (vertTol[tri.v3] < localTol) {
                        localTol = vertTol[tri.v3];
                    }
                } else {
                    localTol = tol;
                }
                RTDisplacedTriangle dispTri = new RTDisplacedTriangle(mesh, i, fromLocal, toLocal, localTol, this.time);
                RTObject dt = dispTri;
                if (!dispTri.isReallyDisplaced()) {
                    dt = new RTTriangle(mesh, i, fromLocal, toLocal, this.time);
                }
                obj.addElement(dt);
                if (this.adaptive && dt instanceof RTDisplacedTriangle) {
                    dist = dt.getBounds().distanceToPoint(orig);
                    if (dist < distToScreen) {
                        ((RTDisplacedTriangle)dt).setTolerance(this.surfaceError);
                    } else {
                        ((RTDisplacedTriangle)dt).setTolerance(this.surfaceError * dist / distToScreen);
                    }
                }
                if (this.renderThread == thisThread) continue;
                return;
            }
        } else {
            for (int i = 0; i < t.length; ++i) {
                RenderingTriangle tri = mesh.triangle[i];
                if (vert[tri.v1].distance(vert[tri.v2]) < 1.0E-12 || vert[tri.v1].distance(vert[tri.v3]) < 1.0E-12 || vert[tri.v2].distance(vert[tri.v3]) < 1.0E-12) continue;
                obj.addElement(new RTTriangle(mesh, i, fromLocal, toLocal, this.time));
            }
        }
    }

    void buildTree() {
        int i;
        BoundingBox[] objBounds = new BoundingBox[this.sceneObject.length];
        double minz = Double.MAX_VALUE;
        double miny = Double.MAX_VALUE;
        double minx = Double.MAX_VALUE;
        double maxz = -1.7976931348623157E308;
        double maxy = -1.7976931348623157E308;
        double maxx = -1.7976931348623157E308;
        for (i = 0; i < this.sceneObject.length; ++i) {
            objBounds[i] = this.sceneObject[i].getBounds();
            if (objBounds[i].minx < minx) {
                minx = objBounds[i].minx;
            }
            if (objBounds[i].maxx > maxx) {
                maxx = objBounds[i].maxx;
            }
            if (objBounds[i].miny < miny) {
                miny = objBounds[i].miny;
            }
            if (objBounds[i].maxy > maxy) {
                maxy = objBounds[i].maxy;
            }
            if (objBounds[i].minz < minz) {
                minz = objBounds[i].minz;
            }
            if (!(objBounds[i].maxz > maxz)) continue;
            maxz = objBounds[i].maxz;
        }
        this.rootNode = new OctreeNode(minx -= 1.0E-12, maxx += 1.0E-12, miny -= 1.0E-12, maxy += 1.0E-12, minz -= 1.0E-12, maxz += 1.0E-12, this.sceneObject, objBounds, null);
        this.cameraNode = this.rootNode.findNode(this.theCamera.getCameraCoordinates().getOrigin());
        this.lightNode = new OctreeNode[this.light.length];
        for (i = 0; i < this.light.length; ++i) {
            this.lightNode[i] = this.light[i].object instanceof DirectionalLight ? null : this.rootNode.findNode(this.light[i].coords.getOrigin());
        }
    }

    private void buildPhotonMap() {
        if (this.giMode == 2) {
            this.listener.statusChanged("Building Global Photon Map");
            this.globalMap = new PhotonMap(this.globalPhotons, this.globalNeighborPhotons, false, false, true, this, this.rootNode, 1, null);
            this.generatePhotons(this.globalMap);
        } else if (this.giMode == 3) {
            this.listener.statusChanged("Building Global Photon Map");
            this.globalMap = new PhotonMap(this.globalPhotons, this.globalNeighborPhotons, true, true, true, this, this.rootNode, 0, null);
            this.generatePhotons(this.globalMap);
        }
        if (this.caustics) {
            BoundingBox bounds = null;
            for (int i = 0; i < this.sceneObject.length; ++i) {
                Texture tex = this.sceneObject[i].getTextureMapping().getTexture();
                MaterialMapping mm = this.sceneObject[i].getMaterialMapping();
                if (!tex.hasComponent(1) && (!tex.hasComponent(2) || mm == null || mm.getMaterial().indexOfRefraction() == 1.0)) continue;
                bounds = bounds == null ? this.sceneObject[i].getBounds() : bounds.merge(this.sceneObject[i].getBounds());
            }
            if (bounds == null) {
                bounds = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
            }
            this.listener.statusChanged("Building Caustics Photon Map");
            this.causticsMap = new PhotonMap(this.causticsPhotons, this.causticsNeighborPhotons, true, false, false, this, bounds, 2, null);
            this.generatePhotons(this.causticsMap);
        }
    }

    private void generatePhotons(PhotonMap map) {
        int i;
        BoundingBox bounds = map.getBounds();
        Vector<PhotonSource> sources = new Vector<PhotonSource>();
        for (i = 0; i < this.light.length; ++i) {
            if (this.light[i].object instanceof DirectionalLight) {
                sources.addElement(new DirectionalPhotonSource((DirectionalLight)this.light[i].object, this.light[i].coords, bounds));
                continue;
            }
            if (this.light[i].object instanceof PointLight) {
                sources.addElement(new PointPhotonSource((PointLight)this.light[i].object, this.light[i].coords, bounds));
                continue;
            }
            if (!(this.light[i].object instanceof SpotLight)) continue;
            sources.addElement(new SpotlightPhotonSource((SpotLight)this.light[i].object, this.light[i].coords, bounds));
        }
        for (i = 0; i < this.sceneObject.length; ++i) {
            PhotonSource src;
            if (!this.sceneObject[i].getTextureMapping().getTexture().hasComponent(4)) continue;
            if (this.sceneObject[i] instanceof RTTriangle) {
                src = new TrianglePhotonSource((RTTriangle)this.sceneObject[i], this);
            } else if (this.sceneObject[i] instanceof RTDisplacedTriangle) {
                src = new DisplacedTrianglePhotonSource((RTDisplacedTriangle)this.sceneObject[i], this);
            } else if (this.sceneObject[i] instanceof RTEllipsoid) {
                src = new EllipsoidPhotonSource((RTEllipsoid)this.sceneObject[i], this);
            } else if (this.sceneObject[i] instanceof RTSphere) {
                src = new EllipsoidPhotonSource((RTSphere)this.sceneObject[i], this);
            } else {
                if (!(this.sceneObject[i] instanceof RTCylinder)) continue;
                src = new CylinderPhotonSource((RTCylinder)this.sceneObject[i], this);
            }
            if (!(src.getTotalIntensity() > 0.0)) continue;
            sources.addElement(src);
        }
        sources.addElement(new EnvironmentPhotonSource(this.theScene, bounds));
        Object[] src = new PhotonSource[sources.size()];
        sources.copyInto(src);
        map.generatePhotons((PhotonSource[])src);
    }

    public void run() {
        try {
            PixelInfo tempPixel = new PixelInfo();
            RGBColor col = this.color[0];
            int lastUpdated = 0;
            long updateTime = System.currentTimeMillis();
            Thread thisThread = Thread.currentThread();
            this.listener.statusChanged("Processing Scene");
            this.buildScene(this.theScene, this.theCamera);
            if (this.renderThread != thisThread) {
                return;
            }
            this.buildTree();
            this.buildPhotonMap();
            this.listener.statusChanged("Rendering");
            for (int i = 0; i < this.pixel.length; ++i) {
                this.pixel[i] = 0;
            }
            this.viewpoint = this.theCamera.getCameraCoordinates().getOrigin();
            Point p = new Point(this.width / 2, this.height / 2);
            this.center = this.theCamera.convertScreenToWorld(p, this.focalDist);
            this.cameraDir = this.center.minus(this.viewpoint);
            this.cameraDir.normalize();
            ++p.x;
            this.hvec = this.theCamera.convertScreenToWorld(p, this.focalDist).minus(this.center);
            --p.x;
            ++p.y;
            this.vvec = this.theCamera.convertScreenToWorld(p, this.focalDist).minus(this.center);
            --p.y;
            this.smoothScale = this.smoothing * this.hvec.length() / this.focalDist;
            double d = this.dofScale = this.depthOfField == 0.0 ? 0.0 : 0.0025 * (double)this.height * this.focalDist / this.depthOfField;
            if (this.maxRays == 1) {
                this.rtWidth = this.width;
                this.rtHeight = this.height;
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        tempPixel.clear();
                        tempPixel.depth = (float)this.spawnEyeRay(j, i, 0, 1);
                        tempPixel.add(col, (float)this.transparency[0]);
                        this.recordPixel(j, i, tempPixel);
                        if (this.renderThread == thisThread) continue;
                        return;
                    }
                    if (System.currentTimeMillis() - updateTime <= 5000L) continue;
                    this.imageSource.newPixels();
                    this.listener.imageUpdated(this.img);
                    lastUpdated = i;
                    updateTime = System.currentTimeMillis();
                }
                this.imageSource.newPixels();
                this.finish();
                return;
            }
            this.rtWidth = 2 * this.width + 2;
            this.rtHeight = 2 * this.height + 2;
            this.hvec.scale(0.5);
            this.vvec.scale(0.5);
            this.smoothScale *= 0.5;
            this.dofScale *= 2.0;
            PixelInfo[][] pix = new PixelInfo[6][this.rtWidth];
            for (int i = 0; i < pix.length; ++i) {
                for (int j = 0; j < pix[i].length; ++j) {
                    pix[i][j] = new PixelInfo();
                }
            }
            int minPerSubpixel = this.minRays / 4;
            int maxPerSubpixel = this.maxRays / 4;
            for (int i = 0; i < this.height - 1; ++i) {
                int j;
                boolean done = false;
                for (int count = minPerSubpixel; count <= maxPerSubpixel && !done; count *= 2) {
                    int j2;
                    int m;
                    for (m = 0; m < 6; ++m) {
                        for (j2 = 0; j2 < this.rtWidth; ++j2) {
                            PixelInfo thisPixel = pix[m][j2];
                            thisPixel.converged = true;
                            if (!thisPixel.needsMore) continue;
                            tempPixel.clear();
                            int baseNum = (m & 1) * 8 + (j2 & 1) * 4;
                            int numNeeded = count - thisPixel.raysSent;
                            for (int k = thisPixel.raysSent; k < count; ++k) {
                                float dist = (float)this.spawnEyeRay(j2, 2 * i + m, baseNum + k, numNeeded);
                                if (k < count / 2) {
                                    thisPixel.add(col, (float)this.transparency[0]);
                                    if (!(dist < thisPixel.depth)) continue;
                                    thisPixel.depth = dist;
                                    continue;
                                }
                                tempPixel.add(col, (float)this.transparency[0]);
                                if (!(dist < tempPixel.depth)) continue;
                                tempPixel.depth = dist;
                            }
                            if (count > 1) {
                                thisPixel.converged = thisPixel.matches(tempPixel, 0.0078125f, 0.03125f);
                            }
                            thisPixel.add(tempPixel);
                            if (this.renderThread == thisThread) continue;
                            return;
                        }
                    }
                    if (count == 1) {
                        for (m = 0; m < 5; ++m) {
                            for (j2 = 0; j2 < this.rtWidth - 1; ++j2) {
                                if (!pix[m][j2].matches(pix[m + 1][j2], 0.0078125f, 0.03125f)) {
                                    pix[m + 1][j2].converged = false;
                                    pix[m][j2].converged = false;
                                }
                                if (pix[m][j2].matches(pix[m][j2 + 1], 0.0078125f, 0.03125f)) continue;
                                pix[m][j2 + 1].converged = false;
                                pix[m][j2].converged = false;
                            }
                        }
                    }
                    for (m = 0; m < 6; ++m) {
                        for (j2 = 0; j2 < this.rtWidth; ++j2) {
                            pix[m][j2].needsMore = false;
                        }
                    }
                    done = true;
                    for (m = 0; m < 6; ++m) {
                        for (j2 = 0; j2 < this.rtWidth; ++j2) {
                            if (pix[m][j2].converged) continue;
                            done = false;
                            pix[m][j2].needsMore = true;
                            if (m > 0) {
                                pix[m - 1][j2].needsMore = true;
                            }
                            if (m < 5) {
                                pix[m + 1][j2].needsMore = true;
                            }
                            if (j2 > 0) {
                                pix[m][j2 - 1].needsMore = true;
                            }
                            if (j2 >= this.rtWidth - 1) continue;
                            pix[m][j2 + 1].needsMore = true;
                        }
                    }
                }
                this.recordRow(pix, tempPixel, i);
                if (System.currentTimeMillis() - updateTime > 5000L) {
                    this.imageSource.newPixels();
                    this.listener.imageUpdated(this.img);
                    lastUpdated = i;
                    updateTime = System.currentTimeMillis();
                }
                PixelInfo[] temp1 = pix[0];
                PixelInfo[] temp2 = pix[1];
                for (j = 0; j < 4; ++j) {
                    pix[j] = pix[j + 2];
                }
                pix[4] = temp1;
                pix[5] = temp2;
                for (j = 0; j < this.rtWidth; ++j) {
                    pix[4][j].clear();
                    pix[5][j].clear();
                }
                done = false;
            }
            this.recordRow(pix, tempPixel, this.height - 1);
            this.imageSource.newPixels();
            this.finish();
        }
        catch (NullPointerException npe) {
            this.setAllNull();
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.setAllNull();
        }
    }

    private void recordRow(PixelInfo[][] pix, PixelInfo tempPixel, int row) {
        for (int i = 0; i < this.width; ++i) {
            int x = i * 2 + 1;
            tempPixel.copy(pix[1][x]);
            tempPixel.add(pix[1][x + 1]);
            tempPixel.add(pix[2][x]);
            tempPixel.add(pix[2][x + 1]);
            if (this.antialiasLevel == 2) {
                tempPixel.add(tempPixel);
                tempPixel.add(pix[0][x]);
                tempPixel.add(pix[0][x + 1]);
                tempPixel.add(pix[3][x]);
                tempPixel.add(pix[3][x + 1]);
                tempPixel.add(pix[1][x - 1]);
                tempPixel.add(pix[2][x - 1]);
                tempPixel.add(pix[1][x + 2]);
                tempPixel.add(pix[2][x + 2]);
            }
            this.recordPixel(i, row, tempPixel);
        }
    }

    private void recordPixel(int x, int y, PixelInfo pix) {
        int index = x + y * this.width;
        this.pixel[index] = pix.calcARGB();
        if (this.floatImage == null) {
            return;
        }
        float ninv = 1.0f / (float)pix.raysSent;
        this.floatImage[0][index] = pix.red * ninv;
        this.floatImage[1][index] = pix.green * ninv;
        this.floatImage[2][index] = pix.blue * ninv;
        this.floatImage[3][index] = 1.0f - pix.transparency * ninv;
        if (this.depthImage != null) {
            this.depthImage[index] = pix.depth;
        }
    }

    private void finish() {
        RenderListener rl = this.listener;
        this.setAllNull();
        System.out.println("Raytracer.finish " + this + " " + rl);
        if (rl != null) {
            ComplexImage im = new ComplexImage(this.img);
            if (this.floatImage != null) {
                im.setComponentValues(2, this.floatImage[0]);
                im.setComponentValues(1, this.floatImage[1]);
                im.setComponentValues(0, this.floatImage[2]);
                im.setComponentValues(3, this.floatImage[3]);
            }
            if (this.depthImage != null) {
                im.setComponentValues(4, this.depthImage);
            }
            rl.imageComplete(im);
        }
        System.gc();
    }

    protected void setAllNull() {
        this.sceneObject = null;
        this.light = null;
        this.rootNode = null;
        this.cameraNode = null;
        this.lightNode = null;
        this.theScene = null;
        this.theCamera = null;
        this.envMapping = null;
        this.renderThread = null;
        this.intersect = null;
        this.matChange = null;
        this.globalMap = null;
        this.causticsMap = null;
    }

    private double spawnEyeRay(int i, int j, int number, int outOf) {
        Vec3 orig = this.ray[0].getOrigin();
        Vec3 dir = this.ray[0].getDirection();
        double h = (double)i - (double)this.rtWidth * 0.5 + 0.5;
        double v = (double)j - (double)this.rtHeight * 0.5 + 0.5;
        if (this.antialiasLevel > 0) {
            int rows = (int)Math.ceil(Math.sqrt(outOf));
            int cols = outOf / rows;
            int num = number % outOf;
            int row = num / cols;
            int col = num - row * cols;
            h += ((double)col + this.random.nextDouble()) / (double)cols - 0.5;
            v += ((double)row + this.random.nextDouble()) / (double)rows - 0.5;
        }
        orig.set(this.viewpoint);
        if (this.depth) {
            double angle = (this.random.nextDouble() + (double)distrib1[number & 0xF]) * Math.PI * 0.5;
            double radius = (this.random.nextDouble() + (double)distrib2[number & 0xF]) * this.dofScale;
            double dh = radius * Math.cos(angle);
            double dv = radius * Math.sin(angle);
            orig.x += dh * this.hvec.x + dv * this.vvec.x;
            orig.y += dh * this.hvec.y + dv * this.vvec.y;
            orig.z += dh * this.hvec.z + dv * this.vvec.z;
        }
        this.rayIntensity[0].setRGB(1.0f, 1.0f, 1.0f);
        dir.x = this.center.x + h * this.hvec.x + v * this.vvec.x - orig.x;
        dir.y = this.center.y + h * this.hvec.y + v * this.vvec.y - orig.y;
        dir.z = this.center.z + h * this.hvec.z + v * this.vvec.z - orig.z;
        dir.normalize();
        this.ray[0].newID();
        double distScale = 1.0 / dir.dot(this.cameraDir);
        if (this.cameraNode != null) {
            return distScale * this.spawnRay(0, this.cameraNode, null, null, null, null, null, number, 0.0, true, false);
        }
        OctreeNode node = this.rootNode.findFirstNode(this.ray[0]);
        if (node == null) {
            if (this.transparentBackground) {
                this.transparency[0] = 1.0;
                this.color[0].setRGB(0.0f, 0.0f, 0.0f);
                return 3.4028234663852886E38;
            }
            if (this.envMode == 0) {
                this.color[0].copy(this.envColor);
                return 3.4028234663852886E38;
            }
            this.envMapping.getTextureSpec(this.ray[0].direction, this.surfSpec[0], 1.0, this.smoothScale, this.time, this.envParamValue);
            if (this.envMode == 1) {
                this.color[0].copy(this.surfSpec[0].diffuse);
            } else {
                this.color[0].copy(this.surfSpec[0].emissive);
            }
            return 3.4028234663852886E38;
        }
        return distScale * this.spawnRay(0, node, null, null, null, null, null, number, 0.0, true, false);
    }

    private double spawnRay(int treeDepth, OctreeNode node, RTObject first, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, int rayNumber, double totalDist, boolean transmitted, boolean diffuse) {
        double d;
        Vec3 temp;
        double texSmoothing;
        OctreeNode nextNode;
        RTObject second = null;
        double beta = 0.0;
        float fract = 0.0f;
        Vec3 intersectionPoint = this.pos[treeDepth];
        Vec3 norm = this.normal[treeDepth];
        Vec3 trueNorm = this.trueNormal[treeDepth];
        boolean totalReflect = false;
        Ray r = this.ray[treeDepth];
        TextureSpec spec = this.surfSpec[treeDepth];
        Mat4 oldMatTrans = null;
        this.transparency[treeDepth] = 0.0;
        if (first != null && first.intersects(r)) {
            first.intersectionPoint(0, intersectionPoint);
            nextNode = this.rootNode.findNode(intersectionPoint);
        } else {
            nextNode = this.traceRay(r, node);
            if (nextNode == null) {
                if (transmitted && this.transparentBackground) {
                    this.color[treeDepth].setRGB(0.0f, 0.0f, 0.0f);
                    this.transparency[treeDepth] = Math.min(Math.min(this.rayIntensity[treeDepth].getRed(), this.rayIntensity[treeDepth].getGreen()), this.rayIntensity[treeDepth].getBlue());
                    return 3.4028234663852886E38;
                }
                if (this.envMode == 0) {
                    this.color[treeDepth].copy(this.envColor);
                    this.color[treeDepth].multiply(this.rayIntensity[treeDepth]);
                    return 3.4028234663852886E38;
                }
                double envSmoothing = diffuse ? this.smoothScale * this.extraGIEnvSmoothing : this.smoothScale;
                this.envMapping.getTextureSpec(r.direction, spec, 1.0, this.smoothing * envSmoothing, this.time, this.envParamValue);
                if (this.envMode == 1) {
                    this.color[treeDepth].copy(spec.diffuse);
                } else {
                    this.color[treeDepth].copy(spec.emissive);
                }
                this.color[treeDepth].multiply(this.rayIntensity[treeDepth]);
                return 3.4028234663852886E38;
            }
            first = this.intersect.first;
            second = this.intersect.second;
            first.intersectionPoint(0, intersectionPoint);
        }
        double dist = first.intersectionDist(0);
        totalDist += dist;
        first.trueNormal(trueNorm);
        double truedot = trueNorm.dot(r.getDirection());
        double d2 = texSmoothing = diffuse ? this.smoothScale * this.extraGISmoothing : this.smoothScale;
        if (truedot > 0.0) {
            first.intersectionProperties(spec, norm, r.getDirection(), totalDist * texSmoothing * 3.0 / (2.0 + truedot));
        } else {
            first.intersectionProperties(spec, norm, r.getDirection(), totalDist * texSmoothing * 3.0 / (2.0 - truedot));
        }
        this.getDirectLight(intersectionPoint, norm, truedot < 0.0, r.getDirection(), treeDepth, nextNode, rayNumber, totalDist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, diffuse);
        if (currentMaterial != null) {
            this.propagateRay(r, node, dist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, this.tempColor, this.rayIntensity[treeDepth], treeDepth, totalDist);
            this.color[treeDepth].multiply(this.rayIntensity[treeDepth]);
            this.color[treeDepth].add(this.tempColor);
        } else if (this.fog) {
            fract = (float)Math.exp(-dist / this.fogDist);
            this.rayIntensity[treeDepth].scale(fract);
            this.color[treeDepth].multiply(this.rayIntensity[treeDepth]);
            this.tempColor.copy(this.fogColor);
            this.tempColor.scale(1.0f - fract);
            this.color[treeDepth].add(this.tempColor);
        } else {
            this.color[treeDepth].multiply(this.rayIntensity[treeDepth]);
        }
        if (treeDepth == this.maxRayDepth - 1) {
            return dist;
        }
        boolean spawnSpecular = false;
        boolean spawnTransmitted = false;
        boolean spawnDiffuse = false;
        float specularScale = 1.0f;
        float transmittedScale = 1.0f;
        float diffuseScale = 1.0f;
        RGBColor col = this.rayIntensity[treeDepth];
        if (this.roulette) {
            float prob = (col.getRed() * spec.specular.getRed() + col.getGreen() * spec.specular.getGreen() + col.getBlue() * spec.specular.getBlue()) / 3.0f;
            if (prob > this.random.nextFloat()) {
                spawnSpecular = true;
                specularScale = 1.0f / prob;
            }
            if ((prob = (col.getRed() * spec.transparent.getRed() + col.getGreen() * spec.transparent.getGreen() + col.getBlue() * spec.transparent.getBlue()) / 3.0f) > this.random.nextFloat()) {
                spawnTransmitted = true;
                transmittedScale = 1.0f / prob;
            }
            if ((this.giMode == 1 || this.giMode == 3 && !diffuse) && (prob = (col.getRed() * spec.diffuse.getRed() + col.getGreen() * spec.diffuse.getGreen() + col.getBlue() * spec.diffuse.getBlue()) / 3.0f) > this.random.nextFloat()) {
                spawnDiffuse = true;
                diffuseScale = 1.0f / prob;
            }
        } else {
            spawnSpecular = col.getRed() * spec.specular.getRed() > this.minRayIntensity || col.getGreen() * spec.specular.getGreen() > this.minRayIntensity || col.getBlue() * spec.specular.getBlue() > this.minRayIntensity;
            boolean bl = spawnTransmitted = col.getRed() * spec.transparent.getRed() > this.minRayIntensity || col.getGreen() * spec.transparent.getGreen() > this.minRayIntensity || col.getBlue() * spec.transparent.getBlue() > this.minRayIntensity;
            if (this.giMode == 1 || this.giMode == 3 && !diffuse) {
                spawnDiffuse = col.getRed() * spec.diffuse.getRed() > this.minRayIntensity || col.getGreen() * spec.diffuse.getGreen() > this.minRayIntensity || col.getBlue() * spec.diffuse.getBlue() > this.minRayIntensity;
            }
        }
        double dot = norm.dot(r.getDirection());
        col = this.rayIntensity[treeDepth + 1];
        if (spawnTransmitted) {
            double n;
            MaterialMapping oldMaterial;
            Mat4 nextMatTrans;
            MaterialMapping nextMaterial;
            col.copy(this.rayIntensity[treeDepth]);
            col.multiply(spec.transparent);
            col.scale(transmittedScale);
            this.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            temp = this.ray[treeDepth + 1].getDirection();
            if (first.getMaterialMapping() == null) {
                temp.set(r.getDirection());
                nextMaterial = currentMaterial;
                nextMatTrans = currentMatTrans;
                oldMaterial = prevMaterial;
                oldMatTrans = prevMatTrans;
            } else if (dot < 0.0) {
                nextMaterial = first.getMaterialMapping();
                nextMatTrans = first.toLocal();
                oldMaterial = currentMaterial;
                oldMatTrans = currentMatTrans;
                n = currentMaterial == null ? nextMaterial.indexOfRefraction() / 1.0 : nextMaterial.indexOfRefraction() / currentMaterial.indexOfRefraction();
                beta = -(dot + Math.sqrt(n * n - 1.0 + dot * dot));
                temp.set(norm);
                temp.scale(beta);
                temp.add(r.getDirection());
                temp.scale(1.0 / n);
            } else {
                if (currentMaterial == first.getMaterialMapping()) {
                    nextMaterial = prevMaterial;
                    nextMatTrans = prevMatTrans;
                    oldMaterial = null;
                    n = nextMaterial == null ? 1.0 / currentMaterial.indexOfRefraction() : nextMaterial.indexOfRefraction() / currentMaterial.indexOfRefraction();
                } else {
                    nextMaterial = currentMaterial;
                    nextMatTrans = currentMatTrans;
                    if (prevMaterial == first.getMaterialMapping()) {
                        oldMaterial = null;
                    } else {
                        oldMaterial = prevMaterial;
                        oldMatTrans = prevMatTrans;
                    }
                    n = 1.0;
                }
                beta = dot - Math.sqrt(n * n - 1.0 + dot * dot);
                temp.set(norm);
                temp.scale(-beta);
                temp.add(r.getDirection());
                temp.scale(1.0 / n);
            }
            if (Double.isNaN(beta)) {
                totalReflect = true;
            } else {
                double d3 = d = truedot > 0.0 ? temp.dot(trueNorm) : -temp.dot(trueNorm);
                if (d < 0.0) {
                    temp.x -= (d += 1.0E-12) * trueNorm.x;
                    temp.y -= d * trueNorm.y;
                    temp.z -= d * trueNorm.z;
                    temp.normalize();
                }
                this.ray[treeDepth + 1].newID();
                if (this.gloss) {
                    this.randomizeDirection(temp, norm, spec.cloudiness, rayNumber + treeDepth + 1);
                }
                this.spawnRay(treeDepth + 1, nextNode, second, nextMaterial, oldMaterial, nextMatTrans, oldMatTrans, rayNumber, totalDist, transmitted, diffuse);
                this.color[treeDepth].add(this.color[treeDepth + 1]);
                if (transmitted && this.transparentBackground) {
                    this.transparency[treeDepth] = this.transparency[treeDepth + 1];
                }
            }
        }
        if (spawnSpecular || totalReflect) {
            col.copy(spec.specular);
            col.scale(specularScale);
            if (totalReflect) {
                col.add(spec.transparent.getRed() * transmittedScale, spec.transparent.getGreen() * transmittedScale, spec.transparent.getBlue() * transmittedScale);
            }
            col.multiply(this.rayIntensity[treeDepth]);
            temp = this.ray[treeDepth + 1].getDirection();
            temp.set(norm);
            temp.scale(-2.0 * dot);
            temp.add(r.getDirection());
            double d4 = d = truedot > 0.0 ? temp.dot(trueNorm) : -temp.dot(trueNorm);
            if (d >= 0.0) {
                temp.x += (d += 1.0E-12) * trueNorm.x;
                temp.y += d * trueNorm.y;
                temp.z += d * trueNorm.z;
                temp.normalize();
            }
            this.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            this.ray[treeDepth + 1].newID();
            if (this.gloss) {
                this.randomizeDirection(temp, norm, spec.roughness, rayNumber + treeDepth + 1);
            }
            this.spawnRay(treeDepth + 1, nextNode, null, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, rayNumber, totalDist, false, diffuse);
            this.color[treeDepth].add(this.color[treeDepth + 1]);
        }
        if (spawnDiffuse) {
            col.copy(spec.diffuse);
            col.multiply(this.rayIntensity[treeDepth]);
            col.scale(0.5f * diffuseScale);
            temp = this.ray[treeDepth + 1].getDirection();
            do {
                temp.set(0.0, 0.0, 0.0);
                this.randomizePoint(temp, 1.0, rayNumber + treeDepth + 1);
                temp.normalize();
                d = temp.dot(trueNorm) * (truedot > 0.0 ? 1.0 : -1.0);
            } while (this.random.nextDouble() > (d < 0.0 ? -d : d));
            if (d > 0.0) {
                temp.scale(-1.0);
            }
            this.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            this.ray[treeDepth + 1].newID();
            this.spawnRay(treeDepth + 1, nextNode, null, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, rayNumber, totalDist, false, true);
            this.color[treeDepth].add(this.color[treeDepth + 1]);
        }
        return dist;
    }

    void getDirectLight(Vec3 pos, Vec3 normal, boolean front, Vec3 viewDir, int treeDepth, OctreeNode node, int rayNumber, double totalDist, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, boolean diffuse) {
        RGBColor lightColor = this.color[treeDepth + 1];
        RGBColor finalColor = this.color[treeDepth];
        TextureSpec spec = this.surfSpec[treeDepth];
        Ray r = this.ray[treeDepth + 1];
        double distToLight = 0.0;
        double fatt = 0.0;
        finalColor.copy(this.ambColor);
        finalColor.multiply(spec.diffuse);
        finalColor.add(spec.emissive);
        if (this.giMode == 3 && diffuse) {
            this.globalMap.getLight(pos, spec, normal, viewDir, front, lightColor);
            finalColor.add(lightColor);
            return;
        }
        if (this.giMode == 2) {
            this.globalMap.getLight(pos, spec, normal, viewDir, front, lightColor);
            finalColor.add(lightColor);
        }
        if (this.caustics) {
            this.causticsMap.getLight(pos, spec, normal, viewDir, front, lightColor);
            finalColor.add(lightColor);
        }
        r.getOrigin().set(pos);
        Vec3 dir = r.getDirection();
        double sign = front ? 1.0 : -1.0;
        boolean hilight = (double)spec.hilight.getRed() != 0.0 || (double)spec.hilight.getGreen() != 0.0 || (double)spec.hilight.getBlue() != 0.0;
        for (int i = this.light.length - 1; i >= 0; --i) {
            Light lt = (Light)this.light[i].object;
            Vec3 lightPos = this.light[i].coords.getOrigin();
            if (lt instanceof PointLight) {
                dir.set(lightPos);
                if (this.penumbra) {
                    this.randomizePoint(dir, ((PointLight)lt).getRadius(), rayNumber + treeDepth + 1);
                }
                dir.subtract(pos);
                distToLight = dir.length();
                dir.normalize();
            } else if (lt instanceof SpotLight) {
                dir.set(lightPos);
                if (this.penumbra) {
                    this.randomizePoint(dir, ((SpotLight)lt).getRadius(), rayNumber + treeDepth + 1);
                }
                dir.subtract(pos);
                distToLight = dir.length();
                dir.normalize();
                fatt = -dir.dot(this.light[i].coords.getZDirection());
                if (fatt < ((SpotLight)lt).getAngleCosine()) {
                    continue;
                }
            } else if (lt instanceof DirectionalLight) {
                dir.set(this.light[i].coords.getZDirection());
                dir.scale(-1.0);
                distToLight = Double.MAX_VALUE;
            }
            r.newID();
            double dot = lt.isAmbient() ? 1.0 : sign * dir.dot(normal);
            if (!(dot > 0.0)) continue;
            lt.getLight(lightColor, (float)distToLight);
            if (lt instanceof SpotLight) {
                lightColor.scale(Math.pow(fatt, ((SpotLight)lt).getExponent()));
            }
            if ((double)lightColor.getRed() * ((double)spec.diffuse.getRed() * dot + (double)spec.hilight.getRed()) < (double)this.minRayIntensity && (double)lightColor.getGreen() * ((double)spec.diffuse.getGreen() * dot + (double)spec.hilight.getGreen()) < (double)this.minRayIntensity && (double)lightColor.getBlue() * ((double)spec.diffuse.getBlue() * dot + (double)spec.hilight.getBlue()) < (double)this.minRayIntensity || !lt.isAmbient() && !this.traceLightRay(r, lt, treeDepth + 1, node, this.lightNode[i], distToLight, totalDist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans)) continue;
            this.tempColor.copy(lightColor);
            this.tempColor.multiply(spec.diffuse);
            this.tempColor.scale(dot);
            finalColor.add(this.tempColor);
            if (!hilight) continue;
            dir.subtract(viewDir);
            dir.normalize();
            dot = sign * dir.dot(normal);
            if (!(dot > 0.0)) continue;
            this.tempColor.copy(lightColor);
            this.tempColor.multiply(spec.hilight);
            this.tempColor.scale(Math.pow(dot, (1.0 - spec.roughness) * 128.0 + 1.0));
            finalColor.add(this.tempColor);
        }
    }

    OctreeNode traceRay(Ray r, OctreeNode node) {
        RTObject first = null;
        RTObject second = null;
        double firstDist = Double.MAX_VALUE;
        double secondDist = Double.MAX_VALUE;
        Vec3 intersectionPoint = this.pos[this.maxRayDepth];
        while (first == null) {
            RTObject[] obj = node.getObjects();
            for (int i = obj.length - 1; i >= 0; --i) {
                if (!obj[i].intersects(r)) continue;
                obj[i].intersectionPoint(0, intersectionPoint);
                if (!node.contains(intersectionPoint)) continue;
                double dist = obj[i].intersectionDist(0);
                if (dist < firstDist) {
                    secondDist = firstDist;
                    second = first;
                    firstDist = dist;
                    first = obj[i];
                    continue;
                }
                if (!(dist < secondDist)) continue;
                secondDist = dist;
                second = obj[i];
            }
            if (first != null || (node = node.findNextNode(r)) != null) continue;
            return null;
        }
        this.intersect.first = first;
        this.intersect.dist = firstDist;
        this.intersect.second = secondDist - firstDist < 1.0E-12 ? second : null;
        return node;
    }

    boolean traceLightRay(Ray r, Light lt, int treeDepth, OctreeNode node, OctreeNode endNode, double distToLight, double totalDist, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans) {
        double dist;
        int i;
        RGBColor lightColor = this.color[treeDepth];
        RGBColor transColor = this.surfSpec[treeDepth].transparent;
        Vec3 intersectionPoint = this.pos[this.maxRayDepth];
        Vec3 norm = this.normal[this.maxRayDepth];
        Vec3 trueNorm = this.trueNormal[this.maxRayDepth];
        int matCount = 0;
        do {
            RTObject[] obj = node.getObjects();
            block1: for (i = obj.length - 1; i >= 0; --i) {
                if (!obj[i].intersects(r)) continue;
                int j = 0;
                while (true) {
                    obj[i].intersectionPoint(j, intersectionPoint);
                    if (node.contains(intersectionPoint) && (dist = obj[i].intersectionDist(j)) < distToLight) {
                        obj[i].trueNormal(trueNorm);
                        double angle = -trueNorm.dot(r.getDirection());
                        obj[i].intersectionTransparency(j, transColor, angle, (totalDist + dist) * this.smoothScale);
                        lightColor.multiply(transColor);
                        if (lightColor.getRed() < this.minRayIntensity && lightColor.getGreen() < this.minRayIntensity && lightColor.getBlue() < this.minRayIntensity) {
                            return false;
                        }
                        MaterialMapping mat = obj[i].getMaterialMapping();
                        if (mat != null && mat.castsShadows()) {
                            this.matChange[matCount].mat = mat;
                            this.matChange[matCount].toLocal = obj[i].toLocal();
                            this.matChange[matCount].dist = dist;
                            this.matChange[matCount].node = node;
                            this.matChange[matCount].entered = matCount == 0 ? angle > 0.0 : !this.matChange[matCount - 1].entered;
                            ++matCount;
                        }
                    }
                    if (j >= obj[i].numIntersections() - 1) continue block1;
                    ++j;
                }
            }
        } while (node != endNode && (node = node.findNextNode(r)) != null);
        if (currentMaterial == null && matCount == 0) {
            return true;
        }
        this.sortMaterialList(matCount);
        this.matChange[matCount++].dist = distToLight;
        dist = 0.0;
        for (i = 0; i < matCount; ++i) {
            double n1;
            if (currentMaterial != null && currentMaterial.castsShadows()) {
                this.propagateLightRay(r, node, dist, this.matChange[i].dist, currentMaterial, lightColor, currentMatTrans, totalDist);
                if (lightColor.getRed() < this.minRayIntensity && lightColor.getGreen() < this.minRayIntensity && lightColor.getBlue() < this.minRayIntensity) {
                    return false;
                }
            }
            double d = n1 = currentMaterial == null ? 1.0 : currentMaterial.indexOfRefraction();
            if (this.matChange[i].entered) {
                if (this.matChange[i].mat != currentMaterial) {
                    prevMaterial = currentMaterial;
                    prevMatTrans = currentMatTrans;
                    currentMaterial = this.matChange[i].mat;
                    currentMatTrans = this.matChange[i].toLocal;
                }
            } else if (this.matChange[i].mat == currentMaterial) {
                currentMaterial = prevMaterial;
                currentMatTrans = prevMatTrans;
                prevMaterial = null;
            } else if (this.matChange[i].mat == prevMaterial) {
                prevMaterial = null;
            }
            if (this.caustics) {
                double n2;
                double d2 = n2 = currentMaterial == null ? 1.0 : currentMaterial.indexOfRefraction();
                if (n1 != n2) {
                    return false;
                }
            }
            node = this.matChange[i].node;
            dist = this.matChange[i].dist;
        }
        return true;
    }

    void propagateRay(Ray r, OctreeNode node, double dist, MaterialMapping material, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, RGBColor emitted, RGBColor filter, int treeDepth, double totalDist) {
        float be;
        float ge;
        float re;
        boolean scattering = material.isScattering();
        float rf = filter.getRed();
        float gf = filter.getGreen();
        float bf = filter.getBlue();
        if (material instanceof UniformMaterialMapping && !scattering) {
            material.getMaterialSpec(r.origin, this.matSpec, 0.0, this.time);
            RGBColor trans = this.matSpec.transparency;
            RGBColor blend = this.matSpec.color;
            float d = (float)dist;
            float rs = trans.getRed() == 1.0f ? 1.0f : (float)Math.pow(trans.getRed(), d);
            float gs = trans.getGreen() == 1.0f ? 1.0f : (float)Math.pow(trans.getGreen(), d);
            float bs = trans.getBlue() == 1.0f ? 1.0f : (float)Math.pow(trans.getBlue(), d);
            re = blend.getRed() * rf * (1.0f - rs);
            ge = blend.getGreen() * gf * (1.0f - gs);
            be = blend.getBlue() * bf * (1.0f - bs);
            rf *= rs;
            gf *= gs;
            bf *= bs;
        } else {
            Vec3 v = this.ray[treeDepth + 1].origin;
            Vec3 origin = r.origin;
            Vec3 direction = r.direction;
            double x = 0.0;
            double distToScreen = this.theCamera.getDistToScreen();
            v.set(origin);
            currentMatTrans.transform(v);
            double origx = v.x;
            double origy = v.y;
            double origz = v.z;
            v.set(direction);
            currentMatTrans.transformDirection(v);
            double dirx = v.x;
            double diry = v.y;
            double dirz = v.z;
            be = 0.0f;
            ge = 0.0f;
            re = 0.0f;
            double step = this.stepSize * material.getStepSize();
            do {
                double newx;
                double dx = this.antialiasLevel > 0 ? step * (1.5 * this.random.nextDouble()) : step;
                if (this.adaptive && totalDist > distToScreen) {
                    dx *= totalDist / distToScreen;
                }
                if ((newx = x + dx) > dist) {
                    dx = dist - x;
                    x = dist;
                } else {
                    x = newx;
                }
                totalDist += dx;
                v.set(origx + dirx * x, origy + diry * x, origz + dirz * x);
                material.getMaterialSpec(v, this.matSpec, dx, this.time);
                RGBColor trans = this.matSpec.transparency;
                RGBColor blend = this.matSpec.color;
                float rs = trans.getRed() == 1.0f ? 1.0f : (float)Math.pow(trans.getRed(), dx);
                float gs = trans.getGreen() == 1.0f ? 1.0f : (float)Math.pow(trans.getGreen(), dx);
                float bs = trans.getBlue() == 1.0f ? 1.0f : (float)Math.pow(trans.getBlue(), dx);
                re += blend.getRed() * rf * (1.0f - rs);
                ge += blend.getGreen() * gf * (1.0f - gs);
                be += blend.getBlue() * bf * (1.0f - bs);
                if (scattering) {
                    OctreeNode nextNode;
                    v.set(origin.x + direction.x * x, origin.y + direction.y * x, origin.z + direction.z * x);
                    while (!node.contains(v) && (nextNode = node.findNextNode(r)) != null) {
                        node = nextNode;
                    }
                    this.rayIntensity[treeDepth + 1].setRGB(rf * (float)dx, gf * (float)dx, bf * (float)dx);
                    this.rayIntensity[treeDepth + 1].multiply(this.matSpec.scattering);
                    if (this.rayIntensity[treeDepth + 1].getRed() > this.minRayIntensity || this.rayIntensity[treeDepth + 1].getGreen() > this.minRayIntensity || this.rayIntensity[treeDepth + 1].getBlue() > this.minRayIntensity) {
                        this.getScatteredLight(treeDepth + 1, node, this.matSpec.eccentricity, totalDist, material, prevMaterial, currentMatTrans, prevMatTrans);
                        re += this.color[treeDepth + 1].getRed();
                        ge += this.color[treeDepth + 1].getGreen();
                        be += this.color[treeDepth + 1].getBlue();
                    }
                }
                rf *= rs;
                gf *= gs;
                bf *= bs;
                if (!(rf < this.minRayIntensity) || !(gf < this.minRayIntensity) || !(bf < this.minRayIntensity)) continue;
                bf = 0.0f;
                gf = 0.0f;
                rf = 0.0f;
                break;
            } while (x < dist);
        }
        emitted.setRGB(re, ge, be);
        filter.setRGB(rf, gf, bf);
    }

    void propagateLightRay(Ray r, OctreeNode node, double startDist, double endDist, MaterialMapping material, RGBColor filter, Mat4 toLocal, double totalDist) {
        float rf = filter.getRed();
        float gf = filter.getGreen();
        float bf = filter.getBlue();
        if (material instanceof UniformMaterialMapping) {
            material.getMaterialSpec(r.origin, this.matSpec, 0.0, this.time);
            RGBColor trans = this.matSpec.transparency;
            float d = (float)(endDist - startDist);
            if (trans.getRed() != 1.0f) {
                rf *= (float)Math.pow(trans.getRed(), d);
            }
            if (trans.getGreen() != 1.0f) {
                gf *= (float)Math.pow(trans.getGreen(), d);
            }
            if (trans.getBlue() != 1.0f) {
                bf *= (float)Math.pow(trans.getBlue(), d);
            }
        } else {
            Vec3 v = this.ray[this.maxRayDepth].origin;
            double x = startDist;
            double distToScreen = this.theCamera.getDistToScreen();
            v.set(r.origin);
            toLocal.transform(v);
            double origx = v.x;
            double origy = v.y;
            double origz = v.z;
            v.set(r.direction);
            toLocal.transformDirection(v);
            double dirx = v.x;
            double diry = v.y;
            double dirz = v.z;
            double step = this.stepSize * material.getStepSize();
            do {
                double newx;
                double dx = this.antialiasLevel > 0 ? step * (1.5 * this.random.nextDouble()) : step;
                if (this.adaptive && totalDist > distToScreen) {
                    dx *= totalDist / distToScreen;
                }
                if ((newx = x + dx) > endDist) {
                    dx = endDist - x;
                    x = endDist;
                } else {
                    x = newx;
                }
                totalDist += dx;
                v.set(origx + dirx * x, origy + diry * x, origz + dirz * x);
                material.getMaterialSpec(v, this.matSpec, dx, this.time);
                RGBColor trans = this.matSpec.transparency;
                if (trans.getRed() != 1.0f) {
                    rf *= (float)Math.pow(trans.getRed(), dx);
                }
                if (trans.getGreen() != 1.0f) {
                    gf *= (float)Math.pow(trans.getGreen(), dx);
                }
                if (trans.getBlue() != 1.0f) {
                    bf *= (float)Math.pow(trans.getBlue(), dx);
                }
                if (!(rf < this.minRayIntensity) || !(gf < this.minRayIntensity) || !(bf < this.minRayIntensity)) continue;
                bf = 0.0f;
                gf = 0.0f;
                rf = 0.0f;
                break;
            } while (x < endDist);
        }
        filter.setRGB(rf, gf, bf);
    }

    void getScatteredLight(int treeDepth, OctreeNode node, double eccentricity, double totalDist, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans) {
        RGBColor filter = this.rayIntensity[treeDepth];
        RGBColor lightColor = this.color[treeDepth];
        Ray r = this.ray[treeDepth];
        Vec3 pos = r.origin;
        Vec3 viewDir = this.ray[treeDepth - 1].direction;
        double distToLight = 0.0;
        double fatt = 0.0;
        double ec2 = eccentricity * eccentricity;
        this.tempColor2.setRGB(0.0f, 0.0f, 0.0f);
        Vec3 dir = r.getDirection();
        for (int i = this.light.length - 1; i >= 0; --i) {
            Light lt = (Light)this.light[i].object;
            Vec3 lightPos = this.light[i].coords.getOrigin();
            if (lt instanceof PointLight) {
                dir.set(lightPos);
                dir.subtract(pos);
                distToLight = dir.length();
                dir.normalize();
            } else if (lt instanceof SpotLight) {
                dir.set(lightPos);
                dir.subtract(pos);
                distToLight = dir.length();
                dir.normalize();
                fatt = -dir.dot(this.light[i].coords.getZDirection());
                if (fatt < ((SpotLight)lt).getAngleCosine()) {
                    continue;
                }
            } else if (lt instanceof DirectionalLight) {
                dir.set(this.light[i].coords.getZDirection());
                dir.scale(-1.0);
                distToLight = Double.MAX_VALUE;
            }
            r.newID();
            lt.getLight(lightColor, (float)distToLight);
            lightColor.multiply(filter);
            if (lt instanceof SpotLight) {
                lightColor.scale(Math.pow(fatt, ((SpotLight)lt).getExponent()));
            }
            if (eccentricity != 0.0 && !lt.isAmbient()) {
                double dot = dir.dot(viewDir);
                fatt = (1.0 - ec2) / Math.pow(1.0 + ec2 + 2.0 * eccentricity * dot, 1.5);
                lightColor.scale(fatt);
            }
            if (lightColor.getRed() < this.minRayIntensity && lightColor.getGreen() < this.minRayIntensity && lightColor.getBlue() < this.minRayIntensity || !lt.isAmbient() && !this.traceLightRay(r, lt, treeDepth, node, this.lightNode[i], distToLight, totalDist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans)) continue;
            this.tempColor2.add(lightColor);
        }
        this.color[treeDepth].copy(this.tempColor2);
    }

    void randomizePoint(Vec3 pos, double size, int number) {
        double z;
        double y;
        double x;
        if (size == 0.0) {
            return;
        }
        while ((x = this.random.nextDouble()) * x + (y = this.random.nextDouble()) * y + (z = this.random.nextDouble()) * z > 1.0) {
        }
        x *= size;
        y *= size;
        z *= size;
        int d = distrib1[number & 0xF];
        if (d < 2) {
            x *= -1.0;
        }
        if (d == 1 || d == 2) {
            y *= -1.0;
        }
        if ((distrib2[number & 0xF] & 1) == 0) {
            z *= -1.0;
        }
        pos.x += x;
        pos.y += y;
        pos.z += z;
    }

    void randomizeDirection(Vec3 dir, Vec3 norm, double roughness, int number) {
        double z;
        double y;
        double x;
        if (roughness == 0.0) {
            return;
        }
        while ((x = this.random.nextDouble()) * x + (y = this.random.nextDouble()) * y + (z = this.random.nextDouble()) * z > 1.0) {
        }
        double scale = Math.pow(roughness, 1.7) * 0.5;
        x *= scale;
        y *= scale;
        z *= scale;
        int d = distrib1[number & 0xF];
        if (d < 2) {
            x *= -1.0;
        }
        if (d == 1 || d == 2) {
            y *= -1.0;
        }
        if ((distrib2[number & 0xF] & 1) == 0) {
            z *= -1.0;
        }
        double dot1 = dir.dot(norm);
        dir.x += x;
        dir.y += y;
        dir.z += z;
        double dot2 = 2.0 * dir.dot(norm);
        if (dot1 < 0.0 && dot2 > 0.0) {
            dir.x -= dot2 * norm.x;
            dir.y -= dot2 * norm.y;
            dir.z -= dot2 * norm.z;
        } else if (dot1 > 0.0 && dot2 < 0.0) {
            dir.x += dot2 * norm.x;
            dir.y += dot2 * norm.y;
            dir.z += dot2 * norm.z;
        }
        dir.normalize();
    }

    private void sortMaterialList(int count) {
        for (int i = 1; i < count; ++i) {
            for (int j = i; j > 0 && this.matChange[j].dist < this.matChange[j - 1].dist; --j) {
                MaterialIntersection temp = this.matChange[j - 1];
                this.matChange[j - 1] = this.matChange[j];
                this.matChange[j] = temp;
            }
        }
    }

    class MaterialIntersection {
        MaterialMapping mat;
        Mat4 toLocal;
        double dist;
        boolean entered;
        OctreeNode node;
    }

    class Intersection {
        RTObject first;
        RTObject second;
        double dist;
    }
}

