/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;

public class RTTriangle
extends RTObject {
    RenderingTriangle tri;
    Vec3 vert1;
    Vec3 trueNorm;
    double d;
    double t;
    double u;
    double v;
    double w;
    double time;
    double edge2d1x;
    double edge2d1y;
    double edge2d2x;
    double edge2d2y;
    double rix;
    double riy;
    double riz;
    short dropAxis;
    short flags;
    Mat4 toLocal;
    Mat4 fromLocal;
    public static final double TOL = 1.0E-12;
    private static final Ray tempRay = new Ray();
    private static final short BUMP_MAPPED = 1;
    private static final short INTERP_NORMALS = 2;

    public RTTriangle(RenderingMesh mesh, int which, Mat4 fromLocal, Mat4 toLocal, double time) {
        this.tri = mesh.triangle[which];
        this.vert1 = mesh.vert[this.tri.v1];
        Vec3 vert2 = mesh.vert[this.tri.v2];
        Vec3 vert3 = mesh.vert[this.tri.v3];
        this.trueNorm = mesh.faceNorm[which];
        this.fromLocal = fromLocal;
        this.toLocal = toLocal;
        this.time = time;
        if (this.tri.n1 != this.tri.n2 || this.tri.n1 != this.tri.n3) {
            // empty if block
        }
        this.flags = (short)(this.flags | 2);
        Vec3 norm1 = mesh.norm[this.tri.n1];
        Vec3 norm2 = mesh.norm[this.tri.n2];
        Vec3 norm3 = mesh.norm[this.tri.n3];
        int i = 0;
        if (this.trueNorm.dot(norm1) < 0.0) {
            ++i;
        }
        if (this.trueNorm.dot(norm2) < 0.0) {
            ++i;
        }
        if (this.trueNorm.dot(norm3) < 0.0) {
            ++i;
        }
        if (i > 1) {
            this.trueNorm.scale(-1.0);
        }
        this.d = -this.trueNorm.dot(this.vert1);
        this.dropAxis = Math.abs(this.trueNorm.y) > Math.abs(this.trueNorm.x) ? (Math.abs(this.trueNorm.z) > Math.abs(this.trueNorm.y) ? (short)2 : (short)1) : (Math.abs(this.trueNorm.z) > Math.abs(this.trueNorm.x) ? (short)2 : (short)0);
        switch (this.dropAxis) {
            case 0: {
                this.edge2d1x = this.vert1.y - vert2.y;
                this.edge2d1y = this.vert1.z - vert2.z;
                this.edge2d2x = this.vert1.y - vert3.y;
                this.edge2d2y = this.vert1.z - vert3.z;
                break;
            }
            case 1: {
                this.edge2d1x = this.vert1.x - vert2.x;
                this.edge2d1y = this.vert1.z - vert2.z;
                this.edge2d2x = this.vert1.x - vert3.x;
                this.edge2d2y = this.vert1.z - vert3.z;
                break;
            }
            default: {
                this.edge2d1x = this.vert1.x - vert2.x;
                this.edge2d1y = this.vert1.y - vert2.y;
                this.edge2d2x = this.vert1.x - vert3.x;
                this.edge2d2y = this.vert1.y - vert3.y;
            }
        }
        double denom = 1.0 / (this.edge2d1x * this.edge2d2y - this.edge2d1y * this.edge2d2x);
        this.edge2d1x *= denom;
        this.edge2d1y *= denom;
        this.edge2d2x *= denom;
        this.edge2d2y *= denom;
        if (this.tri.theMesh.mapping.getTexture().hasComponent(5)) {
            this.flags = (short)(this.flags | 1);
        }
        this.lastRay = -1;
    }

    public final TextureMapping getTextureMapping() {
        return this.tri.getTextureMapping();
    }

    public final MaterialMapping getMaterialMapping() {
        return this.tri.theMesh.matMapping;
    }

    protected boolean checkIntersection(Ray r) {
        double vy;
        double vx;
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        this.lastRay = r.getID();
        double vd = this.trueNorm.dot(dir);
        if (vd == 0.0) {
            this.lastRayResult = false;
            return false;
        }
        double v0 = -(this.trueNorm.dot(orig) + this.d);
        this.t = v0 / vd;
        if (this.t < 1.0E-12) {
            this.lastRayResult = false;
            return false;
        }
        this.rix = orig.x + dir.x * this.t;
        this.riy = orig.y + dir.y * this.t;
        this.riz = orig.z + dir.z * this.t;
        switch (this.dropAxis) {
            case 0: {
                vx = this.riy - this.vert1.y;
                vy = this.riz - this.vert1.z;
                break;
            }
            case 1: {
                vx = this.rix - this.vert1.x;
                vy = this.riz - this.vert1.z;
                break;
            }
            default: {
                vx = this.rix - this.vert1.x;
                vy = this.riy - this.vert1.y;
            }
        }
        this.v = this.edge2d2x * vy - this.edge2d2y * vx;
        if (this.v < -1.0E-12 || this.v > 1.000000000001) {
            this.lastRayResult = false;
            return false;
        }
        this.w = vx * this.edge2d1y - vy * this.edge2d1x;
        if (this.w < -1.0E-12 || this.w > 1.000000000001) {
            this.lastRayResult = false;
            return false;
        }
        this.u = 1.0 - this.v - this.w;
        if (this.u < -1.0E-12 || this.u > 1.000000000001) {
            this.lastRayResult = false;
            return false;
        }
        this.lastRayResult = true;
        return true;
    }

    public int numIntersections() {
        return 1;
    }

    public final void intersectionPoint(int n, Vec3 p) {
        p.set(this.rix, this.riy, this.riz);
    }

    public final double intersectionDist(int n) {
        return this.t;
    }

    public void trueNormal(Vec3 n) {
        n.set(this.trueNorm);
    }

    public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size) {
        if ((this.flags & 2) == 0) {
            n.set(this.trueNorm);
        } else {
            Vec3 norm1 = this.tri.theMesh.norm[this.tri.n1];
            Vec3 norm2 = this.tri.theMesh.norm[this.tri.n2];
            Vec3 norm3 = this.tri.theMesh.norm[this.tri.n3];
            n.x = this.u * norm1.x + this.v * norm2.x + this.w * norm3.x;
            n.y = this.u * norm1.y + this.v * norm2.y + this.w * norm3.y;
            n.z = this.u * norm1.z + this.v * norm2.z + this.w * norm3.z;
            n.normalize();
        }
        this.tri.getTextureSpec(spec, -n.dot(viewDir), this.u, this.v, this.w, size, this.time);
        if ((this.flags & 1) != 0) {
            this.fromLocal.transformDirection(spec.bumpGrad);
            n.scale(spec.bumpGrad.dot(n) + 1.0);
            n.subtract(spec.bumpGrad);
            n.normalize();
        }
    }

    public void intersectionTransparency(int n, RGBColor trans, double angle, double size) {
        this.tri.getTransparency(trans, angle, this.u, this.v, this.w, size, this.time);
    }

    public BoundingBox getBounds() {
        double maxz;
        double maxy;
        double maxx;
        Vec3 vert2 = this.tri.theMesh.vert[this.tri.v2];
        Vec3 vert3 = this.tri.theMesh.vert[this.tri.v3];
        double minx = maxx = this.vert1.x;
        double miny = maxy = this.vert1.y;
        double minz = maxz = this.vert1.z;
        if (vert2.x < minx) {
            minx = vert2.x;
        }
        if (vert2.x > maxx) {
            maxx = vert2.x;
        }
        if (vert2.y < miny) {
            miny = vert2.y;
        }
        if (vert2.y > maxy) {
            maxy = vert2.y;
        }
        if (vert2.z < minz) {
            minz = vert2.z;
        }
        if (vert2.z > maxz) {
            maxz = vert2.z;
        }
        if (vert3.x < minx) {
            minx = vert3.x;
        }
        if (vert3.x > maxx) {
            maxx = vert3.x;
        }
        if (vert3.y < miny) {
            miny = vert3.y;
        }
        if (vert3.y > maxy) {
            maxy = vert3.y;
        }
        if (vert3.z < minz) {
            minz = vert3.z;
        }
        if (vert3.z > maxz) {
            maxz = vert3.z;
        }
        return new BoundingBox(minx, maxx, miny, maxy, minz, maxz);
    }

    public boolean intersectsBox(BoundingBox bb) {
        Vec3 vert2 = this.tri.theMesh.vert[this.tri.v2];
        Vec3 vert3 = this.tri.theMesh.vert[this.tri.v3];
        if (bb.contains(this.vert1) || bb.contains(vert2) || bb.contains(vert3)) {
            return true;
        }
        if (this.edgeIntersectsBox(this.vert1, vert2, bb) || this.edgeIntersectsBox(vert2, vert3, bb) || this.edgeIntersectsBox(vert3, this.vert1, bb)) {
            return true;
        }
        Ray r = tempRay;
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        orig.set(bb.minx, bb.miny, bb.minz);
        dir.set(bb.maxx - bb.minx, bb.maxy - bb.miny, bb.maxz - bb.minz);
        double len = dir.length();
        dir.scale(1.0 / len);
        r.newID();
        if (this.intersects(r) && this.intersectionDist(0) < len) {
            return true;
        }
        orig.set(bb.maxx, bb.miny, bb.minz);
        dir.set(bb.minx - bb.maxx, bb.maxy - bb.miny, bb.maxz - bb.minz);
        len = dir.length();
        dir.scale(1.0 / len);
        r.newID();
        if (this.intersects(r) && this.intersectionDist(0) < len) {
            return true;
        }
        orig.set(bb.minx, bb.maxy, bb.minz);
        dir.set(bb.maxx - bb.minx, bb.miny - bb.maxy, bb.maxz - bb.minz);
        len = dir.length();
        dir.scale(1.0 / len);
        r.newID();
        if (this.intersects(r) && this.intersectionDist(0) < len) {
            return true;
        }
        orig.set(bb.minx, bb.miny, bb.maxz);
        dir.set(bb.maxx - bb.minx, bb.maxy - bb.miny, bb.minz - bb.maxz);
        len = dir.length();
        dir.scale(1.0 / len);
        r.newID();
        return this.intersects(r) && this.intersectionDist(0) < len;
    }

    boolean edgeIntersectsBox(Vec3 p1, Vec3 p2, BoundingBox bb) {
        double t2;
        double t1;
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        double dirx = p2.x - p1.x;
        double diry = p2.y - p1.y;
        double dirz = p2.z - p1.z;
        double len = Math.sqrt(dirx * dirx + diry * diry + dirz * dirz);
        if (dirx == 0.0) {
            if (p1.x < bb.minx || p1.x > bb.maxx) {
                return false;
            }
        } else {
            t1 = (bb.minx - p1.x) * len / dirx;
            t2 = (bb.maxx - p1.x) * len / dirx;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || mint > len || maxt < 0.0) {
                return false;
            }
        }
        if (diry == 0.0) {
            if (p1.y < bb.miny || p1.y > bb.maxy) {
                return false;
            }
        } else {
            t1 = (bb.miny - p1.y) * len / diry;
            t2 = (bb.maxy - p1.y) * len / diry;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || mint > len || maxt < 0.0) {
                return false;
            }
        }
        if (dirz == 0.0) {
            if (p1.z < bb.minz || p1.z > bb.maxz) {
                return false;
            }
        } else {
            t1 = (bb.minz - p1.z) * len / dirz;
            t2 = (bb.maxz - p1.z) * len / dirz;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || mint > len || maxt < 0.0) {
                return false;
            }
        }
        return true;
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }
}

