/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Sphere;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;

public class RTSphere
extends RTObject {
    Sphere theSphere;
    Vec3 v;
    Vec3 v2;
    Vec3 localv;
    Vec3 trueNorm;
    double r;
    double r2;
    double cx;
    double cy;
    double cz;
    double t;
    double t2;
    double time;
    double[] param;
    int intersections;
    boolean bumpMapped;
    boolean normValid;
    Mat4 toLocal;
    Mat4 fromLocal;
    public static final double TOL = 1.0E-12;

    public RTSphere(Sphere sphere, Mat4 fromLocal, Mat4 toLocal, double time, double[] param) {
        this.theSphere = sphere;
        this.time = time;
        this.param = param;
        this.v = new Vec3();
        this.v2 = new Vec3();
        this.trueNorm = new Vec3();
        if (!(sphere.getTextureMapping() instanceof UniformMapping)) {
            this.localv = new Vec3();
        }
        this.cx = fromLocal.m14 / fromLocal.m44;
        this.cy = fromLocal.m24 / fromLocal.m44;
        this.cz = fromLocal.m34 / fromLocal.m44;
        this.r = sphere.getRadii().x;
        this.r2 = this.r * this.r;
        this.bumpMapped = sphere.getTexture().hasComponent(5);
        if (this.bumpMapped) {
            this.fromLocal = fromLocal;
        }
        this.toLocal = toLocal;
        this.lastRay = -1;
    }

    public final TextureMapping getTextureMapping() {
        return this.theSphere.getTextureMapping();
    }

    public final MaterialMapping getMaterialMapping() {
        return this.theSphere.getMaterialMapping();
    }

    protected boolean checkIntersection(Ray r) {
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        this.lastRay = r.getID();
        this.normValid = false;
        this.v.set(this.cx - orig.x, this.cy - orig.y, this.cz - orig.z);
        double b = dir.x * this.v.x + dir.y * this.v.y + dir.z * this.v.z;
        double c = this.v.x * this.v.x + this.v.y * this.v.y + this.v.z * this.v.z - this.r2;
        if (c > 1.0E-12) {
            if (b <= 0.0) {
                this.lastRayResult = false;
                return false;
            }
            double d = b * b - c;
            if (d < 0.0) {
                this.lastRayResult = false;
                return false;
            }
            this.intersections = 2;
            double root = Math.sqrt(d);
            this.t = b - root;
            this.t2 = b + root;
            this.v2.set(orig.x + this.t2 * dir.x, orig.y + this.t2 * dir.y, orig.z + this.t2 * dir.z);
            this.projectPoint(this.v2);
        } else if (c < -1.0E-12) {
            double d = b * b - c;
            if (d < 0.0) {
                this.lastRayResult = false;
                return false;
            }
            this.intersections = 1;
            this.t = b + Math.sqrt(d);
        } else {
            if (b <= 0.0) {
                this.lastRayResult = false;
                return false;
            }
            double d = b * b - c;
            if (d < 0.0) {
                this.lastRayResult = false;
                return false;
            }
            this.intersections = 1;
            this.t = b + Math.sqrt(d);
        }
        this.v.set(orig.x + this.t * dir.x, orig.y + this.t * dir.y, orig.z + this.t * dir.z);
        this.projectPoint(this.v);
        this.lastRayResult = true;
        return true;
    }

    private void projectPoint(Vec3 pos) {
        double dx = pos.x - this.cx;
        double dy = pos.y - this.cy;
        double dz = pos.z - this.cz;
        double scale = this.r / Math.sqrt(dx * dx + dy * dy + dz * dz);
        pos.set(this.cx + dx * scale, this.cy + dy * scale, this.cz + dz * scale);
    }

    public int numIntersections() {
        return this.intersections;
    }

    public final void intersectionPoint(int n, Vec3 p) {
        if (n == 0) {
            p.set(this.v);
        } else {
            p.set(this.v2);
        }
    }

    public final double intersectionDist(int n) {
        if (n == 0) {
            return this.t;
        }
        return this.t2;
    }

    public void trueNormal(Vec3 n) {
        this.calcTrueNorm();
        n.set(this.trueNorm);
    }

    private final void calcTrueNorm() {
        if (this.normValid) {
            return;
        }
        this.normValid = true;
        this.trueNorm.set(this.v.x - this.cx, this.v.y - this.cy, this.v.z - this.cz);
        this.trueNorm.normalize();
    }

    public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size) {
        this.calcTrueNorm();
        n.set(this.trueNorm);
        TextureMapping map = this.theSphere.getTextureMapping();
        if (map instanceof UniformMapping) {
            map.getTextureSpec(this.v, spec, -n.dot(viewDir), size, this.time, this.param);
        } else {
            this.localv.set(this.v);
            this.toLocal.transform(this.localv);
            map.getTextureSpec(this.localv, spec, -n.dot(viewDir), size, this.time, this.param);
        }
        if (this.bumpMapped) {
            this.fromLocal.transformDirection(spec.bumpGrad);
            n.scale(spec.bumpGrad.dot(n) + 1.0);
            n.subtract(spec.bumpGrad);
            n.normalize();
        }
    }

    public void intersectionTransparency(int n, RGBColor trans, double angle, double size) {
        TextureMapping map = this.theSphere.getTextureMapping();
        if (map instanceof UniformMapping) {
            map.getTransparency(this.v, trans, angle, size, this.time, this.param);
        } else {
            if (n == 0) {
                this.localv.set(this.v);
            } else {
                this.localv.set(this.v2);
            }
            this.toLocal.transform(this.localv);
            map.getTransparency(this.localv, trans, angle, size, this.time, this.param);
        }
    }

    public BoundingBox getBounds() {
        return new BoundingBox(this.cx - this.r, this.cx + this.r, this.cy - this.r, this.cy + this.r, this.cz - this.r, this.cz + this.r);
    }

    public boolean intersectsBox(BoundingBox bb) {
        Vec3 c = new Vec3(this.cx, this.cy, this.cz);
        if (this.cx < bb.minx) {
            c.x = bb.minx;
        } else if (this.cx > bb.maxx) {
            c.x = bb.maxx;
        }
        if (this.cy < bb.miny) {
            c.y = bb.miny;
        } else if (this.cy > bb.maxy) {
            c.y = bb.maxy;
        }
        if (this.cz < bb.minz) {
            c.z = bb.minz;
        } else if (this.cz > bb.maxz) {
            c.z = bb.maxz;
        }
        c.set(c.x - this.cx, c.y - this.cy, c.z - this.cz);
        if (c.length2() > this.r2) {
            return false;
        }
        c.set(bb.minx - this.cx, bb.miny - this.cy, bb.minz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.minx - this.cx, bb.miny - this.cy, bb.maxz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.minx - this.cx, bb.maxy - this.cy, bb.minz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.minx - this.cx, bb.maxy - this.cy, bb.maxz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.maxx - this.cx, bb.miny - this.cy, bb.minz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.maxx - this.cx, bb.miny - this.cy, bb.maxz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.maxx - this.cx, bb.maxy - this.cy, bb.minz - this.cz);
        if (c.length2() > this.r2) {
            return true;
        }
        c.set(bb.maxx - this.cx, bb.maxy - this.cy, bb.maxz - this.cz);
        return c.length2() > this.r2;
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }
}

