/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.Ray;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;

public abstract class RTObject {
    protected int lastRay;
    protected boolean lastRayResult;

    public abstract TextureMapping getTextureMapping();

    public abstract MaterialMapping getMaterialMapping();

    public boolean intersects(Ray r) {
        if (this.lastRay == r.getID()) {
            return this.lastRayResult;
        }
        return this.checkIntersection(r);
    }

    protected abstract boolean checkIntersection(Ray var1);

    public abstract int numIntersections();

    public abstract void intersectionPoint(int var1, Vec3 var2);

    public abstract double intersectionDist(int var1);

    public abstract void intersectionProperties(TextureSpec var1, Vec3 var2, Vec3 var3, double var4);

    public abstract void trueNormal(Vec3 var1);

    public abstract void intersectionTransparency(int var1, RGBColor var2, double var3, double var5);

    public abstract BoundingBox getBounds();

    public abstract boolean intersectsBox(BoundingBox var1);

    public abstract Mat4 toLocal();
}

