/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.RenderingMesh;
import artofillusion.RenderingTriangle;
import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;

public class RTDisplacedTriangle
extends RTObject {
    RenderingTriangle tri;
    Vec3 trueNorm;
    double minheight;
    double maxheight;
    private double t;
    private double u;
    private double v;
    private double w;
    private double tol;
    private double mint;
    private double maxt;
    private double time;
    private boolean bumpMapped;
    private BoundingBox bounds;
    private Mat4 toLocal;
    private Mat4 fromLocal;
    private ExtraInfo extra;
    private static final Vec3 temp1 = new Vec3();
    private static final Vec3 temp2 = new Vec3();
    private static final Vec3 temp3 = new Vec3();
    private static final Vec3 temp4 = new Vec3();
    private static final Vec3 orig = new Vec3();
    private static final Vec3 dir = new Vec3();

    public RTDisplacedTriangle(RenderingMesh mesh, int which, Mat4 fromLocal, Mat4 toLocal, double tol, double time) {
        this.tri = mesh.triangle[which];
        Vec3 vert1 = mesh.vert[this.tri.v1];
        Vec3 vert2 = mesh.vert[this.tri.v2];
        Vec3 vert3 = mesh.vert[this.tri.v3];
        this.trueNorm = mesh.faceNorm[which];
        this.fromLocal = fromLocal;
        this.toLocal = toLocal;
        this.tol = tol;
        this.time = time;
        Vec3 norm1 = mesh.norm[this.tri.n1];
        Vec3 norm2 = mesh.norm[this.tri.n2];
        Vec3 norm3 = mesh.norm[this.tri.n3];
        int i = 0;
        if (this.trueNorm.dot(norm1) < 0.0) {
            ++i;
        }
        if (this.trueNorm.dot(norm2) < 0.0) {
            ++i;
        }
        if (this.trueNorm.dot(norm3) < 0.0) {
            ++i;
        }
        if (i > 1) {
            this.trueNorm.scale(-1.0);
        }
        this.minheight = Double.MAX_VALUE;
        this.maxheight = -1.7976931348623157E308;
        this.bounds = new BoundingBox(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        this.bounds.minz = Double.MAX_VALUE;
        this.bounds.miny = Double.MAX_VALUE;
        this.bounds.minx = Double.MAX_VALUE;
        this.bounds.maxz = -1.7976931348623157E308;
        this.bounds.maxy = -1.7976931348623157E308;
        this.bounds.maxx = -1.7976931348623157E308;
        double d = 2.0 * Math.max(Math.max(vert1.minus(vert2).length2(), vert1.minus(vert3).length2()), vert2.minus(vert3).length2());
        int divisions = (int)Math.ceil(Math.sqrt(d) / tol);
        Vec3 temp = new Vec3();
        d = 1.0 / (double)divisions;
        for (i = 0; i <= divisions; ++i) {
            for (int j = 0; j <= divisions - i; ++j) {
                this.u = (double)i * d;
                this.v = (double)j * d;
                this.w = (double)(divisions - i - j) * d;
                double disp = this.tri.getDisplacement(this.u, this.v, this.w, tol, time);
                temp.set(this.u * norm1.x + this.v * norm2.x + this.w * norm3.x, this.u * norm1.y + this.v * norm2.y + this.w * norm3.y, this.u * norm1.z + this.v * norm2.z + this.w * norm3.z);
                temp.normalize();
                double h = disp / temp.dot(this.trueNorm);
                if (h < this.minheight) {
                    this.minheight = h;
                }
                if (h > this.maxheight) {
                    this.maxheight = h;
                }
                temp.set(this.u * vert1.x + this.v * vert2.x + this.w * vert3.x + disp * temp.x, this.u * vert1.y + this.v * vert2.y + this.w * vert3.y + disp * temp.y, this.u * vert1.z + this.v * vert2.z + this.w * vert3.z + disp * temp.z);
                if (temp.x < this.bounds.minx) {
                    this.bounds.minx = temp.x;
                }
                if (temp.x > this.bounds.maxx) {
                    this.bounds.maxx = temp.x;
                }
                if (temp.y < this.bounds.miny) {
                    this.bounds.miny = temp.y;
                }
                if (temp.y > this.bounds.maxy) {
                    this.bounds.maxy = temp.y;
                }
                if (temp.z < this.bounds.minz) {
                    this.bounds.minz = temp.z;
                }
                if (!(temp.z > this.bounds.maxz)) continue;
                this.bounds.maxz = temp.z;
            }
        }
        this.bounds.outset(0.5 * tol);
        this.bumpMapped = this.tri.theMesh.mapping.getTexture().hasComponent(5);
        this.lastRay = -1;
    }

    public boolean isReallyDisplaced() {
        return this.minheight != 0.0 || this.maxheight != 0.0;
    }

    public void setTolerance(double tol) {
        this.tol = tol;
    }

    private void init() {
        this.extra = new ExtraInfo();
        Vec3[] vert = this.tri.theMesh.vert;
        Vec3 vert1 = vert[this.tri.v1];
        Vec3 vert2 = vert[this.tri.v2];
        Vec3 vert3 = vert[this.tri.v3];
        this.extra.trans = Mat4.viewTransform((Vec3)vert3, (Vec3)this.trueNorm, (Vec3)vert2.minus(vert3));
        Vec3 v1 = this.extra.trans.times(vert1);
        Vec3 v2 = this.extra.trans.times(vert2);
        this.extra.v1x = v1.x;
        this.extra.v1y = v1.y;
        this.extra.v2y = v2.y;
        Vec3[] norm = this.tri.theMesh.norm;
        Vec3 n1 = this.extra.trans.timesDirection(norm[this.tri.n1]);
        Vec3 n2 = this.extra.trans.timesDirection(norm[this.tri.n2]);
        Vec3 n3 = this.extra.trans.timesDirection(norm[this.tri.n3]);
        this.extra.n1x = n1.x;
        this.extra.n1y = n1.y;
        this.extra.n1z = n1.z;
        this.extra.n2x = n2.x;
        this.extra.n2y = n2.y;
        this.extra.n2z = n2.z;
        this.extra.n3x = n3.x;
        this.extra.n3y = n3.y;
        this.extra.n3z = n3.z;
        Vec3[] pos = new Vec3[]{new Vec3(v1.x + n1.x * this.minheight, v1.y + n1.y * this.minheight, n1.z * this.minheight), new Vec3(v1.x + n1.x * this.maxheight, v1.y + n1.y * this.maxheight, n1.z * this.maxheight), new Vec3(n2.x * this.minheight, v2.y + n2.y * this.minheight, n2.z * this.minheight), new Vec3(n2.x * this.maxheight, v2.y + n2.y * this.maxheight, n2.z * this.maxheight), new Vec3(n3.x * this.minheight, n3.y * this.minheight, n3.z * this.minheight), new Vec3(n3.x * this.maxheight, n3.y * this.maxheight, n3.z * this.maxheight)};
        BoundingBox bounds2 = new BoundingBox(pos[0].x, pos[0].x, pos[0].y, pos[0].y, pos[0].z, pos[0].z);
        for (int i = 1; i < 6; ++i) {
            if (pos[i].x < bounds2.minx) {
                bounds2.minx = pos[i].x;
            }
            if (pos[i].x > bounds2.maxx) {
                bounds2.maxx = pos[i].x;
            }
            if (pos[i].y < bounds2.miny) {
                bounds2.miny = pos[i].y;
            }
            if (pos[i].y > bounds2.maxy) {
                bounds2.maxy = pos[i].y;
            }
            if (pos[i].z < bounds2.minz) {
                bounds2.minz = pos[i].z;
            }
            if (!(pos[i].z > bounds2.maxz)) continue;
            bounds2.maxz = pos[i].z;
        }
        bounds2.outset(0.5 * this.tol);
        this.extra.bounds2 = bounds2;
        this.extra.dn1x = n1.x - n3.x;
        this.extra.dn1y = n1.y - n3.y;
        this.extra.dn2x = n2.x - n3.x;
        this.extra.dn2y = n2.y - n3.y;
        this.extra.minscale = 1.0 / Math.max(Math.max(n1.z, n2.z), n3.z);
        this.extra.maxscale = 1.0 / Math.min(Math.min(n1.z, n2.z), n3.z);
        this.extra.intersection = new double[4];
        this.extra.interp = new Vec3();
        this.extra.rint = new Vec3[]{new Vec3()};
        this.extra.tint = new double[1];
        this.extra.uint = new double[1];
        this.extra.vint = new double[1];
    }

    public final TextureMapping getTextureMapping() {
        return this.tri.getTextureMapping();
    }

    public final MaterialMapping getMaterialMapping() {
        return this.tri.theMesh.matMapping;
    }

    protected boolean checkIntersection(Ray r) {
        double prevt;
        this.lastRay = r.getID();
        if (!this.rayIntersectsBounds(r.origin, r.direction, this.bounds)) {
            this.lastRayResult = false;
            return false;
        }
        double mint1 = this.mint;
        double maxt1 = this.maxt;
        if (this.extra == null) {
            this.init();
        }
        orig.set(r.origin);
        dir.set(r.direction);
        this.extra.trans.transform(orig);
        this.extra.trans.transformDirection(dir);
        if (!this.rayIntersectsBounds(orig, dir, this.extra.bounds2)) {
            this.lastRayResult = false;
            return false;
        }
        if (mint1 > this.mint) {
            this.mint = mint1;
        }
        if (maxt1 < this.maxt) {
            this.maxt = maxt1;
        }
        if (this.mint < 0.0) {
            this.mint = 0.0;
        }
        double x = RTDisplacedTriangle.orig.x + this.maxt * RTDisplacedTriangle.dir.x;
        double y = RTDisplacedTriangle.orig.y + this.maxt * RTDisplacedTriangle.dir.y;
        double z = RTDisplacedTriangle.orig.z + this.maxt * RTDisplacedTriangle.dir.z;
        this.calcCoords(x, y, z);
        double lastu = this.u;
        double lastv = this.v;
        double lastw = this.w;
        x = RTDisplacedTriangle.orig.x + this.mint * RTDisplacedTriangle.dir.x;
        y = RTDisplacedTriangle.orig.y + this.mint * RTDisplacedTriangle.dir.y;
        z = RTDisplacedTriangle.orig.z + this.mint * RTDisplacedTriangle.dir.z;
        this.calcCoords(x, y, z);
        if (this.u < 0.0 && lastu < 0.0 || this.u > 1.0 && lastu > 1.0 || this.v < 0.0 && lastv < 0.0 || this.v > 1.0 && lastv > 1.0 || this.w < 0.0 && lastw < 0.0 || this.w > 1.0 && lastw > 1.0) {
            this.lastRayResult = false;
            return false;
        }
        temp1.set(this.u * this.extra.n1x + this.v * this.extra.n2x + this.w * this.extra.n3x, this.u * this.extra.n1y + this.v * this.extra.n2y + this.w * this.extra.n3y, this.u * this.extra.n1z + this.v * this.extra.n2z + this.w * this.extra.n3z);
        double disp = this.tri.getDisplacement(this.u, this.v, this.w, this.tol, this.time);
        double height = disp * RTDisplacedTriangle.temp1.z / temp1.length();
        double prevDelta = z - height;
        boolean above = z > height;
        boolean wasOutsideU = this.u < 0.0 || this.u > 1.0;
        boolean wasOutsideV = this.v < 0.0 || this.v > 1.0;
        boolean wasOutsideW = this.w < 0.0 || this.w > 1.0;
        this.t = prevt = this.mint;
        this.extra.intersections = (short)-1;
        this.extra.tint[0] = Double.MAX_VALUE;
        while (this.t < this.maxt) {
            boolean outsideW;
            this.t += this.tol;
            if (this.t >= this.maxt) {
                this.t = this.maxt;
                x = RTDisplacedTriangle.orig.x + this.t * RTDisplacedTriangle.dir.x;
                y = RTDisplacedTriangle.orig.y + this.t * RTDisplacedTriangle.dir.y;
                z = RTDisplacedTriangle.orig.z + this.t * RTDisplacedTriangle.dir.z;
                this.u = lastu;
                this.v = lastv;
                this.w = lastw;
            } else {
                x = RTDisplacedTriangle.orig.x + this.t * RTDisplacedTriangle.dir.x;
                y = RTDisplacedTriangle.orig.y + this.t * RTDisplacedTriangle.dir.y;
                z = RTDisplacedTriangle.orig.z + this.t * RTDisplacedTriangle.dir.z;
                this.calcCoords(x, y, z);
            }
            disp = this.tri.getDisplacement(this.u, this.v, this.w, this.tol, this.time);
            temp1.set(this.u * this.extra.n1x + this.v * this.extra.n2x + this.w * this.extra.n3x, this.u * this.extra.n1y + this.v * this.extra.n2y + this.w * this.extra.n3y, this.u * this.extra.n1z + this.v * this.extra.n2z + this.w * this.extra.n3z);
            height = disp * RTDisplacedTriangle.temp1.z / temp1.length();
            boolean outsideU = this.u < 0.0 || this.u > 1.0;
            boolean outsideV = this.v < 0.0 || this.v > 1.0;
            boolean bl = outsideW = this.w < 0.0 || this.w > 1.0;
            if (outsideU && wasOutsideU || outsideV && wasOutsideV || outsideW && wasOutsideW) {
                above = z > height;
                prevDelta = z - height;
                prevt = this.t;
                wasOutsideU = outsideU;
                wasOutsideV = outsideV;
                wasOutsideW = outsideW;
                continue;
            }
            if (above && z <= height || !above && z >= height) {
                double truet = this.t - (this.t - prevt) * (z - height) / (z - height - prevDelta);
                if (truet <= this.tol) {
                    above = z > height;
                    prevDelta = z - height;
                    prevt = this.t;
                    wasOutsideU = outsideU;
                    wasOutsideV = outsideV;
                    wasOutsideW = outsideW;
                    continue;
                }
                x = RTDisplacedTriangle.orig.x + truet * RTDisplacedTriangle.dir.x;
                y = RTDisplacedTriangle.orig.y + truet * RTDisplacedTriangle.dir.y;
                z = RTDisplacedTriangle.orig.z + truet * RTDisplacedTriangle.dir.z;
                this.calcCoords(x, y, z);
                this.extra.tint[0] = truet;
                this.extra.uint[0] = this.u;
                this.extra.vint[0] = this.v;
                break;
            }
            prevDelta = z - height;
            above = z > height;
            prevt = this.t;
            wasOutsideU = outsideU;
            wasOutsideV = outsideV;
            wasOutsideW = outsideW;
        }
        if (this.extra.tint[0] == Double.MAX_VALUE) {
            this.lastRayResult = false;
            return false;
        }
        Vec3 ri = this.extra.rint[0];
        disp = this.tri.getDisplacement(this.u, this.v, this.w, this.tol, this.time);
        ri.set(r.origin.x + this.extra.tint[0] * r.direction.x, r.origin.y + this.extra.tint[0] * r.direction.y, r.origin.z + this.extra.tint[0] * r.direction.z);
        double dhdu = (this.tri.getDisplacement(this.u + 1.0E-5, this.v, this.w - 1.0E-5, this.tol, this.time) - disp) * 100000.0;
        double dhdv = (this.tri.getDisplacement(this.u, this.v + 1.0E-5, this.w - 1.0E-5, this.tol, this.time) - disp) * 100000.0;
        Vec3[] norm = this.tri.theMesh.norm;
        Vec3 norm1 = norm[this.tri.n1];
        Vec3 norm2 = norm[this.tri.n2];
        Vec3 norm3 = norm[this.tri.n3];
        this.extra.interp.set(this.u * norm1.x + this.v * norm2.x + this.w * norm3.x, this.u * norm1.y + this.v * norm2.y + this.w * norm3.y, this.u * norm1.z + this.v * norm2.z + this.w * norm3.z);
        this.extra.interp.normalize();
        Vec3[] vert = this.tri.theMesh.vert;
        Vec3 vert1 = vert[this.tri.v1];
        Vec3 vert2 = vert[this.tri.v2];
        Vec3 vert3 = vert[this.tri.v3];
        temp1.set(vert1.x + disp * norm1.x, vert1.y + disp * norm1.y, vert1.z + disp * norm1.z);
        temp2.set(vert2.x + disp * norm2.x, vert2.y + disp * norm2.y, vert2.z + disp * norm2.z);
        temp3.set(vert3.x + disp * norm3.x, vert3.y + disp * norm3.y, vert3.z + disp * norm3.z);
        temp1.set(RTDisplacedTriangle.temp1.x - RTDisplacedTriangle.temp3.x, RTDisplacedTriangle.temp1.y - RTDisplacedTriangle.temp3.y, RTDisplacedTriangle.temp1.z - RTDisplacedTriangle.temp3.z);
        temp2.set(RTDisplacedTriangle.temp3.x - RTDisplacedTriangle.temp2.x, RTDisplacedTriangle.temp3.y - RTDisplacedTriangle.temp2.y, RTDisplacedTriangle.temp3.z - RTDisplacedTriangle.temp2.z);
        temp3.set(RTDisplacedTriangle.temp1.y * this.extra.interp.z - RTDisplacedTriangle.temp1.z * this.extra.interp.y, RTDisplacedTriangle.temp1.z * this.extra.interp.x - RTDisplacedTriangle.temp1.x * this.extra.interp.z, RTDisplacedTriangle.temp1.x * this.extra.interp.y - RTDisplacedTriangle.temp1.y * this.extra.interp.x);
        temp4.set(RTDisplacedTriangle.temp2.y * this.extra.interp.z - RTDisplacedTriangle.temp2.z * this.extra.interp.y, RTDisplacedTriangle.temp2.z * this.extra.interp.x - RTDisplacedTriangle.temp2.x * this.extra.interp.z, RTDisplacedTriangle.temp2.x * this.extra.interp.y - RTDisplacedTriangle.temp2.y * this.extra.interp.x);
        temp3.scale(-1.0 / temp3.dot(temp2));
        temp4.scale(1.0 / temp4.dot(temp1));
        temp1.set(dhdu * RTDisplacedTriangle.temp4.x + dhdv * RTDisplacedTriangle.temp3.x, dhdu * RTDisplacedTriangle.temp4.y + dhdv * RTDisplacedTriangle.temp3.y, dhdu * RTDisplacedTriangle.temp4.z + dhdv * RTDisplacedTriangle.temp3.z);
        this.extra.interp.scale(temp1.dot(this.extra.interp) + 1.0);
        this.extra.interp.subtract(temp1);
        this.extra.interp.normalize();
        this.extra.ray = r;
        this.lastRayResult = true;
        return true;
    }

    private final void calcCoords(double x, double y, double z) {
        double dmax = z * this.extra.maxscale;
        double dmin = z * this.extra.minscale;
        this.guessCoords(x, y, dmax);
        double ua = this.u;
        double va = this.v;
        double wa = this.w;
        double zmax = dmax * (this.u * this.extra.n1z + this.v * this.extra.n2z + this.w * this.extra.n3z);
        this.guessCoords(x, y, dmin);
        double ub = this.u;
        double vb = this.v;
        double wb = this.w;
        double zmin = dmin * (this.u * this.extra.n1z + this.v * this.extra.n2z + this.w * this.extra.n3z);
        if (zmax == zmin) {
            return;
        }
        double fract = (z - zmin) / (zmax - zmin);
        double fract2 = 1.0 - fract;
        this.u = fract * ua + fract2 * this.u;
        this.v = fract * va + fract2 * this.v;
        this.w = fract * wa + fract2 * this.w;
    }

    private final void guessCoords(double x, double y, double disp) {
        double a = this.extra.v1x + disp * this.extra.dn1x;
        double b = disp * this.extra.dn2x;
        double c = x - disp * this.extra.n3x;
        double e = this.extra.v1y + disp * this.extra.dn1y;
        double f = this.extra.v2y + disp * this.extra.dn2y;
        double g = y - disp * this.extra.n3y;
        double m = 1.0 / (a * f - b * e);
        this.u = (c * f - b * g) * m;
        this.v = (a * g - c * e) * m;
        this.w = 1.0 - this.u - this.v;
    }

    private final void findAllIntersections() {
        double x = RTDisplacedTriangle.orig.x + this.t * RTDisplacedTriangle.dir.x;
        double y = RTDisplacedTriangle.orig.y + this.t * RTDisplacedTriangle.dir.y;
        double z = RTDisplacedTriangle.orig.z + this.t * RTDisplacedTriangle.dir.z;
        temp1.set(this.u * this.extra.n1x + this.v * this.extra.n2x + this.w * this.extra.n3x, this.u * this.extra.n1y + this.v * this.extra.n2y + this.w * this.extra.n3y, this.u * this.extra.n1z + this.v * this.extra.n2z + this.w * this.extra.n3z);
        double disp = this.tri.getDisplacement(this.u, this.v, this.w, this.tol, this.time);
        double height = disp * RTDisplacedTriangle.temp1.z / temp1.length();
        double prevDelta = z - height;
        double prevt = this.t;
        boolean above = z > height;
        boolean wasOutsideU = this.u < 0.0 || this.u > 1.0;
        boolean wasOutsideV = this.v < 0.0 || this.v > 1.0;
        boolean wasOutsideW = this.w < 0.0 || this.w > 1.0;
        this.extra.intersections = 1;
        while (this.t < this.maxt) {
            boolean outsideW;
            this.t += this.tol;
            if (this.t >= this.maxt) {
                this.t = this.maxt;
            }
            x = RTDisplacedTriangle.orig.x + this.t * RTDisplacedTriangle.dir.x;
            y = RTDisplacedTriangle.orig.y + this.t * RTDisplacedTriangle.dir.y;
            z = RTDisplacedTriangle.orig.z + this.t * RTDisplacedTriangle.dir.z;
            this.calcCoords(x, y, z);
            disp = this.tri.getDisplacement(this.u, this.v, this.w, this.tol, this.time);
            temp1.set(this.u * this.extra.n1x + this.v * this.extra.n2x + this.w * this.extra.n3x, this.u * this.extra.n1y + this.v * this.extra.n2y + this.w * this.extra.n3y, this.u * this.extra.n1z + this.v * this.extra.n2z + this.w * this.extra.n3z);
            height = disp * RTDisplacedTriangle.temp1.z / temp1.length();
            boolean outsideU = this.u < 0.0 || this.u > 1.0;
            boolean outsideV = this.v < 0.0 || this.v > 1.0;
            boolean bl = outsideW = this.w < 0.0 || this.w > 1.0;
            if (outsideU && wasOutsideU || outsideV && wasOutsideV || outsideW && wasOutsideW) {
                above = z > height;
                prevDelta = z - height;
                prevt = this.t;
                wasOutsideU = outsideU;
                wasOutsideV = outsideV;
                wasOutsideW = outsideW;
                continue;
            }
            if (above && z <= height || !above && z >= height) {
                if (this.extra.intersections == this.extra.tint.length) {
                    int j;
                    double[] newt = new double[this.extra.intersections * 2];
                    double[] newu = new double[this.extra.intersections * 2];
                    double[] newv = new double[this.extra.intersections * 2];
                    Vec3[] newr = new Vec3[this.extra.intersections * 2];
                    for (j = 0; j < this.extra.tint.length; ++j) {
                        newt[j] = this.extra.tint[j];
                        newu[j] = this.extra.uint[j];
                        newv[j] = this.extra.vint[j];
                        newr[j] = this.extra.rint[j];
                    }
                    for (j = this.extra.tint.length; j < newt.length; ++j) {
                        newr[j] = new Vec3();
                    }
                    this.extra.tint = newt;
                    this.extra.uint = newu;
                    this.extra.vint = newv;
                    this.extra.rint = newr;
                }
                double oldz = z;
                double truet = this.t - (this.t - prevt) * (z - height) / (z - height - prevDelta);
                x = RTDisplacedTriangle.orig.x + truet * RTDisplacedTriangle.dir.x;
                y = RTDisplacedTriangle.orig.y + truet * RTDisplacedTriangle.dir.y;
                z = RTDisplacedTriangle.orig.z + truet * RTDisplacedTriangle.dir.z;
                this.calcCoords(x, y, z);
                this.extra.tint[this.extra.intersections] = truet;
                this.extra.uint[this.extra.intersections] = this.u;
                this.extra.vint[this.extra.intersections] = this.v;
                this.extra.rint[this.extra.intersections].set(this.extra.ray.origin.x + truet * this.extra.ray.direction.x, this.extra.ray.origin.y + truet * this.extra.ray.direction.y, this.extra.ray.origin.z + truet * this.extra.ray.direction.z);
                this.extra.intersections = (short)(this.extra.intersections + 1);
                z = oldz;
            }
            prevDelta = z - height;
            above = z > height;
            prevt = this.t;
            wasOutsideU = outsideU;
            wasOutsideV = outsideV;
            wasOutsideW = outsideW;
        }
    }

    public int numIntersections() {
        if (this.extra.intersections == -1) {
            this.findAllIntersections();
        }
        return this.extra.intersections;
    }

    public final void intersectionPoint(int n, Vec3 p) {
        p.set(this.extra.rint[n]);
    }

    public final double intersectionDist(int n) {
        return this.extra.tint[n];
    }

    public void trueNormal(Vec3 n) {
        n.set(this.extra.interp);
    }

    public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size) {
        n.set(this.extra.interp);
        this.tri.getTextureSpec(spec, -n.dot(viewDir), this.extra.uint[0], this.extra.vint[0], 1.0 - this.extra.uint[0] - this.extra.vint[0], size, this.time);
        if (this.bumpMapped) {
            this.fromLocal.transformDirection(spec.bumpGrad);
            n.scale(spec.bumpGrad.dot(n) + 1.0);
            n.subtract(spec.bumpGrad);
            n.normalize();
        }
    }

    public void intersectionTransparency(int n, RGBColor trans, double angle, double size) {
        this.tri.getTransparency(trans, angle, this.extra.uint[n], this.extra.vint[n], 1.0 - this.extra.uint[0] - this.extra.vint[0], size, this.time);
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public boolean intersectsBox(BoundingBox bb) {
        if (!bb.intersects(this.bounds)) {
            return false;
        }
        double dot = this.tri.theMesh.vert[this.tri.v1].dot(this.trueNorm);
        double mindot = dot + this.minheight;
        double maxdot = dot + this.maxheight;
        boolean anyBelow = false;
        boolean anyAbove = false;
        dot = this.trueNorm.x * bb.minx + this.trueNorm.y * bb.miny + this.trueNorm.z * bb.minz;
        if (dot < mindot) {
            anyBelow = true;
        } else if (dot > maxdot) {
            anyAbove = true;
        } else {
            return true;
        }
        Vec3[] corners = bb.getCorners();
        dot = this.trueNorm.x * bb.minx + this.trueNorm.y * bb.miny + this.trueNorm.z * bb.maxz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * bb.minx + this.trueNorm.y * bb.maxy + this.trueNorm.z * bb.minz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * bb.minx + this.trueNorm.y * bb.maxy + this.trueNorm.z * bb.maxz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * bb.maxx + this.trueNorm.y * bb.miny + this.trueNorm.z * bb.minz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * bb.maxx + this.trueNorm.y * bb.miny + this.trueNorm.z * bb.maxz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * bb.maxx + this.trueNorm.y * bb.maxy + this.trueNorm.z * bb.minz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
            anyBelow = true;
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
            anyAbove = true;
        } else {
            return true;
        }
        dot = this.trueNorm.x * bb.maxx + this.trueNorm.y * bb.maxy + this.trueNorm.z * bb.maxz;
        if (dot < mindot) {
            if (anyAbove) {
                return true;
            }
        } else if (dot > maxdot) {
            if (anyBelow) {
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    boolean rayIntersectsBounds(Vec3 origin, Vec3 direction, BoundingBox bb) {
        double t2;
        double t1;
        this.mint = -1.7976931348623157E308;
        this.maxt = Double.MAX_VALUE;
        if (direction.x == 0.0) {
            if (origin.x < bb.minx || origin.x > bb.maxx) {
                return false;
            }
        } else {
            t1 = (bb.minx - origin.x) / direction.x;
            t2 = (bb.maxx - origin.x) / direction.x;
            if (t1 < t2) {
                if (t1 > this.mint) {
                    this.mint = t1;
                }
                if (t2 < this.maxt) {
                    this.maxt = t2;
                }
            } else {
                if (t2 > this.mint) {
                    this.mint = t2;
                }
                if (t1 < this.maxt) {
                    this.maxt = t1;
                }
            }
            if (this.mint > this.maxt || this.maxt < 0.0) {
                return false;
            }
        }
        if (direction.y == 0.0) {
            if (origin.y < bb.miny || origin.y > bb.maxy) {
                return false;
            }
        } else {
            t1 = (bb.miny - origin.y) / direction.y;
            t2 = (bb.maxy - origin.y) / direction.y;
            if (t1 < t2) {
                if (t1 > this.mint) {
                    this.mint = t1;
                }
                if (t2 < this.maxt) {
                    this.maxt = t2;
                }
            } else {
                if (t2 > this.mint) {
                    this.mint = t2;
                }
                if (t1 < this.maxt) {
                    this.maxt = t1;
                }
            }
            if (this.mint > this.maxt || this.maxt < 0.0) {
                return false;
            }
        }
        if (direction.z == 0.0) {
            if (origin.z < bb.minz || origin.z > bb.maxz) {
                return false;
            }
        } else {
            t1 = (bb.minz - origin.z) / direction.z;
            t2 = (bb.maxz - origin.z) / direction.z;
            if (t1 < t2) {
                if (t1 > this.mint) {
                    this.mint = t1;
                }
                if (t2 < this.maxt) {
                    this.maxt = t2;
                }
            } else {
                if (t2 > this.mint) {
                    this.mint = t2;
                }
                if (t1 < this.maxt) {
                    this.maxt = t1;
                }
            }
            if (this.mint > this.maxt || this.maxt < 0.0) {
                return false;
            }
        }
        return true;
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }

    private static class ExtraInfo {
        Mat4 trans;
        BoundingBox bounds2;
        double v1x;
        double v1y;
        double v2y;
        double n1x;
        double n1y;
        double n1z;
        double n2x;
        double n2y;
        double n2z;
        double n3x;
        double n3y;
        double n3z;
        double dn1x;
        double dn1y;
        double dn2x;
        double dn2y;
        double minscale;
        double maxscale;
        double[] intersection;
        double[] tint;
        double[] uint;
        double[] vint;
        Vec3 interp;
        Vec3[] rint;
        short intersections;
        Ray ray;

        private ExtraInfo() {
        }
    }
}

