/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cylinder;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;

public class RTCylinder
extends RTObject {
    Cylinder theCylinder;
    Vec3 v;
    Vec3 v2;
    Vec3 dir;
    Vec3 topNormal;
    Vec3 bottomNormal;
    Vec3 trueNorm;
    double rx;
    double rz;
    double height;
    double halfh;
    double rx2;
    double rz2;
    double toprx2;
    double cx;
    double cy;
    double cz;
    double sy;
    double sz;
    double t;
    double t2;
    double time;
    double[] param;
    int hit;
    int intersections;
    boolean bumpMapped;
    boolean cone;
    boolean transform;
    boolean uniform;
    boolean normValid;
    Mat4 toLocal;
    Mat4 fromLocal;
    public static final double TOL = 1.0E-12;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int SIDE = 2;

    public RTCylinder(Cylinder cylinder, Mat4 fromLocal, Mat4 toLocal, double time, double[] param) {
        double ratio = cylinder.getRatio();
        Vec3 vx = toLocal.timesDirection(Vec3.vx());
        Vec3 vy = toLocal.timesDirection(Vec3.vy());
        this.theCylinder = cylinder;
        this.time = time;
        this.param = param;
        Vec3 size = cylinder.getBounds().getSize();
        this.v = new Vec3();
        this.v2 = new Vec3();
        this.trueNorm = new Vec3();
        this.uniform = cylinder.getTextureMapping() instanceof UniformMapping;
        this.cone = false;
        this.transform = true;
        if (vy.y == 1.0) {
            if (vx.x == 1.0 || vx.x == -1.0) {
                this.rx = size.x / 2.0;
                this.rz = size.z / 2.0;
                this.transform = false;
            } else if (vx.z == 1.0 || vx.z == -1.0) {
                this.rx = size.z / 2.0;
                this.rz = size.x / 2.0;
                this.transform = false;
            }
            if (!this.transform && ratio == 0.0) {
                this.cone = true;
            }
        } else if (vy.y == -1.0 && ratio != 0.0) {
            if (vx.x == 1.0 || vx.x == -1.0) {
                this.rx = size.x / 2.0;
                this.rz = size.z / 2.0;
                this.transform = false;
            } else if (vx.z == 1.0 || vx.z == -1.0) {
                this.rx = size.y / 2.0;
                this.rz = size.z / 2.0;
                this.transform = false;
            }
            if (!this.transform) {
                this.rx *= ratio;
                this.rz *= ratio;
                ratio = 1.0 / ratio;
            }
        }
        this.height = size.y;
        this.halfh = this.height / 2.0;
        if (this.transform) {
            this.rx = size.x / 2.0;
            this.rz = size.z / 2.0;
            if (ratio == 0.0) {
                this.cone = true;
            }
            this.fromLocal = fromLocal;
        }
        if (this.transform || !this.uniform) {
            this.dir = new Vec3();
        }
        this.cx = fromLocal.m14 / fromLocal.m44;
        this.cy = fromLocal.m24 / fromLocal.m44;
        this.cz = fromLocal.m34 / fromLocal.m44;
        this.rx2 = this.rx * this.rx;
        this.rz2 = this.rz * this.rz;
        this.toprx2 = this.rx2 * ratio * ratio;
        this.sz = this.rx2 / this.rz2;
        this.sy = this.rx * (ratio - 1.0) / this.height;
        this.bottomNormal = fromLocal.timesDirection(Vec3.vy()).times(-1.0);
        if (!this.cone) {
            this.topNormal = this.bottomNormal.times(-1.0);
        }
        this.bumpMapped = cylinder.getTexture().hasComponent(5);
        this.toLocal = toLocal;
        this.lastRay = -1;
    }

    public final MaterialMapping getMaterialMapping() {
        return this.theCylinder.getMaterialMapping();
    }

    public final TextureMapping getTextureMapping() {
        return this.theCylinder.getTextureMapping();
    }

    protected boolean checkIntersection(Ray r) {
        double e;
        double b;
        double a;
        double temp1;
        Vec3 orig = r.getOrigin();
        Vec3 rdir = r.getDirection();
        this.lastRay = r.getID();
        this.normValid = false;
        if (this.transform) {
            this.v.set(this.cx - orig.x, this.cy - orig.y, this.cz - orig.z);
            this.toLocal.transformDirection(this.v);
            this.v.y -= this.halfh;
            this.dir.set(rdir);
            this.toLocal.transformDirection(this.dir);
        } else {
            this.v.set(this.cx - orig.x, this.cy - orig.y - this.halfh, this.cz - orig.z);
            if (this.uniform) {
                this.dir = rdir;
            } else {
                this.dir.set(rdir);
            }
        }
        double mint = Double.MAX_VALUE;
        if (this.dir.y != 0.0) {
            temp1 = this.v.y / this.dir.y;
            if (temp1 > 1.0E-12 && (a = temp1 * this.dir.x - this.v.x) * a + this.sz * (b = temp1 * this.dir.z - this.v.z) * b < this.rx2) {
                this.hit = 1;
                mint = temp1;
            }
            if (!this.cone && (temp1 = (this.v.y + this.height) / this.dir.y) > 1.0E-12 && (a = temp1 * this.dir.x - this.v.x) * a + this.sz * (b = temp1 * this.dir.z - this.v.z) * b < this.toprx2) {
                if (mint < Double.MAX_VALUE) {
                    this.intersections = 2;
                    if (temp1 < mint) {
                        this.hit = 0;
                        this.t = temp1;
                        this.t2 = mint;
                    } else {
                        this.t = mint;
                        this.t2 = temp1;
                    }
                    this.v.set(orig.x + this.t * rdir.x, orig.y + this.t * rdir.y, orig.z + this.t * rdir.z);
                    this.v2.set(orig.x + this.t2 * rdir.x, orig.y + this.t2 * rdir.y, orig.z + this.t2 * rdir.z);
                    this.lastRayResult = true;
                    return true;
                }
                this.hit = 0;
                mint = temp1;
            }
        }
        temp1 = this.sz * this.dir.z;
        double temp2 = this.sy * this.dir.y;
        double d = this.rx - this.sy * this.v.y;
        b = this.dir.x * this.v.x + d * this.sy * this.dir.y + temp1 * this.v.z;
        double c = this.v.x * this.v.x + this.sz * this.v.z * this.v.z - d * d;
        this.t = Double.MAX_VALUE;
        this.t2 = mint;
        if (c > 1.0E-12) {
            double e2;
            if (b > 0.0 && (e2 = b * b - (a = this.dir.x * this.dir.x + temp1 * this.dir.z - temp2 * temp2) * c) >= 0.0) {
                temp1 = Math.sqrt(e2);
                this.t = (b - temp1) / a;
                if (this.t2 == Double.MAX_VALUE) {
                    this.t2 = (b + temp1) / a;
                }
            }
        } else if (c < -1.0E-12) {
            a = this.dir.x * this.dir.x + temp1 * this.dir.z - temp2 * temp2;
            double e3 = b * b - a * c;
            if (e3 >= 0.0) {
                this.t = (b + Math.sqrt(e3)) / a;
            }
        } else if (b > 0.0 && (e = b * b - (a = this.dir.x * this.dir.x + temp1 * this.dir.z - temp2 * temp2) * c) >= 0.0) {
            this.t = (b + Math.sqrt(e)) / a;
        }
        if (this.t < mint && (a = this.t * this.dir.y - this.v.y) > 0.0 && a < this.height) {
            this.hit = 2;
            mint = this.t;
        }
        if (mint == Double.MAX_VALUE) {
            this.lastRayResult = false;
            return false;
        }
        if (this.t2 < mint) {
            temp1 = this.t2;
            this.t2 = mint;
            mint = temp1;
        }
        this.t = mint;
        this.v.set(orig.x + this.t * rdir.x, orig.y + this.t * rdir.y, orig.z + this.t * rdir.z);
        if (this.hit == 2) {
            this.projectPoint(this.v);
        }
        if (this.t2 == Double.MAX_VALUE) {
            this.intersections = 1;
        } else {
            this.intersections = 2;
            this.v2.set(orig.x + this.t2 * rdir.x, orig.y + this.t2 * rdir.y, orig.z + this.t2 * rdir.z);
        }
        this.lastRayResult = true;
        return true;
    }

    private void projectPoint(Vec3 pos) {
        if (this.transform) {
            this.toLocal.transform(pos);
            double r = this.rx + this.sy * (pos.y + this.halfh);
            double scale = r / Math.sqrt(pos.x * pos.x + this.sz * pos.z * pos.z);
            pos.set(pos.x * scale, pos.y, pos.z * scale);
            this.fromLocal.transform(pos);
        } else {
            double dx = pos.x - this.cx;
            double dz = pos.z - this.cz;
            double r = this.rx + this.sy * (pos.y - this.cy + this.halfh);
            double scale = r / Math.sqrt(dx * dx + this.sz * dz * dz);
            pos.set(this.cx + dx * scale, pos.y, this.cz + dz * scale);
        }
    }

    public int numIntersections() {
        return this.intersections;
    }

    public final void intersectionPoint(int n, Vec3 p) {
        if (n == 0) {
            p.set(this.v);
        } else {
            p.set(this.v2);
        }
    }

    public final double intersectionDist(int n) {
        if (n == 0) {
            return this.t;
        }
        return this.t2;
    }

    public void trueNormal(Vec3 n) {
        this.calcTrueNorm();
        n.set(this.trueNorm);
    }

    private final void calcTrueNorm() {
        if (this.normValid) {
            return;
        }
        this.normValid = true;
        if (this.hit == 0) {
            this.trueNorm.set(this.topNormal);
        } else if (this.hit == 1) {
            this.trueNorm.set(this.bottomNormal);
        } else {
            if (this.transform) {
                this.trueNorm.set(this.v.x - this.cx, this.v.y - this.cy, this.v.z - this.cz);
                this.toLocal.transformDirection(this.trueNorm);
                this.trueNorm.set(this.trueNorm.x, -(this.rx + this.sy * (this.trueNorm.y + this.halfh)) * this.sy, this.trueNorm.z * this.sz);
                this.fromLocal.transformDirection(this.trueNorm);
            } else {
                this.trueNorm.set(this.v.x - this.cx, -(this.rx + this.sy * (this.v.y - this.cy + this.halfh)) * this.sy, (this.v.z - this.cz) * this.sz);
            }
            this.trueNorm.normalize();
        }
    }

    public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size) {
        this.calcTrueNorm();
        n.set(this.trueNorm);
        TextureMapping map = this.theCylinder.getTextureMapping();
        if (this.uniform) {
            map.getTextureSpec(this.v, spec, -n.dot(viewDir), size, this.time, this.param);
        } else {
            this.dir.set(this.v);
            this.toLocal.transform(this.dir);
            map.getTextureSpec(this.dir, spec, -n.dot(viewDir), size, this.time, this.param);
        }
        if (this.bumpMapped) {
            if (this.transform) {
                this.fromLocal.transformDirection(spec.bumpGrad);
            }
            n.scale(spec.bumpGrad.dot(n) + 1.0);
            n.subtract(spec.bumpGrad);
            n.normalize();
        }
    }

    public void intersectionTransparency(int n, RGBColor trans, double angle, double size) {
        TextureMapping map = this.theCylinder.getTextureMapping();
        if (this.uniform) {
            map.getTransparency(this.v, trans, angle, size, this.time, this.param);
        } else {
            if (n == 0) {
                this.dir.set(this.v);
            } else {
                this.dir.set(this.v2);
            }
            this.toLocal.transform(this.dir);
            map.getTransparency(this.dir, trans, angle, size, this.time, this.param);
        }
    }

    public BoundingBox getBounds() {
        if (this.transform) {
            return new BoundingBox(-this.rx, this.rx, -this.halfh, this.halfh, -this.rz, this.rz).transformAndOutset(this.fromLocal);
        }
        if (this.toprx2 > this.rx2) {
            double xrad = Math.sqrt(this.toprx2);
            double zrad = Math.sqrt(this.rz2 * this.toprx2 / this.rx2);
            return new BoundingBox(this.cx - xrad, this.cx + xrad, this.cy - this.halfh, this.cy + this.halfh, this.cz - zrad, this.cz + zrad);
        }
        return new BoundingBox(this.cx - this.rx, this.cx + this.rx, this.cy - this.halfh, this.cy + this.halfh, this.cz - this.rz, this.cz + this.rz);
    }

    public boolean intersectsBox(BoundingBox bb) {
        double maxrad2;
        if (this.transform) {
            bb = bb.transformAndOutset(this.toLocal);
            if (bb.miny > this.halfh || bb.maxy < -this.halfh) {
                return false;
            }
            double x = 0.0;
            double z = 0.0;
            if (bb.minx > 0.0) {
                x = bb.minx;
            } else if (bb.maxx < 0.0) {
                x = bb.maxx;
            }
            if (bb.minz > 0.0) {
                z = bb.minz;
            } else if (bb.maxz < 0.0) {
                z = bb.maxz;
            }
            return !(x * x + this.sz * z * z > this.rx2);
        }
        if (bb.miny > this.cy + this.halfh || bb.maxy < this.cy - this.halfh) {
            return false;
        }
        double x = this.cx;
        double z = this.cz;
        if (this.cx < bb.minx) {
            x = bb.minx;
        } else if (this.cx > bb.maxx) {
            x = bb.maxx;
        }
        if (this.cz < bb.minz) {
            z = bb.minz;
        } else if (this.cz > bb.maxz) {
            z = bb.maxz;
        }
        double d = maxrad2 = this.rx2 > this.toprx2 ? this.rx2 : this.toprx2;
        return !((x - this.cx) * (x - this.cx) + this.sz * (z - this.cz) * (z - this.cz) > maxrad2);
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }
}

