/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.Cube;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;

public class RTCube
extends RTObject {
    private Cube theCube;
    private Vec3 v;
    private Vec3 v2;
    private Vec3 trueNorm;
    private double minx;
    private double miny;
    private double minz;
    private double maxx;
    private double maxy;
    private double maxz;
    private double mint;
    private double maxt;
    private double time;
    private double[] param;
    private int intersections;
    private boolean bumpMapped;
    private boolean transform;
    private boolean uniform;
    private Mat4 toLocal;
    private Mat4 fromLocal;
    public static final double TOL = 1.0E-12;
    private static final Vec3 temp1 = new Vec3();
    private static final Vec3 temp2 = new Vec3();

    public RTCube(Cube cube, Mat4 fromLocal, Mat4 toLocal, double time, double[] param) {
        Vec3 size = cube.getBounds().getSize();
        Vec3 vx = toLocal.timesDirection(Vec3.vx());
        Vec3 vy = toLocal.timesDirection(Vec3.vy());
        this.theCube = cube;
        this.time = time;
        this.param = param;
        this.v = new Vec3();
        this.v2 = new Vec3();
        this.trueNorm = new Vec3();
        this.uniform = cube.getTextureMapping() instanceof UniformMapping;
        double xsize = size.x;
        double ysize = size.y;
        double zsize = size.z;
        this.transform = true;
        if (vx.x == 1.0 || vx.x == -1.0) {
            if (vy.y == 1.0 || vy.y == -1.0) {
                this.transform = false;
            } else if (vy.z == 1.0 || vy.z == -1.0) {
                ysize = size.z;
                zsize = size.y;
                this.transform = false;
            }
        } else if (vx.y == 1.0 || vx.y == -1.0) {
            if (vy.x == 1.0 || vy.x == -1.0) {
                xsize = size.y;
                ysize = size.x;
                this.transform = false;
            } else if (vy.z == 1.0 || vy.z == -1.0) {
                xsize = size.y;
                ysize = size.z;
                zsize = size.x;
                this.transform = false;
            }
        } else if (vx.z == 1.0 || vx.z == -1.0) {
            if (vy.x == 1.0 || vy.x == -1.0) {
                xsize = size.z;
                ysize = size.x;
                zsize = size.y;
                this.transform = false;
            } else if (vy.y == 1.0 || vy.y == -1.0) {
                xsize = size.z;
                zsize = size.x;
                this.transform = false;
            }
        }
        if (this.transform) {
            this.fromLocal = fromLocal;
            this.minx = -0.5 * xsize;
            this.miny = -0.5 * ysize;
            this.minz = -0.5 * zsize;
            this.maxx = 0.5 * xsize;
            this.maxy = 0.5 * ysize;
            this.maxz = 0.5 * zsize;
        } else {
            Vec3 center = fromLocal.times(new Vec3());
            this.minx = center.x - 0.5 * xsize;
            this.miny = center.y - 0.5 * ysize;
            this.minz = center.z - 0.5 * zsize;
            this.maxx = center.x + 0.5 * xsize;
            this.maxy = center.y + 0.5 * ysize;
            this.maxz = center.z + 0.5 * zsize;
        }
        this.bumpMapped = cube.getTexture().hasComponent(5);
        this.toLocal = toLocal;
        this.lastRay = -1;
    }

    public final TextureMapping getTextureMapping() {
        return this.theCube.getTextureMapping();
    }

    public final MaterialMapping getMaterialMapping() {
        return this.theCube.getMaterialMapping();
    }

    protected boolean checkIntersection(Ray r) {
        double t2;
        double t1;
        Vec3 direction;
        Vec3 origin;
        Vec3 rorig = r.getOrigin();
        Vec3 rdir = r.getDirection();
        this.lastRay = r.getID();
        if (this.transform) {
            origin = temp1;
            origin.set(rorig);
            this.toLocal.transform(origin);
            direction = temp2;
            direction.set(rdir);
            this.toLocal.transformDirection(direction);
        } else {
            origin = rorig;
            direction = rdir;
        }
        this.mint = -1.7976931348623157E308;
        this.maxt = Double.MAX_VALUE;
        if (direction.x == 0.0) {
            if (origin.x < this.minx || origin.x > this.maxx) {
                this.lastRayResult = false;
                return false;
            }
        } else {
            t1 = (this.minx - origin.x) / direction.x;
            t2 = (this.maxx - origin.x) / direction.x;
            if (t1 < t2) {
                if (t1 > this.mint) {
                    this.mint = t1;
                }
                if (t2 < this.maxt) {
                    this.maxt = t2;
                }
            } else {
                if (t2 > this.mint) {
                    this.mint = t2;
                }
                if (t1 < this.maxt) {
                    this.maxt = t1;
                }
            }
            if (this.mint > this.maxt || this.maxt < 1.0E-12) {
                this.lastRayResult = false;
                return false;
            }
        }
        if (direction.y == 0.0) {
            if (origin.y < this.miny || origin.y > this.maxy) {
                this.lastRayResult = false;
                return false;
            }
        } else {
            t1 = (this.miny - origin.y) / direction.y;
            t2 = (this.maxy - origin.y) / direction.y;
            if (t1 < t2) {
                if (t1 > this.mint) {
                    this.mint = t1;
                }
                if (t2 < this.maxt) {
                    this.maxt = t2;
                }
            } else {
                if (t2 > this.mint) {
                    this.mint = t2;
                }
                if (t1 < this.maxt) {
                    this.maxt = t1;
                }
            }
            if (this.mint > this.maxt || this.maxt < 1.0E-12) {
                this.lastRayResult = false;
                return false;
            }
        }
        if (direction.z == 0.0) {
            if (origin.z < this.minz || origin.z > this.maxz) {
                this.lastRayResult = false;
                return false;
            }
        } else {
            t1 = (this.minz - origin.z) / direction.z;
            t2 = (this.maxz - origin.z) / direction.z;
            if (t1 < t2) {
                if (t1 > this.mint) {
                    this.mint = t1;
                }
                if (t2 < this.maxt) {
                    this.maxt = t2;
                }
            } else {
                if (t2 > this.mint) {
                    this.mint = t2;
                }
                if (t1 < this.maxt) {
                    this.maxt = t1;
                }
            }
            if (this.mint > this.maxt || this.maxt < 1.0E-12) {
                this.lastRayResult = false;
                return false;
            }
        }
        if (this.mint < 1.0E-12) {
            this.v.set(rorig.x + this.maxt * rdir.x, rorig.y + this.maxt * rdir.y, rorig.z + this.maxt * rdir.z);
            this.mint = this.maxt;
            this.intersections = 1;
        } else {
            this.v2.set(rorig.x + this.maxt * rdir.x, rorig.y + this.maxt * rdir.y, rorig.z + this.maxt * rdir.z);
            this.projectPoint(this.v2, false);
            this.v.set(rorig.x + this.mint * rdir.x, rorig.y + this.mint * rdir.y, rorig.z + this.mint * rdir.z);
            this.intersections = 2;
        }
        this.projectPoint(this.v, true);
        this.lastRayResult = true;
        return true;
    }

    private void projectPoint(Vec3 pos, boolean setNormal) {
        if (this.transform) {
            this.toLocal.transform(pos);
        }
        int side = 0;
        double mindist = Math.abs(pos.x - this.minx);
        double dist = Math.abs(pos.x - this.maxx);
        if (dist < mindist) {
            mindist = dist;
            side = 1;
        }
        if ((dist = Math.abs(pos.y - this.miny)) < mindist) {
            mindist = dist;
            side = 2;
        }
        if ((dist = Math.abs(pos.y - this.maxy)) < mindist) {
            mindist = dist;
            side = 3;
        }
        if ((dist = Math.abs(pos.z - this.minz)) < mindist) {
            mindist = dist;
            side = 4;
        }
        if ((dist = Math.abs(pos.z - this.maxz)) < mindist) {
            mindist = dist;
            side = 5;
        }
        if (side == 0) {
            pos.x = this.minx;
        } else if (side == 1) {
            pos.x = this.maxx;
        } else if (side == 2) {
            pos.y = this.miny;
        } else if (side == 3) {
            pos.y = this.maxy;
        } else if (side == 4) {
            pos.z = this.minz;
        } else if (side == 5) {
            pos.z = this.maxz;
        }
        if (this.transform) {
            this.fromLocal.transform(pos);
        }
        if (setNormal) {
            if (side == 0) {
                this.trueNorm.set(-1.0, 0.0, 0.0);
            }
            if (side == 1) {
                this.trueNorm.set(1.0, 0.0, 0.0);
            }
            if (side == 2) {
                this.trueNorm.set(0.0, -1.0, 0.0);
            }
            if (side == 3) {
                this.trueNorm.set(0.0, 1.0, 0.0);
            }
            if (side == 4) {
                this.trueNorm.set(0.0, 0.0, -1.0);
            }
            if (side == 5) {
                this.trueNorm.set(0.0, 0.0, 1.0);
            }
            if (this.transform) {
                this.fromLocal.transformDirection(this.trueNorm);
            }
        }
    }

    public int numIntersections() {
        return this.intersections;
    }

    public final void intersectionPoint(int n, Vec3 p) {
        if (n == 0) {
            p.set(this.v);
        } else {
            p.set(this.v2);
        }
    }

    public final double intersectionDist(int n) {
        if (n == 0) {
            return this.mint;
        }
        return this.maxt;
    }

    public void trueNormal(Vec3 n) {
        n.set(this.trueNorm);
    }

    public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size) {
        n.set(this.trueNorm);
        TextureMapping map = this.theCube.getTextureMapping();
        if (map instanceof UniformMapping) {
            map.getTextureSpec(this.v, spec, -n.dot(viewDir), size, this.time, this.param);
        } else {
            temp1.set(this.v);
            this.toLocal.transform(temp1);
            map.getTextureSpec(temp1, spec, -n.dot(viewDir), size, this.time, this.param);
        }
        if (this.bumpMapped) {
            if (this.transform) {
                this.fromLocal.transformDirection(spec.bumpGrad);
            }
            n.scale(spec.bumpGrad.dot(n) + 1.0);
            n.subtract(spec.bumpGrad);
            n.normalize();
        }
    }

    public void intersectionTransparency(int n, RGBColor trans, double angle, double size) {
        TextureMapping map = this.theCube.getTextureMapping();
        if (map instanceof UniformMapping) {
            map.getTransparency(this.v, trans, angle, size, this.time, this.param);
        } else {
            if (n == 0) {
                temp1.set(this.v);
            } else {
                temp1.set(this.v2);
            }
            this.toLocal.transform(temp1);
            map.getTransparency(temp1, trans, angle, size, this.time, this.param);
        }
    }

    public BoundingBox getBounds() {
        BoundingBox bounds = new BoundingBox(this.minx, this.maxx, this.miny, this.maxy, this.minz, this.maxz);
        if (this.transform) {
            bounds = bounds.transformAndOutset(this.fromLocal);
        }
        return bounds;
    }

    public boolean intersectsBox(BoundingBox bb) {
        if (!bb.intersects(this.getBounds())) {
            return false;
        }
        if (this.transform) {
            bb = bb.transformAndOutset(this.toLocal);
        }
        return !(bb.minx > this.minx) || !(bb.maxx < this.maxx) || !(bb.miny > this.miny) || !(bb.maxy < this.maxy) || !(bb.minz > this.minz) || !(bb.maxz < this.maxz);
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }
}

