/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.PointLight;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.Ray;

public class PointPhotonSource
implements PhotonSource {
    private PointLight light;
    private Vec3 pos;
    private RGBColor color;
    private float lightIntensity;

    public PointPhotonSource(PointLight light, CoordinateSystem coords, BoundingBox sceneBounds) {
        this.light = light;
        this.pos = coords.getOrigin();
        Vec3[] corner = sceneBounds.getCorners();
        double maxDist2 = 0.0;
        for (int i = 0; i < corner.length; ++i) {
            double dist2 = this.pos.distance2(corner[i]);
            if (!(dist2 > maxDist2)) continue;
            maxDist2 = dist2;
        }
        this.color = new RGBColor();
        double radius = Math.sqrt(maxDist2) * 0.5;
        light.getLight(this.color, (float)radius);
        this.lightIntensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if (this.lightIntensity == 0.0f) {
            return;
        }
        this.color.scale(1.0f / this.lightIntensity);
        this.lightIntensity *= (float)(Math.PI * 4 * radius * radius);
    }

    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    public void generatePhotons(PhotonMap map, double intensity) {
        int n;
        boolean randomizeOrigin = map.getRaytracer().penumbra;
        Ray r = new Ray();
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        for (int num = (int)intensity; num > 0; num -= n * n) {
            n = (int)Math.sqrt(num);
            double du = 2.0 / (double)n;
            double dphi = Math.PI * 2 / (double)n;
            double baseu = -1.0;
            for (int i = 0; i < n; ++i) {
                double basephi = 0.0;
                for (int j = 0; j < n; ++j) {
                    orig.set(this.pos);
                    if (randomizeOrigin) {
                        map.randomizePoint(orig, this.light.getRadius());
                    }
                    double ctheta = baseu + map.random.nextDouble() * du;
                    double phi = basephi + map.random.nextDouble() * dphi;
                    double stheta = Math.sqrt(1.0 - ctheta * ctheta);
                    double cphi = Math.cos(phi);
                    double sphi = Math.sin(phi);
                    dir.set(stheta * sphi, stheta * cphi, ctheta);
                    r.newID();
                    map.spawnPhoton(r, this.color, false);
                    basephi += dphi;
                }
                baseu += du;
            }
        }
    }
}

