/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.OctreeNode;
import artofillusion.raytracer.Photon;
import artofillusion.raytracer.PhotonList;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.Raytracer;
import artofillusion.texture.TextureSpec;
import java.util.Random;
import java.util.Vector;

public class PhotonMap {
    private Raytracer rt;
    private Vector photonVec;
    private Photon[] photon;
    private Photon[] workspace;
    private int numWanted;
    private int filter;
    private BoundingBox bounds;
    private Vec3[] direction;
    private Vec3 tempVec;
    private boolean includeCaustics;
    private boolean includeDirect;
    private boolean includeIndirect;
    private PhotonList nearbyPhotons;
    private RGBColor tempColor;
    private RGBColor tempColor2;
    private double lightScale;
    private float cutoffDist2;
    public Random random;

    public PhotonMap(int totalPhotons, int numEstimate, boolean includeCaustics, boolean includeDirect, boolean includeIndirect, Raytracer raytracer, BoundingBox bounds, int filter, PhotonMap shared) {
        this.numWanted = totalPhotons;
        this.bounds = bounds;
        this.includeCaustics = includeCaustics;
        this.includeDirect = includeDirect;
        this.includeIndirect = includeIndirect;
        this.filter = filter;
        this.rt = raytracer;
        this.direction = shared != null ? shared.direction : new Vec3[65536];
        this.nearbyPhotons = new PhotonList(numEstimate);
        this.random = new Random(1L);
        this.tempColor = new RGBColor();
        this.tempColor2 = new RGBColor();
        this.tempVec = new Vec3();
    }

    public Raytracer getRaytracer() {
        return this.rt;
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public void generatePhotons(PhotonSource[] source) {
        double volume;
        double cutoff2;
        int i;
        Thread currentThread = Thread.currentThread();
        double totalIntensity = 0.0;
        double requestedIntensity = 0.0;
        double totalRequested = 0.0;
        double[] sourceIntensity = new double[source.length];
        double totalSourceIntensity = 0.0;
        for (i = 0; i < source.length; ++i) {
            sourceIntensity[i] = source[i].getTotalIntensity();
            totalSourceIntensity += sourceIntensity[i];
        }
        double currentIntensity = 0.1 * (double)this.numWanted;
        this.photonVec = new Vector((int)(1.1 * (double)this.numWanted));
        while (this.photonVec.size() < this.numWanted) {
            for (i = 0; i < source.length; ++i) {
                if (this.rt.renderThread != currentThread) {
                    return;
                }
                source[i].generatePhotons(this, currentIntensity * sourceIntensity[i] / totalSourceIntensity);
                totalRequested += currentIntensity * sourceIntensity[i] / totalSourceIntensity;
            }
            if ((double)this.photonVec.size() >= (double)this.numWanted * 0.9 || this.photonVec.size() == 0 && currentIntensity > 5.0) break;
            totalIntensity += currentIntensity;
            if (this.photonVec.size() < 10) {
                currentIntensity *= 10.0;
                continue;
            }
            currentIntensity = (double)(this.numWanted - this.photonVec.size()) * totalIntensity / (double)this.photonVec.size();
        }
        this.lightScale = totalSourceIntensity / totalRequested;
        if (this.filter == 2) {
            this.lightScale *= 3.0;
        } else if (this.filter == 1) {
            this.lightScale *= 1.5;
        }
        int numPhotons = this.photonVec.size();
        this.workspace = new Photon[numPhotons];
        this.photonVec.copyInto(this.workspace);
        this.photonVec = null;
        this.photon = new Photon[numPhotons];
        this.buildTree(0, numPhotons - 1, 0);
        this.workspace = null;
        this.nearbyPhotons.init(0.0f);
        for (int i2 = 0; i2 < this.photon.length; ++i2) {
            this.tempColor.setERGB(this.photon[i2].ergb);
            float intensity = -(this.tempColor.getRed() + this.tempColor.getGreen() + this.tempColor.getBlue());
            if (!(intensity <= this.nearbyPhotons.cutoff2)) continue;
            this.nearbyPhotons.addPhoton(this.photon[i2], intensity);
        }
        float red = 0.0f;
        float green = 0.0f;
        float blue = 0.0f;
        for (int i3 = 0; i3 < this.nearbyPhotons.numFound; ++i3) {
            this.tempColor.setERGB(this.nearbyPhotons.photon[i3].ergb);
            red += this.tempColor.getRed();
            green += this.tempColor.getGreen();
            blue += this.tempColor.getBlue();
        }
        float max = Math.max(Math.max(red, green), blue);
        double cutoff1 = Math.sqrt((double)max * this.lightScale / 0.3141592653589793);
        this.cutoffDist2 = (float)(cutoff1 < (cutoff2 = Math.pow(0.5 * (volume = (this.bounds.maxx - this.bounds.minx) * (this.bounds.maxy - this.bounds.miny) * (this.bounds.maxz - this.bounds.minz)) * (double)this.nearbyPhotons.photon.length / (double)this.photon.length, 0.3333333333333333)) ? cutoff1 * cutoff1 : cutoff2 * cutoff2);
    }

    public void spawnPhoton(Ray r, RGBColor color, boolean indirect) {
        if (!r.intersects(this.bounds)) {
            return;
        }
        OctreeNode node = this.rt.rootNode.findNode(r.getOrigin());
        if (node == null) {
            node = this.rt.rootNode.findFirstNode(r);
        }
        if (node == null) {
            return;
        }
        this.tracePhoton(r, color, 0, node, null, null, null, null, null, 0.0, indirect, false);
    }

    private void tracePhoton(Ray r, RGBColor color, int treeDepth, OctreeNode node, RTObject first, MaterialMapping currentMaterial, MaterialMapping prevMaterial, Mat4 currentMatTrans, Mat4 prevMatTrans, double totalDist, boolean diffuse, boolean caustic) {
        double d;
        Vec3 temp;
        float diffuseAvg;
        double texSmoothing;
        OctreeNode nextNode;
        RTObject second = null;
        double n = 1.0;
        double beta = 0.0;
        Vec3 intersectionPoint = this.rt.pos[treeDepth];
        Vec3 norm = this.rt.normal[treeDepth];
        Vec3 trueNorm = this.rt.trueNormal[treeDepth];
        TextureSpec spec = this.rt.surfSpec[treeDepth];
        Mat4 oldMatTrans = null;
        if (first != null && first.intersects(r)) {
            first.intersectionPoint(0, intersectionPoint);
            nextNode = this.rt.rootNode.findNode(intersectionPoint);
        } else {
            nextNode = this.rt.traceRay(r, node);
            if (nextNode == null) {
                return;
            }
            first = this.rt.intersect.first;
            second = this.rt.intersect.second;
            first.intersectionPoint(0, intersectionPoint);
        }
        double dist = first.intersectionDist(0);
        totalDist += dist;
        first.trueNormal(trueNorm);
        double truedot = trueNorm.dot(r.getDirection());
        double d2 = texSmoothing = diffuse ? this.rt.smoothScale * this.rt.extraGISmoothing : this.rt.smoothScale;
        if (truedot > 0.0) {
            first.intersectionProperties(spec, norm, r.getDirection(), totalDist * texSmoothing * 3.0 / (2.0 + truedot));
        } else {
            first.intersectionProperties(spec, norm, r.getDirection(), totalDist * texSmoothing * 3.0 / (2.0 - truedot));
        }
        if (currentMaterial != null) {
            this.rt.propagateRay(r, nextNode, dist, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, this.tempColor, this.rt.rayIntensity[treeDepth], treeDepth, totalDist);
        } else if (this.rt.fog) {
            color.scale((float)Math.exp(-dist / this.rt.fogDist));
        }
        if (color.getRed() + color.getGreen() + color.getBlue() < this.rt.minRayIntensity) {
            return;
        }
        if ((this.includeDirect && treeDepth == 0 || this.includeIndirect && diffuse || this.includeCaustics && caustic) && spec.diffuse.getRed() + spec.diffuse.getGreen() + spec.diffuse.getBlue() + spec.hilight.getRed() + spec.hilight.getGreen() + spec.hilight.getBlue() > this.rt.minRayIntensity) {
            this.addPhoton(intersectionPoint, r.getDirection(), color);
        }
        if (treeDepth == this.rt.maxRayDepth - 1) {
            return;
        }
        boolean spawnSpecular = false;
        boolean spawnTransmitted = false;
        boolean spawnDiffuse = false;
        float specularScale = 1.0f;
        float transmittedScale = 1.0f;
        float diffuseScale = 1.0f;
        if (this.includeCaustics) {
            float transparentAvg;
            float specularAvg = (spec.specular.getRed() + spec.specular.getGreen() + spec.specular.getBlue()) * 0.33333334f;
            if (specularAvg > this.random.nextFloat()) {
                spawnSpecular = true;
                specularScale = 1.0f / specularAvg;
            }
            if ((transparentAvg = (spec.transparent.getRed() + spec.transparent.getGreen() + spec.transparent.getBlue()) * 0.33333334f) > this.random.nextFloat()) {
                spawnTransmitted = true;
                transmittedScale = 1.0f / transparentAvg;
            }
        }
        if (this.includeIndirect && (diffuseAvg = (spec.diffuse.getRed() + spec.diffuse.getGreen() + spec.diffuse.getBlue()) * 0.33333334f) > this.random.nextFloat()) {
            spawnDiffuse = true;
            diffuseScale = 1.0f / diffuseAvg;
        }
        double dot = norm.dot(r.getDirection());
        RGBColor col = this.rt.rayIntensity[treeDepth + 1];
        boolean totalReflect = false;
        if (spawnTransmitted) {
            MaterialMapping oldMaterial;
            Mat4 nextMatTrans;
            MaterialMapping nextMaterial;
            col.copy(color);
            col.multiply(spec.transparent);
            col.scale(transmittedScale);
            this.rt.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            temp = this.rt.ray[treeDepth + 1].getDirection();
            if (first.getMaterialMapping() == null) {
                temp.set(r.getDirection());
                nextMaterial = currentMaterial;
                nextMatTrans = currentMatTrans;
                oldMaterial = prevMaterial;
                oldMatTrans = prevMatTrans;
            } else if (dot < 0.0) {
                nextMaterial = first.getMaterialMapping();
                nextMatTrans = first.toLocal();
                oldMaterial = currentMaterial;
                oldMatTrans = currentMatTrans;
                n = currentMaterial == null ? nextMaterial.indexOfRefraction() / 1.0 : nextMaterial.indexOfRefraction() / currentMaterial.indexOfRefraction();
                beta = -(dot + Math.sqrt(n * n - 1.0 + dot * dot));
                temp.set(norm);
                temp.scale(beta);
                temp.add(r.getDirection());
                temp.scale(1.0 / n);
            } else {
                if (currentMaterial == first.getMaterialMapping()) {
                    nextMaterial = prevMaterial;
                    nextMatTrans = prevMatTrans;
                    oldMaterial = null;
                    n = nextMaterial == null ? 1.0 / currentMaterial.indexOfRefraction() : nextMaterial.indexOfRefraction() / currentMaterial.indexOfRefraction();
                } else {
                    nextMaterial = currentMaterial;
                    nextMatTrans = currentMatTrans;
                    if (prevMaterial == first.getMaterialMapping()) {
                        oldMaterial = null;
                    } else {
                        oldMaterial = prevMaterial;
                        oldMatTrans = prevMatTrans;
                    }
                    n = 1.0;
                }
                beta = dot - Math.sqrt(n * n - 1.0 + dot * dot);
                temp.set(norm);
                temp.scale(-beta);
                temp.add(r.getDirection());
                temp.scale(1.0 / n);
            }
            if (Double.isNaN(beta)) {
                totalReflect = true;
            } else {
                double d3 = d = truedot > 0.0 ? temp.dot(trueNorm) : -temp.dot(trueNorm);
                if (d < 0.0) {
                    temp.x -= (d += 1.0E-12) * trueNorm.x;
                    temp.y -= d * trueNorm.y;
                    temp.z -= d * trueNorm.z;
                    temp.normalize();
                }
                this.rt.ray[treeDepth + 1].newID();
                if (this.rt.gloss) {
                    this.randomizeDirection(temp, norm, spec.cloudiness);
                }
                boolean newCaustic = caustic || n != 1.0;
                this.tracePhoton(this.rt.ray[treeDepth + 1], col, treeDepth + 1, nextNode, second, nextMaterial, oldMaterial, nextMatTrans, oldMatTrans, totalDist, diffuse, newCaustic);
            }
        }
        if (spawnSpecular || totalReflect) {
            col.copy(spec.specular);
            col.scale(specularScale);
            if (totalReflect) {
                col.add(spec.transparent.getRed() * transmittedScale, spec.transparent.getGreen() * transmittedScale, spec.transparent.getBlue() * transmittedScale);
            }
            col.multiply(color);
            temp = this.rt.ray[treeDepth + 1].getDirection();
            temp.set(norm);
            temp.scale(-2.0 * dot);
            temp.add(r.getDirection());
            double d4 = d = truedot > 0.0 ? temp.dot(trueNorm) : -temp.dot(trueNorm);
            if (d >= 0.0) {
                temp.x += (d += 1.0E-12) * trueNorm.x;
                temp.y += d * trueNorm.y;
                temp.z += d * trueNorm.z;
                temp.normalize();
            }
            this.rt.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            this.rt.ray[treeDepth + 1].newID();
            if (this.rt.gloss) {
                this.randomizeDirection(temp, norm, spec.roughness);
            }
            this.tracePhoton(this.rt.ray[treeDepth + 1], col, treeDepth + 1, nextNode, second, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, totalDist, diffuse, true);
        }
        if (spawnDiffuse) {
            col.copy(spec.diffuse);
            col.multiply(color);
            col.scale(0.5f * diffuseScale);
            temp = this.rt.ray[treeDepth + 1].getDirection();
            do {
                temp.set(0.0, 0.0, 0.0);
                this.randomizePoint(temp, 1.0);
                temp.normalize();
                d = temp.dot(trueNorm) * (truedot > 0.0 ? 1.0 : -1.0);
            } while (this.random.nextDouble() > (d < 0.0 ? -d : d));
            if (d > 0.0) {
                temp.scale(-1.0);
            }
            this.rt.ray[treeDepth + 1].getOrigin().set(intersectionPoint);
            this.rt.ray[treeDepth + 1].newID();
            this.tracePhoton(this.rt.ray[treeDepth + 1], col, treeDepth + 1, nextNode, second, currentMaterial, prevMaterial, currentMatTrans, prevMatTrans, totalDist, true, caustic);
        }
    }

    private void addPhoton(Vec3 pos, Vec3 dir, RGBColor color) {
        Photon p = new Photon(pos, dir, color);
        this.photonVec.addElement(p);
        if (this.direction[p.direction & 0xFFFF] == null) {
            int i = p.direction >> 8 & 0xFF;
            int j = p.direction & 0xFF;
            double phi = (double)i * Math.PI / 128.0;
            double theta = (double)j * Math.PI / 256.0;
            double sphi = Math.sin(phi);
            double cphi = Math.cos(phi);
            double stheta = Math.sin(theta);
            double ctheta = Math.cos(theta);
            this.direction[p.direction & 0xFFFF] = new Vec3(cphi * stheta, ctheta, sphi * stheta);
        }
    }

    void randomizePoint(Vec3 pos, double size) {
        double z;
        double y;
        double x;
        if (size == 0.0) {
            return;
        }
        while ((x = this.random.nextDouble() - 0.5) * x + (y = this.random.nextDouble() - 0.5) * y + (z = this.random.nextDouble() - 0.5) * z > 0.25) {
        }
        pos.x += 2.0 * size * x;
        pos.y += 2.0 * size * y;
        pos.z += 2.0 * size * z;
    }

    void randomizeDirection(Vec3 dir, Vec3 norm, double roughness) {
        double z;
        double y;
        double x;
        if (roughness == 0.0) {
            return;
        }
        while ((x = this.random.nextDouble() - 0.5) * x + (y = this.random.nextDouble() - 0.5) * y + (z = this.random.nextDouble() - 0.5) * z > 0.25) {
        }
        double scale = Math.pow(roughness, 1.7) * 0.5;
        double dot1 = dir.dot(norm);
        dir.x += 2.0 * scale * x;
        dir.y += 2.0 * scale * y;
        dir.z += 2.0 * scale * z;
        double dot2 = 2.0 * dir.dot(norm);
        if (dot1 < 0.0 && dot2 > 0.0) {
            dir.x -= dot2 * norm.x;
            dir.y -= dot2 * norm.y;
            dir.z -= dot2 * norm.z;
        } else if (dot1 > 0.0 && dot2 < 0.0) {
            dir.x += dot2 * norm.x;
            dir.y += dot2 * norm.y;
            dir.z += dot2 * norm.z;
        }
        dir.normalize();
    }

    private final void buildTree(int start, int end, int root) {
        if (start == end) {
            this.photon[root] = this.workspace[start];
        }
        if (start >= end) {
            return;
        }
        float minx = Float.MAX_VALUE;
        float miny = Float.MAX_VALUE;
        float minz = Float.MAX_VALUE;
        float maxx = -3.4028235E38f;
        float maxy = -3.4028235E38f;
        float maxz = -3.4028235E38f;
        for (int i = start; i <= end; ++i) {
            Photon p = this.workspace[i];
            if (p.x < minx) {
                minx = p.x;
            }
            if (p.y < miny) {
                miny = p.y;
            }
            if (p.z < minz) {
                minz = p.z;
            }
            if (p.x > maxx) {
                maxx = p.x;
            }
            if (p.y > maxy) {
                maxy = p.y;
            }
            if (!(p.z > maxz)) continue;
            maxz = p.z;
        }
        float xsize = maxx - minx;
        float ysize = maxy - miny;
        float zsize = maxz - minz;
        int axis = xsize > ysize && xsize > zsize ? 0 : (ysize > zsize ? 1 : 2);
        int size = end - start + 1;
        int medianPos = 1;
        while (4 * medianPos <= size) {
            medianPos += medianPos;
        }
        medianPos = 3 * medianPos <= size ? 2 * medianPos + start - 1 : end - medianPos + 1;
        this.medianSplit(start, end, medianPos, axis);
        this.photon[root] = this.workspace[medianPos];
        this.photon[root].axis = (short)axis;
        this.buildTree(start, medianPos - 1, 2 * root + 1);
        this.buildTree(medianPos + 1, end, 2 * root + 2);
    }

    private final void medianSplit(int start, int end, int medianPos, int axis) {
        if (start == end) {
            return;
        }
        if (end - start == 1) {
            if (this.axisPosition(start, axis) > this.axisPosition(end, axis)) {
                this.swap(start, end);
            }
            return;
        }
        while (start < end) {
            float a = this.axisPosition(start, axis);
            float b = this.axisPosition(start + 1, axis);
            float c = this.axisPosition(end, axis);
            float medianEstimate = a > b ? (a > c ? (b > c ? b : c) : a) : (b > c ? (a > c ? a : c) : b);
            int i = start;
            int j = end;
            while (true) {
                if (i < end && this.axisPosition(i, axis) < medianEstimate) {
                    ++i;
                    continue;
                }
                while (this.axisPosition(j, axis) > medianEstimate) {
                    --j;
                }
                if (i >= j) break;
                this.swap(i, j);
                ++i;
                --j;
            }
            this.swap(i, end);
            if (i > medianPos) {
                end = i - 1;
            }
            if (i > medianPos) continue;
            start = i;
        }
    }

    private final float axisPosition(int index, int axis) {
        switch (axis) {
            case 0: {
                return this.workspace[index].x;
            }
            case 1: {
                return this.workspace[index].y;
            }
        }
        return this.workspace[index].z;
    }

    private final void swap(int first, int second) {
        Photon temp = this.workspace[first];
        this.workspace[first] = this.workspace[second];
        this.workspace[second] = temp;
    }

    public void getLight(Vec3 pos, TextureSpec spec, Vec3 normal, Vec3 viewDir, boolean front, RGBColor light) {
        light.setRGB(0.0f, 0.0f, 0.0f);
        if (this.photon.length == 0) {
            return;
        }
        this.nearbyPhotons.init(this.cutoffDist2);
        this.findPhotons(pos, 0);
        if (this.nearbyPhotons.numFound == 0) {
            return;
        }
        float r2inv = 1.0f / this.nearbyPhotons.cutoff2;
        boolean hilight = false;
        if (spec.hilight.getMaxComponent() > this.rt.minRayIntensity) {
            hilight = true;
            this.tempColor2.setRGB(0.0f, 0.0f, 0.0f);
        }
        for (int i = 0; i < this.nearbyPhotons.numFound; ++i) {
            double viewDot;
            Photon p = this.nearbyPhotons.photon[i];
            Vec3 dir = this.direction[p.direction & 0xFFFF];
            double dot = normal.dot(dir);
            if (!(front && dot < -1.0E-10) && (front || !(dot > 1.0E-10))) continue;
            this.tempColor.setERGB(p.ergb);
            float x = this.nearbyPhotons.dist2[i] * r2inv;
            if (this.filter == 2) {
                this.tempColor.scale(x * (x - 2.0f) + 1.0f);
            } else if (this.filter == 1) {
                this.tempColor.scale(1.0f - x * x);
            }
            light.add(this.tempColor);
            if (!hilight) continue;
            this.tempVec.set(dir);
            this.tempVec.add(viewDir);
            this.tempVec.normalize();
            double d = viewDot = front ? -this.tempVec.dot(normal) : this.tempVec.dot(normal);
            if (!(viewDot > 0.0)) continue;
            float scale = (float)Math.pow(viewDot, (1.0 - spec.roughness) * 128.0 + 1.0);
            this.tempColor2.add(this.tempColor.getRed() * scale, this.tempColor.getGreen() * scale, this.tempColor.getBlue() * scale);
        }
        light.multiply(spec.diffuse);
        if (hilight) {
            this.tempColor2.multiply(spec.hilight);
            light.add(this.tempColor2);
        }
        light.scale(this.lightScale / (Math.PI * (double)this.nearbyPhotons.cutoff2));
    }

    private void findPhotons(Vec3 pos, int index) {
        float delta;
        Photon p = this.photon[index];
        float dx = p.x - (float)pos.x;
        float dy = p.y - (float)pos.y;
        float dz = p.z - (float)pos.z;
        float dist2 = dx * dx + dy * dy + dz * dz;
        switch (p.axis) {
            case 0: {
                delta = dx;
                break;
            }
            case 1: {
                delta = dy;
                break;
            }
            default: {
                delta = dz;
            }
        }
        if (delta > 0.0f) {
            int child = (index << 1) + 1;
            if (child < this.photon.length) {
                this.findPhotons(pos, child);
                delta *= delta;
                if (++child < this.photon.length && delta < this.nearbyPhotons.cutoff2) {
                    this.findPhotons(pos, child);
                }
            }
        } else {
            int child = (index << 1) + 2;
            if (child < this.photon.length) {
                this.findPhotons(pos, child);
            }
            delta *= delta;
            if (--child < this.photon.length && delta < this.nearbyPhotons.cutoff2) {
                this.findPhotons(pos, child);
            }
        }
        if (dist2 < this.nearbyPhotons.cutoff2) {
            this.nearbyPhotons.addPhoton(p, dist2);
        }
    }

    private void validateTree(int pos) {
        int child1 = 2 * pos + 1;
        int child2 = 2 * pos + 2;
        if (child1 < this.photon.length) {
            this.validateLowerBranch(child1, this.photon[pos].axis, this.median(pos, this.photon[pos].axis));
            this.validateTree(child1);
        }
        if (child2 < this.photon.length) {
            this.validateUpperBranch(child2, this.photon[pos].axis, this.median(pos, this.photon[pos].axis));
            this.validateTree(child2);
        }
    }

    private void validateLowerBranch(int pos, int axis, float median) {
        float value = this.median(pos, axis);
        if (value > median) {
            System.out.println("error!");
        }
        int child1 = 2 * pos + 1;
        int child2 = 2 * pos + 2;
        if (child1 < this.photon.length) {
            this.validateLowerBranch(child1, axis, median);
        }
        if (child2 < this.photon.length) {
            this.validateLowerBranch(child2, axis, median);
        }
    }

    private void validateUpperBranch(int pos, int axis, float median) {
        float value = this.median(pos, axis);
        if (value < median) {
            System.out.println("error!");
        }
        int child1 = 2 * pos + 1;
        int child2 = 2 * pos + 2;
        if (child1 < this.photon.length) {
            this.validateUpperBranch(child1, axis, median);
        }
        if (child2 < this.photon.length) {
            this.validateUpperBranch(child2, axis, median);
        }
    }

    private final float median(int index, int axis) {
        switch (axis) {
            case 0: {
                return this.photon[index].x;
            }
            case 1: {
                return this.photon[index].y;
            }
        }
        return this.photon[index].z;
    }
}

