/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.SceneRenderInfoProvider;
import artofillusion.math.BoundingBox;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.Raytracer;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;

public class EnvironmentPhotonSource
implements PhotonSource {
    private SceneRenderInfoProvider scene;
    private Vec3 center;
    private RGBColor color;
    private TextureMapping envMapping;
    private int envMode;
    private float lightIntensity;
    private double radius;

    public EnvironmentPhotonSource(SceneRenderInfoProvider scene, BoundingBox sceneBounds) {
        this.scene = scene;
        this.center = sceneBounds.getCenter();
        Vec3[] corner = sceneBounds.getCorners();
        double maxDist2 = 0.0;
        for (int i = 0; i < corner.length; ++i) {
            double dist2 = this.center.distance2(corner[i]);
            if (!(dist2 > maxDist2)) continue;
            maxDist2 = dist2;
        }
        this.radius = Math.sqrt(maxDist2);
        this.envMode = scene.getEnvironmentMode();
        this.color = new RGBColor();
        if (this.envMode == 0) {
            this.color.copy(scene.getEnvironmentColor());
        } else {
            TextureSpec spec = new TextureSpec();
            this.envMapping = scene.getEnvironmentMapping();
            this.envMapping.getTexture().getAverageSpec(spec, scene.getTime(), null);
            if (this.envMode == 1) {
                this.color.copy(spec.diffuse);
            } else {
                this.color.copy(spec.emissive);
            }
        }
        this.lightIntensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if (this.lightIntensity == 0.0f) {
            return;
        }
        this.color.scale(1.0f / this.lightIntensity);
        this.lightIntensity *= (float)(Math.PI * 4 * this.radius * this.radius);
    }

    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    public void generatePhotons(PhotonMap map, double intensity) {
        Raytracer rt = map.getRaytracer();
        TextureSpec spec = rt.surfSpec[0];
        Ray r = new Ray();
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        double emittedIntensity = 0.0;
        int i = 0;
        while (emittedIntensity < intensity) {
            block7: {
                block6: {
                    block5: {
                        double dot;
                        double ctheta = ((double)((i & 3) - 2) + map.random.nextDouble()) * 0.5;
                        double stheta = Math.sqrt(1.0 - ctheta * ctheta);
                        double phi = ((double)(i >> 2 & 3) + map.random.nextDouble()) * 0.5 * Math.PI;
                        double sphi = Math.sin(phi);
                        double cphi = Math.cos(phi);
                        orig.set(stheta * sphi, stheta * cphi, ctheta);
                        do {
                            dir.set(0.0, 0.0, 0.0);
                            map.randomizePoint(dir, 1.0);
                            dir.normalize();
                            dot = orig.dot(dir);
                            if (dot > 0.0) {
                                dir.scale(-1.0);
                                continue;
                            }
                            dot = -dot;
                        } while (dot < map.random.nextDouble());
                        orig.scale(this.radius);
                        orig.add(this.center);
                        if (this.envMode != 1 && this.envMode != 2) break block5;
                        this.envMapping.getTextureSpec(dir.times(-1.0), spec, 1.0, rt.smoothScale * rt.extraGIEnvSmoothing, rt.time, null);
                        if (this.envMode == 1) {
                            this.color.copy(spec.diffuse);
                        } else {
                            this.color.copy(spec.emissive);
                        }
                        float sum = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
                        emittedIntensity += (double)sum;
                        if (!((double)sum < 1.0)) break block6;
                        if (sum < map.random.nextFloat()) break block7;
                        this.color.scale(1.0f / sum);
                        break block6;
                    }
                    emittedIntensity += 1.0;
                }
                r.newID();
                map.spawnPhoton(r, this.color, true);
            }
            ++i;
        }
    }
}

