/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.DirectionalLight;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.Ray;

public class DirectionalPhotonSource
implements PhotonSource {
    private DirectionalLight light;
    private CoordinateSystem coords;
    private RGBColor color;
    private float lightIntensity;
    private double minx;
    private double maxx;
    private double miny;
    private double maxy;
    private Vec3 center;

    public DirectionalPhotonSource(DirectionalLight light, CoordinateSystem coords, BoundingBox sceneBounds) {
        this.light = light;
        this.coords = coords;
        BoundingBox bounds = sceneBounds.transformAndOutset(coords.toLocal());
        this.minx = bounds.minx;
        this.maxx = bounds.maxx;
        this.miny = bounds.miny;
        this.maxy = bounds.maxy;
        this.center = coords.fromLocal().times(new Vec3(0.5 * (this.minx + this.maxx), 0.5 * (this.miny + this.maxy), bounds.minz - 1.0));
        this.color = new RGBColor();
        light.getLight(this.color, 0.0f);
        this.lightIntensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if (this.lightIntensity == 0.0f) {
            return;
        }
        this.color.scale(1.0f / this.lightIntensity);
        this.lightIntensity *= (float)((this.maxx - this.minx) * (this.maxy - this.miny));
    }

    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    public void generatePhotons(PhotonMap map, double intensity) {
        int n;
        Vec3 xdir = this.coords.fromLocal().timesDirection(Vec3.vx());
        Vec3 ydir = this.coords.fromLocal().timesDirection(Vec3.vy());
        double xsize = this.maxx - this.minx;
        double ysize = this.maxy - this.miny;
        Ray r = new Ray();
        Vec3 orig = r.getOrigin();
        r.getDirection().set(this.coords.getZDirection());
        for (int num = (int)intensity; num > 0; num -= n * n) {
            n = (int)Math.sqrt(num);
            if (n == 0) {
                n = 1;
            }
            double dx = xsize / (double)n;
            double dy = ysize / (double)n;
            double basex = -0.5 * xsize;
            for (int i = 0; i < n; ++i) {
                double basey = -0.5 * ysize;
                for (int j = 0; j < n; ++j) {
                    double x = basex + map.random.nextDouble() * dx;
                    double y = basey + map.random.nextDouble() * dy;
                    orig.set(this.center.x + x * xdir.x + y * ydir.x, this.center.y + x * xdir.y + y * ydir.y, this.center.z + x * xdir.z + y * ydir.z);
                    r.newID();
                    map.spawnPhoton(r, this.color, false);
                    basey += dy;
                }
                basex += dx;
            }
        }
    }
}

