/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.RTCylinder;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.Raytracer;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;

public class CylinderPhotonSource
implements PhotonSource {
    private RTCylinder cylinder;
    private double rx;
    private double rz;
    private double height;
    private double ratio;
    private double[] param;
    private double bottomArea;
    private double topArea;
    private double sideArea;
    private Mat4 fromLocal;
    private TextureMapping texMap;
    private RGBColor color;
    private float lightIntensity;

    public CylinderPhotonSource(RTCylinder obj, Raytracer rt) {
        this.cylinder = obj;
        this.rx = obj.rx;
        this.rz = obj.rz;
        this.height = obj.height;
        this.ratio = Math.sqrt(obj.toprx2 / obj.rx2);
        this.fromLocal = obj.fromLocal;
        if (this.fromLocal == null && this.ratio > 1.0) {
            this.rx *= this.ratio;
            this.rz *= this.ratio;
            this.ratio = 1.0 / this.ratio;
            this.fromLocal = Mat4.translation((double)this.cylinder.cx, (double)this.cylinder.cy, (double)this.cylinder.cz).times(Mat4.xrotation((double)Math.PI));
        }
        this.param = obj.param;
        this.texMap = obj.getTextureMapping();
        this.color = new RGBColor();
        this.bottomArea = Math.PI * this.rx * this.rz;
        this.topArea = this.bottomArea * this.ratio * this.ratio;
        this.sideArea = Math.PI * 2 * Math.sqrt(0.5 * (this.rx * this.rx + this.rz * this.rz)) * this.height * (0.5 + 0.5 * this.ratio);
        TextureSpec spec = rt.surfSpec[0];
        this.texMap.getTexture().getAverageSpec(spec, rt.time, obj.param);
        this.color.copy(spec.emissive);
        this.lightIntensity = 0.5f * (this.color.getRed() + this.color.getGreen() + this.color.getBlue()) * (float)(this.bottomArea + this.topArea + this.sideArea);
        if (this.texMap.appliesTo() == 0) {
            this.lightIntensity *= 2.0f;
        }
    }

    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    public void generatePhotons(PhotonMap map, double intensity) {
        Raytracer rt = map.getRaytracer();
        TextureSpec spec = rt.surfSpec[0];
        Ray r = new Ray();
        Vec3 orig = r.getOrigin();
        Vec3 dir = r.getDirection();
        Vec3 norm = new Vec3();
        double prob1 = this.bottomArea / (this.bottomArea + this.topArea + this.sideArea);
        double prob2 = (this.bottomArea + this.topArea) / (this.bottomArea + this.topArea + this.sideArea);
        double halfHeight = 0.5 * this.height;
        double sz = this.rx * this.rx / (this.rz * this.rz);
        double sy = this.rx * (this.ratio - 1.0) / this.height;
        for (double emittedIntensity = 0.0; emittedIntensity < intensity; emittedIntensity += (double)this.generateOnePhoton(map, r, norm)) {
            double h;
            double f;
            double z;
            double x;
            double p = map.random.nextDouble();
            if (p < prob1) {
                while ((x = map.random.nextDouble() - 0.5) * x + (z = map.random.nextDouble() - 0.5) * z > 0.25) {
                }
                orig.set(2.0 * x * this.rx, -halfHeight, 2.0 * z * this.rz);
                norm.set(0.0, -1.0, 0.0);
                continue;
            }
            if (p < prob2) {
                while ((x = map.random.nextDouble() - 0.5) * x + (z = map.random.nextDouble() - 0.5) * z > 0.25) {
                }
                orig.set(2.0 * x * this.rx * this.ratio, halfHeight, 2.0 * z * this.rz * this.ratio);
                norm.set(0.0, 1.0, 0.0);
                continue;
            }
            while ((f = 1.0 - (1.0 - this.ratio) * (h = map.random.nextDouble())) < map.random.nextDouble()) {
            }
            double phi = Math.PI * 2 * map.random.nextDouble();
            double cphi = Math.cos(phi);
            double sphi = Math.sin(phi);
            orig.set(f * this.rx * cphi, h * this.height - halfHeight, f * this.rz * sphi);
            norm.set(orig.x - this.cylinder.cx, -(this.rx + sy * (orig.y - this.cylinder.cy + halfHeight)) * sy, (orig.z - this.cylinder.cz) * sz);
            norm.normalize();
        }
    }

    private float generateOnePhoton(PhotonMap map, Ray r, Vec3 norm) {
        double dot;
        double absdot;
        Raytracer rt = map.getRaytracer();
        TextureSpec spec = rt.surfSpec[0];
        Vec3 dir = r.getDirection();
        float intensity = 1.0f;
        do {
            dir.set(0.0, 0.0, 0.0);
            map.randomizePoint(dir, 1.0);
            dir.normalize();
        } while ((absdot = (dot = norm.dot(dir)) > 0.0 ? dot : -dot) < map.random.nextDouble());
        if (!this.texMap.appliesToFace(dot > 0.0)) {
            dot = -dot;
            dir.scale(-1.0);
        }
        this.texMap.getTextureSpec(dir, spec, dot, rt.smoothScale, rt.time, this.param);
        this.color.copy(spec.emissive);
        intensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if ((double)intensity < 1.0) {
            if (intensity < map.random.nextFloat()) {
                return intensity;
            }
            this.color.scale(1.0f / intensity);
        }
        if (this.fromLocal != null) {
            this.fromLocal.transform(r.getOrigin());
            this.fromLocal.transformDirection(dir);
        } else {
            Vec3 orig = r.getOrigin();
            orig.x += this.cylinder.cx;
            orig.y += this.cylinder.cy;
            orig.z += this.cylinder.cz;
        }
        r.newID();
        map.spawnPhoton(r, this.color, true);
        return intensity;
    }
}

