/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.ModellingApp;
import artofillusion.ObjectPreviewCanvas;
import artofillusion.UndoRecord;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.object.SplineMesh;
import artofillusion.texture.Texture;
import artofillusion.ui.EditingWindow;
import artofillusion.ui.Translate;
import artofillusion.ui.UIUtilities;
import artofillusion.ui.ValueField;
import artofillusion.ui.ValueSlider;
import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BButton;
import buoy.widget.BDialog;
import buoy.widget.BLabel;
import buoy.widget.BOutline;
import buoy.widget.BRadioButton;
import buoy.widget.FormContainer;
import buoy.widget.LayoutInfo;
import buoy.widget.RadioButtonGroup;
import buoy.widget.RowContainer;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Dimension;
import java.awt.Insets;

public class LatheDialog
extends BDialog {
    LayoutWindow window;
    ObjectInfo theCurveInfo;
    Curve theCurve;
    RadioButtonGroup axisGroup;
    BRadioButton xBox;
    BRadioButton yBox;
    BRadioButton zBox;
    BRadioButton endsBox;
    ValueField radiusField;
    ValueField segmentsField;
    ValueSlider angleSlider;
    BButton okButton;
    BButton cancelButton;
    ObjectPreviewCanvas preview;
    private static int counter = 1;

    public LatheDialog(LayoutWindow window, ObjectInfo curveinfo) {
        super((WindowWidget)window, "Lathe", true);
        this.window = window;
        this.theCurveInfo = curveinfo;
        this.theCurve = (Curve)curveinfo.object;
        FormContainer content = new FormContainer(3, 10);
        this.setContent((Widget)BOutline.createEmptyBorder((Widget)content, (int)ModellingApp.standardDialogInsets));
        content.setDefaultLayout(new LayoutInfo(LayoutInfo.WEST, LayoutInfo.NONE, new Insets(0, 0, 0, 5), null));
        content.add((Widget)new BLabel("Select Lathe Axis:"), 0, 0, 2, 1);
        this.axisGroup = new RadioButtonGroup();
        this.xBox = new BRadioButton("X axis", false, this.axisGroup);
        content.add((Widget)this.xBox, 0, 1, 2, 1);
        this.yBox = new BRadioButton("Y axis", true, this.axisGroup);
        content.add((Widget)this.yBox, 0, 2, 2, 1);
        this.zBox = new BRadioButton("Z axis", false, this.axisGroup);
        content.add((Widget)this.zBox, 0, 3, 2, 1);
        this.endsBox = new BRadioButton("Line through endpoints", false, this.axisGroup);
        content.add((Widget)this.endsBox, 0, 4, 2, 1);
        this.axisGroup.addEventLink(SelectionChangedEvent.class, (Object)this, "makeObject");
        content.add((Widget)new BLabel("Total Rotation Angle:"), 0, 5, 2, 1);
        this.angleSlider = new ValueSlider(0.0, 360.0, 180, 360.0);
        content.add((Widget)this.angleSlider, 0, 6, 2, 1);
        this.angleSlider.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        content.add((Widget)new BLabel("Radius:"), 0, 7);
        content.add((Widget)new BLabel("Segments:"), 0, 8);
        this.radiusField = new ValueField(0.0, 0);
        content.add((Widget)this.radiusField, 1, 7);
        this.segmentsField = new ValueField(8.0, 7);
        content.add((Widget)this.segmentsField, 1, 8);
        this.radiusField.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        this.segmentsField.addEventLink(ValueChangedEvent.class, (Object)this, "makeObject");
        this.preview = new ObjectPreviewCanvas(null);
        content.add((Widget)this.preview, 2, 0, 1, 9);
        this.preview.setPreferredSize(new Dimension(150, 150));
        RowContainer buttons = new RowContainer();
        this.okButton = Translate.button((String)"ok", (Object)((Object)this), (String)"doOk");
        buttons.add((Widget)this.okButton);
        this.cancelButton = Translate.button((String)"cancel", (Object)((Object)this), (String)"dispose");
        buttons.add((Widget)this.cancelButton);
        content.add((Widget)buttons, 0, 9, 3, 1, new LayoutInfo());
        this.selectDefaults();
        this.makeObject();
        this.pack();
        UIUtilities.centerDialog((BDialog)this, (WindowWidget)window);
        this.setVisible(true);
    }

    private void doOk() {
        this.window.addObject(this.preview.getObject().object, new CoordinateSystem(new Vec3(this.theCurveInfo.coords.getOrigin()), Vec3.vz(), Vec3.vy()), "Lathed Object " + counter++, null);
        this.window.setSelection(this.window.getScene().getNumObjects() - 1);
        this.window.setUndoRecord(new UndoRecord((EditingWindow)this.window, false, 5, new Object[]{new Integer(this.window.getScene().getNumObjects() - 1)}));
        this.window.updateImage();
        this.dispose();
    }

    private void selectDefaults() {
        MeshVertex[] vert = this.theCurve.getVertices();
        if (!this.theCurve.isClosed() && vert[0].r.distance(vert[vert.length - 1].r) > 0.0) {
            this.axisGroup.setSelection((Object)this.endsBox);
            return;
        }
        this.endsBox.setEnabled(false);
        double minx = Double.MAX_VALUE;
        for (int i = 0; i < vert.length; ++i) {
            if (!(vert[i].r.x < minx)) continue;
            minx = vert[i].r.x;
        }
        minx = Math.max(-minx, 0.0);
        this.radiusField.setValue(Math.ceil(minx));
    }

    private void makeObject() {
        int i;
        int i2;
        Vec3 radius;
        Vec3 axis;
        MeshVertex[] vert = this.theCurve.getVertices();
        Vec3 center = new Vec3();
        int segments = (int)this.segmentsField.getValue();
        double angle = this.angleSlider.getValue();
        double angleStep = angle * Math.PI / ((double)segments * 180.0);
        boolean closed = false;
        if (angle == 360.0) {
            closed = true;
        } else {
            ++segments;
        }
        if (this.axisGroup.getSelection() == this.xBox) {
            axis = Vec3.vx();
            radius = Vec3.vy();
        } else if (this.axisGroup.getSelection() == this.yBox) {
            axis = Vec3.vy();
            radius = Vec3.vx();
        } else if (this.axisGroup.getSelection() == this.zBox) {
            axis = Vec3.vz();
            radius = Vec3.vx();
        } else {
            axis = vert[0].r.minus(vert[vert.length - 1].r);
            axis.normalize();
            center.set(vert[0].r);
            radius = new Vec3();
            for (int i3 = 0; i3 < vert.length; ++i3) {
                radius.add(vert[i3].r);
            }
            radius.scale(1.0 / (double)vert.length);
            radius.subtract(center);
            radius.subtract(axis.times(axis.dot(center)));
            radius.normalize();
        }
        center.add(radius.times(-this.radiusField.getValue()));
        Vec3[][] v = new Vec3[segments][vert.length];
        Vec3 cm = new Vec3();
        CoordinateSystem coords = new CoordinateSystem(center, axis, radius);
        for (int i4 = 0; i4 < segments; ++i4) {
            Mat4 m = coords.fromLocal().times(Mat4.zrotation((double)((double)i4 * angleStep))).times(coords.toLocal());
            for (int j = 0; j < vert.length; ++j) {
                v[i4][j] = m.times(vert[j].r);
                cm.add(v[i4][j]);
            }
        }
        float[] usmooth = new float[segments];
        float[] vsmooth = new float[vert.length];
        float[] s = this.theCurve.getSmoothness();
        for (i2 = 0; i2 < segments; ++i2) {
            usmooth[i2] = 1.0f;
        }
        for (i2 = 0; i2 < s.length; ++i2) {
            vsmooth[i2] = s[i2];
        }
        int smoothMethod = this.theCurve.getSmoothingMethod();
        if (smoothMethod == 0) {
            for (i = 0; i < s.length; ++i) {
                vsmooth[i] = 0.0f;
            }
            smoothMethod = 3;
        } else {
            for (i = 0; i < s.length; ++i) {
                vsmooth[i] = s[i];
            }
        }
        cm.scale(1.0 / (double)(segments * vert.length));
        for (i = 0; i < v.length; ++i) {
            for (int j = 0; j < v[i].length; ++j) {
                v[i][j].subtract(cm);
            }
        }
        SplineMesh mesh = new SplineMesh(v, usmooth, vsmooth, smoothMethod, closed, this.theCurve.isClosed());
        Texture tex = this.window.getScene().getDefaultTexture();
        mesh.setTexture(tex, tex.getDefaultMapping());
        mesh.makeRightSideOut();
        this.preview.setObject((Object3D)mesh);
        this.preview.updateImage();
        this.preview.repaint();
    }
}

