/* Copyright (C) 2001-2004 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY 
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion.tools;

import artofillusion.*;
import artofillusion.object.*;
import artofillusion.ui.*;
import buoy.widget.*;
import java.util.*;

/** The lathe tool creates new objects by rotating a curve around an axis. */

public class LatheTool implements ModellingTool
{
  public LatheTool()
  {
  }
  
  /* Get the text that appear as the menu item.*/

  public String getName()
  {
    return Translate.text("menu.lathe");
  }

  /* See whether an appropriate object is selected and either display an error
     message, or bring up the extrude window. */
  
  public void commandSelected(LayoutWindow window)
  {
    Scene scene = window.getScene();
    int selection[] = scene.getSelection();
    
    if (selection.length == 1)
      {
	Object3D obj = scene.getObject(selection[0]).object;
	if (obj instanceof Curve)
	  {
	    new LatheDialog(window, scene.getObject(selection[0]));
	    return;
	  }
      }
    new BStandardDialog("", "You must select a single curve to lathe.", BStandardDialog.INFORMATION).showMessageDialog(window.getFrame());
  }
}