/* Copyright (C) 2002 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY 
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion.ui;

import buoy.widget.*;

/** This interface represents an object which creates single items of a menu.
 
   @author Michael Butscher
 */

public interface MenuItemFactory
{
  
  /** Creates a MenuWidget which is either a normal MenuItem,
    a CheckboxMenuItem or a whole submenu, depending on
    name and other circumstances.
    A appropriate listener is registered for this MenuItem automatically.
    
    @param menudesc Description of the item to create.
   
    @return The menu item or null if creation is not allowed.
  */

  public MenuWidget createMenuItem(MenuDescription menudesc);

}