
/* Copyright (C) 1999,2000,2002 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion.ui;

import artofillusion.*;
import buoy.event.*;
import buoy.widget.*;
import java.awt.event.KeyEvent;
import java.util.*;
import java.io.*;

/* A MenuEditDialog is a modal dialog to edit menu structure.
 
  @author Michael Butscher.

 */

public class MenuEditDialog extends BDialog
{
//  boolean ok;

  private BComboBox menuChoice;
  private BComboBox filterChoice;
  private BList itemList;
  private BButton transferButton;
  private TreeList treeList;
  private BScrollPane treeListScroller;
  private BTextField itemNameField;

  /** Checkbox if default shortcut should be used. */
  private BCheckBox defShortcutCheck;
  private BTextField shortcutEntry;
  
  /** Parsed content of shortcutEntry. It is only valid if
      defShortcutCheck is not checked. */
  private Shortcut shortcutEntryContent;
  private BLabel shortcutInfo;
  private BButton removeOtherShortcutButton;
  private BButton closeButton;
//  private Button okButton;
//  private Button cancelButton;
  
  private LayoutWindow layoutWindow;
  
  MenuTreeElement rootElement;
  String currentMenuName;
  
  /** Vector of Desc objects. Each element corresponds with one item
    in itemList. */
  Vector itemListDescs;
  
  MenuTreeElement currentTreeEl;
  MenuDescription currentTreeElDesc;

  /** Create a non-modal dialog for editing menus

      @param parent       the parent of the dialog
      @param layoutWindow  the LayoutWindow (can be identical to parent)
  */

  public MenuEditDialog(WindowWidget parent, LayoutWindow layoutWindow)
  {
    super(parent, "Edit Menu", true);
    
    this.layoutWindow = layoutWindow;
    itemListDescs = new Vector();

    java.awt.GridBagConstraints gridBagConstraints;

    menuChoice = new BComboBox(new String[] {
      "MainWindow",
      "TriMesh",
      "SplineMesh"   
    } );
    menuChoice.addEventLink(ValueChangedEvent.class, this, "valueChanged");
    
    filterChoice = new BComboBox();
    itemList = new BList();
    transferButton = new BButton(" ---> ");
    transferButton.setActionCommand("add");
    transferButton.addEventLink(CommandEvent.class, this, "actionPerformed");
    treeList = new TreeList(layoutWindow);
    treeList.setAllowMultiple(false);
    treeList.addEventLink(SelectionChangedEvent.class, this, "selectionChanged");
    treeList.setPreferredSize(new java.awt.Dimension(500, 100));

    treeListScroller = new BScrollPane(BScrollPane.SCROLLBAR_AS_NEEDED,
        BScrollPane.SCROLLBAR_AS_NEEDED);
    treeListScroller.setBackground(java.awt.Color.white);
    treeListScroller.setContent(treeList);
    //treeListScroller.getVAdjustable().setUnitIncrement(10);
    new AutoScroller(treeListScroller, 0, 10);

    itemNameField = new BTextField();
    closeButton = Translate.button("close", this, "actionPerformed");
    //cancelButton = Translate.button("cancel", this);
    
    defShortcutCheck = new BCheckBox(Translate.text("defaultShortcutEntry"), false);
    defShortcutCheck.addEventLink(ValueChangedEvent.class, this, "valueChanged");
    
    shortcutEntry = new BTextField();
    shortcutEntry.addEventLink(KeyPressedEvent.class, this, "keyPressed");
    shortcutInfo = new BLabel();
    removeOtherShortcutButton = Translate.button("removeOtherShortcut", this,
        "actionPerformed");   
    
 //   FormContainer content = new FormContainer(4, 7,);
//    FormContainer content = new FormContainer(
//        new double[] {.5, .5, 1.0, 2.0}, 
//        new double[] {1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0});
    FormContainer content = new FormContainer(
        new double[] {0.0, 0.0, 0.0, 0.0}, 
        new double[] {0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0});
        
    content.setDefaultLayout(new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH));
    
    content.add(menuChoice, 0, 0, 3, 1);
//    content.add(menuChoice, 0, 0, 1, 1);
    content.add(filterChoice, 0, 1);
    content.add(new BScrollPane(itemList, BScrollPane.SCROLLBAR_AS_NEEDED,
        BScrollPane.SCROLLBAR_AS_NEEDED), 0, 2, 2, 1);
//    content.add(itemList, 0, 2, 1, 1);
    content.add(transferButton, 2, 2);
    content.add(treeListScroller, 3, 2);
    content.add(new BLabel("Item name:"), 0, 3);  // TODO(MB) Localize
    content.add(itemNameField, 1, 3, 3, 1);
//    content.add(itemNameField, 1, 3, 1, 1);
    content.add(Translate.label("shortcutField"), 0, 4);
    content.add(shortcutEntry, 1, 4, 2, 1);
//    content.add(shortcutEntry, 1, 4, 1, 1);
    content.add(defShortcutCheck, 3, 4);
    content.add(shortcutInfo, 0, 5, 3, 1);
//    content.add(shortcutInfo, 0, 5, 1, 1);
    content.add(removeOtherShortcutButton, 3, 5);
    content.add(closeButton, 1, 6);
    
    setContent(content);
    
    
//    
//    setLayout(new java.awt.GridBagLayout());
//
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridx = 0;
//    gridBagConstraints.gridy = 0;
//    gridBagConstraints.gridwidth = 3;
//    //gridBagConstraints.anchor = gridBagConstraints.NORTHWEST;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    //gridBagConstraints.weightx = 1;
//    //gridBagConstraints.weighty = 1;
//    gridBagConstraints.insets = new Insets(2, 0, 2, 0);
//    add(menuChoice, gridBagConstraints);
//
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridx = 0;
//    gridBagConstraints.gridy = 1;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    //gridBagConstraints.weightx = 1;
//    //gridBagConstraints.weighty = 1;
//    gridBagConstraints.insets = new Insets(2, 0, 5, 0);
//    add(filterChoice, gridBagConstraints);
//
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridx = 0;
//    gridBagConstraints.gridy = 2;
//    gridBagConstraints.gridwidth = 2;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
//    //gridBagConstraints.anchor = gridBagConstraints.NORTHWEST;
//    //gridBagConstraints.ipadx = 50;
//    gridBagConstraints.weightx = 2;
//    gridBagConstraints.weighty = 1;
//    add(itemList, gridBagConstraints);
//
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridx = 2;
//    gridBagConstraints.gridy = 2;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    gridBagConstraints.weightx = 1;  // 5;
//    gridBagConstraints.weighty = 1;
//    add(transferButton, gridBagConstraints);
//
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridx = 3;
//    gridBagConstraints.gridy = 2;
//    //gridBagConstraints.gridheight = 6;
//    //gridBagConstraints.anchor = gridBagConstraints.NORTHEAST;
//    gridBagConstraints.fill = GridBagConstraints.BOTH;
//    gridBagConstraints.weightx = 2;
//    gridBagConstraints.weighty = 1;
//    add(treeListScroller, gridBagConstraints);
//
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridx = 0;
//    gridBagConstraints.gridy = 3;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
//    //gridBagConstraints.weightx = 19;
//    //gridBagConstraints.weighty = 1;
//    add(new java.awt.Label("Item name:"), gridBagConstraints);  // TODO(MB) Localize
//
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridy = 3;
//    gridBagConstraints.gridwidth = 3;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    //gridBagConstraints.weightx = 1;
//    //gridBagConstraints.weighty = 1;
//    add(itemNameField, gridBagConstraints);
//
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridx = 0;
//    gridBagConstraints.gridy = 4;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
//    //gridBagConstraints.weightx = 19;
//    //gridBagConstraints.weighty = 1;
//    add(Translate.label("shortcutField"), gridBagConstraints);
//
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridy = 4;
//    gridBagConstraints.gridwidth = 2;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    //gridBagConstraints.weightx = 1;
//    //gridBagConstraints.weighty = 1;
//    add(shortcutEntry, gridBagConstraints);
//    
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridy = 4;
//    //gridBagConstraints.gridwidth = 2;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    //gridBagConstraints.weightx = 1;
//    //gridBagConstraints.weighty = 1;
//    add(defShortcutCheck, gridBagConstraints);
//    
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridx = 0;
//    gridBagConstraints.gridy = 5;
//    gridBagConstraints.gridwidth = 3;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    //gridBagConstraints.weightx = 1;
//    //gridBagConstraints.weighty = 1;
//    add(shortcutInfo, gridBagConstraints);
//    
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridy = 5;
//    //gridBagConstraints.gridwidth = 2;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    //gridBagConstraints.weightx = 1;
//    //gridBagConstraints.weighty = 1;
//    add(removeOtherShortcutButton, gridBagConstraints);
//        
//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridx = 1;
//    gridBagConstraints.gridy = 6;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
//    //gridBagConstraints.weightx = 1;
//    //gridBagConstraints.weighty = 1;
//    add(closeButton, gridBagConstraints);

//    gridBagConstraints = new java.awt.GridBagConstraints();
//    gridBagConstraints.gridy = 6;
//    gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
//    gridBagConstraints.insets = new java.awt.Insets(10, 10, 10, 10);
//    //gridBagConstraints.weightx = 1;
//    //gridBagConstraints.weighty = 1;
//    add(cancelButton, gridBagConstraints);

    addEventLink(WindowClosingEvent.class, new Object() {
      public void processEvent(WindowClosingEvent e)
      {
//        ok = false;
        closeWindow();
      }
    } );
    // TODO(MB): Needed?    addAsListener(this);
    pack();
    // TODO(MB): Needed?    setSize(500, 500);
    UIUtilities.centerDialog(this, parent);
    loadMenu("MainWindow");
    setVisible(true);
  }

//  /** Return true if the user clicked OK, false if they clicked Cancel. */
//
//  public boolean clickedOk()
//  {
//    return ok;
//  }
//
//  public Insets getInsets()
//  {
//    Insets in = super.getInsets();
//
//    return new Insets(in.top+10, in.left+10, in.bottom+10, in.right+10);
//  }
//  
  
  /** Create a list of all scripts.
    Internal recursive version.
   
    @see #getScriptList()*/
  
  private static void createScriptList(ArrayList list, File dir)
  {
    String files[] = dir.list();
    if (files == null)
      return;
    for (int i = 0; i < files.length; i++)
      {
        File f = new File(dir, files[i]);
        if (f.isDirectory())
          createScriptList(list, f);
        else if (files[i].endsWith(".bsh") && files[i].length() > 4)
          {
            list.add(new String[]{"beanshell/"+f.getAbsolutePath(),
                files[i].substring(0, files[i].length()-4)});
          }
      }
  }
  
  /** Get a list of all scripts.
    The returned items are string arrays with internal name as
    element 0 and menu label text as element 1.
    */
  
  public static String[][] getScriptList()
  {
    ArrayList list = new ArrayList();
    
    createScriptList(list, new File(ModellingApp.TOOL_SCRIPT_DIRECTORY));
    
    return (String[][])list.toArray(new String[0][]);
  }
  
  /** Fill a unique list of all items in this structure. Internal recursive version.
   */
  // TODO(MB) Faster method?
  protected static Vector fillUniqueList(Object[] itemdescs, Vector list)
  {
    //String s;
    MenuDescription d;
    
    d = (MenuDescription)itemdescs[0];
    if (list.indexOf(d) == -1)
      list.add(d);
    
    for(int i = 1; i < itemdescs.length; ++i)
    {
      if (itemdescs[i] instanceof Object[])
      {
	fillUniqueList((Object[])itemdescs[i], list);
      }
      else if (itemdescs[i] instanceof MenuDescription)
      {
        d = (MenuDescription)itemdescs[i];
        if ( list.indexOf(d) == -1 && !d.internalName.equals("root")
        && !(d.internalName.indexOf('/')>-1) )
          list.add(d);
      }
    }
    return list;
  }

  
  /** Internal helper for recursion. */
  protected MenuTreeElement findOtherShortcut(Shortcut shortcut,
      MenuTreeElement mtel)
  {
    Shortcut shcut = mtel.getItemDescription().getMenuShortcut();
    if (MenuDescription.shortcutEquality(shortcut, shcut))
      return mtel;
    else
    {
      MenuTreeElement result;
      for(int i = 0; i < mtel.getNumChildren(); ++i)
      {
        result = findOtherShortcut(shortcut, (MenuTreeElement)mtel.getChild(i));
        if (result != null && result != currentTreeEl)
          return result;
      }
      
      return null;
    }
  }
  
  /** Returns the first menu tree element where the menu shortcut of 
    the MenuDescription (default or custom)
    is identical to shortcut (if != currentTreeEl) or null if not found.*/
  public MenuTreeElement findOtherShortcut(Shortcut shortcut)
  {
    return findOtherShortcut(shortcut, rootElement);
  }
  
  /** Loads appropriate data for a particular menu and fills it into the
    components of the dialog
  */
  public void loadMenu(String menuname)
  {
    int i;
    
    currentMenuName = menuname;

    // From the default list get all possible menu items
    
    Object[] structdata = new MenuStructure(menuname, true).getData();
    
    itemListDescs.removeAllElements();
    itemListDescs = fillUniqueList(structdata, new Vector());
    
    
    if (menuname.equals("MainWindow"))
    {  // Add Tools and Scripts
      
      // Add Modelling Tools
      ModellingTool tools[] = ModellingApp.getModellingTools();
      MenuDescription menudesc;
      
      for(i = 0; i < tools.length; ++i)
      {
        menudesc = new MenuDescription();
        menudesc.internalName = "modellingTool/"+tools[i].getClass().getName();
        menudesc.labelText = tools[i].getName();
        menudesc.menu = false;
        itemListDescs.add(menudesc);
      }
      
      // Add Scripts
      String[][] scripts = getScriptList();
      for(i = 0; i < scripts.length; ++i)
      {
        menudesc = new MenuDescription();
        menudesc.internalName = scripts[i][0];
        menudesc.labelText = scripts[i][1];
        menudesc.menu = false;
        itemListDescs.add(menudesc);
      }
      
      // Imports      
      Translator trans[] = ModellingApp.getTranslators();

      for (i = 0; i < trans.length; i++)
        if (trans[i].canImport())
        {
          menudesc = new MenuDescription();
          menudesc.internalName = "import/"+trans[i].getClass().getName();
          menudesc.menu = false;
          itemListDescs.add(menudesc);
        }

      // Exports
      for (i = 0; i < trans.length; i++)
        if (trans[i].canExport())
        {
          menudesc = new MenuDescription();
          menudesc.internalName = "export/"+trans[i].getClass().getName();
          menudesc.menu = false;
          itemListDescs.add(menudesc);
        }
    }
    
    itemList.removeAll();
    for(i = 0; i < itemListDescs.size(); ++i)
      itemList.add(((MenuDescription)itemListDescs.get(i)).getPresentableString());


    // Get (possibly customized) structure and build up tree of MenuTreeItem's
    MenuStructure structure = new MenuStructure(menuname, false);
    rootElement = structure.createTreeElements(treeList);
    rootElement.setAsRoot();
    rootElement.setExpanded(true);

    treeList.removeAllElements();
    treeList.addElement(rootElement);
  }

  public void saveMenu()
  {
    if (rootElement == null)
      return;
    MenuStructure struct = new MenuStructure();
    struct.buildFromMenuTree(rootElement);
    struct.saveStructure(currentMenuName);
    
    rootElement = null;
  }
  
  /** Update state of shortcutInfo and removeOtherShortcutButton.*/
  public void updateComponents()
  {
    // TODO(MB) Localize
    
//    // A custom shortcut can be entered iff default shortcut is unchecked
//    shortcutEntry.setEnabled(!defShortcutCheck.getState());
    
    // Text for shortcutInfo label
    String shinfo = "";
    
    // Should the 'Remove other shortcut' button be enabled?
    boolean enableRemoveShortcutButton = false;
    
    if (currentTreeElDesc != null)
    {
      if (defShortcutCheck.getState())
      {  // default shortcut -> tell what it is
        
        shinfo = "Default shortcut: ";
        Shortcut defshcut = currentTreeElDesc.getDefaultMenuShortcut();
        if (defshcut == null)
          shinfo = shinfo + "None";
        else
        {
          // Check if default shortcut already in use
          MenuTreeElement mtel = findOtherShortcut(defshcut);
          if (mtel != null)
          {
            shinfo = MenuDescription.getShortcutDescription(defshcut) + " already used by: "+
                mtel.getItemDescription().getPresentableString();
            enableRemoveShortcutButton = true;
          }
          else
            shinfo = shinfo + MenuDescription.getShortcutDescription(defshcut);
        }
      }
      else
      {
        if (shortcutEntryContent != null)
        {  // custom shortcut -> check if it is used for other menu item already
          MenuTreeElement mtel = findOtherShortcut(shortcutEntryContent);
          if (mtel != null)
          {
            shinfo = "Shortcut already used by: "+
                mtel.getItemDescription().getPresentableString();
            enableRemoveShortcutButton = true;
          }
        }
      }
    }

    shortcutInfo.setText(shinfo);
    removeOtherShortcutButton.setEnabled(enableRemoveShortcutButton);
  }
 
  
  /** Transfer the label entered in itemNameField into the data of the current
    tree element. */
  public void transferToCurrentTreeEl()
  {
    if (currentTreeEl == null)
      return;

    currentTreeElDesc.useDefaultShortcut = defShortcutCheck.getState();
    if (!currentTreeElDesc.useDefaultShortcut)
      currentTreeElDesc.shortcut = shortcutEntryContent;

    if ("".equals(itemNameField.getText()))
      currentTreeElDesc.labelText = null;
    else
      currentTreeElDesc.labelText = itemNameField.getText();
        
    currentTreeEl.rereadLabel();
    treeList.updateTree();
    currentTreeEl = null;
    currentTreeElDesc = null;
    // shortcutEntryContent = null;  //?  
  }
      
    
  public void actionPerformed(CommandEvent e)
  {
    String command = e.getActionCommand();

//    if (command.equals("cancel"))
//    {
//      ok = false;
//      closeWindow();
//    }
    if (command.equals("close"))
    {
//      ok = true;
      closeWindow();
    }
    else if (command.equals("add"))
    {
      int idx = itemList.getSelectedIndex();
      MenuDescription d = (MenuDescription)itemListDescs.get(idx);
      if (d.menu)
      {
        rootElement.addChild(new MenuTreeElement(d,
            treeList, new MenuTreeElement[0]), 0);
        treeList.updateTree();
      }
      else
      {
        rootElement.addChild(new MenuTreeElement(d,
            treeList, null), 0);
        treeList.updateTree();
      }
    }
    else if (command.equals("removeOtherShortcut"))
    {
      MenuTreeElement mtel; // Remove the currently entered shortcut anywhere else
      Shortcut tofind;
      
      if (defShortcutCheck.getState())
        tofind = currentTreeElDesc.getDefaultMenuShortcut();
      else
        tofind = shortcutEntryContent;
      
      while ((mtel = findOtherShortcut(tofind)) != null)
      {
        mtel.getItemDescription().shortcut = null;
        mtel.getItemDescription().useDefaultShortcut = false;
      }
      updateComponents();
    }
  }
  
  /** Called when selection of the tree list changes. */
  
  public void selectionChanged(SelectionChangedEvent e)
  {
    if (e.getSource() == treeList)
    {
      transferToCurrentTreeEl();
      TreeElement[] selected = treeList.getSelectedElements();
      if (selected.length == 1)
      {
        currentTreeEl = (MenuTreeElement) selected[0];
        currentTreeElDesc = currentTreeEl.getItemDescription();
        
        defShortcutCheck.setState(currentTreeElDesc.useDefaultShortcut);
        if (!currentTreeElDesc.useDefaultShortcut)
        {
          shortcutEntryContent = currentTreeElDesc.shortcut;
          if (shortcutEntryContent != null)
            shortcutEntry.setText(MenuDescription.getShortcutDescription(shortcutEntryContent));
          else
            shortcutEntry.setText("");
        }
        else
        {
          shortcutEntryContent = null;
          shortcutEntry.setText("");
        }
        itemNameField.setText(currentTreeElDesc.labelText);
        updateComponents();
      }
    }
  }
  
  public void valueChanged(ValueChangedEvent e)
  {
    if (e.getSource() == defShortcutCheck)
    {
      if (defShortcutCheck.getState())
      {
        shortcutEntryContent = null;
        shortcutEntry.setText("");
      }
      updateComponents();
    }
    else if (e.getSource() == menuChoice)
    {
      transferToCurrentTreeEl();
      saveMenu();
      loadMenu((String)menuChoice.getSelectedValue());
    }
  }

  private void closeWindow()
  {
    transferToCurrentTreeEl();
    
//    if (ok)
    saveMenu();
      
    dispose();
    // removeAsListener(this);   TODO(MB) Needed?
  }

  
  /* Pressing Return and Escape are equivalent to clicking OK and Cancel. */

  public void keyPressed(KeyPressedEvent ev)
  {
    int code = ev.getKeyCode();

    if ( (code == KeyEvent.VK_BACK_SPACE || code == KeyEvent.VK_DELETE) &&
         ev.getSource() == treeList)
    {
      Object[] todelete = treeList.getSelectedObjects();
      TreeElement[] els = treeList.getSelectedElements();

      for(int i = 0; i < todelete.length; ++i)
        if (((MenuTreeElement)els[i]).isDeletable())
          treeList.removeObject(todelete[i]);
        
      return;
    }
    else if (code == KeyEvent.VK_ENTER && ev.getSource() instanceof BButton)
      return;
    else if (ev.getSource() == shortcutEntry)
    {
      if (ev.isControlDown())
      {
        int shmod = Shortcut.DEFAULT_MASK | Shortcut.CTRL_MASK;
        if (ev.isShiftDown())
          shmod |= Shortcut.SHIFT_MASK;
        
        shortcutEntryContent = new Shortcut(code, shmod);
        shortcutEntry.setText(MenuDescription.getShortcutDescription(shortcutEntryContent));
        defShortcutCheck.setState(false);
      }
      else
      {
        if (code == KeyEvent.VK_BACK_SPACE || code == KeyEvent.VK_DELETE)
        {
          shortcutEntryContent = null;
          shortcutEntry.setText("");
        }
        else if (code == KeyEvent.VK_TAB)
          shortcutEntry.getComponent().transferFocus();
      }
      ev.consume();
      updateComponents();
    }
    else if (code == KeyEvent.VK_ENTER || code == KeyEvent.VK_ESCAPE)
    {
//      ok = (code == KeyEvent.VK_ENTER);
      closeWindow();
      return;
    }  
  }


  // TODO(MB) Factor out

//  /** Add this as a key listener to every component. */
//
//  private void addAsListener(Component c)
//  {
//    c.addKeyListener(this);
//    if (c instanceof Container)
//      {
//	Component children[] = ((Container) c).getComponents();
//	for (int i = 0; i < children.length; i++)
//	  addAsListener(children[i]);
//      }
//  }
//
//  /** Remove this as a key listener before returning. */
//
//  private void removeAsListener(Component c)
//  {
//    c.removeKeyListener(this);
//    if (c instanceof Container)
//      {
//	Component children[] = ((Container) c).getComponents();
//	for (int i = 0; i < children.length; i++)
//	  removeAsListener(children[i]);
//      }
//  }
}
