/* This is a canvas which loads an image and displays it. */

/* Copyright (C) 2002 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY 
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion.ui;

import java.awt.*;
import java.awt.image.*;

public class ImageCanvas extends Component
{
  Image im;
  
  /** This constructor takes the name of the image and loads it from the jar file. */
  
  public ImageCanvas(String name)
  {
    ImageProducer ip;
    
    try
      {
        ip = (ImageProducer) getClass().getResource(name).getContent();
      }
    catch (Exception e)
      {
	System.out.println("Error loading image: "+name);
	return;
      }
    im = createImage(ip);
    MediaTracker mt = new MediaTracker(this);
    mt.addImage(im, 0);
    try
      {
	mt.waitForID(0);
      }
    catch (InterruptedException ex)
      {
	System.out.println("Error loading image: "+name);
      }
  }
  
  /** Draw the image. */
  
  public void paint(Graphics g)
  {
    if (im != null)
      g.drawImage(im, 0, 0, null);
  }
  
  public Dimension getPreferredSize()
  {
    if (im == null)
      return new Dimension(0, 0);
    return new Dimension(im.getWidth(null), im.getHeight(null));
  }
}