/* This is a panel which draws a border around its contents. */

/* Copyright (C) 2002 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY 
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion.ui;

import java.awt.*;

public class BorderPanel extends Panel
{
  public BorderPanel()
  {
    super();
  }

  /** Inset the contents by one pixel. */
  
  public Insets getInsets()
  {
    return new Insets(1, 1, 1, 1);
  }
  
  /** Draw the border. */
  
  public void paint(Graphics g)
  {
    Dimension dim = getSize();
    g.drawRect(0, 0, dim.width-1, dim.height-1);
  }
}