/* UniformTriangle is a subclass of RenderingTriangle, which represents a triangle whose
   properties are uniform over the entire triangle. */

/* Copyright (C) 1999-2002 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY 
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion.texture;

import artofillusion.*;
import artofillusion.math.*;

public class UniformTriangle extends RenderingTriangle
{
  public UniformTriangle(int v1, int v2, int v3, int n1, int n2, int n3)
  {
    super(v1, v2, v3, n1, n2, n3);
  }

  public void getTextureSpec(TextureSpec spec, double angle, double u, double v, double w, double size, double t)
  {
    if (!theMesh.mapping.appliesToFace(angle > 0.0))
      {
        spec.diffuse.setRGB(0.0f, 0.0f, 0.0f);
        spec.specular.setRGB(0.0f, 0.0f, 0.0f);
        spec.transparent.setRGB(1.0f, 1.0f, 1.0f);
        spec.emissive.setRGB(0.0f, 0.0f, 0.0f);
        spec.roughness = spec.cloudiness = 0.0;
        spec.bumpGrad.set(0.0, 0.0, 0.0);
        return;
      }
    ((UniformTexture) theMesh.mapping.getTexture()).getTextureSpec(spec);
  }

  public  void getTransparency(RGBColor trans, double angle, double u, double v, double w, double size, double t)
  {
    if (!theMesh.mapping.appliesToFace(angle > 0.0))
      {
        trans.setRGB(1.0f, 1.0f, 1.0f);
        return;
      }
    ((UniformTexture) theMesh.mapping.getTexture()).getTransparency(trans);
  }

  public double getDisplacement(double u, double v, double w, double size, double t)
  {
    return 0.0;
  }
}