///* Copyright (C) 2002 by Peter Eastman
//
//   This program is free software; you can redistribute it and/or modify it under the
//   terms of the GNU General Public License as published by the Free Software
//   Foundation; either version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful, but WITHOUT ANY
//   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
//   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */
//
package artofillusion.texture;

import artofillusion.*;
import artofillusion.object.*;
import artofillusion.ui.*;
import buoy.event.*;
import buoy.widget.*;
//import java.awt.*;


public class UVPinningDialog
{
  public UVPinningDialog(UVMappingWindow window)
  {
    BComboBox distanceModeChoice = new BComboBox();
    BComboBox weightModeChoice = new BComboBox();
    
    distanceModeChoice.add("3D distance");
    distanceModeChoice.add("2D distance");
    if (window.getMesh() instanceof TriangleMesh)
      distanceModeChoice.add("Mesh distance");   // TODO(MB)
    distanceModeChoice.setSelectedIndex(window.pinningDistanceMode);
    
    weightModeChoice.add("Normalized quadratic");
    weightModeChoice.add("Normalized linear");
    weightModeChoice.add("Normalized square root");
    weightModeChoice.setSelectedIndex(window.pinningWeightMode);
    
    ComponentsDialog dlg = new ComponentsDialog(window, "Pinning Options",
      new Widget [] {distanceModeChoice, weightModeChoice},
      new String [] {"Distance Mode", "Weight Mode"});
    if (!dlg.clickedOk())
      return;
      
    window.pinningDistanceMode = distanceModeChoice.getSelectedIndex();
    window.pinningWeightMode = weightModeChoice.getSelectedIndex();
  }
}

//{
//  public UVPinningDialog(UVMappingWindow window)
//  {
//    // TODO Localization
//    Choice distanceModeChoice = new Choice();
//    Choice weightModeChoice = new Choice();
//    
//    distanceModeChoice.add("3D distance");
//    distanceModeChoice.add("2D distance");
//    if (window.getMesh() instanceof TriangleMesh)
//      distanceModeChoice.add("Mesh distance");   // TODO(MB)
//    distanceModeChoice.select(window.pinningDistanceMode);
//    
//    weightModeChoice.add("Normalized quadratic");
//    weightModeChoice.add("Normalized linear");
//    weightModeChoice.add("Normalized square root");
//    weightModeChoice.select(window.pinningWeightMode);
//    
//    ComponentsDialog dlg = new ComponentsDialog(window, "Pinning Options",
//      new Component [] {distanceModeChoice, weightModeChoice},
//      new String [] {"Distance Mode", "Weight Mode"});
//    if (!dlg.clickedOk())
//      return;
//      
//    window.pinningDistanceMode = distanceModeChoice.getSelectedIndex();
//    window.pinningWeightMode = weightModeChoice.getSelectedIndex();
//  }
//}
