/* Copyright (C) 1999-2003 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion.datahandling;

import java.util.*;

/** for operations on arrays or List like adding, modifying, removing
 *  of items.
 *
 * @author  Michael Butscher
 */
public interface ListOperation
{
//  /** Returns an array of the same type as parameter array
//    really has but of length len.
//    <P>
//    Example: int[] newint = (int[]) AbstractListOperation.createArrayOfType(new int[8], 10);
//  */
//  public static Object[] createArrayOfType(Object[] array, int len)
//  {
//    Class cmpclass = array.getClass().getComponentType();
//    return (Object[]) Array.newInstance(cmpclass, len);
//  }
  
  
  /** Changes data according to the type of subclass of AbstractListOperation
    and possibly additional data. This is the only method which must be
    overridden.
  */
  public abstract void applyInplace(List data);
  
  
  /** Apply specified list operation to arr. The returned array type
    can be casted to the same type the parameter array had.
    The returned array may be identical to the parameter array if length
    is not changed during operation. Returns null if array is null.
  */
    
  public Object[] apply(Object[] array);
  
  
  /** Specialized version for boolean arrays.
    
    @see #apply(Object[])
  */
  
  public boolean[] apply(boolean[] array);
  
  
  /** Specialized version for int arrays.    
    @see #apply(Object[])
  */
  
  public int[] apply(int[] array);
  
  
  /** Specialized version for float arrays.    

   @see #apply(Object[])
  */
  
  public float[] apply(float[] array);
  
  
  /** Specialized version for double arrays.    

   @see #apply(Object[])
  */
  
  public double[] apply(double[] array);
}
