/* Copyright (C) 1999-2003 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion.datahandling;

import java.lang.reflect.*;
import java.util.*;


// TODO(MB) add methods for other types

/** Operation on array or List for appending all elements which were
 *  previously added with one of the add methods.
 *
 * @author  Michael Butscher
 */
public class AppendItemsListOp extends AbstractInplaceListOperation
{
  ArrayList list;
  
  public AppendItemsListOp()
  {
    list = new ArrayList();
  }
  
  /** Constructor
   
    @param initialcapacity Initial capacity of internal list
   */
  
  public AppendItemsListOp(int initialCapacity)
  {
    list = new ArrayList(initialCapacity);
  }
  
  /** Changes data as described.
  */
  public void applyInplace(List data)
  {
    data.addAll(list);
  }
  
  /** Add an element to the internal list. This list is appended when
    apply is called.
   */
  public void add(Object o)
  {
    list.add(o);
  }
  
  /** Add an element to the internal list. This list is appended when
    apply is called.
   */
  public void add(int n)
  {
    list.add(new Integer(n));
  }
  
  /** Return number of items which will be added on apply operation. */
  public int getAddSize()
  {
    return list.size();
  }

}
