/* Copyright (C) 1999-2003 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion.datahandling;

import java.lang.reflect.*;
import java.util.*;


/** Operation on array or List for appending a default item multiple
 *  times
 *
 * @author  Michael Butscher
 */
public class AppendDefaultItemListOp extends AbstractInplaceListOperation
{
  Object item;
  int len;
  
  /** Constructor
   
    @param defaultitem Object to add to the list
    @param times how often to add
   */
  
  public AppendDefaultItemListOp(Object defaultitem, int times)
  {
    item = defaultitem;
    len = times;
  }
  
  /** Constructor
   
    @param defaultitem value to add to the list
    @param times how often to add
   */
  
  public AppendDefaultItemListOp(double defaultitem, int times)
  {
    this(new Double(defaultitem), times);
  }

  /** Changes data as described.
  */
  public void applyInplace(List data)
  {
    for(int i = 0; i < len; ++i)
      data.add(item);
  }
}
