/* Copyright (C) 1999-2003 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion;

import artofillusion.math.*;
import artofillusion.object.*;
import artofillusion.texture.*;

/** Provides all necessary information for a renderer to render a scene.
  (Environment and fog settings and read access to the contained objects
  of the scene)
  Allows better decoupling of render plugins and main program.
  
  @author Michael Butscher
 */
 
 
public interface SceneRenderInfoProvider
{
  public static final int ENVIRON_SOLID = 0;
  public static final int ENVIRON_DIFFUSE = 1;
  public static final int ENVIRON_EMISSIVE = 2;
  public static final int ENVIRON_UNDEFINED = 256; // Needed for SceneSubset

  /** Get the current time. */

  public double getTime();

  /** Get the scene's ambient light color. */

  public RGBColor getAmbientColor();

  /** Get the Scene's environment mapping mode.  This will be either ENVIRON_SOLID, ENVIRON_DIFFUSE, or
      ENVIRON_EMISSIVE. */

  public int getEnvironmentMode();
  
  /** Get the texture being used as an environment mapping. */

  public Texture getEnvironmentTexture();

  /** Get the TextureMapping being used to map the environment map texture to the environment sphere. */

  public TextureMapping getEnvironmentMapping();
  
  /** Get the parameter values used for the environment map. */
  
  public ParameterValue [] getEnvironmentParameterValues();

  /** Get the environment color. */

  public RGBColor getEnvironmentColor();
  
  /** Get the fog color. */

  public RGBColor getFogColor();

  /** Determine whether fog is enabled. */

  public boolean getFogState();

  /** Get the length constant for exponential fog. */

  public double getFogDistance();

  /** Get the number of objects in this scene. */

  public int getNumObjects();

  /** Get the i'th object. */

  public ObjectInfo getObject(int i);

}