/* Copyright (C) 1999-2003 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion;

import artofillusion.math.*;
import artofillusion.object.*;
import artofillusion.texture.*;

/** Allows read and write access to the environment ata of a scene.
  Needed by {@link LayoutWindow#changeEnvironmentByDialog}.
 
  @author Michael Butscher
*/


public interface SceneEnvironmentData
{
  /** Get the scene's ambient light color. */

  public RGBColor getAmbientColor();

  /** Get the Scene's environment mapping mode.  This will be either ENVIRON_SOLID, ENVIRON_DIFFUSE, or
      ENVIRON_EMISSIVE. */

  public int getEnvironmentMode();
  
  /** Get the texture being used as an environment mapping. */

  public Texture getEnvironmentTexture();

  /** Get the TextureMapping being used to map the environment map texture to the environment sphere. */

  public TextureMapping getEnvironmentMapping();

  /** Get the parameter values used for the environment map. */
  
  public ParameterValue [] getEnvironmentParameterValues();
  
  /** Get the environment color. */

  public RGBColor getEnvironmentColor();
  
  /** Get the fog color. */

  public RGBColor getFogColor();

  /** Determine whether fog is enabled. */

  public boolean getFogState();

  /** Get the length constant for exponential fog. */

  public double getFogDistance();
  
  /** Set the scene's ambient light color. If parameter is null, the value of
    the underlying SceneInfoProvider is used. */

  public void setAmbientColor(RGBColor ac);

  /** Set the Scene's environment mapping mode.  This will be either ENVIRON_SOLID, ENVIRON_DIFFUSE, or
    ENVIRON_EMISSIVE or ENVIRON_UNDEFINED. If ENVIRON_UNDEFINED is used,
    the value of the underlying SceneInfoProvider is used. */

  public void setEnvironmentMode(int em);
  
  /** Set the texture being used as an environment mapping. If parameter is
    null, the value of the underlying SceneInfoProvider is used. */

  public void setEnvironmentTexture(Texture et);

  /** Set the TextureMapping being used to map the environment map texture to
    the environment sphere. If parameter is null, the value of the underlying
    SceneInfoProvider is used.*/

  public void setEnvironmentMapping(TextureMapping em);

  /** Set the parameter values used for the environment map. */
  
  public void setEnvironmentParameterValues(ParameterValue value[]);

  /** Get the environment color. If parameter is null, the value of the
    underlying SceneInfoProvider is used.*/

  public void setEnvironmentColor(RGBColor ec);
  
  /** Get the fog color. If parameter is null, the value of the underlying
    SceneInfoProvider is used.*/

  public void setFogColor(RGBColor fc);

  /** Set fog . If fog color is null, the value of the
   underlying SceneInfoProvider is used for the getter.*/

  public void setFog(boolean fs, double fd);

//  /** Set the length constant for exponential fog. If fog color is null, the
//   value of the underlying SceneInfoProvider is used for the getter.*/
//
//  public void setFogDistance(double fd);


}

