/* Copyright (C) 2002-2004 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */

package artofillusion;

import artofillusion.ui.*;
import buoy.widget.*;
import java.util.*;

/** This is the window for editing application-wide preferences. */

public class PreferencesWindow
{
  public PreferencesWindow(BFrame parent)
  {
    ApplicationPreferences prefs = ModellingApp.getPreferences();
    BComboBox defaultRendChoice = getRendererChoice(prefs.getDefaultRenderer());
    BComboBox objectRendChoice = getRendererChoice(prefs.getObjectPreviewRenderer());
    BComboBox texRendChoice = getRendererChoice(prefs.getTexturePreviewRenderer());
    BComboBox liveRendChoice = getRendererChoice(prefs.getLiveRenderer());
    ValueField interactiveTolField = new ValueField(prefs.getInteractiveSurfaceError(), ValueField.POSITIVE);
    ValueField undoField = new ValueField(prefs.getUndoLevels(), ValueField.POSITIVE+ValueField.INTEGER);
    BCheckBox objectSceneAutosyncCheckbox = new BCheckBox("", prefs.getObjectSceneAutosync());

    BComboBox displayChoice = new BComboBox(new String [] {
      Translate.text("menu.wireframeDisplay"),
      Translate.text("menu.shadedDisplay"),
      Translate.text("menu.smoothDisplay"),
      Translate.text("menu.texturedDisplay")
    });
    displayChoice.setSelectedIndex(prefs.getDefaultDisplayMode());
    BComboBox localeChoice = new BComboBox();
    Locale languages[] = Translate.getAvailableLocales();
    for (int i = 0; i < languages.length; i++)
    {
      localeChoice.add(languages[i].getDisplayName(prefs.getLocale()));
      if (prefs.getLocale().equals(languages[i]))
        localeChoice.setSelectedIndex(i);
    }
    boolean done = false;
    while (!done)
    {
      ComponentsDialog dlg = new ComponentsDialog(parent, Translate.text("prefsTitle"),
        new Widget [] {defaultRendChoice, objectRendChoice, texRendChoice, liveRendChoice,
        displayChoice, interactiveTolField, undoField, localeChoice, objectSceneAutosyncCheckbox},
        new String [] {Translate.text("defaultRenderer"),
        Translate.text("objPreviewRenderer"), Translate.text("texPreviewRenderer"),
        Translate.text("liveRenderer"), Translate.text("defaultDisplayMode"),
        Translate.text("interactiveSurfError"), Translate.text("maxUndoLevels"),
        Translate.text("language"),
        "Sync object editors with scene"});   // TODO(MB) Localize
      if (!dlg.clickedOk())
        return;
      done = true;
      if (interactiveTolField.getValue() < 0.01)
      {
        String options[] = new String [] {Translate.text("button.ok"), Translate.text("button.cancel")};
        int choice = new BStandardDialog("", Translate.text("lowSurfErrorWarning"), BStandardDialog.WARNING).showOptionDialog(parent, options, options[0]);
        if (choice == 1)
          done = false;
      }
    }
    Renderer renderers[] = ModellingApp.getRenderers();
    if (renderers.length > 0)
    {
      prefs.setDefaultRenderer(renderers[defaultRendChoice.getSelectedIndex()]);
      prefs.setObjectPreviewRenderer(renderers[objectRendChoice.getSelectedIndex()]);
      prefs.setTexturePreviewRenderer(renderers[texRendChoice.getSelectedIndex()]);
      prefs.setLiveRenderer(renderers[liveRendChoice.getSelectedIndex()]);
    }
    prefs.setDefaultDisplayMode(displayChoice.getSelectedIndex());
    prefs.setInteractiveSurfaceError(interactiveTolField.getValue());
    prefs.setUndoLevels((int) undoField.getValue());
    if (!prefs.getLocale().equals(languages[localeChoice.getSelectedIndex()]))
      new BStandardDialog("", UIUtilities.breakString(Translate.text("languageChangedWarning")), BStandardDialog.INFORMATION).showMessageDialog(parent);
    prefs.setLocale(languages[localeChoice.getSelectedIndex()]);
    prefs.setObjectSceneAutosync(objectSceneAutosyncCheckbox.getState());
    prefs.savePreferences();
  }

  /** Create a Choice for selecting a renderer. */

  private BComboBox getRendererChoice(Renderer selected)
  {
    Renderer renderers[] = ModellingApp.getRenderers();
    BComboBox c = new BComboBox();

    for (int i = 0; i < renderers.length; i++)
      c.add(renderers[i].getName());
    if (selected != null)
      c.setSelectedValue(selected.getName());
    return c;
  }
}