/* Copyright (C) 1999-2002 by Peter Eastman

   This program is free software; you can redistribute it and/or modify it under the
   terms of the GNU General Public License as published by the Free Software
   Foundation; either version 2 of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
   PARTICULAR PURPOSE.  See the GNU General Public License for more details. */


package artofillusion;

/** Represents an object which can be (deeply) copied
 *
 * @author  Michael Butscher
 */
public interface Copieable
{
  /** Make this object equal to another object c of the same type.
  */
  public void makeEqual(Copieable c);

  /** Create a copy of this object and return it. */
  public Copieable createCopy();

}
