/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.EventSource;
import buoy.event.ToolTipEvent;
import buoy.event.WidgetMouseEvent;
import buoy.internal.EventLinkAdapter;
import buoy.internal.ToolTipMonitor;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetDecoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.lang.reflect.Method;

public abstract class Widget
extends EventSource {
    protected Component component;
    private WidgetContainer parent;
    private boolean wantsToolTipEvents;

    protected Widget() {
    }

    public Component getComponent() {
        return this.component;
    }

    public WidgetContainer getParent() {
        return this.parent;
    }

    protected void setParent(WidgetContainer container) {
        this.parent = container;
    }

    protected void invalidateSize() {
        if (this.parent != null) {
            this.parent.invalidateSize();
        }
    }

    public Dimension getMinimumSize() {
        Dimension min = this.component.getMinimumSize().getSize();
        Dimension pref = this.component.getPreferredSize();
        if (min.width > pref.width) {
            min.width = pref.width;
        }
        if (min.height > pref.height) {
            min.height = pref.height;
        }
        return min;
    }

    public Dimension getMaximumSize() {
        Dimension max = this.component.getMaximumSize().getSize();
        Dimension pref = this.component.getPreferredSize();
        if (max.width < pref.width) {
            max.width = pref.width;
        }
        if (max.height < pref.height) {
            max.height = pref.height;
        }
        return max;
    }

    public Dimension getPreferredSize() {
        return this.component.getPreferredSize();
    }

    public Rectangle getBounds() {
        return this.component.getBounds();
    }

    public void repaint() {
        this.component.repaint();
    }

    public boolean isVisible() {
        return this.component.isVisible();
    }

    public void setVisible(boolean visible) {
        this.component.setVisible(visible);
        this.invalidateSize();
    }

    public boolean isEnabled() {
        return this.component.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.component.setEnabled(enabled);
    }

    public Cursor getCursor() {
        return this.component.getCursor();
    }

    public void setCursor(Cursor cursor) {
        this.component.setCursor(cursor);
    }

    public Color getBackground() {
        return this.component.getBackground();
    }

    public void setBackground(Color background) {
        this.component.setBackground(background);
    }

    public Font getFont() {
        return this.component.getFont();
    }

    public void setFont(Font font) {
        this.component.setFont(font);
        this.invalidateSize();
    }

    public boolean hasFocus() {
        return this.component.hasFocus();
    }

    public void requestFocus() {
        this.component.requestFocus();
    }

    public boolean isFocusable() {
        return this.component.isFocusable();
    }

    public void setFocusable(boolean focusable) {
        this.component.setFocusable(focusable);
    }

    public String getName() {
        return this.component.getName();
    }

    public void setName(String name) {
        this.component.setName(name);
        if (name != null) {
            WidgetDecoder.registerObject(name, this);
        }
    }

    public void addEventLink(Class eventType, Object target, Method method) {
        super.addEventLink(eventType, target, method);
        if (this.eventAdapter == null) {
            this.eventAdapter = new EventLinkAdapter(this);
        }
        this.eventAdapter.newEventType(eventType);
        if (eventType.isAssignableFrom(ToolTipEvent.class)) {
            this.wantsToolTipEvents = true;
        }
    }

    public void dispatchEvent(Object event) {
        super.dispatchEvent(event);
        if (this.wantsToolTipEvents && event instanceof WidgetMouseEvent) {
            ToolTipMonitor.processMouseEvent((WidgetMouseEvent)event);
        }
    }
}

