/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.GridContainerDelegate;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

public class GridContainer
extends WidgetContainer {
    private Widget[][] child;
    private LayoutInfo defaultLayout;
    private LayoutInfo[][] childLayout;
    private int numRows;
    private int numCols;

    public GridContainer(int cols, int rows) {
        this.component = new WidgetContainerPanel(this);
        this.child = new Widget[cols][rows];
        this.childLayout = new LayoutInfo[cols][rows];
        this.defaultLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.NONE, new Insets(2, 2, 2, 2), null);
        this.numRows = rows;
        this.numCols = cols;
    }

    public int getChildCount() {
        int count = 0;
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                ++count;
            }
        }
        return count;
    }

    public Iterator getChildren() {
        ArrayList<Widget> ls = new ArrayList<Widget>(this.numCols * this.numRows);
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                ls.add(this.child[i][j]);
            }
        }
        return ls.iterator();
    }

    public Widget getChild(int col, int row) {
        return this.child[col][row];
    }

    public void layoutChildren() {
        int i;
        Dimension dim = this.component.getSize();
        int[] cellXBound = new int[this.numCols + 1];
        int[] cellYBound = new int[this.numRows + 1];
        double xsize = dim.width / this.numCols;
        double ysize = dim.height / this.numRows;
        for (i = 1; i < cellXBound.length; ++i) {
            cellXBound[i] = (int)((double)i * xsize);
        }
        for (i = 1; i < cellYBound.length; ++i) {
            cellYBound[i] = (int)((double)i * ysize);
        }
        Rectangle cell = new Rectangle();
        for (int i2 = 0; i2 < this.child.length; ++i2) {
            for (int j = 0; j < this.child[i2].length; ++j) {
                if (this.child[i2][j] == null) continue;
                Widget w = this.child[i2][j];
                LayoutInfo layout = this.childLayout[i2][j];
                if (layout == null) {
                    layout = this.defaultLayout;
                }
                cell.x = cellXBound[i2];
                cell.y = cellYBound[j];
                cell.width = cellXBound[i2 + 1] - cell.x;
                cell.height = cellYBound[j + 1] - cell.y;
                w.getComponent().setBounds(layout.getWidgetLayout(w, cell));
                if (!(w instanceof WidgetContainer)) continue;
                ((WidgetContainer)w).layoutChildren();
            }
        }
    }

    public void add(Widget widget, int col, int row) {
        this.add(widget, col, row, null);
    }

    public void add(Widget widget, int col, int row, LayoutInfo layout) {
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        if (this.child[col][row] != null) {
            this.remove(col, row);
        }
        this.child[col][row] = widget;
        this.childLayout[col][row] = layout;
        ((JPanel)this.component).add(widget.component);
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(int col, int row) {
        return this.childLayout[col][row];
    }

    public void setChildLayout(int col, int row, LayoutInfo layout) {
        this.childLayout[col][row] = layout;
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] != widget) continue;
                return this.childLayout[i][j];
            }
        }
        return null;
    }

    public void setChildLayout(Widget widget, LayoutInfo layout) {
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] != widget) continue;
                this.childLayout[i][j] = layout;
                return;
            }
        }
        this.invalidateSize();
    }

    public LayoutInfo getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(LayoutInfo layout) {
        this.defaultLayout = layout;
        this.invalidateSize();
    }

    public int getRowCount() {
        return this.numRows;
    }

    public void setRowCount(int rows) {
        if (rows < this.numRows) {
            for (int i = 0; i < this.child.length; ++i) {
                for (int j = rows; j < this.child[i].length; ++j) {
                    if (this.child[i][j] == null) continue;
                    this.remove(i, j);
                }
            }
        }
        Widget[][] newchild = new Widget[this.numCols][rows];
        LayoutInfo[][] newlayout = new LayoutInfo[this.numCols][rows];
        int copy = Math.min(rows, this.numRows);
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < copy; ++j) {
                newchild[i][j] = this.child[i][j];
                newlayout[i][j] = this.childLayout[i][j];
            }
        }
        this.child = newchild;
        this.childLayout = newlayout;
        this.numRows = rows;
        this.invalidateSize();
    }

    public int getColumnCount() {
        return this.numCols;
    }

    public void setColumnCount(int cols) {
        if (cols < this.numCols) {
            for (int i = cols; i < this.child.length; ++i) {
                for (int j = 0; j < this.child[i].length; ++j) {
                    if (this.child[i][j] == null) continue;
                    this.remove(i, j);
                }
            }
        }
        Widget[][] newchild = new Widget[cols][this.numRows];
        LayoutInfo[][] newlayout = new LayoutInfo[cols][this.numRows];
        int copy = Math.min(cols, this.numCols);
        for (int i = 0; i < copy; ++i) {
            newchild[i] = this.child[i];
            newlayout[i] = this.childLayout[i];
        }
        this.child = newchild;
        this.childLayout = newlayout;
        this.numCols = cols;
        this.invalidateSize();
    }

    public void remove(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] != widget) continue;
                ((JPanel)this.component).remove(widget.component);
                this.removeAsParent(widget);
                this.child[i][j] = null;
                this.childLayout[i][j] = null;
                this.invalidateSize();
                return;
            }
        }
    }

    public void remove(int col, int row) {
        ((JPanel)this.component).remove(this.child[col][row].component);
        this.removeAsParent(this.child[col][row]);
        this.child[col][row] = null;
        this.childLayout[col][row] = null;
        this.invalidateSize();
    }

    public void removeAll() {
        ((JPanel)this.component).removeAll();
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                this.removeAsParent(this.child[i][j]);
                this.child[i][j] = null;
                this.childLayout[i][j] = null;
            }
        }
        this.invalidateSize();
    }

    public Point getChildCell(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] != widget) continue;
                return new Point(i, j);
            }
        }
        return null;
    }

    public Dimension getMinimumSize() {
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                Dimension dim = this.child[i][j].getMinimumSize();
                if (dim.width > x) {
                    x = dim.width;
                }
                if (dim.height <= y) continue;
                y = dim.height;
            }
        }
        return new Dimension(x * this.numCols, y * this.numRows);
    }

    public Dimension getPreferredSize() {
        int x = 0;
        int y = 0;
        for (int i = 0; i < this.child.length; ++i) {
            for (int j = 0; j < this.child[i].length; ++j) {
                if (this.child[i][j] == null) continue;
                Widget w = this.child[i][j];
                LayoutInfo layout = this.childLayout[i][j];
                if (layout == null) {
                    layout = this.defaultLayout;
                }
                Dimension dim = layout.getPreferredSize(w);
                if (dim.width > x) {
                    x = dim.width;
                }
                if (dim.height <= y) continue;
                y = dim.height;
            }
        }
        return new Dimension(x * this.numCols, y * this.numRows);
    }

    static {
        WidgetEncoder.setPersistenceDelegate(GridContainer.class, new GridContainerDelegate());
    }
}

