/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.FormContainerDelegate;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;

public class FormContainer
extends WidgetContainer {
    private double[] rowWeight;
    private double[] colWeight;
    private int[] minRowSize;
    private int[] prefRowSize;
    private int[] minColSize;
    private int[] prefColSize;
    private ArrayList child;
    private LayoutInfo defaultLayout;

    public FormContainer(double[] colWeight, double[] rowWeight) {
        this.colWeight = colWeight;
        this.rowWeight = rowWeight;
        this.component = new WidgetContainerPanel(this);
        this.child = new ArrayList();
        this.defaultLayout = new LayoutInfo();
    }

    public FormContainer(int numCols, int numRows) {
        this(new double[numCols], new double[numRows]);
        int i;
        for (i = 0; i < this.rowWeight.length; ++i) {
            this.rowWeight[i] = 1.0;
        }
        for (i = 0; i < this.colWeight.length; ++i) {
            this.colWeight[i] = 1.0;
        }
    }

    public int getChildCount() {
        return this.child.size();
    }

    public Widget getChild(int i) {
        return ((ChildInfo)this.child.get((int)i)).widget;
    }

    public Iterator getChildren() {
        ArrayList<Widget> list = new ArrayList<Widget>();
        for (int i = 0; i < this.child.size(); ++i) {
            list.add(((ChildInfo)this.child.get((int)i)).widget);
        }
        return list.iterator();
    }

    public int getRowCount() {
        return this.rowWeight.length;
    }

    public int getColumnCount() {
        return this.colWeight.length;
    }

    public void setRowCount(int rows) {
        double[] newWeight = new double[rows];
        if (rows > this.rowWeight.length) {
            int i;
            for (i = 0; i < this.rowWeight.length; ++i) {
                newWeight[i] = this.rowWeight[i];
            }
            for (i = this.rowWeight.length; i < newWeight.length; ++i) {
                newWeight[i] = 1.0;
            }
        } else {
            int i;
            for (i = this.child.size() - 1; i >= 0; --i) {
                ChildInfo info = (ChildInfo)this.child.get(i);
                if (info.y + info.height <= rows) continue;
                this.remove(i);
            }
            for (i = 0; i < newWeight.length; ++i) {
                newWeight[i] = this.rowWeight[i];
            }
        }
        this.rowWeight = newWeight;
    }

    public void setColumnCount(int columns) {
        double[] newWeight = new double[columns];
        if (columns > this.colWeight.length) {
            int i;
            for (i = 0; i < this.colWeight.length; ++i) {
                newWeight[i] = this.colWeight[i];
            }
            for (i = this.colWeight.length; i < newWeight.length; ++i) {
                newWeight[i] = 1.0;
            }
        } else {
            int i;
            for (i = this.child.size() - 1; i >= 0; --i) {
                ChildInfo info = (ChildInfo)this.child.get(i);
                if (info.x + info.width <= columns) continue;
                this.remove(i);
            }
            for (i = 0; i < newWeight.length; ++i) {
                newWeight[i] = this.colWeight[i];
            }
        }
        this.colWeight = newWeight;
    }

    public double getRowWeight(int row) {
        return this.rowWeight[row];
    }

    public double getColumnWeight(int col) {
        return this.colWeight[col];
    }

    public void setRowWeight(int row, double weight) {
        this.rowWeight[row] = weight;
    }

    public void setColumnWeight(int col, double weight) {
        this.colWeight[col] = weight;
    }

    public void layoutChildren() {
        if (this.minColSize == null) {
            this.calculateSizes();
        }
        Dimension size = this.component.getSize();
        int[] rowPos = this.calculatePositions(this.minRowSize, this.prefRowSize, this.rowWeight, size.height);
        int[] colPos = this.calculatePositions(this.minColSize, this.prefColSize, this.colWeight, size.width);
        Rectangle cell = new Rectangle();
        for (int i = 0; i < this.child.size(); ++i) {
            ChildInfo info = (ChildInfo)this.child.get(i);
            LayoutInfo layout = info.layout == null ? this.defaultLayout : info.layout;
            cell.x = info.x == 0 ? 0 : colPos[info.x - 1];
            cell.y = info.y == 0 ? 0 : rowPos[info.y - 1];
            cell.width = colPos[info.x + info.width - 1] - cell.x;
            cell.height = rowPos[info.y + info.height - 1] - cell.y;
            info.widget.getComponent().setBounds(layout.getWidgetLayout(info.widget, cell));
            if (!(info.widget instanceof WidgetContainer)) continue;
            ((WidgetContainer)info.widget).layoutChildren();
        }
    }

    private int[] calculatePositions(int[] minSize, int[] prefSize, double[] weight, int totalSize) {
        int[] pos = new int[minSize.length];
        int totalMin = 0;
        int totalPref = 0;
        for (int i = 0; i < minSize.length; ++i) {
            totalMin += minSize[i];
            totalPref += prefSize[i];
        }
        if (totalMin > totalSize) {
            int current = 0;
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = current += minSize[i];
            }
        } else if (totalPref > totalSize) {
            double fract = (double)(totalSize - totalMin) / (double)(totalPref - totalMin);
            double current = 0.0;
            for (int i = 0; i < pos.length; ++i) {
                pos[i] = (int)Math.round(current += (double)minSize[i] + fract * (double)(prefSize[i] - minSize[i]));
            }
        } else {
            int i;
            double[] realWeight = new double[weight.length];
            double totalWeight = 0.0;
            for (i = 0; i < weight.length; ++i) {
                totalWeight += weight[i];
            }
            if (totalWeight > 0.0) {
                for (i = 0; i < realWeight.length; ++i) {
                    realWeight[i] = weight[i] / totalWeight;
                }
            }
            double current = 0.0;
            for (int i2 = 0; i2 < pos.length; ++i2) {
                pos[i2] = (int)Math.round(current += (double)prefSize[i2] + realWeight[i2] * (double)(totalSize - totalPref));
            }
        }
        return pos;
    }

    public void add(Widget widget, int col, int row) {
        this.add(widget, col, row, null);
    }

    public void add(Widget widget, int col, int row, LayoutInfo layout) {
        this.add(widget, col, row, 1, 1, layout);
    }

    public void add(Widget widget, int col, int row, int width, int height) {
        this.add(widget, col, row, width, height, null);
    }

    public void add(Widget widget, int col, int row, int width, int height, LayoutInfo layout) {
        if (col < 0 || col + width > this.colWeight.length || row < 0 || row + height > this.rowWeight.length || width < 1 || height < 1) {
            throw new IllegalArgumentException();
        }
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child.add(new ChildInfo(widget, layout, col, row, width, height));
        ((JPanel)this.component).add(widget.component);
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(int index) {
        return ((ChildInfo)this.child.get((int)index)).layout;
    }

    public void setChildLayout(int index, LayoutInfo layout) {
        ((ChildInfo)this.child.get((int)index)).layout = layout;
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Widget widget) {
        int index = this.getWidgetIndex(widget);
        if (index == -1) {
            return null;
        }
        return ((ChildInfo)this.child.get((int)index)).layout;
    }

    public void setChildLayout(Widget widget, LayoutInfo layout) {
        int index = this.getWidgetIndex(widget);
        if (index == -1) {
            return;
        }
        ((ChildInfo)this.child.get((int)index)).layout = layout;
        this.invalidateSize();
    }

    public LayoutInfo getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(LayoutInfo layout) {
        this.defaultLayout = layout;
        this.invalidateSize();
    }

    public Rectangle getChildCells(int index) {
        ChildInfo info = (ChildInfo)this.child.get(index);
        return new Rectangle(info.x, info.y, info.width, info.height);
    }

    public void setChildCells(int index, Rectangle cells) {
        ChildInfo info = (ChildInfo)this.child.get(index);
        info.x = cells.x;
        info.y = cells.y;
        info.width = cells.width;
        info.height = cells.height;
        this.invalidateSize();
    }

    public Rectangle getChildCells(Widget widget) {
        int index = this.getWidgetIndex(widget);
        if (index == -1) {
            return null;
        }
        return this.getChildCells(index);
    }

    public void setChildCells(Widget widget, Rectangle cells) {
        int index = this.getWidgetIndex(widget);
        if (index == -1) {
            return;
        }
        this.setChildCells(index, cells);
    }

    public void remove(Widget widget) {
        int index = this.getWidgetIndex(widget);
        if (index > -1) {
            this.remove(index);
        }
    }

    public void remove(int index) {
        Widget w = ((ChildInfo)this.child.get((int)index)).widget;
        ((JPanel)this.component).remove(w.component);
        this.child.remove(index);
        this.removeAsParent(w);
        this.invalidateSize();
    }

    public void removeAll() {
        ((JPanel)this.component).removeAll();
        for (int i = 0; i < this.child.size(); ++i) {
            this.removeAsParent(((ChildInfo)this.child.get((int)i)).widget);
        }
        this.child.clear();
        this.invalidateSize();
    }

    public int getWidgetIndex(Widget widget) {
        for (int i = 0; i < this.child.size(); ++i) {
            if (((ChildInfo)this.child.get((int)i)).widget != widget) continue;
            return i;
        }
        return -1;
    }

    public Dimension getMinimumSize() {
        int i;
        if (this.minColSize == null) {
            this.calculateSizes();
        }
        Dimension minSize = new Dimension(0, 0);
        for (i = 0; i < this.minColSize.length; ++i) {
            minSize.width += this.minColSize[i];
        }
        for (i = 0; i < this.minRowSize.length; ++i) {
            minSize.height += this.minRowSize[i];
        }
        return minSize;
    }

    public Dimension getPreferredSize() {
        int i;
        if (this.prefColSize == null) {
            this.calculateSizes();
        }
        Dimension prefSize = new Dimension(0, 0);
        for (i = 0; i < this.prefColSize.length; ++i) {
            prefSize.width += this.prefColSize[i];
        }
        for (i = 0; i < this.prefRowSize.length; ++i) {
            prefSize.height += this.prefRowSize[i];
        }
        return prefSize;
    }

    protected void invalidateSize() {
        this.prefColSize = null;
        this.prefRowSize = null;
        this.minColSize = null;
        this.minRowSize = null;
        super.invalidateSize();
    }

    private void calculateSizes() {
        int i;
        Dimension[] dim = new Dimension[this.child.size()];
        for (i = 0; i < dim.length; ++i) {
            dim[i] = ((ChildInfo)this.child.get((int)i)).widget.getMinimumSize();
        }
        this.minRowSize = this.calculateRequiredSizes(dim, true);
        this.minColSize = this.calculateRequiredSizes(dim, false);
        for (i = 0; i < dim.length; ++i) {
            ChildInfo info = (ChildInfo)this.child.get(i);
            LayoutInfo layout = info.layout == null ? this.defaultLayout : info.layout;
            dim[i] = layout.getPreferredSize(info.widget);
        }
        this.prefRowSize = this.calculateRequiredSizes(dim, true);
        this.prefColSize = this.calculateRequiredSizes(dim, false);
    }

    private int[] calculateRequiredSizes(Dimension[] dim, boolean row) {
        LinkedList<int[]> requiredList = new LinkedList<int[]>();
        for (int i = 0; i < dim.length; ++i) {
            ChildInfo info = (ChildInfo)this.child.get(i);
            if (row) {
                requiredList.addLast(new int[]{info.y, info.height, dim[i].height});
                continue;
            }
            requiredList.addLast(new int[]{info.x, info.width, dim[i].width});
        }
        int[] width = new int[row ? this.rowWeight.length : this.colWeight.length];
        double[] weight = row ? this.rowWeight : this.colWeight;
        int currentWidth = 1;
        while (requiredList.size() > 0) {
            Iterator iter = requiredList.iterator();
            while (iter.hasNext()) {
                int i;
                int[] req = (int[])iter.next();
                if (req[1] != currentWidth) continue;
                iter.remove();
                if (currentWidth == 1) {
                    width[req[0]] = Math.max(width[req[0]], req[2]);
                    continue;
                }
                int total = 0;
                for (int i2 = 0; i2 < currentWidth; ++i2) {
                    total += width[req[0] + i2];
                }
                if (total >= req[2]) continue;
                double totalWeight = 0.0;
                for (int i3 = 0; i3 < currentWidth; ++i3) {
                    totalWeight += weight[req[0] + i3];
                }
                int[] extra = new int[currentWidth];
                int totalExtra = 0;
                for (i = 0; i < currentWidth - 1; ++i) {
                    double w = totalWeight > 0.0 ? weight[req[0] + i] / totalWeight : 1.0 / (double)currentWidth;
                    int n = i;
                    extra[n] = (int)((double)extra[n] + w * (double)(req[2] - total));
                    totalExtra += extra[i];
                }
                extra[extra.length - 1] = req[2] - total - totalExtra;
                for (i = 0; i < currentWidth; ++i) {
                    int n = req[0] + i;
                    width[n] = width[n] + extra[i];
                }
            }
            ++currentWidth;
        }
        return width;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(FormContainer.class, new FormContainerDelegate());
    }

    private class ChildInfo {
        public Widget widget;
        public LayoutInfo layout;
        public int x;
        public int y;
        public int width;
        public int height;

        public ChildInfo(Widget widget, LayoutInfo layout, int x, int y, int width, int height) {
            this.widget = widget;
            this.layout = layout;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }
}

