/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.internal.WidgetContainerPanel;
import buoy.widget.LayoutInfo;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.BorderContainerDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JPanel;

public class BorderContainer
extends WidgetContainer {
    private Widget[] child;
    private LayoutInfo[] childLayout;
    private LayoutInfo defaultLayout;
    private boolean cornersVertical;
    public static final Position CENTER = new Position(0);
    public static final Position NORTH = new Position(1);
    public static final Position EAST = new Position(2);
    public static final Position SOUTH = new Position(3);
    public static final Position WEST = new Position(4);

    public BorderContainer() {
        this.component = new WidgetContainerPanel(this);
        this.child = new Widget[5];
        this.childLayout = new LayoutInfo[5];
        this.defaultLayout = new LayoutInfo(LayoutInfo.CENTER, LayoutInfo.BOTH, null, null);
    }

    public int getChildCount() {
        int count = 0;
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] == null) continue;
            ++count;
        }
        return count;
    }

    public Iterator getChildren() {
        ArrayList<Widget> ls = new ArrayList<Widget>(5);
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] == null) continue;
            ls.add(this.child[i]);
        }
        return ls.iterator();
    }

    public Widget getChild(Position where) {
        return this.child[where.value];
    }

    public void layoutChildren() {
        int i;
        Dimension size = this.component.getSize();
        Rectangle[] bounds = new Rectangle[5];
        Dimension[] prefSize = new Dimension[5];
        for (i = 0; i < this.child.length; ++i) {
            bounds[i] = new Rectangle();
            prefSize[i] = this.child[i] == null || i == BorderContainer.CENTER.value ? new Dimension() : (this.childLayout[i] == null ? this.defaultLayout.getPreferredSize(this.child[i]) : this.childLayout[i].getPreferredSize(this.child[i]));
        }
        bounds[BorderContainer.WEST.value].width = prefSize[BorderContainer.WEST.value].width;
        bounds[BorderContainer.EAST.value].width = prefSize[BorderContainer.EAST.value].width;
        bounds[BorderContainer.EAST.value].x = size.width - bounds[BorderContainer.EAST.value].width;
        bounds[BorderContainer.NORTH.value].height = prefSize[BorderContainer.NORTH.value].height;
        bounds[BorderContainer.SOUTH.value].height = prefSize[BorderContainer.SOUTH.value].height;
        bounds[BorderContainer.SOUTH.value].y = size.height - bounds[BorderContainer.SOUTH.value].height;
        if (this.cornersVertical) {
            bounds[BorderContainer.WEST.value].height = bounds[BorderContainer.EAST.value].height = size.height;
            bounds[BorderContainer.NORTH.value].x = bounds[BorderContainer.SOUTH.value].x = bounds[BorderContainer.WEST.value].width;
            bounds[BorderContainer.NORTH.value].width = bounds[BorderContainer.SOUTH.value].width = bounds[BorderContainer.EAST.value].x - bounds[BorderContainer.NORTH.value].x;
        } else {
            bounds[BorderContainer.NORTH.value].width = bounds[BorderContainer.SOUTH.value].width = size.width;
            bounds[BorderContainer.WEST.value].y = bounds[BorderContainer.EAST.value].y = bounds[BorderContainer.NORTH.value].height;
            bounds[BorderContainer.WEST.value].height = bounds[BorderContainer.EAST.value].height = bounds[BorderContainer.SOUTH.value].y - bounds[BorderContainer.WEST.value].y;
        }
        bounds[BorderContainer.CENTER.value].x = bounds[BorderContainer.WEST.value].width;
        bounds[BorderContainer.CENTER.value].y = bounds[BorderContainer.NORTH.value].height;
        bounds[BorderContainer.CENTER.value].width = bounds[BorderContainer.EAST.value].x - bounds[BorderContainer.CENTER.value].x;
        bounds[BorderContainer.CENTER.value].height = bounds[BorderContainer.SOUTH.value].y - bounds[BorderContainer.CENTER.value].y;
        for (i = 0; i < 5; ++i) {
            if (this.child[i] == null) continue;
            LayoutInfo layout = this.childLayout[i] == null ? this.defaultLayout : this.childLayout[i];
            this.child[i].getComponent().setBounds(layout.getWidgetLayout(this.child[i], bounds[i]));
            if (!(this.child[i] instanceof WidgetContainer)) continue;
            ((WidgetContainer)this.child[i]).layoutChildren();
        }
    }

    public void add(Widget widget, Position where) {
        this.add(widget, where, null);
    }

    public void add(Widget widget, Position where, LayoutInfo layout) {
        if (this.child[where.value] != null) {
            this.remove(where);
        }
        if (widget.getParent() != null) {
            widget.getParent().remove(widget);
        }
        this.child[where.value] = widget;
        this.childLayout[where.value] = layout;
        ((JPanel)this.component).add(widget.component);
        this.setAsParent(widget);
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Position where) {
        return this.childLayout[where.value];
    }

    public void setChildLayout(Position where, LayoutInfo layout) {
        this.childLayout[where.value] = layout;
        this.invalidateSize();
    }

    public LayoutInfo getChildLayout(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] != widget) continue;
            return this.childLayout[i];
        }
        return null;
    }

    public void setChildLayout(Widget widget, LayoutInfo layout) {
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] != widget) continue;
            this.childLayout[i] = layout;
            return;
        }
        this.invalidateSize();
    }

    public LayoutInfo getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(LayoutInfo layout) {
        this.defaultLayout = layout;
        this.invalidateSize();
    }

    public void remove(Widget widget) {
        for (int i = 0; i < this.child.length; ++i) {
            if (this.child[i] != widget) continue;
            this.remove(i);
            return;
        }
    }

    public void remove(Position where) {
        this.remove(where.value);
    }

    private void remove(int where) {
        if (this.child[where] == null) {
            return;
        }
        ((JPanel)this.component).remove(this.child[where].component);
        this.removeAsParent(this.child[where]);
        this.child[where] = null;
        this.childLayout[where] = null;
        this.invalidateSize();
    }

    public void removeAll() {
        for (int i = 0; i < this.child.length; ++i) {
            this.remove(i);
        }
    }

    public boolean getCornersAreVertical() {
        return this.cornersVertical;
    }

    public void setCornersAreVertical(boolean vertical) {
        this.cornersVertical = vertical;
        this.invalidateSize();
    }

    public Dimension getMinimumSize() {
        Dimension size;
        Dimension dimension = size = this.child[BorderContainer.CENTER.value] == null ? new Dimension() : this.child[BorderContainer.CENTER.value].getMinimumSize();
        if (this.cornersVertical) {
            Dimension dim;
            if (this.child[BorderContainer.NORTH.value] != null) {
                dim = this.child[BorderContainer.NORTH.value].getMinimumSize();
                size.height += dim.height;
                if (size.width < dim.width) {
                    size.width = dim.width;
                }
            }
            if (this.child[BorderContainer.SOUTH.value] != null) {
                dim = this.child[BorderContainer.SOUTH.value].getMinimumSize();
                size.height += dim.height;
                if (size.width < dim.width) {
                    size.width = dim.width;
                }
            }
            if (this.child[BorderContainer.EAST.value] != null) {
                dim = this.child[BorderContainer.EAST.value].getMinimumSize();
                size.width += dim.width;
                if (size.height < dim.height) {
                    size.height = dim.height;
                }
            }
            if (this.child[BorderContainer.WEST.value] != null) {
                dim = this.child[BorderContainer.WEST.value].getMinimumSize();
                size.width += dim.width;
                if (size.height < dim.height) {
                    size.height = dim.height;
                }
            }
        } else {
            Dimension dim;
            if (this.child[BorderContainer.EAST.value] != null) {
                dim = this.child[BorderContainer.EAST.value].getMinimumSize();
                size.width += dim.width;
                if (size.height < dim.height) {
                    size.height = dim.height;
                }
            }
            if (this.child[BorderContainer.WEST.value] != null) {
                dim = this.child[BorderContainer.WEST.value].getMinimumSize();
                size.width += dim.width;
                if (size.height < dim.height) {
                    size.height = dim.height;
                }
            }
            if (this.child[BorderContainer.NORTH.value] != null) {
                dim = this.child[BorderContainer.NORTH.value].getMinimumSize();
                size.height += dim.height;
                if (size.width < dim.width) {
                    size.width = dim.width;
                }
            }
            if (this.child[BorderContainer.SOUTH.value] != null) {
                dim = this.child[BorderContainer.SOUTH.value].getMinimumSize();
                size.height += dim.height;
                if (size.width < dim.width) {
                    size.width = dim.width;
                }
            }
        }
        return size;
    }

    public Dimension getPreferredSize() {
        Dimension size = this.child[BorderContainer.CENTER.value] == null ? new Dimension() : (this.childLayout[BorderContainer.CENTER.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.CENTER.value]) : this.childLayout[BorderContainer.CENTER.value].getPreferredSize(this.child[BorderContainer.CENTER.value]));
        if (this.cornersVertical) {
            Dimension dim;
            if (this.child[BorderContainer.NORTH.value] != null) {
                dim = this.childLayout[BorderContainer.NORTH.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.NORTH.value]) : this.childLayout[BorderContainer.NORTH.value].getPreferredSize(this.child[BorderContainer.NORTH.value]);
                size.height += dim.height;
                if (size.width < dim.width) {
                    size.width = dim.width;
                }
            }
            if (this.child[BorderContainer.SOUTH.value] != null) {
                dim = this.childLayout[BorderContainer.SOUTH.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.SOUTH.value]) : this.childLayout[BorderContainer.SOUTH.value].getPreferredSize(this.child[BorderContainer.SOUTH.value]);
                size.height += dim.height;
                if (size.width < dim.width) {
                    size.width = dim.width;
                }
            }
            if (this.child[BorderContainer.EAST.value] != null) {
                dim = this.childLayout[BorderContainer.EAST.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.EAST.value]) : this.childLayout[BorderContainer.EAST.value].getPreferredSize(this.child[BorderContainer.EAST.value]);
                size.width += dim.width;
                if (size.height < dim.height) {
                    size.height = dim.height;
                }
            }
            if (this.child[BorderContainer.WEST.value] != null) {
                dim = this.childLayout[BorderContainer.WEST.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.WEST.value]) : this.childLayout[BorderContainer.WEST.value].getPreferredSize(this.child[BorderContainer.WEST.value]);
                size.width += dim.width;
                if (size.height < dim.height) {
                    size.height = dim.height;
                }
            }
        } else {
            Dimension dim;
            if (this.child[BorderContainer.EAST.value] != null) {
                dim = this.childLayout[BorderContainer.EAST.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.EAST.value]) : this.childLayout[BorderContainer.EAST.value].getPreferredSize(this.child[BorderContainer.EAST.value]);
                size.width += dim.width;
                if (size.height < dim.height) {
                    size.height = dim.height;
                }
            }
            if (this.child[BorderContainer.WEST.value] != null) {
                dim = this.childLayout[BorderContainer.WEST.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.WEST.value]) : this.childLayout[BorderContainer.WEST.value].getPreferredSize(this.child[BorderContainer.WEST.value]);
                size.width += dim.width;
                if (size.height < dim.height) {
                    size.height = dim.height;
                }
            }
            if (this.child[BorderContainer.NORTH.value] != null) {
                dim = this.childLayout[BorderContainer.NORTH.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.NORTH.value]) : this.childLayout[BorderContainer.NORTH.value].getPreferredSize(this.child[BorderContainer.NORTH.value]);
                size.height += dim.height;
                if (size.width < dim.width) {
                    size.width = dim.width;
                }
            }
            if (this.child[BorderContainer.SOUTH.value] != null) {
                dim = this.childLayout[BorderContainer.SOUTH.value] == null ? this.defaultLayout.getPreferredSize(this.child[BorderContainer.SOUTH.value]) : this.childLayout[BorderContainer.SOUTH.value].getPreferredSize(this.child[BorderContainer.SOUTH.value]);
                size.height += dim.height;
                if (size.width < dim.width) {
                    size.width = dim.width;
                }
            }
        }
        return size;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(BorderContainer.class, new BorderContainerDelegate());
        WidgetEncoder.setPersistenceDelegate(Position.class, new StaticFieldDelegate(BorderContainer.class));
    }

    public static class Position {
        protected int value;

        private Position(int value) {
            this.value = value;
        }
    }
}

