/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.SelectionChangedEvent;
import buoy.event.ValueChangedEvent;
import buoy.widget.BScrollPane;
import buoy.widget.Widget;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class BTree
extends Widget {
    private TreeModelListener modelListener;
    private int suppressEvents;
    private boolean selectionEnabled;

    public BTree() {
        this(new DefaultTreeModel(new DefaultMutableTreeNode("Tree")));
    }

    public BTree(TreeNode root) {
        this(new DefaultTreeModel(root));
    }

    public BTree(TreeModel model) {
        this.component = this.createComponent(model);
        ((JTree)this.component).addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent ev) {
                if (BTree.this.suppressEvents == 0) {
                    BTree.this.dispatchEvent(new SelectionChangedEvent(BTree.this, false));
                }
            }
        });
        final Runnable scrollPaneUpdater = new Runnable(){

            public void run() {
                BTree.this.updateScrollPane();
            }
        };
        ((JTree)this.component).addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                SwingUtilities.invokeLater(scrollPaneUpdater);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                SwingUtilities.invokeLater(scrollPaneUpdater);
            }
        });
        this.modelListener = new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent ev) {
                if (BTree.this.suppressEvents == 0) {
                    BTree.this.dispatchEvent(new ValueChangedEvent(BTree.this));
                }
            }

            public void treeNodesInserted(TreeModelEvent ev) {
            }

            public void treeNodesRemoved(TreeModelEvent ev) {
            }

            public void treeStructureChanged(TreeModelEvent ev) {
            }
        };
        model.addTreeModelListener(this.modelListener);
        if (model instanceof DefaultTreeModel) {
            ((DefaultTreeModel)model).setAsksAllowsChildren(true);
        }
        ((JTree)this.component).setSelectionModel(new BTreeSelectionModel());
        this.selectionEnabled = true;
        ((JTree)this.component).setShowsRootHandles(true);
    }

    protected JTree createComponent(TreeModel model) {
        return new JTree(model);
    }

    public TreeModel getModel() {
        return ((JTree)this.component).getModel();
    }

    public void setModel(TreeModel model) {
        ((JTree)this.component).getModel().removeTreeModelListener(this.modelListener);
        ((JTree)this.component).setModel(model);
        model.addTreeModelListener(this.modelListener);
        this.invalidateSize();
    }

    public TreePath getRootNode() {
        Object root = this.getModel().getRoot();
        if (root == null) {
            return null;
        }
        return new TreePath(root);
    }

    public int getChildNodeCount(TreePath path) {
        return this.getModel().getChildCount(path.getLastPathComponent());
    }

    public TreePath getChildNode(TreePath path, int index) {
        Object child = this.getModel().getChild(path.getLastPathComponent(), index);
        return path.pathByAddingChild(child);
    }

    public TreePath getParentNode(TreePath path) {
        return path.getParentPath();
    }

    public boolean isLeafNode(TreePath path) {
        return this.getModel().isLeaf(path.getLastPathComponent());
    }

    public TreePath addNode(TreePath parent, MutableTreeNode node) {
        return this.addNode(parent, node, this.getChildNodeCount(parent));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TreePath addNode(TreePath parent, MutableTreeNode node, int index) {
        MutableTreeNode parentNode = (MutableTreeNode)parent.getLastPathComponent();
        try {
            ++this.suppressEvents;
            parentNode.insert(node, index);
            TreeModel model = this.getModel();
            if (model instanceof DefaultTreeModel) {
                ((DefaultTreeModel)model).nodesWereInserted(parentNode, new int[]{index});
            }
        }
        finally {
            --this.suppressEvents;
        }
        this.updateScrollPane();
        return parent.pathByAddingChild(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(TreePath path) {
        try {
            ++this.suppressEvents;
            MutableTreeNode node = (MutableTreeNode)path.getLastPathComponent();
            TreeNode parentNode = node.getParent();
            int index = parentNode.getIndex(node);
            node.removeFromParent();
            TreeModel model = this.getModel();
            if (model instanceof DefaultTreeModel) {
                ((DefaultTreeModel)model).nodesWereRemoved(parentNode, new int[]{index}, new Object[]{node});
            }
        }
        finally {
            --this.suppressEvents;
        }
        this.updateScrollPane();
    }

    public boolean isSelectionEnabled() {
        return this.selectionEnabled;
    }

    public void setSelectionEnabled(boolean enabled) {
        this.selectionEnabled = enabled;
        if (!enabled) {
            this.clearSelection();
        }
    }

    public boolean isMultipleSelectionEnabled() {
        return ((JTree)this.component).getSelectionModel().getSelectionMode() != 1;
    }

    public void setMultipleSelectionEnabled(boolean multiple) {
        ((JTree)this.component).getSelectionModel().setSelectionMode(multiple ? 4 : 1);
    }

    public int getSelectionCount() {
        return ((JTree)this.component).getSelectionCount();
    }

    public TreePath getSelectedNode() {
        return ((JTree)this.component).getSelectionPath();
    }

    public TreePath[] getSelectedNodes() {
        return ((JTree)this.component).getSelectionPaths();
    }

    public boolean isNodeSelected(TreePath path) {
        return ((JTree)this.component).isPathSelected(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNodeSelected(TreePath path, boolean selected) {
        try {
            ++this.suppressEvents;
            if (selected) {
                ((JTree)this.component).addSelectionPath(path);
            } else {
                ((JTree)this.component).removeSelectionPath(path);
            }
        }
        finally {
            --this.suppressEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        try {
            ++this.suppressEvents;
            ((JTree)this.component).clearSelection();
        }
        finally {
            --this.suppressEvents;
        }
    }

    public boolean isEditable() {
        return ((JTree)this.component).isEditable();
    }

    public void setEditable(boolean editable) {
        ((JTree)this.component).setEditable(editable);
    }

    public void editNode(TreePath path) {
        ((JTree)this.component).startEditingAtPath(path);
    }

    public TreePath findNode(Point pos) {
        return ((JTree)this.component).getPathForLocation(pos.x, pos.y);
    }

    public boolean isNodeExpanded(TreePath path) {
        return ((JTree)this.component).isExpanded(path);
    }

    public void setNodeExpanded(TreePath path, boolean expanded) {
        if (expanded) {
            ((JTree)this.component).expandPath(path);
        } else {
            ((JTree)this.component).collapsePath(path);
        }
        this.updateScrollPane();
    }

    public boolean isNodeVisible(TreePath path) {
        return ((JTree)this.component).isVisible(path);
    }

    public void makeNodeVisible(TreePath path) {
        ((JTree)this.component).makeVisible(path);
    }

    public void scrollToNode(TreePath path) {
        Rectangle bounds = ((JTree)this.component).getPathBounds(path);
        if (bounds != null) {
            ((JTree)this.component).scrollRectToVisible(bounds);
        }
    }

    public boolean isRootNodeShown() {
        return ((JTree)this.component).isRootVisible();
    }

    public void setRootNodeShown(boolean shown) {
        ((JTree)this.component).setRootVisible(shown);
    }

    public int getPreferredVisibleRows() {
        return ((JTree)this.component).getVisibleRowCount();
    }

    public void setPreferredVisibleRows(int rows) {
        ((JTree)this.component).setVisibleRowCount(rows);
        this.invalidateSize();
    }

    public TreeCellRenderer getCellRenderer() {
        return ((JTree)this.component).getCellRenderer();
    }

    public void setCellRenderer(TreeCellRenderer renderer) {
        ((JTree)this.component).setCellRenderer(renderer);
    }

    private void updateScrollPane() {
        this.invalidateSize();
        if (this.getParent() instanceof BScrollPane) {
            this.getParent().layoutChildren();
        }
    }

    private class BTreeSelectionModel
    extends DefaultTreeSelectionModel {
        private BTreeSelectionModel() {
        }

        public void setSelectionPaths(TreePath[] path) {
            if (BTree.this.selectionEnabled) {
                super.setSelectionPaths(path);
            }
        }

        public void addSelectionPaths(TreePath[] path) {
            if (BTree.this.selectionEnabled) {
                super.addSelectionPaths(path);
            }
        }

        public void removeSelectionPaths(TreePath[] path) {
            if (BTree.this.selectionEnabled) {
                super.removeSelectionPaths(path);
            }
        }
    }
}

