/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.event.CellValueChangedEvent;
import buoy.event.SelectionChangedEvent;
import buoy.widget.BScrollPane;
import buoy.widget.Widget;
import buoy.widget.WidgetContainer;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.BTableDelegate;
import buoy.xml.delegate.BTableHeaderDelegate;
import buoy.xml.delegate.StaticFieldDelegate;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class BTable
extends Widget {
    protected DefaultTableModel defaultModel = new DefaultTableModel(){

        public boolean isCellEditable(int row, int column) {
            return (Boolean)BTable.this.columnEditable.get(column);
        }
    };
    protected BTableHeader tableHeader;
    protected ArrayList columnEditable;
    public static final SelectionMode SELECT_NONE = new SelectionMode();
    public static final SelectionMode SELECT_ROWS = new SelectionMode();
    public static final SelectionMode SELECT_COLUMNS = new SelectionMode();
    public static final SelectionMode SELECT_CELLS = new SelectionMode();

    public BTable() {
        this.component = this.createComponent();
        this.tableHeader = new BTableHeader();
        this.columnEditable = new ArrayList();
        ListSelectionListener lsl = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent ev) {
                BTable.this.dispatchEvent(new SelectionChangedEvent(BTable.this, ev.getValueIsAdjusting()));
            }
        };
        ((JTable)this.component).getSelectionModel().addListSelectionListener(lsl);
        ((JTable)this.component).getColumnModel().getSelectionModel().addListSelectionListener(lsl);
    }

    public BTable(int rows, int cols) {
        this();
        this.defaultModel.setRowCount(rows);
        this.defaultModel.setColumnCount(cols);
        for (int i = 0; i < cols; ++i) {
            this.columnEditable.add(Boolean.FALSE);
        }
    }

    public BTable(Object[][] cellData, Object[] columnTitle) {
        this();
        this.defaultModel.setDataVector(cellData, columnTitle);
        for (int i = 0; i < columnTitle.length; ++i) {
            this.columnEditable.add(Boolean.FALSE);
        }
    }

    public BTable(TableModel model) {
        this();
        ((JTable)this.component).setModel(model);
    }

    protected JTable createComponent() {
        return new JTable(this.defaultModel){

            public void editingStopped(ChangeEvent ev) {
                int row = this.getEditingRow();
                int col = this.getEditingColumn();
                super.editingStopped(ev);
                BTable.this.dispatchEvent(new CellValueChangedEvent(BTable.this, row, col));
            }
        };
    }

    public BTableHeader getTableHeader() {
        return this.tableHeader;
    }

    public TableModel getModel() {
        return ((JTable)this.component).getModel();
    }

    public void setModel(TableModel model) {
        ((JTable)this.component).setModel(model);
        this.invalidateSize();
    }

    public void addColumn(Object columnTitle) {
        this.defaultModel.addColumn(columnTitle);
        this.columnEditable.add(Boolean.FALSE);
        this.invalidateSize();
    }

    public void addColumn(Object columnTitle, Object[] columnData) {
        this.defaultModel.addColumn(columnTitle, columnData);
        this.columnEditable.add(Boolean.FALSE);
        this.invalidateSize();
    }

    public void removeColumn(int index) {
        JTable table = (JTable)this.component;
        table.removeColumn(table.getColumnModel().getColumn(index));
        if (index < this.columnEditable.size()) {
            this.columnEditable.remove(index);
        }
        this.invalidateSize();
    }

    public void addRow(Object[] rowData) {
        this.defaultModel.addRow(rowData);
        this.invalidateSize();
    }

    public void addRow(int index, Object[] rowData) {
        this.defaultModel.insertRow(index, rowData);
        this.invalidateSize();
    }

    public void removeRow(int index) {
        this.defaultModel.removeRow(index);
        this.invalidateSize();
    }

    public int getRowCount() {
        return ((JTable)this.component).getRowCount();
    }

    public int getColumnCount() {
        return ((JTable)this.component).getColumnCount();
    }

    public boolean isColumnEditable(int index) {
        return (Boolean)this.columnEditable.get(index);
    }

    public void setColumnEditable(int index, boolean editable) {
        this.columnEditable.set(index, new Boolean(editable));
    }

    public Object getCellValue(int row, int col) {
        return ((JTable)this.component).getModel().getValueAt(row, col);
    }

    public void setCellValue(int row, int col, Object value) {
        ((JTable)this.component).getModel().setValueAt(value, row, col);
    }

    private TableColumn getColumn(int col) {
        return ((JTable)this.component).getColumnModel().getColumn(col);
    }

    public Object getColumnHeader(int col) {
        return this.getColumn(col).getHeaderValue();
    }

    public void setColumnHeader(int col, Object value) {
        this.getColumn(col).setHeaderValue(value);
    }

    public int getRowHeight(int row) {
        return ((JTable)this.component).getRowHeight(row);
    }

    public void setRowHeight(int row, int height) {
        ((JTable)this.component).setRowHeight(row, height);
        this.invalidateSize();
    }

    public int getColumnWidth(int col) {
        return this.getColumn(col).getWidth();
    }

    public void setColumnWidth(int col, int width) {
        this.getColumn(col).setPreferredWidth(width);
        this.invalidateSize();
    }

    public void sizeColumnToFit(int col) {
        TableColumn tc = this.getColumn(col);
        if (tc.getHeaderRenderer() != null) {
            tc.sizeWidthToFit();
        } else {
            JTableHeader th = ((JTable)this.component).getTableHeader();
            FontMetrics fm = th.getFontMetrics(th.getFont());
            tc.setPreferredWidth(fm.stringWidth(tc.getHeaderValue().toString()) + 10);
        }
        this.invalidateSize();
    }

    public boolean getColumnsResizable() {
        return ((JTable)this.component).getTableHeader().getResizingAllowed();
    }

    public void setColumnsResizable(boolean resizable) {
        ((JTable)this.component).getTableHeader().setResizingAllowed(resizable);
    }

    public boolean getColumnsReorderable() {
        return ((JTable)this.component).getTableHeader().getReorderingAllowed();
    }

    public void setColumnsReorderable(boolean reorderable) {
        ((JTable)this.component).getTableHeader().setReorderingAllowed(reorderable);
    }

    public SelectionMode getSelectionMode() {
        JTable table = (JTable)this.component;
        if (table.getCellSelectionEnabled()) {
            return SELECT_CELLS;
        }
        if (table.getColumnSelectionAllowed()) {
            return SELECT_COLUMNS;
        }
        if (table.getRowSelectionAllowed()) {
            return SELECT_ROWS;
        }
        return SELECT_NONE;
    }

    public void setSelectionMode(SelectionMode mode) {
        JTable table = (JTable)this.component;
        table.setColumnSelectionAllowed(mode == SELECT_COLUMNS || mode == SELECT_CELLS);
        table.setRowSelectionAllowed(mode == SELECT_ROWS || mode == SELECT_CELLS);
    }

    public boolean isMultipleSelectionEnabled() {
        return ((JTable)this.component).getSelectionModel().getSelectionMode() != 0;
    }

    public void setMultipleSelectionEnabled(boolean multiple) {
        ((JTable)this.component).setSelectionMode(multiple ? 2 : 0);
    }

    public boolean isRowSelected(int row) {
        return ((JTable)this.component).isRowSelected(row);
    }

    public void setRowSelected(int row, boolean selected) {
        if (selected) {
            ((JTable)this.component).addRowSelectionInterval(row, row);
        } else {
            ((JTable)this.component).removeRowSelectionInterval(row, row);
        }
    }

    public boolean isColumnSelected(int col) {
        return ((JTable)this.component).isColumnSelected(col);
    }

    public void setColumnSelected(int col, boolean selected) {
        if (selected) {
            ((JTable)this.component).addColumnSelectionInterval(col, col);
        } else {
            ((JTable)this.component).removeColumnSelectionInterval(col, col);
        }
    }

    public boolean isCellSelected(int row, int col) {
        return ((JTable)this.component).isCellSelected(row, col);
    }

    public void setCellSelected(int row, int col, boolean selected) {
        if (selected) {
            ((JTable)this.component).addRowSelectionInterval(row, row);
            ((JTable)this.component).addColumnSelectionInterval(col, col);
        } else {
            ((JTable)this.component).removeRowSelectionInterval(row, row);
            ((JTable)this.component).removeColumnSelectionInterval(col, col);
        }
    }

    public void clearSelection() {
        ((JTable)this.component).clearSelection();
    }

    public int findRow(Point pos) {
        return ((JTable)this.component).rowAtPoint(pos);
    }

    public int findColumn(Point pos) {
        return ((JTable)this.component).columnAtPoint(pos);
    }

    public void editCellAt(int row, int col) {
        ((JTable)this.component).editCellAt(row, col);
    }

    public boolean getShowHorizontalLines() {
        return ((JTable)this.component).getShowHorizontalLines();
    }

    public void setShowHorizontalLines(boolean show) {
        ((JTable)this.component).setShowHorizontalLines(show);
    }

    public boolean getShowVerticalLines() {
        return ((JTable)this.component).getShowVerticalLines();
    }

    public void setShowVerticalLines(boolean show) {
        ((JTable)this.component).setShowVerticalLines(show);
    }

    protected void setParent(WidgetContainer container) {
        super.setParent(container);
        if (container instanceof BScrollPane) {
            BScrollPane scroll = (BScrollPane)container;
            scroll.setColHeader(this.tableHeader);
            ((JTable)this.component).setAutoResizeMode(scroll.getHorizontalScrollbarPolicy() == BScrollPane.SCROLLBAR_NEVER ? 2 : 0);
        }
    }

    static {
        WidgetEncoder.setPersistenceDelegate(BTable.class, new BTableDelegate());
        WidgetEncoder.setPersistenceDelegate(BTableHeader.class, new BTableHeaderDelegate());
        WidgetEncoder.setPersistenceDelegate(SelectionMode.class, new StaticFieldDelegate(BTable.class));
    }

    public static class SelectionMode {
        private SelectionMode() {
        }
    }

    public class BTableHeader
    extends Widget {
        private BTableHeader() {
            this.component = ((JTable)BTable.this.component).getTableHeader();
            this.component.addComponentListener(new ComponentAdapter(this){
                private final /* synthetic */ BTableHeader this$1;
                {
                    this.this$1 = this$1;
                }

                public void componentResized(ComponentEvent ev) {
                    if (((JTableHeader)this.this$1.component).getResizingColumn() != null && this.this$1.getParent() instanceof BScrollPane) {
                        this.this$1.getParent().layoutChildren();
                    }
                }
            });
        }

        public BTable getTable() {
            return BTable.this;
        }
    }
}

