/*
 * Decompiled with CFR 0.152.
 */
package buoy.widget;

import buoy.widget.Widget;
import buoy.xml.WidgetEncoder;
import buoy.xml.delegate.StaticFieldDelegate;
import javax.swing.JOptionPane;

public class BStandardDialog {
    private Object message;
    private String title;
    private Style style;
    public static final Style ERROR = new Style(0);
    public static final Style INFORMATION = new Style(1);
    public static final Style WARNING = new Style(2);
    public static final Style QUESTION = new Style(3);
    public static final Style PLAIN = new Style(-1);

    public BStandardDialog() {
        this("", "", PLAIN);
    }

    public BStandardDialog(String title, Object message, Style style) {
        this.setTitle(title);
        this.setMessage(message);
        this.setStyle(style);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Object getMessage() {
        return this.message;
    }

    public void setMessage(Object message) {
        this.message = message;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public void showMessageDialog(Widget parent) {
        JOptionPane.showMessageDialog(parent == null ? null : parent.component, BStandardDialog.buildMessage(this.message), this.title, this.style.value);
    }

    public int showOptionDialog(Widget parent, String[] options, String defaultVal) {
        if (options.length != 2 && options.length != 3) {
            throw new IllegalArgumentException("Number of options must be 2 or 3");
        }
        int response = JOptionPane.showOptionDialog(parent == null ? null : parent.component, BStandardDialog.buildMessage(this.message), this.title, options.length == 2 ? 0 : 1, this.style.value, null, options, defaultVal);
        if (response == 0) {
            return 0;
        }
        if (response == 1) {
            return 1;
        }
        return 2;
    }

    public String showInputDialog(Widget parent, String[] options, String defaultVal) {
        return (String)JOptionPane.showInputDialog(parent == null ? null : parent.component, BStandardDialog.buildMessage(this.message), this.title, this.style.value, null, options, defaultVal);
    }

    private static Object buildMessage(Object message) {
        if (message.getClass().isArray()) {
            Object[] msg = (Object[])message;
            Object[] a = new Object[msg.length];
            for (int i = 0; i < msg.length; ++i) {
                a[i] = BStandardDialog.buildMessage(msg[i]);
            }
            return a;
        }
        if (message instanceof Widget) {
            Widget widget = (Widget)message;
            if (widget.getParent() != null) {
                widget.getParent().remove(widget);
            }
            return widget.getComponent();
        }
        return message;
    }

    static {
        WidgetEncoder.setPersistenceDelegate(Style.class, new StaticFieldDelegate(Style.class));
    }

    public static class Style {
        public int value;

        private Style(int value) {
            this.value = value;
        }
    }
}

