/*
 * Decompiled with CFR 0.152.
 */
package buoy.internal;

import buoy.event.FocusGainedEvent;
import buoy.event.FocusLostEvent;
import buoy.event.KeyPressedEvent;
import buoy.event.KeyReleasedEvent;
import buoy.event.KeyTypedEvent;
import buoy.event.MouseClickedEvent;
import buoy.event.MouseDraggedEvent;
import buoy.event.MouseEnteredEvent;
import buoy.event.MouseExitedEvent;
import buoy.event.MouseMovedEvent;
import buoy.event.MousePressedEvent;
import buoy.event.MouseReleasedEvent;
import buoy.event.MouseScrolledEvent;
import buoy.event.ToolTipEvent;
import buoy.event.WindowActivatedEvent;
import buoy.event.WindowClosingEvent;
import buoy.event.WindowDeactivatedEvent;
import buoy.event.WindowDeiconifiedEvent;
import buoy.event.WindowIconifiedEvent;
import buoy.widget.Widget;
import buoy.widget.WindowWidget;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

public class EventLinkAdapter
implements FocusListener,
KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
WindowListener {
    private Widget widget;
    private int eventFlags;
    private static final int MOUSE_EVENT = 1;
    private static final int MOUSE_MOTION_EVENT = 2;
    private static final int MOUSE_WHEEL_EVENT = 4;
    private static final int KEY_EVENT = 8;
    private static final int FOCUS_EVENT = 16;
    private static final int WINDOW_EVENT = 32;

    public EventLinkAdapter(Widget widget) {
        this.widget = widget;
    }

    public void newEventType(Class eventType) {
        if ((this.eventFlags & 1) == 0 && (eventType.isAssignableFrom(MousePressedEvent.class) || eventType.isAssignableFrom(MouseReleasedEvent.class) || eventType.isAssignableFrom(MouseClickedEvent.class) || eventType.isAssignableFrom(MouseEnteredEvent.class) || eventType.isAssignableFrom(MouseExitedEvent.class) || eventType.isAssignableFrom(ToolTipEvent.class))) {
            this.eventFlags |= 1;
            this.widget.getComponent().addMouseListener(this);
        }
        if ((this.eventFlags & 2) == 0 && (eventType.isAssignableFrom(MouseMovedEvent.class) || eventType.isAssignableFrom(MouseDraggedEvent.class) || eventType.isAssignableFrom(ToolTipEvent.class))) {
            this.eventFlags |= 2;
            this.widget.getComponent().addMouseMotionListener(this);
        }
        if ((this.eventFlags & 4) == 0 && eventType.isAssignableFrom(MouseScrolledEvent.class)) {
            this.eventFlags |= 4;
            this.widget.getComponent().addMouseWheelListener(this);
        }
        if ((this.eventFlags & 8) == 0 && (eventType.isAssignableFrom(KeyPressedEvent.class) || eventType.isAssignableFrom(KeyReleasedEvent.class) || eventType.isAssignableFrom(KeyTypedEvent.class))) {
            this.eventFlags |= 8;
            this.widget.getComponent().addKeyListener(this);
        }
        if ((this.eventFlags & 0x10) == 0 && (eventType.isAssignableFrom(FocusGainedEvent.class) || eventType.isAssignableFrom(FocusLostEvent.class))) {
            this.eventFlags |= 0x10;
            this.widget.getComponent().addFocusListener(this);
        }
        if ((this.eventFlags & 0x20) == 0 && this.widget instanceof WindowWidget && this.widget.getComponent() instanceof Window && (eventType.isAssignableFrom(WindowActivatedEvent.class) || eventType.isAssignableFrom(WindowClosingEvent.class) || eventType.isAssignableFrom(WindowDeactivatedEvent.class) || eventType.isAssignableFrom(WindowDeiconifiedEvent.class) || eventType.isAssignableFrom(WindowIconifiedEvent.class))) {
            this.eventFlags |= 0x20;
            ((Window)this.widget.getComponent()).addWindowListener(this);
        }
    }

    public void mousePressed(MouseEvent ev) {
        this.widget.dispatchEvent(new MousePressedEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getX(), ev.getY(), ev.getClickCount(), ev.isPopupTrigger(), ev.getButton()));
    }

    public void mouseReleased(MouseEvent ev) {
        this.widget.dispatchEvent(new MouseReleasedEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getX(), ev.getY(), ev.getClickCount(), ev.isPopupTrigger(), ev.getButton()));
    }

    public void mouseClicked(MouseEvent ev) {
        this.widget.dispatchEvent(new MouseClickedEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getX(), ev.getY(), ev.getClickCount(), ev.isPopupTrigger(), ev.getButton()));
    }

    public void mouseEntered(MouseEvent ev) {
        this.widget.dispatchEvent(new MouseEnteredEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getX(), ev.getY()));
    }

    public void mouseExited(MouseEvent ev) {
        this.widget.dispatchEvent(new MouseExitedEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getX(), ev.getY()));
    }

    public void mouseMoved(MouseEvent ev) {
        this.widget.dispatchEvent(new MouseMovedEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getX(), ev.getY()));
    }

    public void mouseDragged(MouseEvent ev) {
        this.widget.dispatchEvent(new MouseDraggedEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getX(), ev.getY()));
    }

    public void mouseWheelMoved(MouseWheelEvent ev) {
        this.widget.dispatchEvent(new MouseScrolledEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getX(), ev.getY(), ev.getScrollType(), ev.getScrollAmount(), ev.getWheelRotation()));
    }

    public void keyPressed(KeyEvent ev) {
        this.widget.dispatchEvent(new KeyPressedEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getKeyCode()));
    }

    public void keyReleased(KeyEvent ev) {
        this.widget.dispatchEvent(new KeyReleasedEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getKeyCode()));
    }

    public void keyTyped(KeyEvent ev) {
        this.widget.dispatchEvent(new KeyTypedEvent(this.widget, ev.getWhen(), ev.getModifiersEx(), ev.getKeyChar()));
    }

    public void focusGained(FocusEvent ev) {
        this.widget.dispatchEvent(new FocusGainedEvent(this.widget, ev.isTemporary()));
    }

    public void focusLost(FocusEvent ev) {
        this.widget.dispatchEvent(new FocusLostEvent(this.widget, ev.isTemporary()));
    }

    public void windowActivated(WindowEvent ev) {
        this.widget.dispatchEvent(new WindowActivatedEvent((WindowWidget)this.widget));
    }

    public void windowClosed(WindowEvent ev) {
    }

    public void windowClosing(WindowEvent ev) {
        this.widget.dispatchEvent(new WindowClosingEvent((WindowWidget)this.widget));
    }

    public void windowDeactivated(WindowEvent ev) {
        this.widget.dispatchEvent(new WindowDeactivatedEvent((WindowWidget)this.widget));
    }

    public void windowDeiconified(WindowEvent ev) {
        this.widget.dispatchEvent(new WindowDeiconifiedEvent((WindowWidget)this.widget));
    }

    public void windowIconified(WindowEvent ev) {
        this.widget.dispatchEvent(new WindowIconifiedEvent((WindowWidget)this.widget));
    }

    public void windowOpened(WindowEvent ev) {
    }
}

