unit setdate;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, ComCtrls, strutils, dateutils;

type
  TForm1 = class(TForm)
    YearsCheckBox: TCheckBox;
    MonthsCheckBox: TCheckBox;
    DaysCheckBox: TCheckBox;
    HoursCheckBox: TCheckBox;
    MinutesCheckBox: TCheckBox;
    SecondsCheckBox: TCheckBox;
    StartfromLabel: TLabel;
    IncrementbyLabel: TLabel;
    YearsStartSpinEdit: TSpinEdit;
    YearsIncSpinEdit: TSpinEdit;
    MonthsStartSpinEdit: TSpinEdit;
    MonthsIncSpinEdit: TSpinEdit;
    DaysStartSpinEdit: TSpinEdit;
    DaysIncSpinEdit: TSpinEdit;
    HoursStartSpinEdit: TSpinEdit;
    HoursIncSpinEdit: TSpinEdit;
    MinutesStartSpinEdit: TSpinEdit;
    MinutesIncSpinEdit: TSpinEdit;
    SecondsStartSpinEdit: TSpinEdit;
    SecondsIncSpinEdit: TSpinEdit;
    StartButton: TButton;
    Close: TButton;
    PreviewLabel: TLabel;
    PreviewListView: TListView;
    AutoupdatingLabel: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure YearsCheckBoxClick(Sender: TObject);
    procedure MonthsCheckBoxClick(Sender: TObject);
    procedure DaysCheckBoxClick(Sender: TObject);
    procedure HoursCheckBoxClick(Sender: TObject);
    procedure MinutesCheckBoxClick(Sender: TObject);
    procedure SecondsCheckBoxClick(Sender: TObject);
    procedure YearsStartSpinEditChange(Sender: TObject);
    procedure MonthsStartSpinEditChange(Sender: TObject);
    procedure DaysStartSpinEditChange(Sender: TObject);
    procedure HoursStartSpinEditChange(Sender: TObject);
    procedure MinutesStartSpinEditChange(Sender: TObject);
    procedure SecondsStartSpinEditChange(Sender: TObject);
    procedure YearsIncSpinEditChange(Sender: TObject);
    procedure MonthsIncSpinEditChange(Sender: TObject);
    procedure DaysIncSpinEditChange(Sender: TObject);
    procedure HoursIncSpinEditChange(Sender: TObject);
    procedure MinutesIncSpinEditChange(Sender: TObject);
    procedure SecondsIncSpinEditChange(Sender: TObject);
    procedure CloseClick(Sender: TObject);
    procedure PreviewListViewKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure StartButtonClick(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure PreviewListViewClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  filelist: tstringlist;
  autoupdate: boolean = true;
  initialpos: integer = 0;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
begin
  if paramcount = 0 then
    begin
      showmessage('List file not specified. Make sure you have specified %L in the Parameters: field of ReDate in the Button Bar or the Start Menu. Exiting.');
      halt;
    end;

  if fileexists(paramstr(1)) = false then
    begin
      showmessage('List file "' + paramstr(1) + '" not found. Make sure you have specified %L in the Parameters: field of ReDate in the Button Bar or the Start Menu. Exiting.');
      halt;
    end;
end;

procedure TForm1.FormShow(Sender: TObject);
var
  i: integer;                                   // Used when iterating over the filelist
  date: tdatetime;
  handle: integer;
  systime: tsystemtime;
  ft: filetime;
  lt: filetime;

begin
  filelist := tstringlist.create;

  // Let's read all the filenames into the filelist
  filelist.LoadFromFile(paramstr(1));

  i := 0;

  while i < filelist.Count do
    if ansiendstext('\', filelist.Strings[i]) = true then   // Remove any dirs in list
      filelist.Delete(i)
    else
      if uppercase(filelist.Strings[i]) = paramstr(0) then  // Make sure we remove ourselves
        filelist.Delete(i)                                  // in case we've been added
      else
        begin
          // fill the list with files with relative paths (to the current dir)
          if paramcount > 1 then
            if filelist[i] = paramstr(2) then
              initialpos := i;
          filelist[i] := extractrelativepath(IncludeTrailingPathDelimiter(getcurrentdir), filelist[i]);
          inc(i);
        end;

  // fill the preview with files and their current timestamps
  PreviewListView.Items.BeginUpdate;

  for i := 0 to filelist.Count - 1 do
    begin
      handle := fileopen(filelist[i], fmOpenRead or fmShareDenyNone);
      if handle = -1 then
        begin
          showmessage('Error opening ' + filelist[i]);
          continue;
        end;

      if getfiletime(handle, NIL, NIL, @ft) = false then
        begin
          showmessage('Error getting timestamp of ' + filelist[i]);
          fileclose(handle);
          continue;
        end;

      fileclose(handle);

      if FileTimeToLocalFileTime(ft, lt) = false then
        begin
          showmessage('FileTimeToLocalFileTime error on file ' + filelist[i]);
          continue;
        end;

      if FileTimeToSystemTime(lt, systime) = false then
        begin
          showmessage('LocalFileTimeToSystemTime error on file ' + filelist[i]);
          continue;
        end;

      with previewlistview.Items.Add do
        begin
          Caption := filelist[i];
          SubItems.Append(formatdatetime('ddddd tt', SystemTimeToDateTime(systime)));
          subitems.append(subitems[0]);
        end;
    end;

  if previewlistview.Items.Count = 0 then
    begin
      showmessage('No file could be added. Exiting.');
      application.Terminate;
      exit;
    end;

  PreviewListView.ItemIndex := initialpos;

  PreviewListView.Items.EndUpdate;

  {$INCLUDE 'fillstartfromfields.pas'}

  // initialize the RNG
  randomize;
end;

procedure TForm1.YearsCheckBoxClick(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if YearsCheckBox.Checked = true then
    begin
      YearsStartSpinEdit.TabStop := true;
      YearsIncSpinEdit.TabStop := true;
      YearsStartSpinEdit.SetFocus;
    end
  else
    begin
      YearsStartSpinEdit.TabStop := false;
      YearsIncSpinEdit.TabStop := false;
    end;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.MonthsCheckBoxClick(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if MonthsCheckBox.Checked = true then
    begin
      MonthsStartSpinEdit.TabStop := true;
      MonthsIncSpinEdit.TabStop := true;
      MonthsStartSpinEdit.SetFocus;
    end
  else
    begin
      MonthsStartSpinEdit.TabStop := false;
      MonthsIncSpinEdit.TabStop := false;
    end;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.DaysCheckBoxClick(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if DaysCheckBox.Checked = true then
    begin
      DaysStartSpinEdit.TabStop := true;
      DaysIncSpinEdit.TabStop := true;
      DaysStartSpinEdit.SetFocus;
    end
  else
    begin
      DaysStartSpinEdit.TabStop := false;
      DaysIncSpinEdit.TabStop := false;
    end;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.HoursCheckBoxClick(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if HoursCheckBox.Checked = true then
    begin
      HoursStartSpinEdit.TabStop := true;
      HoursIncSpinEdit.TabStop := true;
      HoursStartSpinEdit.SetFocus;
    end
  else
    begin
      HoursStartSpinEdit.TabStop := false;
      HoursIncSpinEdit.TabStop := false;
    end;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.MinutesCheckBoxClick(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if MinutesCheckBox.Checked = true then
    begin
      MinutesStartSpinEdit.TabStop := true;
      MinutesIncSpinEdit.TabStop := true;
      MinutesStartSpinEdit.SetFocus;
    end
  else
    begin
      MinutesStartSpinEdit.TabStop := false;
      MinutesIncSpinEdit.TabStop := false;
    end;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.SecondsCheckBoxClick(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if SecondsCheckBox.Checked = true then
    begin
      SecondsStartSpinEdit.TabStop := true;
      SecondsIncSpinEdit.TabStop := true;
      SecondsStartSpinEdit.SetFocus;
    end
  else
    begin
      SecondsStartSpinEdit.TabStop := false;
      SecondsIncSpinEdit.TabStop := false;
    end;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.YearsStartSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if YearsCheckBox.Checked = true then
    begin
      {$INCLUDE 'countnewdates.pas'}
    end;
end;

procedure TForm1.MonthsStartSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if MonthsCheckBox.Checked = true then
    begin
      {$INCLUDE 'countnewdates.pas'}
    end;
end;

procedure TForm1.DaysStartSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if DaysCheckBox.Checked = true then
    begin
      {$INCLUDE 'countnewdates.pas'}
    end;
end;

procedure TForm1.HoursStartSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if HoursCheckBox.Checked = true then
    begin
      {$INCLUDE 'countnewdates.pas'}
    end;
end;

procedure TForm1.MinutesStartSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if MinutesCheckBox.Checked = true then
    begin
      {$INCLUDE 'countnewdates.pas'}
    end;
end;

procedure TForm1.SecondsStartSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  if SecondsCheckBox.Checked = true then
    begin
      {$INCLUDE 'countnewdates.pas'}
    end;
end;

procedure TForm1.YearsIncSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  YearsCheckBox.Checked := true;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.MonthsIncSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  MonthsCheckBox.Checked := true;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.DaysIncSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  DaysCheckBox.Checked := true;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.HoursIncSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  HoursCheckBox.Checked := true;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.MinutesIncSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  MinutesCheckBox.Checked := true;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.SecondsIncSpinEditChange(Sender: TObject);
  {$INCLUDE 'vars.pas'}
begin
  SecondsCheckBox.Checked := true;
  {$INCLUDE 'countnewdates.pas'}
end;

procedure TForm1.CloseClick(Sender: TObject);
begin
  filelist.free;
  application.Terminate;
end;

procedure TForm1.PreviewListViewKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  strn: string;
  date: tdatetime;
begin
  case key of

    // Cursor Up
    38: if ssCtrl in Shift then
          begin
            if (filelist.Count > 1) and (previewlistview.ItemIndex > 0) then
              begin
                PreviewListView.Items.BeginUpdate;

                // exchange old date values
                strn := previewlistview.Items.Item[previewlistview.itemindex].SubItems[0];
                previewlistview.Items.Item[previewlistview.itemindex].SubItems[0] := previewlistview.Items.Item[previewlistview.itemindex - 1].SubItems[0];
                previewlistview.Items.Item[previewlistview.itemindex - 1].SubItems[0] := strn;

                // exchange names
                strn := filelist[previewlistview.itemindex];
                filelist[previewlistview.itemindex] := filelist[previewlistview.itemindex - 1];
                filelist[previewlistview.itemindex - 1] := strn;
                PreviewListView.Items.Item[previewlistview.itemindex].Caption := filelist[previewlistview.itemindex];
                PreviewListView.Items.Item[previewlistview.itemindex - 1].Caption := filelist[previewlistview.itemindex - 1];

                previewlistview.Items.EndUpdate;
              end;
          end
        else
          {$INCLUDE 'fillstartfromfields.pas'}

    // Cursor Down
    40: if ssCtrl in Shift then
          begin
            if (filelist.Count > 1) and (previewlistview.ItemIndex < filelist.Count - 1) then
              begin
                PreviewListView.Items.BeginUpdate;

                // exchange old date values
                strn := previewlistview.Items.Item[previewlistview.itemindex].SubItems[0];
                previewlistview.Items.Item[previewlistview.itemindex].SubItems[0] := previewlistview.Items.Item[previewlistview.itemindex + 1].SubItems[0];
                previewlistview.Items.Item[previewlistview.itemindex + 1].SubItems[0] := strn;

                // exchange names
                strn := filelist[previewlistview.itemindex];
                filelist[previewlistview.itemindex] := filelist[previewlistview.itemindex + 1];
                filelist[previewlistview.itemindex + 1] := strn;
                PreviewListView.Items.Item[previewlistview.itemindex].Caption := filelist[previewlistview.itemindex];
                PreviewListView.Items.Item[previewlistview.itemindex + 1].Caption := filelist[previewlistview.itemindex + 1];

                previewlistview.Items.EndUpdate;
              end;
          end
        else
          {$INCLUDE 'fillstartfromfields.pas'}

  else
    {$INCLUDE 'fillstartfromfields.pas'}

  end;
end;

procedure TForm1.StartButtonClick(Sender: TObject);
var
  i: integer;
  handle: integer;
  systime: tsystemtime;
  ft: filetime;
  lt: filetime;

begin
  for i := 0 to filelist.Count - 1 do
    begin
      // try to get a handle for the current file
      handle := fileopen(filelist[i], fmOpenWrite + fmShareDenyNone);
      if handle = -1 then
        begin
          showmessage('Error opening ' + filelist[i]);
          continue;
        end;

      // get the new filetime from the Preview and try to set it
      datetimetosystemtime(strtodatetime(previewlistview.Items.Item[i].SubItems[1]), systime);
      systemtimetofiletime(systime, lt);
      localfiletimetofiletime(lt, ft);
      if setfiletime(handle, NIL, NIL, @ft) = false then
        begin
          showmessage('Error setting time of ' + filelist[i]);
          fileclose(handle);
          continue;
        end;

      fileclose(handle);
    end;

  previewlistview.Items.BeginUpdate;
  for i := 0 to filelist.count - 1 do
//    PreviewListView.Items.Item[i].SubItems[0] := datetimetostr(filedatetodatetime(fileage(filelist.Strings[i])));

        begin
        handle := fileopen(filelist[i], fmOpenWrite);
        if handle = -1 then
          begin
            showmessage('Error opening ' + filelist[i]);
            continue;
          end;

        if getfiletime(handle, NIL, NIL, @ft) = false then
          begin
            showmessage('Error getting timestamp of ' + filelist[i]);
            fileclose(handle);
            continue;
          end;
        fileclose(handle);

        if FileTimeToLocalFileTime(ft, lt) = false then
          begin
            showmessage('FileTimeToLocalFileTime error on file ' + filelist[i]);
            continue;
          end;

        if FileTimeToSystemTime(lt, systime) = false then
          begin
            showmessage('LocalFileTimeToSystemTime error on file ' + filelist[i]);
            continue;
          end;

        PreviewListView.Items.Item[i].SubItems[0] := formatdatetime('ddddd tt', SystemTimeToDateTime(systime));
        end;
  previewlistview.items.EndUpdate;
end;

// this is currently purely for the special randomization and updating on/off purposes
procedure TForm1.FormKeyPress(Sender: TObject; var Key: Char);
{$INCLUDE 'vars.pas'}
begin
  if key = 'r' then
    begin
      PreviewListView.Items.BeginUpdate;
      for i := 0 to filelist.Count - 1 do
        begin
          date := filedatetodatetime(fileage(filelist.Strings[i]));

          // generate a random value between Years Start and (Years Start + Years Inc)
          if yearscheckbox.checked then
            date := recodeyear(date, YearsStartSpinEdit.Value + trunc(random(YearsIncSpinEdit.value + 1)));

          // generate random values between the respective Start and Inc values
          if monthscheckbox.checked then
            date := recodeMonth(date, MonthsStartSpinEdit.Value + trunc(random(MonthsIncSpinEdit.value - MonthsStartSpinEdit.Value + 1)));
          if dayscheckbox.checked then
            date := recodeDay(date, DaysStartSpinEdit.Value + trunc(random(DaysIncSpinEdit.value - DaysStartSpinEdit.Value + 1)));
          if hourscheckbox.checked then
            date := recodeHour(date, HoursStartSpinEdit.Value + trunc(random(HoursIncSpinEdit.value - HoursStartSpinEdit.Value + 1)));
          if minutescheckbox.checked then
            date := recodeMinute(date, MinutesStartSpinEdit.Value + trunc(random(MinutesIncSpinEdit.value - MinutesStartSpinEdit.Value + 1)));
          if secondscheckbox.checked then
            date := recodeSecond(date, SecondsStartSpinEdit.Value + trunc(random(SecondsIncSpinEdit.value - SecondsStartSpinEdit.Value + 1)));
          previewlistview.Items.Item[i].SubItems[1] := formatdatetime('ddddd tt', date);
        end;
      previewlistview.Items.EndUpdate;
    end
  else
    if key = 'u' then
      begin
        autoupdate := not autoupdate;
        if autoupdate = true then
          begin
            AutoupdatingLabel.Caption := 'Auto &updating: ON';
            {$INCLUDE 'countnewdates.pas'}
          end
        else
          AutoupdatingLabel.Caption := 'Auto &updating: OFF';
      end;
end;

// when the user clicks on a file in the Preview and none of the chcekobex are checked then
// fill the Start from fields with the time and date of the clicked file
procedure TForm1.PreviewListViewClick(Sender: TObject);
var
  date: tdatetime;

begin
  {$INCLUDE 'fillstartfromfields.pas'}
end;

end.
