unit addon;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Spin, DateUtils;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    SecondsSpinEdit: TSpinEdit;
    YearsSpinEdit: TSpinEdit;
    MonthsSpinEdit: TSpinEdit;
    DaysSpinEdit: TSpinEdit;
    HoursSpinEdit: TSpinEdit;
    MinutesSpinEdit: TSpinEdit;
    StartButton: TButton;
    CancelButton: TButton;
    procedure CancelButtonClick(Sender: TObject);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormCreate(Sender: TObject);
    procedure StartButtonClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  filelist: tstringlist;

implementation

{$R *.dfm}

procedure ReadFileNames;
var
  fileinfo: tsearchrec;

begin

  // Let's add all the files we can find in the current dir

  if findfirst('*.*', $27, fileinfo) = 0 then
    repeat
      filelist.Add(expandfilename(fileinfo.name));
    until findnext(fileinfo) <> 0;
  findclose(fileinfo);
end;

procedure ProcessDir(startpath: string);
var
  fileinfo: tsearchrec;                         // Used in findfirst / findnext
  i: integer;                                   // Used to check the result of findnext
  curdir: string;                   // To save the name of the dir we're in when going up '..'

begin
  ReadFileNames;                                // Adds all the files in the current dir


  // let's find the first subdir

  findfirst('*.*', $10, fileinfo);
  findnext(fileinfo);
  repeat
    i := findnext(fileinfo);
  until (i <> 0) or (fileinfo.attr and faDirectory <> 0);
  findclose(fileinfo);


  // i determines if subdir was found. 0 means subdir was found, any other value
  // means no subdir found

  // let's keep going deeper and deeper into a subdir and processing each subdir
  // until no further subdir is found (subdir subdir subdir subdir!)

  if i = 0 then
    begin
      chdir(fileinfo.name);
      processdir(startpath);
    end


  // if no deeper subdir is found then let's find out the name of the current dir,
  // go one level higher and see if there are more dirs than the one we were in.
  // If yes, then let's go into them and process them
  // We repeat this until we're not back up in the root (start) path

  else
    if getcurrentdir <> startpath then          // Only do this if we aren't in the startpath
      begin
        repeat
          curdir := copy(getcurrentdir, lastdelimiter('\', getcurrentdir) + 1,
           length(getcurrentdir) - lastdelimiter('\', getcurrentdir));
          chdir('..');
          findfirst('*.*', $10, fileinfo);
          findnext(fileinfo);
          repeat
            findnext(fileinfo);
          until (fileinfo.attr and faDirectory <> 0) and (fileinfo.Name = curdir);
          repeat
            i := findnext(fileinfo);
          until (i <> 0) or (fileinfo.attr and faDirectory <> 0);
        until (i = 0) or (getcurrentdir = startpath);
        findclose(fileinfo);

        if i = 0 then                                     // when subdir is found let's
          begin                                           // process it, otherwise end it
            chdir(fileinfo.name);                         // (and possibly return to where
            processdir(startpath);                        // we were called recursively)
          end;
      end;
end;

procedure TForm1.CancelButtonClick(Sender: TObject);
begin
  application.terminate;
end;

procedure TForm1.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key = 27 then halt;                        // Escape pressed
  if key = 13 then StartButton.Click;           // Enter pressed
end;

procedure TForm1.FormCreate(Sender: TObject);
begin                                           // Check if there is exactly one parameter -
  if paramcount <> 1 then                       // the name of the file that contains a list
    begin                                       // of all the files to be changed
      showmessage('Paramcount <> 1. Exiting.');
      halt;
    end;
  if fileexists(paramstr(1)) = false then       // Check if the list file exists
    begin
      showmessage('List file ''' + paramstr(1) + ''' not found. Exiting.');
      halt;
    end;
end;

procedure TForm1.StartButtonClick(Sender: TObject);
var
  f: textfile;                                  // The list file
  s: string;                                    // Used in readln
  i: cardinal;                                  // Used when iterating over the filelist
  date: tdatetime;                              // Used to store / change the filedates
  handle: integer;
  ft: filetime;
  lt: filetime;
  systime: tsystemtime;

begin
  assignfile(f, paramstr(1));
  reset(f);
  filelist := tstringlist.create;
  filelist.CaseSensitive := false;
  filelist.Sorted := true;                        // Must be true so that the next line works
  filelist.Duplicates := dupIgnore;               // Make sure we don't process a file twice


  // Let's read all the filenames into the filelist

  repeat
    readln(f, s);
    if s[length(s)] <> '\' then                    // Is a file
      begin
        if uppercase(s) <> paramstr(0) then        // Make sure we don't add ourselves
          filelist.Add(s);
      end
    else                                           // Is a dir
      begin
        chdir(s);
        processdir(getcurrentdir);
      end;
  until eof(f);
  closefile(f);

  for i := 0 to filelist.Count - 1 do
    begin
//      date := filedatetodatetime(fileage(filelist[i]));

      handle := fileopen(filelist[i], fmOpenWrite + fmShareDenyNone);
      if handle = -1 then
        begin
          showmessage('Error opening ' + filelist[i]);
          continue;
        end;

      if GetFileTime(handle, NIL, NIL, @ft) = false then
        begin
          showmessage('GetFileTime error on file ' + filelist[i]);
          fileclose(handle);
          continue;
        end;

      if FileTimeToLocalFileTime(ft, lt) = false then
        begin
          showmessage('FileTimeToLocalFileTime error on file ' + filelist[i]);
          fileclose(handle);
          continue;
        end;

      if FileTimeToSystemTime(lt, systime) = false then
        begin
          showmessage('LocalFileTimeToSystemTime error on file ' + filelist[i]);
          fileclose(handle);
          continue;
        end;

      date := systemtimetodatetime(systime);

      date := incyear(date, YearsSpinEdit.Value);
      date := incmonth(date, MonthsSpinEdit.Value);
      date := incday(date, DaysSpinEdit.Value);
      date := inchour(date, HoursSpinEdit.Value);
      date := incminute(date, MinutesSpinEdit.Value);
      date := incsecond(date, SecondsSpinEdit.Value);

      datetimetosystemtime(date, systime);

      if systemtimetofiletime(systime, lt) = false then
        begin
          showmessage('SystemTimetoLocalFileTime error on file ' + filelist[i]);
          fileclose(handle);
          continue;
        end;

      if LocalFileTimeToFileTime(lt, ft) = false then
        begin
          showmessage('LocalFileTimeToFileTime error on file ' + filelist[i]);
          fileclose(handle);
          continue;
        end;

      if setfiletime(handle, NIL, NIL, @ft) = false then
        begin
          showmessage('Error setting time of ' + filelist[i]);
          fileclose(handle);
          continue;
        end;

      fileclose(handle);

//      filesetdate(filelist[i], datetimetofiledate(date));
    end;

  filelist.free;
  application.terminate;
end;

end.
