/*****************************************/
/* Stack Shield 0.4                      */
/* by Vendicator 1999                    */
/*****************************************/
/* File: globalretstack.h                */
/* Stack Shield global RET stack include */
/*****************************************/

const char grsheader[] = 
"#-----------------------------------------\n"
".data\n"
".comm retptr,4,4\n"
".comm rettop,4,4\n"
".comm retarray,<BUFFSIZE>,4\n"
"#-----------------------------------------\n";

const char grsprolog[] =
"#-----------------------------------------\n"
"        movl retptr,%eax\n"
"        cmpl %eax,rettop\n"
"        jbe .LSHIELDPROLOG<PROLOGCOUNT>\n"
"        movl 4(%ebp),%edx\n"
"        movl %edx,(%eax)\n"
".LSHIELDPROLOG<PROLOGCOUNT>:\n"
"        addl $4,retptr\n"
"#-----------------------------------------\n";

const char grsepilog[] =
"#-----------------------------------------\n"
"        addl $-4,retptr\n"
"        movl retptr,%ebx\n"
"        cmpl %ebx,rettop\n"
"        jbe .LSHIELDEPILOG<EPILOGCOUNT>\n"
"        movl (%ebx),%edx\n"
"        movl %edx,4(%ebp)\n"
".LSHIELDEPILOG<EPILOGCOUNT>:\n"
"#-----------------------------------------\n";

const char grsmainprolog[] =
"#-----------------------------------------\n"
"        movl $retarray,retptr\n"
"        movl $retarray,rettop\n"
"        addl $<BUFFSIZE>,rettop\n"
"#-----------------------------------------\n";

const char grsdetectattackepilog[] =
"#-----------------------------------------\n"
"        addl $-4,retptr\n"
"        movl retptr,%ebx\n"
"        cmpl %ebx,rettop\n"
"        jbe .LSHIELDEPILOG<EPILOGCOUNT>\n"
"       movl (%ebx),%edx\n"
"       cmpl %edx,4(%ebp)\n"
"	je .LSHIELDEPILOG<EPILOGCOUNT>\n"
"	movl $1,%eax\n"
"	movl $-1,%ebx\n"
"	int $0x80\n"
".LSHIELDEPILOG<EPILOGCOUNT>:\n"
"#-----------------------------------------\n";

const char grsanticrashprolog[] =
"#-----------------------------------------\n"
"	cmpl $0xFFFFFFFF,retptr\n"
"	je .LSHIELDANTICRASHPROLOG<PROLOGCOUNT>\n"
"       movl retptr,%eax\n"
"       cmpl %eax,rettop\n"
"       jbe .LSHIELDPROLOG<PROLOGCOUNT>\n"
"       movl 4(%ebp),%edx\n"
"       movl %edx,(%eax)\n"
".LSHIELDPROLOG<PROLOGCOUNT>:\n"
"       addl $4,retptr\n"
".LSHIELDANTICRASHPROLOG<PROLOGCOUNT>:\n"
"#-----------------------------------------\n";

const char grsanticrashepilog[] =
"#-----------------------------------------\n"
"	cmpl $0xFFFFFFFF,retptr\n"
"	je .LSHIELDEPILOG<EPILOGCOUNT>\n"
"#-----------------------------------------\n";

