/*****************************************/
/* Stack Shield v0.3                     */
/* by Vendicator 1999                    */
/*****************************************/
/* File: stackshield.c                   */
/* Stack Shield file protection program  */
/*****************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

void usage(char *progname);
void initerror(char *filename);
void parsefile(FILE *srcptr, FILE *destptr, FILE *tmpptr);
void doprolog(FILE *fileptr);
void doepilog(FILE *fileptr);

int prologcount = 0;
int epilogcount = 0;

void usage(char *progname) {
  fprintf(stderr, "Usage: %s srcfile destfile\n", progname);
  fprintf(stderr, "Where:\n");
  fprintf(stderr, "srcfile is the input assembly file\n");
  fprintf(stderr, "destfile is the output assembly file\n");

  exit(EXIT_FAILURE);
}

void initerror(char *filename) {
  fprintf(stderr, "Error while initializing %s\n", filename);

  exit(EXIT_FAILURE);
}

void doprolog(FILE *fileptr) {
  FILE *dataptr;
  char line[257];
  char buffer[257];
  char label[257];
  char *tmp;

  dataptr=fopen("../lib/prolog.s", "r");

  prologcount++;
  line[256]='\0';
  buffer[256]='\0';
  label[256]='\0';
  while (fgets(line, 256, dataptr)) {
    if (tmp=strstr(line, ".SHIELDPROLOG1")) {
      strncpy(buffer, tmp, 256);
      snprintf(label, 256, ".SHIELDPROLOG%d", prologcount);
      strncpy(tmp, label, strlen(label));
      strncpy(tmp+strlen(label), buffer+strlen(".SHIELDPROLOG1"),
        strlen(buffer+strlen(".SHIELDPROLOG1")));
    }
    fprintf(fileptr, "%s", line);
  }
  fclose(dataptr);
}

void doepilog(FILE *fileptr) {
  FILE *dataptr;
  char line[257];
  char buffer[257];
  char label[257];
  char *tmp;

  dataptr=fopen("../lib/epilog.s", "r");

  epilogcount++;
  line[256]='\0';
  buffer[256]='\0';
  label[256]='\0';
  while (fgets(line, 256, dataptr)) {
    if (tmp=strstr(line, ".SHIELDEPILOG1")) {
      strncpy(buffer, tmp, 256);
      snprintf(label, 256, ".SHIELDEPILOG%d", prologcount);
      strncpy(tmp, label, strlen(label));
      strncpy(tmp+strlen(label), buffer+strlen(".SHIELDEPILOG1"),
        strlen(buffer+strlen(".SHIELDEPILOG1")));
    }
    fprintf(fileptr, "%s", line);
  }
  fclose(dataptr);
}

void parsefile(FILE *srcptr, FILE *destptr, FILE *tmpptr) {
  char line[257];

  line[256]='\0';
  while (fgets(line, 257, tmpptr)) {
    if (strstr(line, "pushl %ebp")) {
      fprintf(destptr, "%s", line);
      fgets(line, 257, tmpptr);
      if (strstr(line, "movl %esp,%ebp")) {
        fprintf(destptr, "%s", line);
        doprolog(destptr);
      }
    }
    else if (strstr(line, "movl %ebp,%esp")) {
      fgets(line, 257, tmpptr);
      if (strstr(line, "popl %ebp")) {
        fgets(line, 257, tmpptr);
        if (strstr(line, "ret")) {
	  doepilog(destptr);
	  fprintf(destptr, "	%s\n", "movl %ebp,%esp");
	  fprintf(destptr, "	%s\n", "popl %ebp");
  	  fprintf(destptr, "	%s\n", "ret");
        }
      }
    }
    else
    fprintf(destptr, "%s", line);
  }
}

int main(int argc, char **argv) {
  char srcfile[257];
  char destfile[257];
  char tmpfile[257];
  char cmdline[1024];
  FILE *srcptr, *destptr, *tmpptr;

  if (argc < 3)
    usage(argv[0]);
  strncpy(srcfile, argv[1], 257);
  strncpy(destfile, argv[2], 257);
  strncpy(tmpfile, tmpnam(NULL), 257);
  srcfile[256]=destfile[256]=tmpfile[256]='\0';

  if ((srcptr=fopen(srcfile, "r")) == NULL) {
    fprintf(stderr, "Error: cannot read %s\n", srcfile);
    exit(EXIT_FAILURE);
  }

  sprintf(cmdline, "cp ../lib/prefile.s %s", tmpfile);
  if (system(cmdline)) initerror(tmpfile);
  sprintf(cmdline, "cat %s >> %s", srcfile, tmpfile);
  if (system(cmdline)) initerror(tmpfile);
  sprintf(cmdline, "cat ../lib/postfile.s >> %s", tmpfile);
  if (system(cmdline)) initerror(tmpfile);

  if ((tmpptr=fopen(tmpfile, "r")) == NULL) {
    fprintf(stderr, "Error: cannot read temporany file %s\n", tmpfile);
    exit(EXIT_FAILURE);
  }

  if ((destptr=fopen(destfile, "w")) == NULL) {
    fprintf(stderr, "Error: cannot create %s\n", destfile);
    exit(EXIT_FAILURE);
  }

  parsefile(srcptr, destptr, tmpptr);
  
  fclose(srcptr);
  fclose(destptr);
  fclose(tmpptr);
  remove(tmpfile);

  if (prologcount != epilogcount) {
    fprintf(stderr, "Warning: prologs and epilogs counts are different\n");
    fprintf(stderr, "Prologs: %d, epilogs: %d\n", prologcount, epilogcount);
    fprintf(stderr, "The output program may not work\n");
    exit(EXIT_FAILURE);
  }

  exit(EXIT_SUCCESS);
}