/************************************************************

Program:        Calculator

File:           Calculator.cpp

Function(s):    main(), Math::addition(), Math::subtraction()
                Math::multiplication(), Math::division(), remainder(),
                output(), findArea(), setPi(), getPi()

Description:    Performs simple calculations

Author(s):      Jeff Foster (jf)

Environment:    Dev C++ version 4.9.6.0

Updates and Notes:      0.50  4/14/03 (jf) Initial Work
                        1.00  4/15/03 (jf) First Release
                        1.10  4/16/03 (jf) Fixed Runtime Error
                        and added basic area formulas, fixed 
                        casting error for circle area
         -----> Changed all necissary int variables to type float <-----
                        1.11  4/19/03 (jf) Added Math class definition 
                        in resource file, began work on trig... needs work!
                        1.115 4/21/03 (jf) Added cool borders and pretty 
                        colors. Yay!

Work Plan (to do list): Add Quadratic Formula
                        Add Logarithims
                        Repair Runtime error that occurs when interger
                        is input for type char variables            
              
************************************************************/

#include "calc.hpp"
//Math remainder function (unused)
inline float remainder( float , float );
//Program instructions and information
void output(); 
//Area 
void findArea();
//Trig
void solveTrig();
//Cool introduction thingy
void intro();

int main()
{
  
  Math Object; //Creates an object from the Math class
  float number, number2, answer, dividedNumber/*, remain*/;
  char operation[20], doNext[20] = "null";
  char plus[] = "plus", minus[] = "minus", multiply[] = "multiply", divide[] = "divide";
  char quit[] = "quit", area[] = "area", operations[] = "operations", instructions[] = "instructions",
  trig[] = "trig";
  intro();
  while (strcmp ( doNext , quit ) != 0 ) 
  {
    cout << "( instructions/area/trig/operations/quit ): ";
    cin >> doNext;
    if(strcmp ( doNext , instructions ) == 0)
      output();
    if(strcmp (doNext , trig ) == 0 )
      /*solveTrig();*/
      cout << "\nTemporarily unavailable. Sorry.\n\n";
    if(strcmp ( doNext , area ) == 0)
      findArea();
    if(strcmp ( doNext , operations ) == 0 )
    { 
      cout << "\nEnter first number: ";
      cin >> number;
      if( number >= 65535 )
      {
        double(number);
        cout <<"\nRe-Enter number: ";
        cin >> number;
      }
      cout << "\nEnter operation: ";
      cin >> operation;
      cout << "\nEnter second number: ";
      cin >> number2;
      if( number2 >= 65535 )
      {
        double(number2);
        cout <<"\nRe-Enter number: ";
        cin >> number2;
      }
  //////////////////////
  //Find operation
  //Send variables to operation functions
  //Display Answer
  ///////////////////////
      if  ( strcmp ( operation , plus ) == 0 )
      {
          answer = Object.addition( number , number2 );
          cout << "\nAnswer: " << answer << "\n\n";
      }
      if  ( strcmp ( operation , minus ) == 0 )
      {
          answer = Object.subtraction( number , number2 );
          cout << "\nAnswer: " << answer << "\n\n";
      }
      if  ( strcmp ( operation , multiply ) == 0 )
      {
          answer = Object.multiplication( number , number2 );
          cout << "\nAnswer: " << answer << "\n\n";
      }
      if  ( strcmp ( operation , divide ) == 0 )
      {
          dividedNumber = Object.division( number , number2 );
          /*remain = remainder( number , number2 );*/
          cout << "\nAnswer: " << dividedNumber /*<<" " << remain << "/" << number2*/ << "\n\n";
      }
      //Make sure that one of the operations was selected
      if ((strcmp(operation , plus) != 0) && (strcmp(operation , minus) != 0)
      && (strcmp(operation , divide) != 0) && (strcmp(operation, multiply) != 0))
          cout << "\nError!\n\n";
      cout << "\n-------------------------";
      cout << "\noperation: " << operation << "\n\n"; //Verify operation
      } //Loop terminates if doNext == quit
    //Make sure that one of the menu options was selected
    if ((strcmp(doNext , instructions) != 0) && (strcmp(doNext , area) != 0)
    && (strcmp(doNext , operations) != 0) && (strcmp(doNext, quit) != 0)
    && (strcmp(doNext, trig) != 0))
      cout << "\nError!\n\n";
    }
  MessageBox(NULL, "Thanks for using Calculator", "Calculator", MB_OK);
  return 0;
}

//setPi function for accessing Pi variable in the Math class
float Math::setPi( float Pi )
{
  itsPi = Pi;
}

//remainder function for division
/*float remainder( float number, float number2 )
{
  return( int(number) % int(number2) );
}*/
//Output function
void output()
{
    textcolor(14);
    cout << "\n--------------------------------------------------";
    cout << "\nTo use this calculator first select the problem type,\n";
    cout << "then follow the instructions provided. To use the simple\n";
    cout <<"calculations option first enter a number\n";
    cout << "Then enter an operation: (plus, minus, multiply, devide)\n";
    cout << "Finally enter the second number and it will calculate it for you.";
    cout << "\n--------------------------------------------------\n\n";
    textcolor(15);
}

//Area function used to compute areas
void findArea()
{
  Math Object; //Define Object in the math class
  Object.setPi(3.1415926536); //calling of setPi function
  float base, base2, height, width, radius, answer, temp;
  char box[] = "box", cube[] = "cube", trapezoid[] = "trapezoid", triangle[] = "triangle",
  circle[] = "circle";
  char type[20];
  cout << "\nFind the area of: ( box/cube/trapezoid/circle/triangle ): ";
  cin >> type;
  if(strcmp( type , box ) == 0 ) //Area for box
  {
      cout <<"\nEnter width: ";
      cin >> width;
      cout <<"\nEnter height: ";
      cin >> height;
      answer = Object.multiplication( width , height );
      cout <<"\nArea:" << answer <<"\n\n"; 
  }
  if(strcmp( type , cube ) == 0 ) //Area for cube
  {
    cout <<"\nEnter width: ";
    cin >> width;
    cout <<"\nEnter height: ";
    cin >> height;
    cout <<"\nEnter length: ";
    cin >> base;
    answer = ( width * height * base );
    cout <<"\nArea: " << answer <<"\n\n";
  }  
  if(strcmp( type , trapezoid ) == 0 )  //Area for trapezoid
  {
    cout <<"\nEnter base: ";
    cin >> base;
    cout <<"\nEnter base2: ";
    cin >> base2;
    cout <<"\nEnter height: ";
    cin >> height;
    temp = Object.addition( base , base2 );
    temp = Object.multiplication( temp , height );
    answer = temp / 2;
    /*temp = int(temp) % 2;*/
    cout <<"\nArea: " << answer /*<<" " << temp */<<"\n\n";
  }
  if(strcmp( type , triangle ) == 0 ) //Area for triangle
  {
    cout <<"\nEnter base: ";
    cin >> base;
    cout <<"\nEnter height: ";
    cin >> height;
    answer = Object.multiplication( base , height );
    /*temp = int(answer) % 2;*/
    answer = answer / 2;
    cout <<"\nArea: " << answer /*<<" " << temp */<<"\n\n";
  }
  if(strcmp( type , circle ) == 0 ) //area for circle
  {
    cout << "\nEnter radius: ";
    cin >> radius;
    float(answer) = radius * radius;
    answer = radius * Object.getPi();
    cout <<"\nArea: " << answer <<"\n\n";
  }
  if ((strcmp(type , box) != 0) && (strcmp(type , cube) != 0)
  && (strcmp(type , circle) != 0) && (strcmp(type, trapezoid) != 0)
  && (strcmp(type, triangle) != 0))
    cout << "\nError!\n\n";
}

void solveTrig()
{
  Math Object;
  float number, number2, angle, side, hypotenuse, temp, answer;
  char sine[] = "sine", cosine[] = "cosine", tangent[] = "tangent";
  char fAngle[] = "angle", fSide[] = "side";
  char trigSelection[20];
  cout << "\n(sine/cosine/tangent): ";
  cin >> trigSelection;
  if(strcmp ( trigSelection , cosine ) == 0 )
  {
    cout << "\nSolve for (angle/side/hypotenuse ): ";
    cin >> trigSelection;
    if(strcmp ( trigSelection , fAngle ) == 0 )
    {
      cout << "\nEnter side length: ";
      cin >> side;
      cout << "\nEnter hypotenuse: ";
      cin >> hypotenuse;
      temp = Object.division( side , hypotenuse );
      cout << temp;
      angle = acos( temp ); //function added by math.h
      cout <<"\nAngle: " << angle << "\n\n";
    }
  if(strcmp ( trigSelection , fSide ) == 0 )
    {
      cout << "\nEnter angle: ";
      cin >> angle;
      cout << "\nEnter hypotenuse: ";
      cin >> hypotenuse;
      temp = cos( angle ); //function added by math.h
      cout << temp;
      side = Object.multiplication( temp , hypotenuse );
      cout <<"\nSide: " << side << "\n\n";
    }
  }  
}

//Really cool box thingy with borders. hehe.
void intro()
{
  textcolor(14); //yellow
  gotoxy(17,2);cout << "ͻ"; //top part of rectangle
  gotoxy(17,3);cout << "                                            "; //sides
  gotoxy(17,4);cout << "                                            ";
  gotoxy(17,5);cout << "                                            ";
  gotoxy(17,6);cout << "                                            ";
  gotoxy(17,7);cout << "                                            ";
  gotoxy(17,8);cout << "                                            ";
  gotoxy(17,9);cout << "                                            ";
  gotoxy(17,10);cout << "                                            ";
  gotoxy(17,11);cout << "ͼ"; //bottom
  textcolor(15); //white
  gotoxy(34,5);cout << "Calculator";
  gotoxy(17,6);cout << "==============================================";
  gotoxy(33,7);cout << "Version 1.11";
  textcolor(3);
  gotoxy(1,3);cout << "";
  gotoxy(1,10);cout << "";
  gotoxy(62,3);cout << "";
  gotoxy(62,10);cout << "";
  textcolor(15);
  gotoxy(1,13); //cursor point for the remainder of the program
}
