/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class Understanding {

    public static class MapStore
    extends MapEntry {
        protected Vector children = new Vector();

        public Vector getChildren() {
            return this.children;
        }

        public void setChildren(Vector vector) {
            this.children = vector;
        }

        public MapStore(String string) {
            super(string);
        }

        public void add(MapEntry mapEntry) {
            mapEntry.setParent(this);
            this.children.add(mapEntry);
        }

        public void delete(MapEntry mapEntry) {
            this.children.remove(mapEntry);
            mapEntry.setParent(null);
        }

        public void delete(String string) {
            MapEntry mapEntry = this.get(string);
            if (mapEntry == null) {
                return;
            }
            MapStore mapStore = mapEntry.getParent();
            if (mapStore == null) {
                return;
            }
            mapStore.delete(mapEntry);
        }

        public Enumeration getEnumeration(String string) {
            int n = string.indexOf("*");
            if (n == -1) {
                throw new IllegalArgumentException("Spec must contain an asterisk(*).");
            }
            if (n <= 0 || string.charAt(n - 1) != '.') {
                throw new IllegalArgumentException("Illegal path.");
            }
            String string2 = string.substring(0, n - 1);
            String string3 = n < string.length() - 2 && string.charAt(n + 1) == '.' ? string.substring(n + 2) : null;
            MapStore mapStore = (MapStore)this.get(string2);
            if (mapStore == null) {
                return null;
            }
            Enumeration enumeration = mapStore.getChildren().elements();
            Enumeration enumeration2 = new Enumeration(this, enumeration, string3){
                private final /* synthetic */ Enumeration val$e;
                private final /* synthetic */ String val$gpath;
                private final /* synthetic */ MapStore this$0;
                {
                    this.this$0 = mapStore;
                    this.val$e = enumeration;
                    this.val$gpath = string;
                }

                public boolean hasMoreElements() {
                    return this.val$e.hasMoreElements();
                }

                public Object nextElement() {
                    MapStore mapStore = (MapStore)this.val$e.nextElement();
                    if (this.val$gpath != null) {
                        return mapStore.get(this.val$gpath);
                    }
                    return mapStore;
                }
            };
            return enumeration2;
        }

        public MapEntry get(StringTokenizer stringTokenizer) {
            String string = stringTokenizer.nextToken();
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                MapEntry mapEntry = (MapEntry)enumeration.nextElement();
                if (!mapEntry.getName().equalsIgnoreCase(string)) continue;
                if (stringTokenizer.hasMoreTokens()) {
                    if (mapEntry instanceof MapStore) {
                        return ((MapStore)mapEntry).get(stringTokenizer);
                    }
                    return null;
                }
                return mapEntry;
            }
            return null;
        }

        public MapEntry get(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
            if (stringTokenizer.hasMoreTokens()) {
                return this.get(stringTokenizer);
            }
            return this;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getName() + "{ ");
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                MapEntry mapEntry = (MapEntry)enumeration.nextElement();
                stringBuffer.append(mapEntry.getName());
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
            stringBuffer.append(" }");
            return stringBuffer.toString();
        }

        public void dump() {
            System.out.println(this.getName() + "{ ");
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                MapEntry mapEntry = (MapEntry)enumeration.nextElement();
                mapEntry.dump();
                System.out.println();
            }
            System.out.print(" }");
        }
    }

    public static class LookupMapStore
    extends IndexMapStore {
        protected LookupList ll;

        public LookupMapStore(int n, LookupList lookupList) {
            super(n);
            this.ll = lookupList;
        }

        public String getName() {
            return this.ll.lookup(this.index);
        }
    }

    public static class IndexMapStore
    extends MapStore {
        protected int index;

        public String getName() {
            return new Integer(this.index).toString();
        }

        public IndexMapStore(int n) {
            super(null);
            this.index = n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getName() + ". ");
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                MapEntry mapEntry = (MapEntry)enumeration.nextElement();
                stringBuffer.append(mapEntry.getName());
                if (!enumeration.hasMoreElements()) continue;
                stringBuffer.append(", ");
            }
            return stringBuffer.toString();
        }

        public void dump() {
            System.out.print(this.getName() + ". ");
            Enumeration enumeration = this.children.elements();
            while (enumeration.hasMoreElements()) {
                MapEntry mapEntry = (MapEntry)enumeration.nextElement();
                mapEntry.dump();
                if (!enumeration.hasMoreElements()) continue;
                System.out.print(", ");
            }
            System.out.println();
        }
    }

    public static class StringEntry
    extends VoidEntry {
        public StringEntry(String string, byte[] byArray) {
            super(string, byArray);
        }

        public String toString() {
            byte[] byArray = this.getData();
            StringBuffer stringBuffer = new StringBuffer(this.getName() + ": ");
            int n = 0;
            while (n < byArray.length) {
                stringBuffer.append((char)byArray[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    public static class STProtectedStringEntry
    extends VoidEntry {
        public STProtectedStringEntry(String string, byte[] byArray) {
            super(string, byArray);
        }

        public String toString() {
            byte[] byArray = this.getData();
            StringBuffer stringBuffer = new StringBuffer(this.getName() + ": ");
            int n = 0;
            while (n < byArray.length) {
                int n2 = byArray.length - n - 1;
                int n3 = byArray[n2] & 0xFF;
                int n4 = 255 - n3 - n;
                stringBuffer.append((char)n4);
                ++n;
            }
            return stringBuffer.toString();
        }
    }

    public static class VoidEntry
    extends MapEntry {
        private byte[] data;

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] byArray) {
            this.data = byArray;
        }

        public VoidEntry(String string, byte[] byArray) {
            super(string);
            this.data = byArray;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.getName() + ": ");
            int n = 0;
            while (n < this.data.length) {
                if (n >= 16) {
                    stringBuffer.append("...");
                    break;
                }
                stringBuffer.append(VoidEntry.hexByte(this.data[n]) + " ");
                ++n;
            }
            return stringBuffer.toString();
        }

        private static String hexByte(byte by) {
            String string = "00" + Integer.toHexString(by & 0xFF);
            string = string.substring(string.length() - 2);
            return string;
        }
    }

    public static class MapEntry {
        private MapStore parent = null;
        private String name_;
        private Parser parser;

        public MapStore getParent() {
            return this.parent;
        }

        public void setParent(MapStore mapStore) {
            this.parent = mapStore;
        }

        public String getName() {
            return this.name_;
        }

        public void setName(String string) {
            this.name_ = string;
        }

        public MapEntry(String string) {
            this.name_ = string;
        }

        public Parser getParser() {
            return this.parser;
        }

        public void setParser(Parser parser) {
            this.parser = parser;
        }

        public String get() {
            return null;
        }

        public String toString() {
            return this.name_;
        }

        public void dump() {
            System.out.print(this.toString());
        }
    }

    public static class IDParser
    extends Parser {
        private String value = null;

        public IDParser(String string) {
            super(string);
        }

        public IDParser(String string, String string2) {
            super(string);
            this.value = string2;
        }

        public boolean parse(DataStore dataStore, MapStore mapStore) {
            byte[] byArray = new byte[4];
            dataStore.read(byArray);
            String string = new String(byArray);
            if (this.value != null && !this.value.equals(string)) {
                return false;
            }
            IDEntry iDEntry = new IDEntry(this.getName(), string);
            mapStore.add(iDEntry);
            iDEntry.setParser(this);
            return true;
        }

        public MapEntry create(Object object) {
            String string = "UNKN";
            if (object != null) {
                string = (String)object;
            }
            IDEntry iDEntry = new IDEntry(this.getName(), string);
            iDEntry.setParser(this);
            return iDEntry;
        }

        public boolean write(DataStore dataStore, MapEntry mapEntry) {
            IDEntry iDEntry = (IDEntry)mapEntry;
            if (iDEntry == null) {
                return false;
            }
            byte[] byArray = iDEntry.getData().getBytes();
            dataStore.write(byArray);
            return true;
        }

        public static class IDEntry
        extends MapEntry {
            private String data;

            public String getData() {
                return this.data;
            }

            public void setData(String string) {
                this.data = string;
            }

            public IDEntry(String string, String string2) {
                super(string);
                this.data = string2;
            }

            public String get() {
                return this.getData();
            }

            public String toString() {
                return this.getName() + ": " + this.data;
            }
        }
    }

    public static class ByteParser
    extends NumericParser {
        public ByteParser(String string) {
            super(string);
        }

        public ByteParser(String string, int n) {
            super(string, n);
        }

        public ByteParser(String string, LookupList lookupList) {
            super(string, lookupList);
        }

        protected int readValue(DataStore dataStore) {
            return dataStore.readByte();
        }

        protected void writeValue(DataStore dataStore, int n) {
            dataStore.writeByte(n);
        }
    }

    public static class WordParser
    extends NumericParser {
        public WordParser(String string) {
            super(string);
        }

        public WordParser(String string, int n) {
            super(string, n);
        }

        public WordParser(String string, LookupList lookupList) {
            super(string, lookupList);
        }

        protected int readValue(DataStore dataStore) {
            return dataStore.readWord();
        }

        protected void writeValue(DataStore dataStore, int n) {
            dataStore.writeWord(n);
        }
    }

    public static class IntParser
    extends NumericParser {
        public IntParser(String string) {
            super(string);
        }

        public IntParser(String string, int n) {
            super(string, n);
        }

        public IntParser(String string, LookupList lookupList) {
            super(string, lookupList);
        }

        protected int readValue(DataStore dataStore) {
            return dataStore.readInt();
        }

        protected void writeValue(DataStore dataStore, int n) {
            dataStore.writeInt(n);
        }
    }

    public static class MultiValueParser
    extends NumericParser {
        private int[] values;

        public MultiValueParser(String string, int[] nArray, LookupList lookupList) {
            super(string, lookupList);
            this.values = nArray;
        }

        public MultiValueParser(String string, int[] nArray) {
            super(string);
            this.values = nArray;
        }

        protected int readValue(DataStore dataStore) {
            return dataStore.readByte();
        }

        protected void writeValue(DataStore dataStore, int n) {
            dataStore.writeByte(n);
        }

        public boolean validate(int n) {
            int n2 = 0;
            while (n2 < this.values.length) {
                if (n == this.values[n2]) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }

    public static abstract class NumericParser
    extends Parser {
        private int value;
        private boolean constValue = false;
        protected LookupList ll;

        public NumericParser(String string) {
            super(string);
        }

        public NumericParser(String string, LookupList lookupList) {
            super(string);
            this.ll = lookupList;
        }

        public NumericParser(String string, int n) {
            super(string);
            this.constValue = true;
            this.value = n;
        }

        protected abstract int readValue(DataStore var1);

        protected abstract void writeValue(DataStore var1, int var2);

        public boolean validate(int n) {
            if (this.constValue && this.value != n) {
                return false;
            }
            return n != -1;
        }

        public boolean parse(DataStore dataStore, MapStore mapStore) {
            int n = this.readValue(dataStore);
            if (!this.validate(n)) {
                return false;
            }
            NumericEntry numericEntry = new NumericEntry(this.getName(), n);
            numericEntry.setLookupList(this.ll);
            numericEntry.setParser(this);
            mapStore.add(numericEntry);
            return true;
        }

        public MapEntry create(Object object) throws CreationException {
            int n = 0;
            if (object instanceof Integer) {
                if (object != null) {
                    n = (Integer)object;
                }
            } else if (object instanceof String) {
                if (this.ll != null) {
                    n = this.ll.getValue((String)object);
                    if (n == -1) {
                        throw new CreationException(this.getName() + " unable to find value '" + object + "'");
                    }
                } else {
                    try {
                        n = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new CreationException(this.getName() + " unable to parse value '" + object + "'");
                    }
                }
            }
            if (this.validate(n)) {
                NumericEntry numericEntry = new NumericEntry(this.getName(), n);
                numericEntry.setLookupList(this.ll);
                numericEntry.setParser(this);
                return numericEntry;
            }
            throw new CreationException(this.getName() + " unable to accept value " + object + "(" + n + ")");
        }

        public boolean write(DataStore dataStore, MapEntry mapEntry) {
            NumericEntry numericEntry = (NumericEntry)mapEntry;
            if (numericEntry == null) {
                return false;
            }
            int n = numericEntry.intValue();
            this.writeValue(dataStore, n);
            return true;
        }
    }

    public static class NumericEntry
    extends MapEntry {
        private LookupList ll;
        private int data;

        public LookupList getLookupList() {
            return this.ll;
        }

        public void setLookupList(LookupList lookupList) {
            this.ll = lookupList;
        }

        public NumericEntry(String string, int n) {
            super(string);
            this.data = n;
        }

        public int intValue() {
            return this.data;
        }

        public void setInt(int n) {
            this.data = n;
        }

        public String get() {
            if (this.ll != null) {
                return this.ll.lookup(this.data);
            }
            return new Integer(this.data).toString();
        }

        public String toString() {
            if (this.ll != null) {
                return this.getName() + ": " + this.ll.lookup(this.data) + "(" + this.data + ")";
            }
            return this.getName() + ": " + this.data;
        }
    }

    public static class TableLookupList
    extends LookupList {
        private String[] list;

        public TableLookupList(String[] stringArray) {
            this.list = stringArray;
        }

        public String lookup(int n) {
            if (n >= 0 && n < this.list.length) {
                return this.list[n];
            }
            return "Unknown";
        }

        public int getValue(String string) {
            int n = 0;
            while (n < this.list.length) {
                if (this.list[n].equals(string)) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
    }

    public static abstract class LookupList {
        public abstract String lookup(int var1);

        public abstract int getValue(String var1);
    }

    public static class RestParser
    extends ElementParser {
        public RestParser(String string) {
            super(string, -1);
        }

        public boolean parse(DataStore dataStore, MapStore mapStore) {
            int n = dataStore.getCount() - dataStore.getPos();
            byte[] byArray = new byte[n];
            try {
                dataStore.read(byArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            VoidEntry voidEntry = new VoidEntry(this.getName(), byArray);
            mapStore.add(voidEntry);
            voidEntry.setParser(this);
            return true;
        }
    }

    public static class StringParser
    extends ElementParser {
        public StringParser(String string, int n) {
            super(string, n);
        }

        public StringParser(String string, String string2) {
            super(string, string2);
        }

        protected MapEntry getEntry(byte[] byArray) {
            return new StringEntry(this.getName(), byArray);
        }
    }

    public static class STProtectedStringParser
    extends ElementParser {
        public STProtectedStringParser(String string, int n) {
            super(string, n);
        }

        public STProtectedStringParser(String string, String string2) {
            super(string, string2);
        }

        protected MapEntry getEntry(byte[] byArray) {
            return new STProtectedStringEntry(this.getName(), byArray);
        }
    }

    public static class ElementParser
    extends Parser {
        private int length;
        private byte[] value = null;
        private String lenref = null;

        public ElementParser(String string, int n) {
            super(string);
            this.length = n;
        }

        public ElementParser(String string, String string2) {
            super(string);
            this.lenref = string2;
        }

        public ElementParser(String string, byte[] byArray) {
            super(string);
            this.length = byArray.length;
            this.value = byArray;
        }

        public boolean parse(DataStore dataStore, MapStore mapStore) {
            Object object;
            if (this.lenref != null) {
                object = (NumericEntry)mapStore.get(this.lenref);
                this.length = ((NumericEntry)object).intValue();
                int n = dataStore.getCount() - dataStore.getPos();
                if (this.length < 0 || this.length > n) {
                    this.length = n;
                }
            }
            object = new byte[this.length];
            try {
                dataStore.read((byte[])object);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (this.value != null) {
                int n = 0;
                while (n < ((Object)object).length) {
                    if (object[n] != this.value[n]) break;
                    ++n;
                }
                if (n < ((Object)object).length) {
                    return false;
                }
            }
            MapEntry mapEntry = this.getEntry((byte[])object);
            mapStore.add(mapEntry);
            mapEntry.setParser(this);
            return true;
        }

        protected MapEntry getEntry(byte[] byArray) {
            return new VoidEntry(this.getName(), byArray);
        }

        public boolean write(DataStore dataStore, MapEntry mapEntry) {
            VoidEntry voidEntry = (VoidEntry)mapEntry;
            if (voidEntry == null) {
                return false;
            }
            byte[] byArray = voidEntry.getData();
            dataStore.write(byArray);
            return true;
        }

        public MapEntry create(Object object) throws CreationException {
            if (object == null) {
                if (this.value == null) {
                    if (this.length != -1) {
                        byte[] byArray = new byte[this.length];
                        MapEntry mapEntry = this.getEntry(byArray);
                        mapEntry.setParser(this);
                        return mapEntry;
                    }
                    throw new CreationException("Unable to create VoidElements of variable length.");
                }
                throw new CreationException("Unable to create VoidElement without data.");
            }
            if (object instanceof byte[]) {
                MapEntry mapEntry = this.getEntry((byte[])object);
                mapEntry.setParser(this);
                return mapEntry;
            }
            throw new CreationException("Unable to create VoidElements from " + object.getClass() + ".");
        }
    }

    public static class LookupListParser
    extends IndexListParser {
        private LookupList ll;

        public LookupListParser(String string, Parser parser, LookupList lookupList) {
            super(string, parser);
            this.ll = lookupList;
        }

        public LookupListParser(String string, Parser parser, int n, LookupList lookupList) {
            super(string, parser, n);
            this.ll = lookupList;
        }

        protected MapStore getStore(int n) {
            return new LookupMapStore(n, this.ll);
        }
    }

    public static class IndexListParser
    extends NodeParser {
        private Parser element;
        private int count = -1;

        public IndexListParser(String string, Parser parser) {
            super(string);
            this.element = parser;
        }

        public IndexListParser(String string, Parser parser, int n) {
            super(string);
            this.element = parser;
            this.count = n;
        }

        public boolean parse(DataStore dataStore, MapStore mapStore) {
            MapStore mapStore2 = new MapStore(this.getName());
            mapStore.add(mapStore2);
            mapStore2.setParser(this);
            int n = 0;
            while ((this.count == -1 || n < this.count) && dataStore.getPos() < dataStore.getCount()) {
                int n2 = dataStore.getPos();
                MapStore mapStore3 = this.getStore(n);
                mapStore3.setParser(this);
                if (!this.element.parse(dataStore, mapStore3)) {
                    dataStore.setPos(n2);
                    break;
                }
                mapStore2.add(mapStore3);
                ++n;
            }
            return n > 0;
        }

        protected void addListDirect(MapStore mapStore, MapEntry[] mapEntryArray) throws CreationException {
            MapStore mapStore2;
            if (this.count != -1 && mapEntryArray.length > this.count) {
                throw new CreationException("Object list length exceeds count (" + mapEntryArray.length + ">" + this.count + ")");
            }
            int n = 0;
            while (n < mapEntryArray.length) {
                mapStore2 = this.getStore(n);
                mapStore2.setParser(this);
                if (mapEntryArray[n] != null) {
                    mapStore2.add(mapEntryArray[n]);
                } else {
                    mapStore2.add(this.element.create());
                }
                mapStore.add(mapStore2);
                ++n;
            }
            if (this.count != -1) {
                while (n < this.count) {
                    mapStore2 = this.getStore(n);
                    mapStore2.setParser(this);
                    mapStore2.add(this.element.create());
                    mapStore.add(mapStore2);
                    ++n;
                }
            }
        }

        protected void addList(MapStore mapStore, Object[] objectArray) throws CreationException {
            MapStore mapStore2;
            if (this.count != -1 && objectArray.length > this.count) {
                throw new CreationException("Object list length exceeds count (" + objectArray.length + ">" + this.count + ")");
            }
            int n = 0;
            while (n < objectArray.length) {
                mapStore2 = this.getStore(n);
                mapStore2.setParser(this);
                mapStore2.add(this.element.create(objectArray[n]));
                mapStore.add(mapStore2);
                ++n;
            }
            if (this.count != -1) {
                while (n < this.count) {
                    mapStore2 = this.getStore(n);
                    mapStore2.setParser(this);
                    mapStore2.add(this.element.create());
                    mapStore.add(mapStore2);
                    ++n;
                }
            }
        }

        protected void addList(MapStore mapStore, Object object) throws CreationException {
            if (object instanceof MapEntry[]) {
                this.addListDirect(mapStore, (MapEntry[])object);
            } else if (object instanceof Object[]) {
                this.addList(mapStore, (Object[])object);
            } else {
                super.addList(mapStore, object);
            }
        }

        protected MapStore getStore(int n) {
            return new IndexMapStore(n);
        }
    }

    public static class ListParser
    extends NodeParser {
        private Parser element;

        public ListParser(String string, Parser parser) {
            super(string);
            this.element = parser;
        }

        public boolean parse(DataStore dataStore, MapStore mapStore) {
            int n;
            MapStore mapStore2 = new MapStore(this.getName());
            mapStore.add(mapStore2);
            mapStore2.setParser(this);
            do {
                n = dataStore.getPos();
            } while (this.element.parse(dataStore, mapStore2));
            dataStore.setPos(n);
            return true;
        }
    }

    public static class SectionParser
    extends Parser {
        private Parser id;
        private Parser len;
        private Parser data;

        public SectionParser(String string, Parser parser) {
            this(string, null, parser);
        }

        public SectionParser(String string, String string2, Parser parser) {
            super(string);
            this.data = parser;
            this.id = new IDParser("id", string2);
            this.len = new IntParser("len");
        }

        public boolean parse(DataStore dataStore, MapStore mapStore) {
            MapStore mapStore2 = new MapStore(this.getName());
            mapStore2.setParser(this);
            int n = dataStore.getPos();
            int n2 = dataStore.getCount();
            if (!this.id.parse(dataStore, mapStore2)) {
                dataStore.setPos(n);
                return false;
            }
            if (!this.len.parse(dataStore, mapStore2)) {
                dataStore.setPos(n);
                return false;
            }
            int n3 = ((NumericEntry)mapStore2.get("len")).intValue();
            if (n3 > n2 - n || n3 < 0) {
                n3 = n2 - n - 8;
            }
            dataStore.setCount(dataStore.getPos() + n3);
            this.data.parse(dataStore, mapStore2);
            mapStore.add(mapStore2);
            dataStore.setPos(dataStore.getCount());
            dataStore.setCount(n2);
            return true;
        }

        public MapEntry create(Object object) throws CreationException {
            MapStore mapStore = new MapStore(this.getName());
            mapStore.setParser(this);
            if (object != null) {
                Object[] objectArray = (Object[])object;
                mapStore.add(this.id.create(objectArray[0]));
                mapStore.add(this.len.create(objectArray[1]));
                mapStore.add(this.data.create(objectArray[2]));
            } else {
                mapStore.add(this.id.create());
                mapStore.add(this.len.create());
                mapStore.add(this.data.create());
            }
            return mapStore;
        }

        public boolean write(DataStore dataStore, MapEntry mapEntry) {
            MapStore mapStore = (MapStore)mapEntry;
            int n = dataStore.getPos();
            MapEntry mapEntry2 = mapStore.get(this.id.getName());
            if (!this.id.write(dataStore, mapEntry2)) {
                dataStore.setPos(n);
                return false;
            }
            int n2 = dataStore.getPos();
            NumericEntry numericEntry = (NumericEntry)mapStore.get(this.len.getName());
            this.len.write(dataStore, numericEntry);
            int n3 = dataStore.getPos();
            mapEntry2 = (MapEntry)mapStore.getChildren().elementAt(2);
            if (!this.data.write(dataStore, mapEntry2)) {
                dataStore.setPos(n);
                return false;
            }
            n = dataStore.getPos();
            int n4 = n - n3;
            numericEntry.setInt(n4);
            dataStore.setPos(n2);
            this.len.write(dataStore, numericEntry);
            dataStore.setPos(n);
            return true;
        }
    }

    public static class RecordParser
    extends NodeParser {
        private Parser[] list;
        protected int length = -1;
        private int count = 0;

        public RecordParser(String string, Parser[] parserArray) {
            super(string);
            this.list = parserArray;
        }

        public RecordParser(String string, Parser[] parserArray, int n) {
            super(string);
            this.list = parserArray;
            this.length = n;
        }

        protected boolean parseChildren(DataStore dataStore, MapStore mapStore) {
            int n = 0;
            while (n < this.list.length) {
                if (!this.list[n].parse(dataStore, mapStore)) {
                    return false;
                }
                ++n;
            }
            return true;
        }

        public boolean parse(DataStore dataStore, MapStore mapStore) {
            MapStore mapStore2 = new MapStore(this.getName());
            mapStore2.setParser(this);
            int n = dataStore.getPos();
            if (!this.parseChildren(dataStore, mapStore2)) {
                dataStore.setPos(n);
                return false;
            }
            mapStore.add(mapStore2);
            if (this.length != -1) {
                dataStore.setPos(n + this.length);
            }
            return true;
        }

        protected void addList(MapStore mapStore, Object[] objectArray) throws CreationException {
            if (objectArray.length < this.list.length) {
                throw new CreationException(this.getName() + ": Not enough arguments " + objectArray.length + "<" + this.list.length);
            }
            int n = 0;
            while (n < this.list.length) {
                mapStore.add(this.list[n].create(objectArray[n]));
                ++n;
            }
        }

        protected void addList(MapStore mapStore, Map map) throws CreationException {
            int n = 0;
            while (n < this.list.length) {
                Object v = map.get(this.list[n].getName().toLowerCase());
                MapEntry mapEntry = this.list[n].create(v);
                if (mapEntry == null) {
                    throw new CreationException("Null MapEntry " + n + " for " + this.list[n].getName());
                }
                mapStore.add(mapEntry);
                ++n;
            }
        }

        protected void addList(MapStore mapStore) throws CreationException {
            int n = 0;
            while (n < this.list.length) {
                mapStore.add(this.list[n].create());
                ++n;
            }
        }

        protected void addList(MapStore mapStore, Object object) throws CreationException {
            if (object instanceof MapEntry[]) {
                this.addListDirect(mapStore, (MapEntry[])object);
            } else if (object instanceof Object[]) {
                this.addList(mapStore, (Object[])object);
            } else if (object instanceof Map) {
                this.addList(mapStore, (Map)object);
            } else if (object == null) {
                this.addList(mapStore);
            } else {
                super.addList(mapStore, object);
            }
        }
    }

    public static class SwitchParser
    extends NodeParser {
        private Parser[] choices;

        public SwitchParser(String string, Parser[] parserArray) {
            super(string);
            this.choices = parserArray;
        }

        public boolean parse(DataStore dataStore, MapStore mapStore) {
            int n = dataStore.getPos();
            int n2 = 0;
            while (n2 < this.choices.length) {
                if (this.choices[n2].parse(dataStore, mapStore)) {
                    return true;
                }
                dataStore.setPos(n);
                ++n2;
            }
            return false;
        }

        public boolean write(DataStore dataStore, MapEntry mapEntry) {
            return false;
        }

        public MapEntry create(Object object) throws CreationException {
            MapEntry mapEntry = null;
            int n = 0;
            while (n < this.choices.length) {
                try {
                    mapEntry = this.choices[n].create(object);
                    break;
                }
                catch (CreationException creationException) {
                    ++n;
                }
            }
            if (mapEntry == null) {
                throw new CreationException(this.getName() + " unable to find a valid choice for " + object + " in " + this.choices.length + ".");
            }
            return mapEntry;
        }
    }

    public static abstract class NodeParser
    extends Parser {
        public NodeParser(String string) {
            super(string);
        }

        public boolean write(DataStore dataStore, MapEntry mapEntry) {
            Enumeration enumeration = ((MapStore)mapEntry).getChildren().elements();
            while (enumeration.hasMoreElements()) {
                MapEntry mapEntry2 = (MapEntry)enumeration.nextElement();
                Parser parser = mapEntry2.getParser();
                if (parser == null) {
                    return false;
                }
                int n = dataStore.getPos();
                if (parser.write(dataStore, mapEntry2)) continue;
                dataStore.setPos(n);
                return false;
            }
            return true;
        }

        protected void addList(MapStore mapStore, Object object) throws CreationException {
            if (!(object instanceof MapEntry[])) {
                throw new CreationException("Unknown data type for create '" + object.getClass() + "'.");
            }
            this.addListDirect(mapStore, (MapEntry[])object);
        }

        protected void addListDirect(MapStore mapStore, MapEntry[] mapEntryArray) throws CreationException {
            int n = 0;
            while (n < mapEntryArray.length) {
                if (mapEntryArray[n] == null) {
                    throw new CreationException(this.getName() + " MapEntry[" + n + "] " + mapEntryArray + " Null Entry");
                }
                mapStore.add(mapEntryArray[n]);
                ++n;
            }
        }

        public MapEntry create(Object object) throws CreationException {
            MapStore mapStore = new MapStore(this.getName());
            mapStore.setParser(this);
            this.addList(mapStore, object);
            return mapStore;
        }
    }

    public static abstract class Parser {
        private String name;

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public Parser(String string) {
            this.name = string;
        }

        public abstract boolean parse(DataStore var1, MapStore var2);

        public MapEntry create(Object object) throws CreationException {
            throw new CreationException("Creation not defined for this parser.");
        }

        public MapEntry create() throws CreationException {
            return this.create(null);
        }

        public abstract boolean write(DataStore var1, MapEntry var2);
    }

    public static class CreationException
    extends Exception {
        public CreationException(String string) {
            super(string);
        }
    }
}

