/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Enumeration;

public class TilesetUnderstanding
extends Understanding {
    private Understanding.Parser cv5Parser = new Understanding.IndexListParser("cv5", new Understanding.RecordParser("entry", new Understanding.Parser[]{new Understanding.ElementParser("unknown", 20), new Understanding.IndexListParser("index", new Understanding.WordParser("vx4"), 16)}));
    private Understanding.Parser vx4Parser = new Understanding.IndexListParser("vx4", new Understanding.IndexListParser("row", new Understanding.IndexListParser("col", new Understanding.WordParser("subtileid"), 4), 4));
    private Understanding.Parser vr4Parser = new Understanding.IndexListParser("vr4", new Understanding.IndexListParser("row", new Understanding.IndexListParser("col", new Understanding.WordParser("pixel"), 8), 8));
    private Understanding.Parser wpeParser = new Understanding.IndexListParser("wpe", new Understanding.RecordParser("pixel", new Understanding.Parser[]{new Understanding.ByteParser("red"), new Understanding.ByteParser("green"), new Understanding.ByteParser("blue"), new Understanding.ByteParser("alpha")}));
    Understanding.MapStore cv5 = null;
    Understanding.MapStore vx4 = null;
    byte[] vr4 = null;
    Understanding.MapStore wpe = null;
    public static final int MEGA_TILESET_SIZE = 1665;
    public static final int MINI_TILESET_SIZE = 5046;
    int[] cv5vx4 = null;
    int[][][] vx4vr4 = null;
    Color[] pcolor = null;
    Frame frame = new Frame();
    int now;
    int max = 1;

    private byte[] readFile(String string) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        int n = (int)randomAccessFile.length();
        System.out.println("Reading file " + string + "(len=" + n + ")...");
        byte[] byArray = new byte[n];
        randomAccessFile.read(byArray);
        randomAccessFile.close();
        return byArray;
    }

    private void makePalette() {
        this.pcolor = new Color[256];
        int n = 0;
        Enumeration enumeration = this.wpe.getEnumeration("wpe.*.pixel");
        while (enumeration.hasMoreElements()) {
            Understanding.MapStore mapStore = (Understanding.MapStore)enumeration.nextElement();
            Understanding.NumericEntry numericEntry = (Understanding.NumericEntry)mapStore.get("red");
            Understanding.NumericEntry numericEntry2 = (Understanding.NumericEntry)mapStore.get("green");
            Understanding.NumericEntry numericEntry3 = (Understanding.NumericEntry)mapStore.get("blue");
            this.pcolor[n++] = new Color(numericEntry.intValue(), numericEntry2.intValue(), numericEntry3.intValue());
        }
    }

    public void drawSubTile(Graphics graphics, int n, int n2, int n3, boolean bl, Image image) {
        if (image == null || bl) {
            this.drawSubTile(graphics, n, n2, n3, bl);
        } else {
            this.drawSubTile(graphics, n, n2, n3, bl);
        }
    }

    public void drawSubTile(Graphics graphics, int n, int n2, int n3, boolean bl) {
        int n4 = 0;
        while (n4 < 8) {
            int n5 = 0;
            while (n5 < 8) {
                int n6 = n2 + n4;
                int n7 = n3 + n5;
                if (!bl) {
                    this.drawSubTilePixel(graphics, n, n4, n5, n6, n7);
                } else {
                    this.drawSubTilePixel(graphics, n, 7 - n4, n5, n6, n7);
                }
                ++n5;
            }
            ++n4;
        }
    }

    public void drawSubTilePixel(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        try {
            byte by = this.vr4[n * 64 + n3 * 8 + n2];
            int n6 = by & 0xFF;
            graphics.setColor(this.pcolor[n6]);
            graphics.fillRect(n4, n5, 1, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            System.out.println("Error in subtile " + n + " y" + n3 + " x" + n2 + " byte" + n * 64 + n3 * 8 + n2);
        }
    }

    public int getVR4(int n, int n2, int n3) {
        try {
            return this.vx4vr4[n][n3][n2];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public void paintTile(Graphics graphics, int n, int n2, int n3, Image image) {
        System.out.print("Offset " + n);
        int n4 = 0;
        while (n4 < 4) {
            int n5 = 0;
            while (n5 < 4) {
                int n6 = this.getVR4(n, n5, n4);
                int n7 = n6 / 2;
                boolean bl = n6 % 2 == 1;
                int n8 = n2 + n5 * 8;
                int n9 = n3 + n4 * 8;
                this.drawSubTile(graphics, n7, n8, n9, bl, image);
                ++n5;
            }
            ++n4;
        }
        System.out.println();
    }

    public int getVX4(int n) {
        try {
            return this.cv5vx4[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return 0;
        }
    }

    public void paintTileId(Graphics graphics, int n, int n2, int n3, Image image) {
        try {
            int n4 = this.getVX4(n);
            this.paintTile(graphics, n4, n2, n3, image);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void makeTileImage(Graphics graphics) {
        this.makeTileImage(graphics, null);
    }

    public void makeTileImage(Graphics graphics, Image image) {
        int n = 0;
        while (n < this.cv5vx4.length) {
            int n2 = n % 16;
            int n3 = n / 16;
            this.paintTileId(graphics, n, n2 * 32, n3 * 32, image);
            ++n;
        }
    }

    public void makeAllImages(Graphics graphics) {
        int n = 0;
        Enumeration enumeration = this.vx4.getEnumeration("vx4.*");
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement();
            int n2 = n % 16;
            int n3 = n / 16;
            this.paintTile(graphics, n, n2 * 32, n3 * 32, null);
            ++n;
        }
    }

    public synchronized int getDone() {
        return this.now * 100 / this.max;
    }

    public int getNumSubtiles() {
        return this.vr4.length / 64;
    }

    public void makeAllSubtiles(Graphics graphics) {
        TilesetUnderstanding tilesetUnderstanding;
        TilesetUnderstanding tilesetUnderstanding2 = this;
        synchronized (tilesetUnderstanding2) {
            this.max = this.getNumSubtiles();
        }
        int n = 0;
        while (n < this.getNumSubtiles()) {
            tilesetUnderstanding = this;
            synchronized (tilesetUnderstanding) {
                this.now = n;
            }
            if (n % 1024 == 0) {
                System.out.println("Subtile " + n);
            }
            int n2 = n % 128;
            int n3 = n / 128;
            int n4 = n2 * 8 * 2;
            int n5 = n3 * 8;
            this.drawSubTile(graphics, n, n4, n5, false, null);
            this.drawSubTile(graphics, n, n4 + 8, n5, true, null);
            ++n;
        }
        tilesetUnderstanding = this;
        synchronized (tilesetUnderstanding) {
            this.now = this.max;
        }
    }

    public void load(String string) throws IOException {
        byte[] byArray = this.readFile(string + ".cv5");
        DataStore dataStore = new DataStore(byArray);
        this.cv5 = new Understanding.MapStore("root");
        if (this.cv5Parser.parse(dataStore, this.cv5)) {
            this.init_cv5(this.cv5);
        }
        this.cv5 = null;
        byArray = this.readFile(string + ".vx4");
        dataStore = new DataStore(byArray);
        this.vx4 = new Understanding.MapStore("root");
        if (this.vx4Parser.parse(dataStore, this.vx4)) {
            this.init_vx4(this.vx4);
        }
        this.vx4 = null;
        byArray = this.readFile(string + ".wpe");
        dataStore = new DataStore(byArray);
        this.wpe = new Understanding.MapStore("root");
        if (this.wpeParser.parse(dataStore, this.wpe)) {
            this.makePalette();
        }
        this.wpe = null;
        this.vr4 = this.readFile(string + ".vr4");
    }

    public void init_cv5(Understanding.MapStore mapStore) {
        int n = ((Understanding.MapStore)mapStore.get("cv5")).getChildren().size();
        this.cv5vx4 = new int[n * 16];
        int n2 = 0;
        mapStore.dump();
        Enumeration enumeration = mapStore.getEnumeration("cv5.*.entry");
        while (enumeration.hasMoreElements()) {
            Understanding.MapStore mapStore2 = (Understanding.MapStore)enumeration.nextElement();
            int n3 = 0;
            Enumeration enumeration2 = mapStore2.getEnumeration("index.*.vx4");
            while (enumeration2.hasMoreElements()) {
                Understanding.NumericEntry numericEntry = (Understanding.NumericEntry)enumeration2.nextElement();
                this.cv5vx4[n2 * 16 + n3++] = numericEntry.intValue();
            }
            ++n2;
        }
    }

    public void init_vx4(Understanding.MapStore mapStore) {
        int n = ((Understanding.MapStore)mapStore.get("vx4")).getChildren().size();
        this.vx4vr4 = new int[n][4][4];
        int n2 = 0;
        Enumeration enumeration = mapStore.getEnumeration("vx4.*");
        while (enumeration.hasMoreElements()) {
            Understanding.MapStore mapStore2 = (Understanding.MapStore)enumeration.nextElement();
            int n3 = 0;
            Enumeration enumeration2 = mapStore2.getEnumeration("row.*");
            while (enumeration2.hasMoreElements()) {
                Understanding.MapStore mapStore3 = (Understanding.MapStore)enumeration2.nextElement();
                int n4 = 0;
                Enumeration enumeration3 = mapStore3.getEnumeration("col.*.subtileid");
                while (enumeration3.hasMoreElements()) {
                    Understanding.NumericEntry numericEntry = (Understanding.NumericEntry)enumeration3.nextElement();
                    this.vx4vr4[n2][n3][n4++] = numericEntry.intValue();
                }
                ++n3;
            }
            ++n2;
        }
    }

    public void prestore() {
    }

    public void dump() {
    }
}

