/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class Reader
implements Serializable {
    public static int debug = 0;
    private static final String PROG_NAME = "GUEdit 3.6 alpha";
    private static final String IN_FILE = "scenario.chk";
    private static final String TMP_FILE = "scenario.out";
    private static final String STAT_FILE = "status.dat";
    private static final String SC_INSTALL = "c:\\program files\\starcraft";
    private static final String SC_MAPS = "c:\\program files\\starcraft\\maps";
    String username = null;
    String useremail = null;
    String sc_install_dir = null;
    transient Frame main;
    transient int[][] maptiles = null;
    private static final int MPQ_FILE_TYPE = 2;
    private static final int CHK_FILE_TYPE = 1;
    private static final int UNKNOWN_FILE_TYPE = 0;
    transient int option = 0;
    transient MapUnderstanding mu = null;
    transient Enabler mapNoProtect;
    transient Enabler mapNoLoaded;
    String infile = null;
    private static final long serialVersionUID = 8959264854951834821L;

    public static void main(String[] stringArray) {
        Reader.reload();
    }

    public void initFrame() {
        this.main = new Frame(PROG_NAME);
        ((Component)this.main).setSize(200, 200);
    }

    public Reader() {
        this.initFrame();
    }

    private void run() throws IOException {
        System.err.println("GUEdit 3.6 alpha Copyright 2000 by GoldenUrg");
        this.editor();
    }

    public static void reload() {
        Reader reader;
        try {
            File file = new File(STAT_FILE);
            if (file.exists()) {
                if (debug > 5) {
                    System.err.println(file.getName() + " exists");
                }
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
                    reader = (Reader)objectInputStream.readObject();
                    objectInputStream.close();
                    reader.initFrame();
                }
                catch (Exception exception) {
                    reader = new Reader();
                }
            } else {
                reader = new Reader();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            reader = new Reader();
        }
        try {
            reader.run();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
    }

    private void saveStatus(int n) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(STAT_FILE));
        objectOutputStream.writeObject(this);
        objectOutputStream.close();
    }

    private void error(int n, String string) {
        this.error("Error", n, string);
    }

    private void error(String string, int n, String string2) {
        final Dialog dialog = new Dialog(this.main, string, true);
        Panel panel = new Panel();
        panel.add(new Label(n + ": " + string2));
        Button button = new Button("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        panel.add(button);
        dialog.add(panel);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        dialog.pack();
        dialog.show();
    }

    private void showText(String string, String string2) {
        final Dialog dialog = new Dialog(this.main, string, true);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        TextArea textArea = new TextArea(string2);
        textArea.setEditable(false);
        panel.add((Component)textArea, "Center");
        Button button = new Button("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        panel.add((Component)button, "South");
        dialog.add(panel);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        dialog.pack();
        dialog.show();
    }

    private void getUserInfo() {
        final Dialog dialog = new Dialog(this.main, "User Info", true);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        TextArea textArea = new TextArea("This information will be displayed\nif the map opening is attempted with GUEdit\n");
        textArea.setEditable(false);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(3, 1));
        Panel panel3 = new Panel();
        panel3.add(new Label("Name"));
        final TextField textField = new TextField(30);
        if (this.username != null) {
            textField.setText(this.username);
        }
        panel3.add(textField);
        panel2.add(panel3);
        panel3 = new Panel();
        panel3.add(new Label("E-mail"));
        final TextField textField2 = new TextField(40);
        if (this.useremail != null) {
            textField2.setText(this.useremail);
        }
        panel3.add(textField2);
        panel2.add(panel3);
        Button button = new Button("Full Protect(beta)");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Reader.this.username = textField.getText();
                Reader.this.useremail = textField2.getText();
                Reader.this.option = 1;
                ((Component)dialog).setVisible(false);
            }
        });
        panel2.add(button);
        panel.add((Component)textArea, "Center");
        panel.add((Component)panel2, "South");
        dialog.add(panel);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Reader.this.option = 0;
                ((Component)dialog).setVisible(false);
            }
        });
        dialog.pack();
        dialog.show();
    }

    private void getWaveString(final MapUnderstanding mapUnderstanding) {
        final Dialog dialog = new Dialog(this.main, "Add MPQ Wave", true);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        TextArea textArea = new TextArea("This feature does not work.\n");
        textArea.setEditable(false);
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(3, 1));
        Panel panel3 = new Panel();
        panel3.add(new Label("Full Path"));
        final TextField textField = new TextField(30);
        panel3.add(textField);
        panel2.add(panel3);
        Button button = new Button("Add Wave");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = textField.getText();
                try {
                    mapUnderstanding.addWaveString(string);
                }
                catch (Exception exception) {
                    Reader.this.error(414, exception.toString());
                }
                ((Component)dialog).setVisible(false);
            }
        });
        panel2.add(button);
        panel.add((Component)textArea, "Center");
        panel.add((Component)panel2, "South");
        dialog.add(panel);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        dialog.pack();
        dialog.show();
    }

    private boolean extract(String string, String string2) {
        try {
            System.out.println("Starting...");
            Process process = Runtime.getRuntime().exec(new String[]{"mpq2k\\mpq2k", "e", "\"" + string + "\"", "\"" + string2 + "\""});
            final InputStream inputStream = process.getInputStream();
            new Thread("outreader"){

                public void run() {
                    try {
                        byte[] byArray = new byte[80];
                        int n = 0;
                        while (n != -1) {
                            n = inputStream.available();
                            if (n <= 0) {
                                n = 1;
                            }
                            if (n > byArray.length) {
                                n = byArray.length;
                            }
                            n = inputStream.read(byArray, 0, n);
                            int n2 = 0;
                            while (n2 < n) {
                                System.out.print((char)byArray[n2]);
                                ++n2;
                            }
                            System.out.flush();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    System.out.println();
                }
            }.start();
            process.waitFor();
            inputStream.close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (this.attemptInstallationRepair()) {
                this.error("Install Error Corrected", 404, "Installation repaired. Try again.");
            } else {
                this.error(405, "Unable to start mpq2k. " + exception.getClass() + ":" + exception.getMessage());
            }
            return false;
        }
    }

    private boolean installTileset(String string, String string2, String string3) {
        String string4 = string + "\\" + string2;
        String string5 = "tileset\\" + string3;
        if (!(new File(string3 + ".cv5").exists() && new File(string3 + ".wpe").exists() && new File(string3 + ".vx4").exists() && new File(string3 + ".vr4").exists())) {
            if (!this.extract(string4, string5 + ".cv5")) {
                return false;
            }
            if (!this.extract(string4, string5 + ".vx4")) {
                return false;
            }
            if (!this.extract(string4, string5 + ".wpe")) {
                return false;
            }
            if (!this.extract(string4, string5 + ".vr4")) {
                return false;
            }
        } else {
            return true;
        }
        if (!(new File(string3 + ".cv5").exists() && new File(string3 + ".wpe").exists() && new File(string3 + ".vx4").exists() && new File(string3 + ".vr4").exists())) {
            this.error(415, "Unable to install tileset files.");
            return false;
        }
        return true;
    }

    private void showPlayerColors(final MapUnderstanding mapUnderstanding) {
        final int[] nArray = mapUnderstanding.getPlayerColors();
        if (nArray != null) {
            Component component;
            final Dialog dialog = new Dialog(this.main, "Player Colors", true);
            Panel panel = new Panel();
            panel.setLayout(new BorderLayout());
            final TextField[] textFieldArray = new TextField[8];
            Panel panel2 = new Panel();
            panel2.setLayout(new GridLayout(-1, 1));
            int n = 1;
            while (n <= 8) {
                component = new Panel();
                ((Container)component).add(new Label("Player " + n));
                textFieldArray[n - 1] = new TextField(8);
                textFieldArray[n - 1].setText(new Integer(nArray[n - 1]).toString());
                ((Container)component).add(textFieldArray[n - 1]);
                panel2.add(component);
                ++n;
            }
            panel.add((Component)panel2, "Center");
            component = new TextArea("Key: \n00 = red \n01 = blue \n02 = teal \n03 = purple \n04 = orange \n05 = brown \n06 = white \n07 = yellow \n08 = green \n09 = pale yellow \n10 = tan \n11 = aqua(neutral color) \nAfter this point, may be different on different terrains \n12 = pale green \n13 = blueish gray \n14 = pale yellow(same as 09) \n15 = cyan \n17 = black \n");
            ((TextComponent)component).setEditable(false);
            panel.add(component, "East");
            Panel panel3 = new Panel();
            Button button = new Button("OK");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = 0;
                    while (n < 8) {
                        try {
                            nArray[n] = Integer.parseInt(textFieldArray[n].getText());
                        }
                        catch (Exception exception) {
                            nArray[n] = n;
                        }
                        ++n;
                    }
                    if (!mapUnderstanding.setPlayerColors(nArray)) {
                        Reader.this.error(504, "Unable set player colors. Player colors are only in SCXs.");
                    }
                    ((Component)dialog).setVisible(false);
                }
            });
            panel3.add(button);
            button = new Button("Cancel");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Component)dialog).setVisible(false);
                }
            });
            panel3.add(button);
            panel.add((Component)panel3, "South");
            dialog.add(panel);
            dialog.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ((Component)dialog).setVisible(false);
                }
            });
            dialog.pack();
            dialog.show();
        } else {
            this.error(506, "Player colors are only available in BroodWar maps.");
        }
    }

    private void editCosts(final MapUnderstanding mapUnderstanding) {
        final Dialog dialog = new Dialog(this.main, "Adjust Costs", true);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(-1, 1));
        final TextField textField = new TextField("100");
        final TextField textField2 = new TextField("100");
        final TextField textField3 = new TextField("100");
        final TextField textField4 = new TextField("100");
        Panel panel3 = new Panel();
        panel3.add(new Label("Ore Cost"));
        panel3.add(textField);
        panel3.add(new Label("%"));
        panel2.add(panel3);
        panel3 = new Panel();
        panel3.add(new Label("Gas Cost"));
        panel3.add(textField2);
        panel3.add(new Label("%"));
        panel2.add(panel3);
        panel3 = new Panel();
        panel3.add(new Label("Time Cost"));
        panel3.add(textField3);
        panel3.add(new Label("%"));
        panel2.add(panel3);
        panel3 = new Panel();
        panel3.add(new Label("Energy Cost"));
        panel3.add(textField4);
        panel3.add(new Label("%"));
        panel2.add(panel3);
        panel.add((Component)panel2, "Center");
        Panel panel4 = new Panel();
        Button button = new Button("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(textField.getText());
                    int n2 = Integer.parseInt(textField2.getText());
                    int n3 = Integer.parseInt(textField3.getText());
                    int n4 = Integer.parseInt(textField4.getText());
                    mapUnderstanding.adjustUpgradeCosts(n, n2, n3, n4);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Reader.this.error(409, exception.toString());
                }
                ((Component)dialog).setVisible(false);
            }
        });
        panel4.add(button);
        button = new Button("Cancel");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        panel4.add(button);
        panel.add((Component)panel4, "South");
        dialog.add(panel);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        dialog.pack();
        dialog.show();
    }

    private void editUpgrades(final MapUnderstanding mapUnderstanding) {
        final Dialog dialog = new Dialog(this.main, "Set Upgrades", true);
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        Panel panel2 = new Panel();
        panel2.setLayout(new GridLayout(-1, 1));
        final TextField textField = new TextField("0");
        final TextField textField2 = new TextField("3");
        final TextField textField3 = new TextField("255");
        Panel panel3 = new Panel();
        panel3.add(new Label("Player (0=default)"));
        panel3.add(textField);
        panel2.add(panel3);
        panel3 = new Panel();
        panel3.add(new Label("Min Upgrade (-1=don't change)"));
        panel3.add(textField2);
        panel2.add(panel3);
        panel3 = new Panel();
        panel3.add(new Label("Max Upgrade (-1=don't change)"));
        panel3.add(textField3);
        panel2.add(panel3);
        panel.add((Component)panel2, "Center");
        Panel panel4 = new Panel();
        Button button = new Button("OK");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = Integer.parseInt(textField.getText());
                    int n2 = Integer.parseInt(textField2.getText());
                    int n3 = Integer.parseInt(textField3.getText());
                    mapUnderstanding.setUpgradeSettings(n, n2, n3);
                }
                catch (Exception exception) {
                    Reader.this.error(408, exception.toString());
                }
                ((Component)dialog).setVisible(false);
            }
        });
        panel4.add(button);
        button = new Button("Cancel");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        panel4.add(button);
        panel.add((Component)panel4, "South");
        dialog.add(panel);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        dialog.pack();
        dialog.show();
    }

    private int identify(String string) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        byte[] byArray = new byte[4];
        randomAccessFile.read(byArray);
        randomAccessFile.close();
        String string2 = new String(byArray);
        if (string2.startsWith("MPQ")) {
            return 2;
        }
        if (string2.startsWith("TYPE")) {
            return 1;
        }
        if (string2.startsWith("VER ")) {
            return 1;
        }
        return 0;
    }

    public void loadMapFile(MapUnderstanding mapUnderstanding, String string) throws IOException {
        switch (this.identify(string)) {
            case 2: {
                this.readMPQ(mapUnderstanding, string);
                break;
            }
            case 1: {
                this.readCHK(mapUnderstanding, string);
                break;
            }
            default: {
                throw new IOException("Not a map file");
            }
        }
    }

    private void readMPQ(MapUnderstanding mapUnderstanding, String string) throws IOException {
        File file = new File(IN_FILE);
        if (file.exists()) {
            file.delete();
        }
        this.extract(string, "staredit\\scenario.chk");
        if (file.exists()) {
            this.readCHK(mapUnderstanding, IN_FILE);
        }
    }

    public String promptForSC() throws IOException {
        FileDialog fileDialog = new FileDialog(this.main, "Find starcraft.exe", 0);
        fileDialog.setDirectory(SC_INSTALL);
        fileDialog.setFilenameFilter(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.equalsIgnoreCase("starcraft.exe");
            }
        });
        fileDialog.show();
        String string = fileDialog.getDirectory();
        return string;
    }

    public String promptForFile(MapUnderstanding mapUnderstanding) throws IOException {
        FileDialog fileDialog = new FileDialog(this.main, "Load Map", 0);
        fileDialog.show();
        String string = fileDialog.getDirectory() + fileDialog.getFile();
        if (fileDialog.getFile() != null) {
            if (string.indexOf(34) == -1) {
                this.loadMapFile(mapUnderstanding, string);
                return string;
            }
            this.error(401, "Filename cannot contain quotes(\"). Rename the map first.");
        }
        return null;
    }

    public void loadTriggers(MapUnderstanding mapUnderstanding) throws IOException {
        FileDialog fileDialog = new FileDialog(this.main, "Load Trigger Text", 0);
        fileDialog.show();
        String string = fileDialog.getDirectory() + fileDialog.getFile();
        if (fileDialog.getFile() != null) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            PrintWriter printWriter = new PrintWriter(new FileWriter("errors.txt"));
            mapUnderstanding.parseTriggers(bufferedReader, printWriter);
            bufferedReader.close();
            printWriter.close();
        }
    }

    public void saveTriggers(MapUnderstanding mapUnderstanding) throws IOException {
        FileDialog fileDialog = new FileDialog(this.main, "Save Trigger Text", 1);
        fileDialog.show();
        String string = fileDialog.getDirectory() + fileDialog.getFile();
        if (fileDialog.getFile() != null) {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            mapUnderstanding.showTriggers(printStream);
            printStream.close();
            this.error("Done", 599, "Triggers written to '" + string + "' successfully.");
        }
    }

    private boolean attemptInstallationRepair() {
        if (!new File("mpq2k\\mpq2k.exe").exists() && new File("mpq2k.exe").exists()) {
            try {
                File file = new File("mpq2k");
                if (!file.exists()) {
                    file.mkdir();
                }
                if (!file.isDirectory()) {
                    this.error(404, "Directory create failed.");
                    return false;
                }
                Reader.copy("mpq2k.exe", "mpq2k\\mpq2k.exe");
                Reader.copy("lmpqapi.dll", "mpq2k\\lmpqapi.dll");
                Reader.copy("storm.dll", "mpq2k\\storm.dll");
                Reader.copy("staredit.exe", "mpq2k\\staredit.exe");
                return true;
            }
            catch (IOException iOException) {
                this.error(403, "File error fixing installation. " + iOException.getClass() + ":" + iOException.getMessage());
                return false;
            }
        }
        if (!(new File("mpq2k\\mpq2k.exe").exists() && new File("mpq2k\\lmpqapi.dll").exists() && new File("mpq2k\\storm.dll").exists() && new File("mpq2k\\staredit.exe").exists())) {
            this.error(402, "MPQ2K not installed correctly.");
            return false;
        }
        return false;
    }

    private void showMenu() {
        this.mapNoProtect = new Enabler();
        this.mapNoLoaded = new Enabler();
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(-1, 1));
        Button button = new Button("Load...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Reader.this.infile = Reader.this.promptForFile(Reader.this.mu);
                    Reader.this.setButtonStatus();
                }
                catch (IOException iOException) {
                    Reader.this.error(505, "Start Load. " + iOException.getClass() + ":" + iOException.getMessage());
                }
            }
        });
        panel.add(button);
        button = new Button("Protect...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Reader.this.getUserInfo();
                if (Reader.this.option != 0) {
                    Reader.this.mu.setName(Reader.this.username);
                    Reader.this.mu.setEMail(Reader.this.useremail);
                    Reader.this.mu.fullProtect();
                    Reader.this.error("Done", 503, "Protection Enabled.");
                    Reader.this.setButtonStatus();
                }
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Change Terrain Type...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Reader.this.mu.getTerrain();
                if (n >= 4 && n <= 7) {
                    Reader.this.showTerrainChanger();
                } else {
                    Reader.this.error(501, "Conversion Impossible. Only Jungle, Desert, Ice, and Twilight can be converted. ");
                }
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Set Upgrades...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Reader.this.editUpgrades(Reader.this.mu);
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Edit Costs...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Reader.this.editCosts(Reader.this.mu);
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Add MPQ Wave...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Reader.this.getWaveString(Reader.this.mu);
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Change Player Colors...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Reader.this.showPlayerColors(Reader.this.mu);
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Edit Terrain...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    String string = Reader.this.mu.getTerrainSourceFilename();
                    String string2 = Reader.this.mu.getTerrainFilename();
                    if (Reader.this.sc_install_dir == null) {
                        Reader.this.sc_install_dir = Reader.this.promptForSC();
                    }
                    if (Reader.this.sc_install_dir != null && Reader.this.installTileset(Reader.this.sc_install_dir, string, string2)) {
                        TilesetUnderstanding tilesetUnderstanding = new TilesetUnderstanding();
                        tilesetUnderstanding.load(string2);
                        Reader.this.maptiles = Reader.this.mu.getMapTiles();
                        new TerrainView(Reader.this.maptiles, tilesetUnderstanding).show();
                        Reader.this.mapNoLoaded.setStatus(false);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    Reader.this.error(416, "Editing Terrain " + exception.getClass() + ":" + exception.getMessage());
                }
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Store Terrain");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Reader.this.maptiles != null) {
                    Reader.this.mu.setMapTiles(Reader.this.maptiles);
                    Reader.this.mu.setSETiles(Reader.this.maptiles);
                    Reader.this.maptiles = null;
                    Reader.this.mapNoLoaded.setStatus(true);
                } else {
                    Reader.this.error(417, "Not Editing Terrain");
                }
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Repair Location Bug");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (Reader.this.mu.repairLocationStrings(true)) {
                    Reader.this.error("Success", 505, "1 or more locations deleted.");
                } else {
                    Reader.this.error(506, "No corrupted locations detected.");
                }
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        if (debug > 5) {
            button = new Button("Repair Location Names");
            button.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (Reader.this.mu.repairLocationStrings(false)) {
                        Reader.this.error("Success", 507, "1 or more locations fixed.");
                    } else {
                        Reader.this.error(508, "No corrupted locations detected.");
                    }
                }
            });
            this.mapNoProtect.add(button);
            panel.add(button);
        }
        button = new Button("Load Triggers...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Reader.this.loadTriggers(Reader.this.mu);
                }
                catch (IOException iOException) {
                    Reader.this.error(503, "Error loading triggers. " + iOException.getClass() + ":" + iOException.getMessage());
                }
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Save Triggers...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Reader.this.saveTriggers(Reader.this.mu);
                }
                catch (IOException iOException) {
                    Reader.this.error(504, "Error saving triggers. " + iOException.getClass() + ":" + iOException.getMessage());
                }
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Copy Sections...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    Reader.this.copySection();
                }
                catch (IOException iOException) {
                    Reader.this.error(505, "Error copying sections: " + iOException.getClass() + ":" + iOException.getMessage());
                }
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Save CHK...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileDialog fileDialog = new FileDialog(Reader.this.main, "Save CHK", 1);
                fileDialog.show();
                String string = fileDialog.getDirectory() + fileDialog.getFile();
                if (fileDialog.getFile() != null) {
                    Reader.this.writeCHK(string);
                }
            }
        });
        this.mapNoProtect.add(button);
        panel.add(button);
        button = new Button("Save...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Reader.this.writeCHK(Reader.IN_FILE);
                if (new File(Reader.IN_FILE).exists()) {
                    try {
                        Reader.this.promptForSaveFile();
                    }
                    catch (IOException iOException) {
                        Reader.this.error(503, "Error in saving...");
                    }
                }
            }
        });
        this.mapNoLoaded.add(button);
        panel.add(button);
        button = new Button("Quit (No Save)");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        panel.add(button);
        this.main.add(panel);
        this.main.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        this.setButtonStatus();
        this.main.pack();
        this.main.show();
    }

    private void setButtonStatus() {
        this.mapNoProtect.setStatus(this.mu.isLoaded() && !this.mu.isProtected());
        this.mapNoLoaded.setStatus(this.mu.isLoaded());
    }

    private void showTerrainChanger() {
        final Dialog dialog = new Dialog(this.main, "Terrain Changer", true);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(2, 1));
        final Choice choice = new Choice();
        choice.add("Jungle");
        choice.add("Desert");
        choice.add("Ice World");
        choice.add("Twilight");
        panel.add(choice);
        Button button = new Button("Convert Terrain");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                int n2 = choice.getSelectedIndex() + 4;
                if (n2 != (n = Reader.this.mu.getTerrain())) {
                    if (Reader.this.mu.convertTerrain(n2)) {
                        Reader.this.showText("Warning", "550: Conversion done.\nTerrain conversion is not very exact.\nYou need to open the map in StarEdit and correct\nany terrain errors and fix any misplaced units and doodads.");
                    } else {
                        Reader.this.error(501, "Conversion Impossible. Only Jungle, Desert, Ice, and Twilight can be converted. ");
                    }
                }
                ((Component)dialog).setVisible(false);
            }
        });
        panel.add(button);
        dialog.add(panel);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        dialog.pack();
        dialog.show();
    }

    private void copySection() throws IOException {
        MapUnderstanding mapUnderstanding = new MapUnderstanding();
        if (this.promptForFile(mapUnderstanding) != null) {
            try {
                Understanding.MapStore mapStore = mapUnderstanding.getMap();
                this.showCopySection(mapStore);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.error(601, "Error in copy " + exception.getClass() + ":" + exception.getMessage() + ".");
            }
        }
    }

    private void showCopySection(final Understanding.MapStore mapStore) {
        final Dialog dialog = new Dialog(this.main, "Copy Sections", true);
        Panel panel = new Panel();
        panel.setLayout(new GridLayout(-1, 1));
        final Checkbox checkbox = new Checkbox("Terrain");
        panel.add(checkbox);
        final Checkbox checkbox2 = new Checkbox("Triggers");
        panel.add(checkbox2);
        final Checkbox checkbox3 = new Checkbox("Player Colors");
        panel.add(checkbox3);
        final Checkbox checkbox4 = new Checkbox("Player Setup");
        panel.add(checkbox4);
        final Checkbox checkbox5 = new Checkbox("Units");
        panel.add(checkbox5);
        final Checkbox checkbox6 = new Checkbox("StarCraft Settings");
        panel.add(checkbox6);
        final Checkbox checkbox7 = new Checkbox("Broodwar Settings");
        panel.add(checkbox7);
        Button button = new Button("Import Sections");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (checkbox.getState()) {
                        try {
                            Reader.this.mu.copySection("Tileset", mapStore);
                            Reader.this.mu.copySection("Dimensions", mapStore);
                            Reader.this.mu.copySection("MTXM", mapStore);
                            Reader.this.mu.copySection("Fog Of War", mapStore);
                            Reader.this.mu.copySection("Thingy", mapStore);
                            Reader.this.mu.copySection("Doodads", mapStore);
                            Reader.this.mu.copySection("ISOM", mapStore);
                            Reader.this.mu.copySection("TILE", mapStore);
                        }
                        catch (MapUnderstanding.MapException mapException) {
                            Reader.this.error(602, "Section copy failed. " + mapException.getClass() + ":" + mapException.getMessage());
                        }
                    }
                    if (checkbox2.getState()) {
                        try {
                            Reader.this.mu.copySection("Triggers", mapStore);
                            Reader.this.mu.copySection("Briefing", mapStore);
                            Reader.this.mu.copySection("Locations", mapStore);
                            Reader.this.mu.copySection("Strings", mapStore);
                            Reader.this.mu.copySection("Forces", mapStore);
                            Reader.this.mu.copySection("Scenario", mapStore);
                            Reader.this.mu.copySection("UPUS", mapStore);
                            Reader.this.mu.copySection("UPRP", mapStore);
                            Reader.this.mu.copySection("Switches", mapStore);
                            Reader.this.mu.copySection("WAVs", mapStore);
                        }
                        catch (MapUnderstanding.MapException mapException) {
                            Reader.this.error(602, "Section copy failed. " + mapException.getClass() + ":" + mapException.getMessage());
                        }
                    }
                    if (checkbox3.getState()) {
                        try {
                            Reader.this.mu.copySection("Color", mapStore);
                        }
                        catch (MapUnderstanding.MapException mapException) {
                            Reader.this.error(602, "Section copy failed. " + mapException.getClass() + ":" + mapException.getMessage());
                        }
                    }
                    if (checkbox4.getState()) {
                        try {
                            Reader.this.mu.copySection("Race", mapStore);
                            Reader.this.mu.copySection("Slot Control", mapStore);
                            Reader.this.mu.copySection("StarEdit Owner", mapStore);
                        }
                        catch (MapUnderstanding.MapException mapException) {
                            Reader.this.error(602, "Section copy failed. " + mapException.getClass() + ":" + mapException.getMessage());
                        }
                    }
                    if (checkbox5.getState()) {
                        try {
                            Reader.this.mu.copySection("Units", mapStore);
                        }
                        catch (MapUnderstanding.MapException mapException) {
                            Reader.this.error(602, "Section copy failed. " + mapException.getClass() + ":" + mapException.getMessage());
                        }
                    }
                    if (checkbox6.getState()) {
                        try {
                            Reader.this.mu.copySection("Player Unit Restrictions", mapStore);
                            Reader.this.mu.copySection("Player Upgrade Restrictions", mapStore);
                            Reader.this.mu.copySection("Player Technology Restrictions", mapStore);
                            Reader.this.mu.copySection("Unit Settings", mapStore);
                            Reader.this.mu.copySection("Upgrade Settings", mapStore);
                            Reader.this.mu.copySection("Technology Settings", mapStore);
                        }
                        catch (MapUnderstanding.MapException mapException) {
                            Reader.this.error(602, "Section copy failed. " + mapException.getClass() + ":" + mapException.getMessage());
                        }
                    }
                    if (checkbox7.getState()) {
                        try {
                            Reader.this.mu.copySection("Player Unit Restrictions", mapStore);
                            Reader.this.mu.copySection("Player Upgrade Restrictions Extended", mapStore);
                            Reader.this.mu.copySection("Player Technology Restrictions Extended", mapStore);
                            Reader.this.mu.copySection("Unit Settings Extended", mapStore);
                            Reader.this.mu.copySection("Upgrade Settings Extended", mapStore);
                            Reader.this.mu.copySection("Technology Settings Extended", mapStore);
                        }
                        catch (MapUnderstanding.MapException mapException) {
                            Reader.this.error(602, "Section copy failed. " + mapException.getClass() + ":" + mapException.getMessage());
                        }
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ((Component)dialog).setVisible(false);
            }
        });
        panel.add(button);
        dialog.add(panel);
        dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ((Component)dialog).setVisible(false);
            }
        });
        dialog.pack();
        dialog.show();
    }

    public void mainMenu() throws IOException {
        this.showMenu();
    }

    public void promptForSaveFile() throws IOException {
        FileDialog fileDialog = new FileDialog(this.main, "Save Map", 1);
        if (new File(SC_MAPS).exists()) {
            fileDialog.setDirectory(SC_MAPS);
        }
        String string = null;
        boolean bl = false;
        while (!bl) {
            fileDialog.show();
            string = fileDialog.getDirectory() + fileDialog.getFile();
            if (fileDialog.getFile() == null) break;
            if (string.equals(this.infile)) {
                this.error(201, "Cannot overwrite original.");
                continue;
            }
            if (string.indexOf(34) != -1) {
                this.error(202, "Filename cannot contain quotes(\").");
                continue;
            }
            if (!string.toLowerCase().endsWith(".scx") && !string.toLowerCase().endsWith(".scm")) {
                this.error(203, "Filename should end in .scm or .scx (BroodWar only)");
                continue;
            }
            Reader.copy(this.infile, string);
            Process process = Runtime.getRuntime().exec(new String[]{"mpq2k\\mpq2k", "a", string, IN_FILE, "staredit\\scenario.chk"});
            final InputStream inputStream = process.getInputStream();
            new Thread("outreader"){

                public void run() {
                    try {
                        byte[] byArray = new byte[80];
                        int n = 0;
                        while (n != -1) {
                            n = inputStream.available();
                            if (n <= 0) {
                                n = 1;
                            }
                            if (n > byArray.length) {
                                n = byArray.length;
                            }
                            n = inputStream.read(byArray, 0, n);
                            int n2 = 0;
                            while (n2 < n) {
                                System.out.print((char)byArray[n2]);
                                ++n2;
                            }
                            System.out.flush();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    System.out.println();
                }
            }.start();
            try {
                process.waitFor();
                if (new File(string).exists()) {
                    this.error("Done", 399, "Map '" + string + "' successfully written.");
                } else {
                    this.error(305, "Save error writing '" + string + "'.");
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.error(306, "Error running mpq2k " + exception.getClass() + ":" + exception.getMessage() + ".");
            }
            bl = true;
        }
    }

    public void editor() throws IOException {
        this.mu = new MapUnderstanding();
        this.mainMenu();
    }

    private byte[] readFile(String string) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        byte[] byArray = new byte[(int)randomAccessFile.length()];
        randomAccessFile.read(byArray);
        randomAccessFile.close();
        return byArray;
    }

    public void readCHK(MapUnderstanding mapUnderstanding, String string) {
        try {
            byte[] byArray = this.readFile(string);
            if (debug > 0) {
                System.err.println("Debug mode: " + debug);
            }
            boolean bl = false;
            mapUnderstanding.load(byArray);
            if (debug > 0) {
                mapUnderstanding.dump();
                if (debug > 5) {
                    mapUnderstanding.showStrings();
                }
            }
            switch (mapUnderstanding.getProtectionVersion()) {
                case -1: {
                    this.showText("Protected", "Protected with Scum Protector 1.1 by Moneran");
                    break;
                }
                case -2: {
                    this.showText("Protected", "Protected with SCM/SCX Protector by acc adapter");
                    break;
                }
                case -3: {
                    String string2 = "Protected with SCMToolkit by ShadowFlare\n" + mapUnderstanding.getSTInfo();
                    this.showText("Protected", string2);
                    break;
                }
                case -9: {
                    this.showText("Protected", "Protected with an Unknown Map Protector");
                    break;
                }
                case 1: {
                    String string3 = "Protected with GUEdit beta by GoldenUrg\n" + mapUnderstanding.getGUInfo();
                    this.showText("Protected", string3);
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    String string4 = "Protected with GUEdit Unknown Version\n" + mapUnderstanding.getGUInfo();
                    this.showText("Protected", string4);
                    break;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeCHK(String string) {
        byte[] byArray = this.mu.store();
        if (debug > 2) {
            System.err.println("New Size " + byArray.length);
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            this.error(502, "Unable to write " + string + ". " + iOException.getClass() + ":" + iOException.getMessage());
        }
    }

    public static void copy(String string, String string2) throws IOException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        int n = (int)randomAccessFile.length();
        byte[] byArray = new byte[n];
        randomAccessFile.read(byArray);
        randomAccessFile.close();
        RandomAccessFile randomAccessFile2 = new RandomAccessFile(string2, "rw");
        randomAccessFile2.write(byArray);
        randomAccessFile2.close();
    }

    private class Enabler {
        private boolean status;
        private Vector components = new Vector();

        private Enabler() {
        }

        public boolean getStatus() {
            return this.status;
        }

        public void setStatus(boolean bl) {
            this.status = bl;
            this.updateComponents();
        }

        public void add(Component component) {
            this.components.add(component);
            component.setEnabled(this.status);
        }

        private void updateComponents() {
            Enumeration enumeration = this.components.elements();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)enumeration.nextElement();
                component.setEnabled(this.status);
            }
        }
    }
}

