/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public class MappedImageFrame
extends Frame {
    TileMapper tm;
    TileListener listener = null;
    Panel mapPanel;
    int tilew;
    int tileh;
    int lastx;
    int lasty;
    boolean mouseDown = false;

    public MappedImageFrame(String string, TileMapper tileMapper) {
        super(string);
        this.tm = tileMapper;
        this.tilew = tileMapper.getTileWidth();
        this.tileh = tileMapper.getTileHeight();
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        panel.setLayout(new BorderLayout());
        final Label label = new Label();
        final Scrollbar scrollbar = new Scrollbar(1);
        final Scrollbar scrollbar2 = new Scrollbar(0);
        final Panel panel2 = new Panel(){
            Point p = new Point();
            int width = -1;
            int height = -1;

            public void update(Graphics graphics) {
                this.paint(graphics);
            }

            public void paint(Graphics graphics) {
                this.updateScrollBars();
                int n = scrollbar.getValue();
                int n2 = scrollbar2.getValue();
                Dimension dimension = this.getSize();
                int n3 = 0;
                while (n3 < dimension.height / MappedImageFrame.this.tileh + 1) {
                    int n4 = n + n3;
                    int n5 = 0;
                    while (n5 < dimension.width / MappedImageFrame.this.tilew + 1) {
                        int n6 = n2 + n5;
                        MappedImageFrame.this.tm.getMapping(this.p, n6, n4);
                        Image image = MappedImageFrame.this.tm.getImage();
                        int n7 = this.p.x;
                        int n8 = this.p.y;
                        if (n7 >= 0 && n8 >= 0) {
                            graphics.drawImage(image, n5 * MappedImageFrame.this.tilew, n3 * MappedImageFrame.this.tileh, n5 * MappedImageFrame.this.tilew + MappedImageFrame.this.tilew, n3 * MappedImageFrame.this.tileh + MappedImageFrame.this.tileh, n7 * MappedImageFrame.this.tilew, n8 * MappedImageFrame.this.tileh, n7 * MappedImageFrame.this.tilew + MappedImageFrame.this.tilew, n8 * MappedImageFrame.this.tileh + MappedImageFrame.this.tileh, this);
                        } else {
                            graphics.setColor(Color.white);
                            graphics.fillRect(n5 * MappedImageFrame.this.tilew, n3 * MappedImageFrame.this.tilew, MappedImageFrame.this.tilew, MappedImageFrame.this.tilew);
                        }
                        switch (MappedImageFrame.this.tm.getStatus(n6, n4)) {
                            case 0: {
                                break;
                            }
                            case 1: {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n5 * MappedImageFrame.this.tilew, n3 * MappedImageFrame.this.tileh, MappedImageFrame.this.tilew, MappedImageFrame.this.tileh);
                                break;
                            }
                            case 2: {
                                graphics.setColor(Color.black);
                                graphics.drawRect(n5 * MappedImageFrame.this.tilew, n3 * MappedImageFrame.this.tileh, MappedImageFrame.this.tilew, MappedImageFrame.this.tileh);
                                graphics.setColor(Color.red);
                                graphics.drawLine(n5 * MappedImageFrame.this.tilew, n3 * MappedImageFrame.this.tileh, n5 * MappedImageFrame.this.tilew + MappedImageFrame.this.tilew, n3 * MappedImageFrame.this.tileh + MappedImageFrame.this.tileh);
                                graphics.drawLine(n5 * MappedImageFrame.this.tilew + MappedImageFrame.this.tilew, n3 * MappedImageFrame.this.tileh, n5 * MappedImageFrame.this.tilew, n3 * MappedImageFrame.this.tileh + MappedImageFrame.this.tileh);
                            }
                        }
                        ++n5;
                    }
                    ++n3;
                }
            }

            public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
                if ((n & 1) == 1) {
                    this.width = n4;
                    this.updateScrollBars();
                    this.validate();
                }
                if ((n & 2) == 2) {
                    this.height = n5;
                    this.updateScrollBars();
                    this.validate();
                }
                if (this.width != -1 && this.height != -1 && (n & 3) != 0) {
                    System.out.println("image Update: " + this.width + "x" + this.height);
                }
                return super.imageUpdate(image, n, n2, n3, n4, n5);
            }

            public void setSize(Dimension dimension) {
                super.setSize(dimension);
                this.updateScrollBars();
            }

            public void setSize(int n, int n2) {
                super.setSize(n, n2);
                this.updateScrollBars();
            }

            public void updateScrollBars() {
                Dimension dimension = this.getSize();
                scrollbar2.setMaximum(MappedImageFrame.this.tm.getWidth());
                scrollbar2.setVisibleAmount(dimension.width / MappedImageFrame.this.tilew);
                scrollbar.setMaximum(MappedImageFrame.this.tm.getHeight());
                scrollbar.setVisibleAmount(dimension.height / MappedImageFrame.this.tileh);
            }
        };
        panel2.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = scrollbar.getValue();
                int n2 = scrollbar2.getValue();
                int n3 = mouseEvent.getX() / MappedImageFrame.this.tilew;
                int n4 = mouseEvent.getY() / MappedImageFrame.this.tileh;
                MappedImageFrame.this.mouseDown = true;
                if (MappedImageFrame.this.listener != null) {
                    MappedImageFrame.this.listener.selected(n2 + n3, n + n4);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                MappedImageFrame.this.mouseDown = false;
            }
        });
        panel2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent mouseEvent) {
                int n = scrollbar.getValue();
                int n2 = scrollbar2.getValue();
                int n3 = mouseEvent.getX() / MappedImageFrame.this.tilew + n2;
                int n4 = mouseEvent.getY() / MappedImageFrame.this.tileh + n;
                label.setText("(" + n3 + "," + n4 + ") " + MappedImageFrame.this.tm.getMappingText(n3, n4));
                MappedImageFrame.this.lastx = n2 + n3;
                MappedImageFrame.this.lasty = n + n4;
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                int n = scrollbar.getValue();
                int n2 = scrollbar2.getValue();
                int n3 = mouseEvent.getX() / MappedImageFrame.this.tilew + n2;
                int n4 = mouseEvent.getY() / MappedImageFrame.this.tileh + n;
                label.setText("(" + n3 + "," + n4 + ") " + MappedImageFrame.this.tm.getMappingText(n3, n4));
                if (MappedImageFrame.this.mouseDown && (MappedImageFrame.this.lastx != n2 + n3 || MappedImageFrame.this.lasty != n + n4) && MappedImageFrame.this.listener != null) {
                    MappedImageFrame.this.listener.selected(n2 + n3, n + n4);
                }
                MappedImageFrame.this.lastx = n2 + n3;
                MappedImageFrame.this.lasty = n + n4;
            }
        });
        this.mapPanel = panel2;
        scrollbar.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                panel2.repaint();
            }
        });
        scrollbar2.addAdjustmentListener(new AdjustmentListener(){

            public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                panel2.repaint();
            }
        });
        panel.add((Component)scrollbar, "East");
        panel.add((Component)scrollbar2, "South");
        panel.add((Component)panel2, "Center");
        this.add((Component)panel, "Center");
        this.add((Component)label, "South");
        this.pack();
    }

    public Image createOffscreenImage(int n, int n2) {
        return this.mapPanel.createImage(n, n2);
    }

    public void repaintMap() {
        this.mapPanel.repaint();
    }

    public void addListener(TileListener tileListener) {
        this.listener = tileListener;
    }

    public static class SimpleTileMapper
    implements TileMapper {
        Image i;
        int tilew;
        int tileh;

        public SimpleTileMapper() {
            this(null, 32, 32);
        }

        public SimpleTileMapper(Image image) {
            this(image, 32, 32);
        }

        public SimpleTileMapper(int n, int n2) {
            this(null, n, n2);
        }

        public SimpleTileMapper(Image image, int n, int n2) {
            this.i = image;
            this.tilew = n;
            this.tileh = n2;
        }

        public void setImage(Image image) {
            this.i = image;
        }

        public Image getImage() {
            return this.i;
        }

        public void getMapping(Point point, int n, int n2) {
            if (n < this.getWidth() && n2 < this.getHeight()) {
                point.x = n;
                point.y = n2;
            } else {
                point.x = -1;
                point.y = -1;
            }
        }

        public String getMappingText(int n, int n2) {
            return "";
        }

        public int getStatus(int n, int n2) {
            return 0;
        }

        public int getWidth() {
            return (this.i.getWidth(null) + this.tilew - 1) / this.tilew;
        }

        public int getHeight() {
            return (this.i.getHeight(null) + this.tileh - 1) / this.tileh;
        }

        public int getTileWidth() {
            return this.tilew;
        }

        public int getTileHeight() {
            return this.tileh;
        }
    }

    public static interface TileMapper {
        public void getMapping(Point var1, int var2, int var3);

        public int getStatus(int var1, int var2);

        public Image getImage();

        public String getMappingText(int var1, int var2);

        public int getWidth();

        public int getHeight();

        public int getTileWidth();

        public int getTileHeight();
    }

    public static interface TileListener {
        public void selected(int var1, int var2);
    }
}

