/*
 * Decompiled with CFR 0.152.
 */
public class DataStore {
    protected byte[] buf;
    protected int pos;
    protected int mark = 0;
    protected int count;
    private int addSize = 16;

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public DataStore(byte[] byArray) {
        this.buf = byArray;
        this.pos = 0;
        this.count = byArray.length;
    }

    public DataStore(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.count = Math.min(n + n2, byArray.length);
        this.mark = n;
    }

    public synchronized int read() {
        return this.pos < this.count ? this.buf[this.pos++] & 0xFF : -1;
    }

    public synchronized int read(byte[] byArray) {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + n2 > this.count) {
            n2 = this.count - this.pos;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(this.buf, this.pos, byArray, n, n2);
        this.pos += n2;
        return n2;
    }

    public synchronized int write(byte[] byArray) {
        return this.write(byArray, 0, byArray.length);
    }

    public synchronized int write(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos + n2 >= this.count) {
            this.addLength(n2);
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (n2 <= 0) {
            return 0;
        }
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
        this.pos += n2;
        return n2;
    }

    public synchronized long skip(long l) {
        if ((long)this.pos + l > (long)this.count) {
            l = this.count - this.pos;
        }
        if (l < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + l);
        return l;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public void setPos(int n) {
        this.pos = n;
    }

    public int getPos() {
        return this.pos;
    }

    public int readInt() {
        if (this.count - this.pos < 4) {
            return -1;
        }
        int n = this.buf[this.pos + 0] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8 | (this.buf[this.pos + 2] & 0xFF) << 16 | (this.buf[this.pos + 3] & 0xFF) << 24;
        this.pos += 4;
        return n;
    }

    public int readWord() {
        if (this.count - this.pos < 2) {
            return -1;
        }
        int n = this.buf[this.pos + 0] & 0xFF | (this.buf[this.pos + 1] & 0xFF) << 8;
        this.pos += 2;
        return n;
    }

    public int readByte() {
        if (this.count - this.pos < 1) {
            return -1;
        }
        int n = this.buf[this.pos + 0] & 0xFF;
        ++this.pos;
        return n;
    }

    public void writeInt(int n) {
        if (this.count - this.pos < 4) {
            this.addLength(4);
        }
        this.buf[this.pos + 3] = (byte)(n >> 24 & 0xFF);
        this.buf[this.pos + 2] = (byte)(n >> 16 & 0xFF);
        this.buf[this.pos + 1] = (byte)(n >> 8 & 0xFF);
        this.buf[this.pos + 0] = (byte)(n >> 0 & 0xFF);
        this.pos += 4;
    }

    public void writeWord(int n) {
        if (this.count - this.pos < 2) {
            this.addLength(2);
        }
        this.buf[this.pos + 1] = (byte)(n >> 8 & 0xFF);
        this.buf[this.pos + 0] = (byte)(n >> 0 & 0xFF);
        this.pos += 2;
    }

    public void writeByte(int n) {
        if (this.count - this.pos < 1) {
            this.addLength(1);
        }
        this.buf[this.pos + 0] = (byte)(n & 0xFF);
        ++this.pos;
    }

    private void addLength(int n) {
        int n2 = this.pos + n - this.count;
        if (n2 > 0) {
            if (this.count + n2 > this.buf.length) {
                int n3 = Math.max(this.addSize, n);
                byte[] byArray = new byte[this.buf.length + n3];
                if (this.buf.length > 0) {
                    System.arraycopy(this.buf, 0, byArray, 0, this.buf.length);
                }
                this.addSize *= 2;
                this.buf = byArray;
            }
            this.count += n2;
        }
    }

    public byte[] getData() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buf, 0, byArray, 0, byArray.length);
        return byArray;
    }
}

