/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Point;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class TerrainView {
    private int width = 0;
    private int height = 0;
    private int[][] map;
    private TilesetUnderstanding tu;
    Image tileimage = null;
    int selecttile = -1;

    public TerrainView(int[][] nArray, TilesetUnderstanding tilesetUnderstanding) {
        this.width = nArray[0].length;
        this.height = nArray.length;
        this.map = nArray;
        this.tu = tilesetUnderstanding;
    }

    public void show() {
        MappedImageFrame.SimpleTileMapper simpleTileMapper = new MappedImageFrame.SimpleTileMapper(8, 8){

            public void getMapping(Point point, int n, int n2) {
                int n3 = n2 / 4;
                int n4 = n / 4;
                int n5 = n % 4;
                int n6 = n2 % 4;
                if (n4 >= 0 && n4 < 16) {
                    int n7 = n3 * 16 + n4;
                    int n8 = TerrainView.this.tu.getVX4(n7);
                    int n9 = TerrainView.this.tu.getVR4(n8, n5, n6);
                    point.x = n9 % 256;
                    point.y = n9 / 256;
                } else {
                    point.x = -1;
                    point.y = -1;
                }
            }

            public String getMappingText(int n, int n2) {
                Point point = new Point();
                try {
                    int n3 = n2 / 4;
                    int n4 = n / 4;
                    int n5 = n % 4;
                    int n6 = n2 % 4;
                    if (n4 >= 0 && n4 < 16) {
                        int n7 = n3 * 16 + n4;
                        int n8 = TerrainView.this.tu.getVX4(n7);
                        int n9 = TerrainView.this.tu.getVR4(n8, n5, n6);
                        point.x = n9 % 256;
                        point.y = n9 / 256;
                        return "tilecode=" + n7 + " vx4=" + n8 + " vr4=" + n9 + " image (" + point.x + "," + point.y + ")";
                    }
                    return "";
                }
                catch (Exception exception) {
                    return "No info";
                }
            }

            public int getStatus(int n, int n2) {
                try {
                    int n3 = n2 / 4;
                    int n4 = n / 4;
                    int n5 = n % 4;
                    int n6 = n2 % 4;
                    if (n4 >= 0 && n4 < 16) {
                        int n7 = n3 * 16 + n4;
                        int n8 = TerrainView.this.tu.getVX4(n7);
                        return n8 == 0 ? 2 : 0;
                    }
                    return 0;
                }
                catch (Exception exception) {
                    return 0;
                }
            }

            public int getHeight() {
                return 6660;
            }

            public int getWidth() {
                return 64;
            }
        };
        final MappedImageFrame mappedImageFrame = new MappedImageFrame("Mega Tiles", simpleTileMapper);
        mappedImageFrame.addListener(new MappedImageFrame.TileListener(){

            public void selected(int n, int n2) {
                int n3 = n2 / 4;
                int n4 = n / 4;
                int n5 = n % 4;
                int n6 = n2 % 4;
                if (n4 >= 0 && n4 < 16) {
                    int n7;
                    TerrainView.this.selecttile = n7 = n3 * 16 + n4;
                }
            }
        });
        final Image image = mappedImageFrame.createOffscreenImage(2048, (this.tu.getNumSubtiles() + 127) / 128 * 8);
        simpleTileMapper.setImage(image);
        final MappedImageFrame mappedImageFrame2 = new MappedImageFrame("Map", new MappedImageFrame.SimpleTileMapper(image, 8, 8){

            public void getMapping(Point point, int n, int n2) {
                int n3 = n2 / 4;
                int n4 = n / 4;
                int n5 = n % 4;
                int n6 = n2 % 4;
                int n7 = 0;
                if (n4 >= 0 && n4 < TerrainView.this.width && n3 >= 0 && n3 < TerrainView.this.height) {
                    n7 = TerrainView.this.map[n3][n4];
                }
                int n8 = TerrainView.this.tu.getVX4(n7);
                int n9 = TerrainView.this.tu.getVR4(n8, n5, n6);
                point.y = n9 / 256;
                point.x = n9 % 256;
            }

            public String getMappingText(int n, int n2) {
                try {
                    int n3 = n2 / 4;
                    int n4 = n / 4;
                    int n5 = n % 4;
                    int n6 = n2 % 4;
                    int n7 = 0;
                    if (n4 >= 0 && n4 < TerrainView.this.width && n3 >= 0 && n3 < TerrainView.this.height) {
                        n7 = TerrainView.this.map[n3][n4];
                    }
                    return "tilecode=" + n7;
                }
                catch (Exception exception) {
                    return "No info";
                }
            }

            public int getHeight() {
                return TerrainView.this.height * 4;
            }

            public int getWidth() {
                return TerrainView.this.width * 4;
            }
        });
        mappedImageFrame2.addListener(new MappedImageFrame.TileListener(){

            public void selected(int n, int n2) {
                int n3 = n2 / 4;
                int n4 = n / 4;
                if (TerrainView.this.selecttile > -1) {
                    ((TerrainView)TerrainView.this).map[n3][n4] = TerrainView.this.selecttile;
                }
                mappedImageFrame2.repaintMap();
            }
        });
        mappedImageFrame2.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                mappedImageFrame.dispose();
                mappedImageFrame2.dispose();
            }

            public void windowClosed(WindowEvent windowEvent) {
                5 var2_2 = this;
                synchronized (var2_2) {
                    this.notify();
                }
            }
        });
        mappedImageFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                mappedImageFrame.dispose();
                mappedImageFrame2.dispose();
            }
        });
        new Thread(){

            public void run() {
                TerrainView.this.tu.makeAllSubtiles(image.getGraphics());
                mappedImageFrame.show();
                mappedImageFrame2.show();
                try {
                    TestWriteJPEG.writeJPEG("test.jpg", image, mappedImageFrame);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                }
            }
        }.start();
        new Thread(){

            public void run() {
                ProgressMonitor progressMonitor = new ProgressMonitor(mappedImageFrame, "Loading ...", "Loading Tileset...", 0, 100);
                try {
                    int n = 0;
                    while (n < 100) {
                        Thread.sleep(1000L);
                        n = TerrainView.this.tu.getDone();
                        System.out.println("Done " + n);
                        int n2 = n;
                        SwingUtilities.invokeAndWait(new Runnable(this, progressMonitor, n2){
                            private final /* synthetic */ ProgressMonitor val$pm;
                            private final /* synthetic */ int val$now;
                            private final /* synthetic */ 8 this$1;
                            {
                                this.this$1 = var1_1;
                                this.val$pm = progressMonitor;
                                this.val$now = n;
                            }

                            public void run() {
                                this.val$pm.setProgress(this.val$now);
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                progressMonitor.close();
            }
        }.start();
    }

    public int getTileId(int n, int n2) {
        if (n >= 0 && n < 16 && n2 >= 0 && n2 < 4096) {
            return (n2 << 4) + n;
        }
        return 0;
    }

    public Point getTileLocation(Point point, int n) {
        if (point == null) {
            point = new Point();
        }
        point.x = n % 16;
        point.y = n / 16;
        return point;
    }

    public Point getTileMapping(Point point, int n, int n2) {
        int n3 = 0;
        if (n2 >= 0 && n2 < this.width && n >= 0 && n < this.width) {
            n3 = this.map[n2][n];
        }
        int n4 = n3;
        return this.getTileLocation(point, n4);
    }

    private static String hexWord(int n) {
        String string = "0000" + Integer.toHexString(n & 0xFFFF);
        string = string.substring(string.length() - 4);
        return string;
    }

    private static String hexByte(int n) {
        String string = "00" + Integer.toHexString(n & 0xFF);
        string = string.substring(string.length() - 2);
        return string;
    }

    private static String showParts(int n) {
        String string = TerrainView.hexByte((n & 0xC000) >> 14) + " " + TerrainView.hexByte((n & 0x3E00) >> 9) + " " + TerrainView.hexByte((n & 0x1E0) >> 5) + " " + TerrainView.hexByte((n & 0x1F) >> 0);
        return string;
    }
}

