// winbotDoc.h : interface of the CWinbotDoc class
//
/////////////////////////////////////////////////////////////////////////////

#if !defined(AFX_WINBOTDOC_H__C9EE226A_E138_11D1_90B4_0080ADB745E7__INCLUDED_)
#define AFX_WINBOTDOC_H__C9EE226A_E138_11D1_90B4_0080ADB745E7__INCLUDED_

#if _MSC_VER >= 1000
#pragma once
#endif // _MSC_VER >= 1000

#include <afxtempl.h>
#include <afxmt.h>
#include "mybot.h"

extern const unsigned int MAX_LINES;


class CTextLine : public CString
{
public:
	int m_nFlags;
};

class CWinbotDoc : public CDocument
{
protected: // create from serialization only
	CWinbotDoc();
	DECLARE_DYNCREATE(CWinbotDoc)

// Attributes
public:
	CMyBot	TheBot;
protected:
	CArray<CTextLine, CTextLine&> aszText;
	unsigned int uiTop;
	unsigned int uiBottom;
	BOOL bViewChatUpdates;
// Operations
public:
	void HandleBotSocketMessages(WPARAM wParam, LPARAM lParam);

	void PutLine(char * szNewString, int nFlags = 0);
	int GetFirstLine(int iWhichLine, CString & szLine, int & nFlags);
	int GetNextLine(int iLastLine, CString & szLine, int & nFlags);
	unsigned int GetNumberOfLines();

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CWinbotDoc)
	public:
	virtual BOOL OnNewDocument();
	virtual void Serialize(CArchive& ar);
	//}}AFX_VIRTUAL

// Implementation
public:
	virtual ~CWinbotDoc();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif

protected:

// Generated message map functions
protected:
	//{{AFX_MSG(CWinbotDoc)
	afx_msg void OnViewChatUpdates();
	afx_msg void OnUpdateViewChatUpdates(CCmdUI* pCmdUI);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Developer Studio will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_WINBOTDOC_H__C9EE226A_E138_11D1_90B4_0080ADB745E7__INCLUDED_)
